/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.util.iterators.impl;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.function.BiFunction;
import kd.fi.bd.model.common.PairTuple;

public class BatchProcessIterator<T, E> {
    private int batchSize;
    private Iterator<E> sourceIterator;
    private BiFunction<Integer, PairTuple<T, E>, Boolean> buffedFunc;
    private BiFunction<Integer, T, Boolean> batchProcessingFunc;
    private T _batchProcessContext;
    private int _currentDataSeqNum;
    private int _currentBatchSeqNum;
    private PairTuple<T, E> _dataPairWrap;
    private boolean _hasValue;

    public BatchProcessIterator(int batchSize, Iterator<E> sourceIterator, T batchProcessContext, BiFunction<Integer, PairTuple<T, E>, Boolean> buffedFunc, BiFunction<Integer, T, Boolean> batchProcessingFunc) {
        this.batchSize = batchSize;
        if (this.batchSize < 1) {
            throw new IllegalArgumentException("Batch Size must greater than 0!");
        }
        this.sourceIterator = sourceIterator;
        this._hasValue = this.sourceIterator != null;
        this.buffedFunc = buffedFunc;
        this.batchProcessingFunc = batchProcessingFunc;
        this._batchProcessContext = batchProcessContext;
        this._dataPairWrap = new PairTuple<T, Object>(this._batchProcessContext, null);
        this._currentDataSeqNum = 0;
        this._currentBatchSeqNum = 0;
    }

    public boolean hasNext() {
        return this._hasValue && this.sourceIterator.hasNext();
    }

    public boolean processNextBatch() {
        if (!this.hasNext()) {
            return false;
        }
        int pos = 0;
        while (this._hasValue && this.sourceIterator.hasNext()) {
            if (!this.buffedFunc.apply(this._currentDataSeqNum++, this._dataPairWrap.setValue(this.sourceIterator.next())).booleanValue()) {
                this._hasValue = false;
            }
            if (++pos < this.batchSize) continue;
            pos = 0;
            if (this.batchProcessingFunc.apply(this._currentBatchSeqNum++, (Integer)this._batchProcessContext).booleanValue()) continue;
            this._hasValue = false;
            return true;
        }
        if (pos > 0) {
            this.batchProcessingFunc.apply(this._currentBatchSeqNum++, (Integer)this._batchProcessContext);
        }
        return true;
    }

    public void reset(Iterator<E> sourceIterator) {
        this.sourceIterator = sourceIterator;
        this._hasValue = this.sourceIterator != null;
        this._currentDataSeqNum = 0;
        this._currentBatchSeqNum = 0;
    }

    public static void main(String[] args) {
        LinkedList<String> source = new LinkedList<String>();
        for (int i = 0; i < 10; ++i) {
            source.add("Test-" + i);
        }
        LinkedList batchContext = new LinkedList();
        BatchProcessIterator batchIterator = new BatchProcessIterator(3, source.iterator(), batchContext, (seq, pair) -> batchContext.add(pair.getValue()), (batchseq, context) -> {
            System.out.println(context);
            context.clear();
            return true;
        });
        while (batchIterator.hasNext()) {
            batchIterator.processNextBatch();
        }
    }
}

