/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.util.iterators.impl;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.function.BiFunction;
import java.util.function.Supplier;

public class BufferedIterator<T, E>
implements Iterator<T[]> {
    private int batchSize;
    private Iterator<E> sourceIterator;
    private int _currentDataSeqNum;
    private int _currentBatchSeqNum;
    private BiFunction<Integer, E, T> convertor;
    private T[] _outputBuffer;
    private boolean _hasValue;
    private boolean keepNullValue;

    public BufferedIterator(Iterator<E> sourceIterator, Supplier<T[]> bufferCreator, BiFunction<Integer, E, T> convertor, boolean keepNullValue) {
        this.sourceIterator = sourceIterator;
        this._hasValue = this.sourceIterator != null;
        this.convertor = convertor;
        this._outputBuffer = bufferCreator.get();
        this.batchSize = this._outputBuffer.length;
        this.keepNullValue = keepNullValue;
        this._currentDataSeqNum = 0;
        this._currentBatchSeqNum = 0;
    }

    public BufferedIterator(Iterator<E> sourceIterator, Supplier<T[]> bufferCreator, BiFunction<Integer, E, T> convertor) {
        this(sourceIterator, bufferCreator, convertor, false);
    }

    @Override
    public boolean hasNext() {
        return this._hasValue && this.sourceIterator.hasNext();
    }

    @Override
    public T[] next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more elements!");
        }
        int pos = 0;
        while (this.sourceIterator.hasNext()) {
            T buf;
            if ((buf = this.convertor.apply(this._currentDataSeqNum++, this.sourceIterator.next())) == null && !this.keepNullValue) continue;
            this._outputBuffer[pos++] = buf;
            if (pos < this.batchSize) continue;
            return this._outputBuffer;
        }
        return pos > 0 ? Arrays.copyOf(this._outputBuffer, pos) : null;
    }

    public void reset(Iterator<E> sourceIterator) {
        for (int i = 0; i < this._outputBuffer.length; ++i) {
            this._outputBuffer[i] = null;
        }
        this.sourceIterator = sourceIterator;
        this._hasValue = this.sourceIterator != null;
        this._currentDataSeqNum = 0;
        this._currentBatchSeqNum = 0;
    }

    public static void main(String[] args) {
        LinkedList<String> source = new LinkedList<String>();
        for (int i2 = 0; i2 < 10; ++i2) {
            source.add("Test-" + i2);
        }
        BufferedIterator<String, String> bufferedIterator = new BufferedIterator<String, String>(source.iterator(), () -> new String[3], (i, v) -> v, true);
        while (bufferedIterator.hasNext()) {
            System.out.println(Arrays.deepToString(bufferedIterator.next()));
        }
    }
}

