/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.util.iterators.impl;

import java.io.Serializable;
import java.util.Iterator;
import kd.fi.bd.util.iterators.impl.IntArraySequenceIteratorBuilder;

public class IntArraySequenceIterator
implements Iterator<Object[]>,
Serializable {
    private static final long serialVersionUID = -3221594884552500253L;
    protected int lastStepPos;
    protected IntArraySequenceIteratorBuilder.MemberStep[] stepItems;
    protected Object[] currentRowValues;

    protected IntArraySequenceIterator() {
    }

    public IntArraySequenceIterator(IntArraySequenceIteratorBuilder.MemberStep[] stepItems, Object[] outputRowValues) {
        this.stepItems = stepItems;
        this.lastStepPos = stepItems == null ? -1 : stepItems.length - 1;
        this.currentRowValues = outputRowValues;
    }

    public IntArraySequenceIterator(IntArraySequenceIterator srcIterator) {
        int stepCnt = 0;
        if (srcIterator.stepItems != null && (stepCnt = srcIterator.stepItems.length) > 0) {
            int i;
            this.currentRowValues = new Object[stepCnt];
            this.stepItems = new IntArraySequenceIteratorBuilder.MemberStep[stepCnt];
            for (i = 0; i < stepCnt; ++i) {
                this.stepItems[i] = srcIterator.stepItems[i].copy();
                this.currentRowValues[i] = ((IntArraySequenceIteratorBuilder.ArrayStep)this.stepItems[i]).getValues()[0];
            }
            for (i = 0; i < stepCnt; ++i) {
                this.stepItems[i].setResultArray(this.currentRowValues);
            }
            this.lastStepPos = stepCnt - 1;
        } else {
            this.stepItems = new IntArraySequenceIteratorBuilder.MemberStep[0];
            this.lastStepPos = -1;
        }
    }

    @Override
    public boolean hasNext() {
        if (this.stepItems != null) {
            for (IntArraySequenceIteratorBuilder.MemberStep step : this.stepItems) {
                if (step == null || !step.hasNext()) continue;
                return true;
            }
        }
        return false;
    }

    protected void resetMemberSteps(int startPos) {
        for (int i = startPos; i < this.stepItems.length; ++i) {
            if (this.stepItems[i] == null) continue;
            this.stepItems[i].reset();
            this.stepItems[i].next();
        }
    }

    public int getMemberStepCnt() {
        return this.lastStepPos + 1;
    }

    public int getMemberStepSize(int index) {
        if (index < 0 || index >= this.stepItems.length) {
            return -1;
        }
        return this.stepItems[index] != null ? this.stepItems[index].getMemberCnt() : 0;
    }

    public long getTotalStepCnt() {
        if (this.lastStepPos < 0 || this.stepItems == null) {
            return 0L;
        }
        long totalCnt = 1L;
        for (IntArraySequenceIteratorBuilder.MemberStep step : this.stepItems) {
            if (step == null || step.getMemberCnt() <= 0) continue;
            totalCnt *= (long)step.getMemberCnt();
        }
        return totalCnt;
    }

    public int calculateBatchSize(int orginalBatchSize) {
        if (orginalBatchSize <= 0 || this.stepItems == null || this.stepItems.length <= 0) {
            return 0;
        }
        if (this.stepItems.length == 1) {
            return Math.min(orginalBatchSize, this.stepItems[0].getMemberCnt());
        }
        int currentBatchSize = 1;
        int resultBatchSize = 0;
        int idx = this.stepItems.length - 1;
        do {
            int memberCnt;
            if (currentBatchSize * (memberCnt = this.stepItems[idx].getMemberCnt()) >= orginalBatchSize) {
                for (int i = 0; i < memberCnt; ++i) {
                    if ((resultBatchSize += currentBatchSize) < orginalBatchSize || memberCnt % (i + 1) != 0) continue;
                    return resultBatchSize;
                }
            } else {
                currentBatchSize *= memberCnt;
            }
        } while (--idx >= 0);
        return currentBatchSize;
    }

    @Override
    public Object[] next() {
        for (int stepIndex = this.lastStepPos; stepIndex >= 0; --stepIndex) {
            if (this.stepItems[stepIndex] == null || !this.stepItems[stepIndex].hasNext()) continue;
            this.stepItems[stepIndex].next();
            if (stepIndex < this.lastStepPos) {
                this.resetMemberSteps(stepIndex + 1);
            }
            return this.currentRowValues;
        }
        throw new IndexOutOfBoundsException();
    }

    public IntArraySequenceIteratorBuilder.MemberStep[] getStepItems() {
        return this.stepItems;
    }

    public Object[] getCurrentRowValues() {
        return this.currentRowValues;
    }

    public void reset() {
        for (int i = 0; i < this.stepItems.length - 1; ++i) {
            this.stepItems[i].reset();
            this.stepItems[i].next();
        }
        this.stepItems[this.stepItems.length - 1].reset();
    }
}

