/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.util.optimizor;

import kd.bos.context.RequestContext;
import kd.bos.util.ConfigurationUtil;
import kd.fi.bd.util.data.IDataValueUtil;

public class OptimizeControlPanel {
    private static final String DefaultApp_Prefix = "fi";
    private static final String CDC_Service_Enabled_Prefix = "fi.cdc.enable.";
    private static final String External_Index_Enable_Prefix = "fi.ex-indexing.enable.";
    private static final String FI_XDB_AUTO_Optimize_SliceHint = "xdb_auto_optimize_slice_hint";
    private static final String FI_Filter_AUTO_Optimize = "filter_auto_optimize";
    private static final String ThreadPool_Max_Size = "threadpool_max_size.";

    public static boolean debug_isDefaultEnabledSystemOutput() {
        return OptimizeControlPanel.getSysPropertyBoolean("fi.debug.timecostmeter.systemout", false);
    }

    public static Integer getThreadPoolMaxSize(String appName) {
        if (appName == null) {
            throw new IllegalArgumentException("App Name cannot be null!");
        }
        return OptimizeControlPanel.getSysPropertyInteger(ThreadPool_Max_Size + appName.toLowerCase(), null);
    }

    public static String getSysPropertyString(String propertyName, String defaultValue) {
        String tenantPropValue = ConfigurationUtil.getString((String)String.format("%s_%s", RequestContext.getOrCreate().getTenantId(), propertyName));
        if (null == tenantPropValue) {
            return ConfigurationUtil.getString((String)propertyName, (String)defaultValue);
        }
        return tenantPropValue;
    }

    public static Integer getSysPropertyInteger(String propertyName, Integer defaultValue) {
        Integer tenantPropValue = ConfigurationUtil.getInteger((String)String.format("%s_%s", RequestContext.getOrCreate().getTenantId(), propertyName));
        if (null == tenantPropValue) {
            return ConfigurationUtil.getInteger((String)propertyName, (Integer)defaultValue);
        }
        return tenantPropValue;
    }

    public static Long getSysPropertyLong(String propertyName, Long defaultValue) {
        Long tenantPropValue = ConfigurationUtil.getLong((String)String.format("%s_%s", RequestContext.getOrCreate().getTenantId(), propertyName));
        if (null == tenantPropValue) {
            return ConfigurationUtil.getLong((String)propertyName, (Long)defaultValue);
        }
        return tenantPropValue;
    }

    public static Boolean getSysPropertyBoolean(String propertyName, Boolean defaultValue) {
        String val = ConfigurationUtil.getString((String)String.format("%s_%s", RequestContext.getOrCreate().getTenantId(), propertyName));
        if (null == val) {
            return IDataValueUtil.getBoolean(ConfigurationUtil.getString((String)propertyName, (String)(defaultValue != false ? "true" : "false")));
        }
        return IDataValueUtil.getBoolean(val);
    }

    public static synchronized void registerSystemProperty(String propertyName, String value) {
        String key = String.format("%s_%s", RequestContext.getOrCreate().getTenantId(), propertyName);
        if (System.getProperties().containsKey(key)) {
            throw new IllegalArgumentException(String.format("Already Contain System Property: %s=%s", key, System.getProperty(key)));
        }
        System.setProperty(key, value);
    }

    public static synchronized void registerSystemPropertyDirect(String propertyName, String value) {
        if (System.getProperties().containsKey(propertyName)) {
            throw new IllegalArgumentException(String.format("Already Contain System Property: %s=%s", propertyName, System.getProperty(propertyName)));
        }
        System.setProperty(propertyName, value);
    }

    public static String getSysPropertyString(String propertyName) {
        return OptimizeControlPanel.getSysPropertyString(propertyName, null);
    }

    private static String getSysParamName(String sysParamName) {
        return "fi." + sysParamName;
    }

    private static String getSysParamName(String appPrefix, String sysParamName) {
        return appPrefix + "." + sysParamName;
    }

    public static boolean isExternalIndexEnabled(String externalIndexType) {
        if (externalIndexType == null) {
            return false;
        }
        return OptimizeControlPanel.getSysPropertyBoolean(External_Index_Enable_Prefix + externalIndexType.toLowerCase(), false);
    }

    public static boolean isESIndexEnabled() {
        return OptimizeControlPanel.isExternalIndexEnabled("es");
    }

    public static boolean isParamEnabled(String appPrefix, String sysParamName) {
        return OptimizeControlPanel.getSysPropertyBoolean(OptimizeControlPanel.getSysParamName(appPrefix, sysParamName), false);
    }

    public static boolean isParamEnabled(String sysParamName) {
        return OptimizeControlPanel.isParamEnabled(DefaultApp_Prefix, sysParamName);
    }

    public static boolean isXDBAutoOptimizeEnabled() {
        return OptimizeControlPanel.isParamEnabled(FI_XDB_AUTO_Optimize_SliceHint);
    }

    public static boolean isFilterAutoOptimizeEnabled() {
        return OptimizeControlPanel.isParamEnabled(FI_Filter_AUTO_Optimize);
    }

    public static boolean isCDCServiceEnabled(String moduleName) {
        return OptimizeControlPanel.getSysPropertyBoolean(CDC_Service_Enabled_Prefix + moduleName, false);
    }
}

