/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.util.pipe;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.bd.indexing.constant.CDCStageEnum;
import kd.fi.bd.threads.FIConfigurableThreadService;
import kd.fi.bd.threads.ThreadCategoryEnum;
import kd.fi.bd.util.exception.IExceptionListener;
import kd.fi.bd.util.pipe.datablock.IAsyncStreamDataBlock;
import kd.fi.bd.util.pipe.datablock.SimpleAsyncStreamDataBlock;

public class SimpleAsyncPipe<E> {
    protected final Log logger;
    protected ThreadCategoryEnum threadCategoryEnum;
    protected BiConsumer<ThreadCategoryEnum, IAsyncStreamDataBlock<E>> dataConsumer;
    protected Consumer<Runnable> threadExecutor;
    protected IExceptionListener exceptionListener;

    public SimpleAsyncPipe(ThreadCategoryEnum threadCategoryEnum, BiConsumer<ThreadCategoryEnum, IAsyncStreamDataBlock<E>> dataConsumer, Consumer<Runnable> threadExecutor, Log logger) {
        this.logger = logger;
        if (this.logger == null) {
            throw new IllegalArgumentException("Logger is null!");
        }
        this.threadCategoryEnum = threadCategoryEnum;
        if (this.threadCategoryEnum == null) {
            throw new IllegalArgumentException("Thread Category cannot be null!");
        }
        this.setDataConsumer(dataConsumer);
        this.setThreadExecutor(threadExecutor);
    }

    public SimpleAsyncPipe(ThreadCategoryEnum threadCategoryEnum, BiConsumer<ThreadCategoryEnum, IAsyncStreamDataBlock<E>> dataConsumer) {
        this(threadCategoryEnum, dataConsumer, task -> FIConfigurableThreadService.getInstance().execute(threadCategoryEnum, (Runnable)task), LogFactory.getLog(SimpleAsyncPipe.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doDataConsume(ThreadCategoryEnum threadCategoryEnum, IAsyncStreamDataBlock<E> dataBlock) {
        boolean success = false;
        try {
            this.dataConsumer.accept(threadCategoryEnum, dataBlock);
            success = true;
        }
        catch (Exception ex) {
            if (this.exceptionListener != null) {
                this.exceptionListener.onError(ex);
            }
            this.logger.error(ex.getMessage(), (Throwable)ex);
        }
        finally {
            dataBlock.onStageCompleted(CDCStageEnum.Completed, success);
        }
        return success;
    }

    public List<IAsyncStreamDataBlock<E>> putToQueue(Object groupKey, Collection<E> srcDatas) {
        LinkedList<IAsyncStreamDataBlock<IAsyncStreamDataBlock<E>>> result = new LinkedList<IAsyncStreamDataBlock<IAsyncStreamDataBlock<E>>>();
        for (E src : srcDatas) {
            result.add(this.putToQueue(groupKey, src));
        }
        return result;
    }

    public List<IAsyncStreamDataBlock<E>> putToQueue(Collection<E> srcDatas) {
        return this.putToQueue((Object)null, srcDatas);
    }

    public IAsyncStreamDataBlock<E> putToQueue(Object groupKey, E srcData) {
        return this.putToQueue(new SimpleAsyncStreamDataBlock<E>(groupKey, srcData));
    }

    public IAsyncStreamDataBlock<E> putToQueue(E srcData) {
        return this.putToQueue(null, srcData);
    }

    public IAsyncStreamDataBlock<E> putToQueue(Object groupKey, E srcData, int requiredNewPage, int requiredFlush, boolean last) {
        return this.putToQueue(new SimpleAsyncStreamDataBlock<E>(groupKey, srcData, requiredNewPage, requiredFlush, last));
    }

    public IAsyncStreamDataBlock<E> putToQueue(IAsyncStreamDataBlock<E> srcData) {
        this.threadExecutor.accept(() -> this.doDataConsume(this.threadCategoryEnum, srcData));
        return srcData;
    }

    public ThreadCategoryEnum getThreadCategoryEnum() {
        return this.threadCategoryEnum;
    }

    public void setThreadCategoryEnum(ThreadCategoryEnum threadCategoryEnum) {
        this.threadCategoryEnum = threadCategoryEnum;
        if (this.threadCategoryEnum == null) {
            throw new IllegalArgumentException("Thread Category cannot be null!");
        }
    }

    public BiConsumer<ThreadCategoryEnum, IAsyncStreamDataBlock<E>> getDataConsumer() {
        return this.dataConsumer;
    }

    public Log getLogger() {
        return this.logger;
    }

    public void setDataConsumer(BiConsumer<ThreadCategoryEnum, IAsyncStreamDataBlock<E>> dataConsumer) {
        this.dataConsumer = dataConsumer;
        if (this.dataConsumer == null) {
            throw new IllegalArgumentException("Data Block Consumer cannot be null!");
        }
    }

    public Consumer<Runnable> getThreadExecutor() {
        return this.threadExecutor;
    }

    public void setThreadExecutor(Consumer<Runnable> threadExecutor) {
        this.threadExecutor = threadExecutor;
        if (this.threadExecutor == null) {
            throw new IllegalArgumentException("Thread Pool Provider cannot be null!");
        }
    }

    public IExceptionListener getExceptionListener() {
        return this.exceptionListener;
    }

    public void setExceptionListener(IExceptionListener exceptionListener) {
        this.exceptionListener = exceptionListener;
    }
}

