/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.util.pipe.datablock;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import kd.fi.bd.indexing.constant.CDCStageEnum;
import kd.fi.bd.model.common.PairTuple;
import kd.fi.bd.util.pipe.datablock.IAsyncDataBlockFuture;
import kd.fi.bd.util.pipe.datablock.IAsyncStreamDataBlock;

public class SimpleAsyncStreamDataBlock<E>
implements IAsyncStreamDataBlock<E>,
IAsyncDataBlockFuture {
    protected Object groupId;
    protected Object groupParams;
    protected E data;
    protected int requiredNewPage;
    protected int requiredFlush;
    protected boolean last;
    protected AtomicInteger stage_Code;
    protected AtomicBoolean stage_Status;
    protected BiFunction<PairTuple<CDCStageEnum, Boolean>, IAsyncStreamDataBlock<E>, Boolean> stageChangeNotifier;

    public SimpleAsyncStreamDataBlock(Object groupId, E data, int requiredNewPage, int requiredFlush, boolean last) {
        this.groupId = groupId;
        this.data = data;
        this.requiredNewPage = requiredNewPage;
        this.requiredFlush = requiredFlush;
        this.last = last;
        this.stage_Status = new AtomicBoolean(true);
        this.stage_Code = new AtomicInteger(CDCStageEnum.Waiting_Start.getValue());
    }

    public SimpleAsyncStreamDataBlock(Object groupId, E data, boolean last) {
        this(groupId, data, 0, 0, last);
    }

    public SimpleAsyncStreamDataBlock(Object groupId, E data) {
        this(groupId, data, 0, 0, false);
    }

    public SimpleAsyncStreamDataBlock(E data) {
        this(null, data, 0, 0, false);
    }

    public String toString() {
        return "SimpleAsyncStreamDataBlock [data=" + this.data + ", requiredNewPage=" + this.requiredNewPage + ", requiredFlush=" + this.requiredFlush + ", last=" + this.last + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStageCompleted(CDCStageEnum completedStageCode, boolean success) {
        AtomicInteger atomicInteger = this.stage_Code;
        synchronized (atomicInteger) {
            this.stage_Status.set(success);
            this.stage_Code.set(completedStageCode.getValue());
            try {
                this.stage_Code.notifyAll();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.stageChangeNotifier != null) {
            this.stageChangeNotifier.apply(new PairTuple<CDCStageEnum, Boolean>(completedStageCode, success), this);
        }
    }

    @Override
    public E getData() {
        return this.data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PairTuple<CDCStageEnum, Boolean> waitStageChange(long timeOut) {
        boolean curStageStatus;
        int curStageCode;
        boolean infinityWait = timeOut < 0L;
        AtomicInteger atomicInteger = this.stage_Code;
        synchronized (atomicInteger) {
            curStageCode = this.stage_Code.get();
            curStageStatus = this.stage_Status.get();
            if (curStageCode == CDCStageEnum.Completed.getValue() || curStageCode == CDCStageEnum.Canceled.getValue()) {
                return new PairTuple<CDCStageEnum, Boolean>(CDCStageEnum.getCDCStageEnum(curStageCode), curStageStatus);
            }
            try {
                if (infinityWait) {
                    do {
                        this.stage_Code.wait(1000L);
                    } while (this.stage_Code.get() == curStageCode);
                } else {
                    this.stage_Code.wait(timeOut);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            curStageCode = this.stage_Code.get();
            curStageStatus = this.stage_Status.get();
        }
        return new PairTuple<CDCStageEnum, Boolean>(CDCStageEnum.getCDCStageEnum(curStageCode), curStageStatus);
    }

    @Override
    public byte[] getDataBytes() {
        return null;
    }

    @Override
    public int requiredNewPage() {
        return 0;
    }

    @Override
    public int requiredFlush() {
        return 0;
    }

    @Override
    public boolean isLast() {
        return this.last;
    }

    public void setLast(boolean last) {
        this.last = last;
    }

    public BiFunction<PairTuple<CDCStageEnum, Boolean>, IAsyncStreamDataBlock<E>, Boolean> getStageChangeNotifier() {
        return this.stageChangeNotifier;
    }

    public SimpleAsyncStreamDataBlock setStageChangeNotifier(BiFunction<PairTuple<CDCStageEnum, Boolean>, IAsyncStreamDataBlock<E>, Boolean> stageChangeNotifier) {
        this.stageChangeNotifier = stageChangeNotifier;
        return this;
    }

    @Override
    public PairTuple<CDCStageEnum, Boolean> getStageStatus() {
        return new PairTuple<CDCStageEnum, Boolean>(CDCStageEnum.getCDCStageEnum(this.stage_Code.get()), this.stage_Status.get());
    }

    @Override
    public Object getGroupId() {
        return this.groupId;
    }

    public SimpleAsyncStreamDataBlock<E> setGroupId(Object groupId) {
        this.groupId = groupId;
        return this;
    }

    @Override
    public Object getGroupParams() {
        return this.groupParams;
    }

    public SimpleAsyncStreamDataBlock<E> setGroupParams(Object groupParams) {
        this.groupParams = groupParams;
        return this;
    }
}

