/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.mobile.recclaim;

import java.math.BigDecimal;
import java.util.EventObject;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.fi.cas.formplugin.mobile.recclaim.M;
import kd.fi.cas.formplugin.mobile.recclaim.RecClaimPageJumpHandler;

public class ClaimAppealMobBillPlugin
extends AbstractMobBillPlugIn
implements RowClickEventListener {
    private static final String ENTRYENTITY = "entryentity";
    private static final String ENTRYSUMMARYMONEY = "entrysummary_money";
    private static final String CLAIM_TYPE = "claimtype";
    private static final String PAYER_BASE = "recbasepayer";

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        AbstractGrid entryentity = (AbstractGrid)this.getView().getControl(ENTRYENTITY);
        if (entryentity != null) {
            entryentity.addRowClickListener((RowClickEventListener)this);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.handlePayer();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.handleEntryPanel();
        this.handlePageLabel();
    }

    private void handlePageLabel() {
        String claimType;
        switch (claimType = (String)this.getModel().getValue(CLAIM_TYPE)) {
            case "1": {
                ((Label)this.getControl("labelap1")).setText(ResManager.loadKDString((String)"\u6536\u6b3e\u53d8\u66f4\u4fe1\u606f", (String)"ClaimAppealMobBillPlugin_2", (String)"fi-cas-mobile", (Object[])new Object[0]));
                ((Label)this.getControl("labelap")).setText(ResManager.loadKDString((String)"\u53d8\u66f4\u660e\u7ec6", (String)"ClaimAppealMobBillPlugin_3", (String)"fi-cas-mobile", (Object[])new Object[0]));
                break;
            }
            case "2": {
                ((Label)this.getControl("labelap1")).setText(ResManager.loadKDString((String)"\u6536\u6b3e\u7533\u8bc9\u4fe1\u606f", (String)"ClaimAppealMobBillPlugin_4", (String)"fi-cas-mobile", (Object[])new Object[0]));
                ((Label)this.getControl("labelap")).setText(ResManager.loadKDString((String)"\u7533\u8bc9\u660e\u7ec6", (String)"ClaimAppealMobBillPlugin_5", (String)"fi-cas-mobile", (Object[])new Object[0]));
            }
        }
    }

    private void handlePayer() {
        String type = (String)this.getModel().getValue("paymenttype");
        if (!StringUtils.equals((CharSequence)type, (CharSequence)"other")) {
            this.getModel().setValue("paymentbasetype", (Object)type);
            this.getModel().setValue(PAYER_BASE, this.getModel().getValue("recpayer"));
        }
    }

    private void handleEntryPanel() {
        IDataModel model = this.getModel();
        DynamicObjectCollection entryEntity = model.getEntryEntity(ENTRYENTITY);
        BigDecimal reAmount = entryEntity.stream().map(dynamicObject -> (BigDecimal)dynamicObject.get("e_receivableamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
        Label entryCountMoneyLabel = (Label)this.getControl(ENTRYSUMMARYMONEY);
        entryCountMoneyLabel.setText(M.getCurrencyFormatStr((DynamicObject)model.getValue("currency"), reAmount));
    }

    public void entryRowClick(RowClickEvent evt) {
        CardEntry source = (CardEntry)evt.getSource();
        if (ENTRYENTITY.equals(source.getEntryKey())) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRYENTITY);
            RecClaimPageJumpHandler.claimAnnounceToAnnounceEntry((AbstractFormPlugin)this, rowIndex);
        }
    }
}

