/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.mobile.recclaim;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.Map;
import java.util.Optional;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.fi.cas.formplugin.mobile.recclaim.RecClaimPageJumpHandler;

public class MinePlugin
extends AbstractMobFormPlugin {
    public void afterCreateNewData(EventObject e) {
        this.setUserInfo();
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"item_help"});
        super.registerListener(e);
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "item_help": {
                RecClaimPageJumpHandler.showHelpPage((AbstractFormPlugin)this);
            }
        }
        super.click(evt);
    }

    private void setUserInfo() {
        DynamicObject currentUser;
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        DynamicObjectCollection users = MinePlugin.getUser(userId);
        String org = "";
        Optional<DynamicObject> depObj = users.stream().filter(user -> !user.getBoolean("entryentity.ispartjob")).findFirst();
        if (depObj.isPresent()) {
            currentUser = depObj.get();
            org = currentUser.getString("entryentity.dpt.name");
        } else {
            currentUser = (DynamicObject)users.get(0);
        }
        String name = currentUser.getString("name");
        String avatar = MinePlugin.getUserImageFullPath(userId);
        ((Label)this.getControl("name")).setText(name);
        ((Image)this.getControl("avatar")).setUrl(avatar);
        ((Label)this.getControl("org")).setText(org);
    }

    private static DynamicObjectCollection getUser(Long userId) {
        QFilter qFilter = new QFilter("id", "=", (Object)userId);
        QFilter[] qFilters = new QFilter[]{qFilter};
        String selectFields = "id,name,picturefield,entryentity.id,entryentity.position,entryentity.dpt.name,entryentity.ispartjob";
        return QueryServiceHelper.query((String)"bos_user", (String)selectFields, (QFilter[])qFilters);
    }

    private static String getUserImageFullPath(Long userId) {
        ArrayList<Long> id = new ArrayList<Long>(1);
        id.add(userId);
        Map userAvatarPath = UserServiceHelper.getUserAvatarPath(id, (boolean)true);
        return userAvatarPath.size() > 0 ? (String)userAvatarPath.get(userId) : null;
    }
}

