/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.mobile.recclaim;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.AbstractFormPlugin;

public class MobileEntryUtil {
    private static final String CUSTOM_PARAM_ENTRYEDITINDEX = "entryeditindex";

    public static void setEntryDataOnSubPage(AbstractFormPlugin formPlugin, String entryName) {
        IFormView view = formPlugin.getView();
        FormShowParameter param = view.getFormShowParameter();
        if (param.getCustomParam(CUSTOM_PARAM_ENTRYEDITINDEX) == null) {
            return;
        }
        int index = (Integer)param.getCustomParam(CUSTOM_PARAM_ENTRYEDITINDEX);
        IDataModel model = view.getModel();
        model.deleteEntryData(entryName);
        IDataModel parentModel = view.getParentView().getModel();
        DynamicObjectCollection entryEntity = parentModel.getEntryEntity(entryName);
        DynamicObject srcEntry = (DynamicObject)entryEntity.get(index);
        DataEntityPropertyCollection srcProperties = entryEntity.getDynamicObjectType().getProperties();
        DataEntityPropertyCollection properties = MobileEntryUtil.getTargetProperties(model, entryName);
        model.beginInit();
        int newEntryRow = model.createNewEntryRow(entryName);
        for (IDataEntityProperty property : properties) {
            if ("seq".equals(property.getName()) || !srcProperties.containsKey((Object)property.getName())) continue;
            Object object = srcEntry.get(property.getName());
            model.setValue(property.getName(), MobileEntryUtil.getObjectValue(object), newEntryRow);
        }
        model.endInit();
        view.updateView(entryName, newEntryRow);
    }

    public static void returnEntryDataToParentPage(AbstractFormPlugin formPlugin, String entryName) {
        IDataModel model = formPlugin.getView().getModel();
        DynamicObject dataEntity = model.getDataEntity(true);
        DynamicObjectCollection entries = dataEntity.getDynamicObjectCollection(entryName);
        IFormView parentView = formPlugin.getView().getParentView();
        DynamicObject parentDataEntity = parentView.getModel().getDataEntity(true);
        DynamicObjectCollection parentEntries = parentDataEntity.getDynamicObjectCollection(entryName);
        FormShowParameter param = formPlugin.getView().getFormShowParameter();
        if (param.getCustomParam(CUSTOM_PARAM_ENTRYEDITINDEX) != null) {
            int index = (Integer)param.getCustomParam(CUSTOM_PARAM_ENTRYEDITINDEX);
            parentEntries.remove(index);
            MobileEntryUtil.copy(parentEntries, entries, index);
        } else {
            MobileEntryUtil.copy(parentEntries, entries, parentEntries.size());
        }
        parentView.updateView(entryName);
        formPlugin.getView().sendFormAction(parentView);
    }

    private static void copy(DynamicObjectCollection parentEntries, DynamicObjectCollection entries, int rowIndex) {
        DynamicObjectType parentType = parentEntries.getDynamicObjectType();
        DynamicObjectType thisType = entries.getDynamicObjectType();
        DataEntityPropertyCollection properties = parentType.getProperties();
        for (DynamicObject thisentry : entries) {
            DynamicObject entry = (DynamicObject)parentType.createInstance();
            parentEntries.add(rowIndex++, entry);
            for (IDataEntityProperty property : properties) {
                if (thisType.getProperty(property.getName()) == null) continue;
                property.setValueFast((Object)entry, thisentry.get(property.getName()));
            }
        }
    }

    private static DataEntityPropertyCollection getTargetProperties(IDataModel model, String entryName) {
        return model.getDataEntity().getDynamicObjectCollection(entryName).getDynamicObjectType().getProperties();
    }

    public static Object getObjectValue(Object entity) {
        if (entity instanceof DynamicObject) {
            return ((DynamicObject)entity).getPkValue();
        }
        return entity;
    }
}

