/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.mobile.recclaim;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.workflow.component.approvalrecord.IApprovalRecordGroup;
import kd.bos.workflow.component.approvalrecord.IApprovalRecordItem;
import kd.bos.workflow.engine.impl.persistence.entity.task.component.ApprovalRecordGroup;
import kd.bos.workflow.engine.impl.persistence.entity.task.component.ApprovalRecordItem;
import kd.fi.cas.formplugin.mobile.recclaim.OperationRsEnum;
import kd.fi.cas.formplugin.mobile.recclaim.operation.RecClaimBillOperationHelper;

public class OperationResultPlugin
extends AbstractBillPlugIn {
    private static Log log = LogFactory.getLog(OperationResultPlugin.class);

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_continue", "btn_back_to_index"});
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "btn_back_to_index": {
                this.jumpPage("cas_index_m");
                break;
            }
            case "btn_continue": {
                this.jumpPage("cas_claimnotice_m");
            }
        }
    }

    private void jumpPage(String formId) {
        MobileFormShowParameter parameter = new MobileFormShowParameter();
        parameter.setFormId(formId);
        parameter.getOpenStyle().setShowType(ShowType.Floating);
        this.getView().showForm((FormShowParameter)parameter);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Map param = this.getView().getFormShowParameter().getCustomParams();
        this.handleChildNode(param);
    }

    private void handleChildNode(Map<String, Object> param) {
        String pagetype = param.get("pagetype").toString();
        String billno = param.get("billno").toString();
        this.handleViews(pagetype);
        this.showOperationResult(pagetype, billno);
    }

    private void handleViews(String pagetype) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"btn_continue"});
        Image imageap = (Image)this.getControl("imageap");
        Label labelM1 = (Label)this.getControl("label_msg_1");
        Label labelM2 = (Label)this.getControl("label_msg_2");
        String msg1 = "";
        String msg2 = "";
        String url = "";
        switch (pagetype) {
            case "0": {
                url = "/images/mobile/emotion/skrl_rljxz_123_104.png";
                this.getView().setVisible(Boolean.TRUE, new String[]{"btn_continue"});
                msg1 = OperationRsEnum.CLAIM.getName();
                msg2 = OperationRsEnum.CLAIM.getMsg();
                break;
            }
            case "1": {
                url = "/images/mobile/emotion/skrl_bgjxz_123_104.png";
                msg1 = OperationRsEnum.CHANGE.getName();
                msg2 = OperationRsEnum.CHANGE.getMsg();
                break;
            }
            case "2": {
                url = "/images/mobile/emotion/skrl_ssjxz_123_104.png";
                msg1 = OperationRsEnum.APPEAL.getName();
                msg2 = OperationRsEnum.APPEAL.getMsg();
                break;
            }
            case "3": {
                url = "/images/mobile/emotion/skrl_xgjxz_123_104.png";
                msg1 = OperationRsEnum.MODIFY.getName();
                msg2 = OperationRsEnum.MODIFY.getMsg();
            }
        }
        imageap.setUrl(url);
        labelM1.setText(msg1);
        labelM2.setText(msg2);
    }

    private void showOperationResult(String pagetype, String billno) {
        List claimBill = QueryServiceHelper.queryPrimaryKeys((String)"cas_claimbill", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billno)}, null, (int)1);
        if (claimBill == null || claimBill.isEmpty()) {
            return;
        }
        List records = WorkflowServiceHelper.getAllApprovalRecord((String)claimBill.get(0).toString());
        log.info(String.format("call getAllApprovalRecord,data:%s", SerializationUtils.toJsonString((Object)records)));
        records.removeIf(group -> StringUtils.equals((CharSequence)group.getGroupDecisionType(), (CharSequence)"wait"));
        Map<String, IApprovalRecordGroup> map = this.prehandleRecords(claimBill.get(0).toString());
        log.info(String.format("call prehandleRecords,data:%s", SerializationUtils.toJsonString(map)));
        ArrayList<IApprovalRecordGroup> record = new ArrayList<IApprovalRecordGroup>(10);
        record.addAll(records);
        for (IApprovalRecordGroup iApprovalRecordGroup : records) {
            map.remove(((IApprovalRecordItem)iApprovalRecordGroup.getChildren().get(0)).getActivityName().trim());
        }
        for (Map.Entry entry : map.entrySet()) {
            record.add((IApprovalRecordGroup)entry.getValue());
        }
        if (CollectionUtils.isEmpty(record)) {
            List<IApprovalRecordGroup> recordGroups = this.mockApprovalRecordGroupsData();
            Label label = (Label)this.getControl("label_msg_2");
            label.setText(ResManager.loadKDString((String)"\u8bf7\u7b49\u5f85\u8d22\u52a1\u786e\u8ba4\u3002", (String)"OperationResultPlugin_0", (String)"fi-cas-mobile", (Object[])new Object[0]));
            this.jumpApprovalNode(pagetype, recordGroups);
        } else {
            log.info(String.format("before call jumpApprovalNode,data:%s", SerializationUtils.toJsonString(record)));
            this.jumpApprovalNode(pagetype, record);
        }
    }

    private Map<String, IApprovalRecordGroup> prehandleRecords(String claimBillId) {
        List<Map<String, Object>> windowRecords = RecClaimBillOperationHelper.forecastWorkflow(claimBillId);
        log.info(String.format("call getProcessWindowRecords,data:%s", SerializationUtils.toJsonString(windowRecords)));
        LinkedHashMap<String, IApprovalRecordGroup> map = new LinkedHashMap<String, IApprovalRecordGroup>();
        HashSet<String> tmp = new HashSet<String>();
        tmp.add(ResManager.loadKDString((String)"\u5f00\u59cb", (String)"OperationResultPlugin_1", (String)"fi-cas-mobile", (Object[])new Object[0]));
        tmp.add(ResManager.loadKDString((String)"\u7ed3\u675f", (String)"OperationResultPlugin_2", (String)"fi-cas-mobile", (Object[])new Object[0]));
        for (int i = 0; i < windowRecords.size(); ++i) {
            String nodeName;
            Map<String, Object> objectMap = windowRecords.get(i);
            if (objectMap == null || tmp.contains(nodeName = objectMap.get("nodeName").toString().trim())) continue;
            if (map.containsKey(nodeName) && ((Boolean)objectMap.get("executed")).booleanValue()) {
                map.remove(nodeName);
            }
            ApprovalRecordGroup group = new ApprovalRecordGroup();
            ArrayList<ApprovalRecordItem> items = new ArrayList<ApprovalRecordItem>(10);
            group.setActivityName(nodeName);
            group.setGroupDecisionType("submit");
            Object obj = objectMap.get("assignee");
            if (obj == null) continue;
            List ids = null;
            if (obj instanceof List) {
                ids = (List)obj;
            }
            if (ids != null && !ids.isEmpty()) {
                ids = ids.stream().filter(Objects::nonNull).collect(Collectors.toList());
                List infos = UserServiceHelper.getUserInfoByID(ids);
                List positions = UserServiceHelper.getPosition(ids);
                Map avatarPath = UserServiceHelper.getUserAvatarPath(ids, (boolean)true);
                for (Map info : infos) {
                    StringBuilder sbr = new StringBuilder(info.get("name").toString());
                    ApprovalRecordItem item = new ApprovalRecordItem();
                    item.setActivityName(nodeName);
                    for (Map position : positions) {
                        if (!info.get("name").toString().equals(position.get("name").toString())) continue;
                        ArrayList arr = (ArrayList)position.get("entryentity");
                        item.setAvatar((String)avatarPath.get(position.get("id")));
                        if (CollectionUtils.isEmpty((Collection)arr)) break;
                        for (Map m : arr) {
                            if (((Boolean)m.get("ispartjob")).booleanValue()) continue;
                            sbr.append('|').append(m.get("position"));
                        }
                    }
                    item.setAssignee(sbr.toString());
                    items.add(item);
                }
            }
            if (!((Boolean)objectMap.get("executed")).booleanValue()) {
                group.setGroupDecisionType("wait");
            }
            group.setChildren(items);
            map.put(nodeName, (IApprovalRecordGroup)group);
        }
        return map;
    }

    private void jumpApprovalNode(String pagetype, List<IApprovalRecordGroup> record) {
        Container control = (Container)this.getControl("flex_approval_process");
        List items = control.getItems();
        if (!items.isEmpty()) {
            control.deleteControls((String[])items.stream().map(Control::getKey).toArray(String[]::new));
        }
        FlexPanelAp flex = new FlexPanelAp();
        for (int i = record.size() - 1; i >= 0; --i) {
            String flexNumber = "result_item_tmp" + i;
            flex.setKey(flexNumber);
            flex.setGrow(0);
            flex.setShrink(0);
            ArrayList<Map> list = new ArrayList<Map>(1);
            list.add(flex.createControl());
            control.addControls(list);
            MobileFormShowParameter showParameter = new MobileFormShowParameter();
            showParameter.setFormId("cas_approval_node");
            showParameter.getOpenStyle().setShowType(ShowType.InContainer);
            showParameter.getOpenStyle().setTargetKey(flexNumber);
            showParameter.setCustomParam("pagetype", (Object)pagetype);
            showParameter.setCustomParam("item", (Object)record.get(i));
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    private List<IApprovalRecordGroup> mockApprovalRecordGroupsData() {
        ArrayList<IApprovalRecordGroup> record = new ArrayList<IApprovalRecordGroup>(2);
        RequestContext context = RequestContext.get();
        long userId = Long.parseLong(context.getUserId());
        record.add((IApprovalRecordGroup)this.newApprovalRecordGroup("submit", ResManager.loadKDString((String)"\u6536\u6b3e\u8ba4\u9886\u5355\u63d0\u4ea4", (String)"OperationResultPlugin_3", (String)"fi-cas-mobile", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6536\u6b3e\u8ba4\u9886\u5355\u63d0\u4ea4", (String)"OperationResultPlugin_3", (String)"fi-cas-mobile", (Object[])new Object[0]), this.getUserAvatar(userId), context.getUserName()));
        record.add((IApprovalRecordGroup)this.newApprovalRecordGroup("wait", ResManager.loadKDString((String)"\u8d22\u52a1\u786e\u8ba4", (String)"OperationResultPlugin_4", (String)"fi-cas-mobile", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8d22\u52a1\u786e\u8ba4", (String)"OperationResultPlugin_4", (String)"fi-cas-mobile", (Object[])new Object[0]), "images/pc/emotion/default_person_82_82.png", ""));
        return record;
    }

    private ApprovalRecordGroup newApprovalRecordGroup(String groupDecisionType, String groupActivityName, String itemActivityName, String itemAvatar, String itemAssignee) {
        ApprovalRecordGroup group = new ApprovalRecordGroup();
        group.setGroupDecisionType(groupDecisionType);
        group.setActivityName(groupActivityName);
        ArrayList<ApprovalRecordItem> items = new ArrayList<ApprovalRecordItem>(1);
        ApprovalRecordItem item = new ApprovalRecordItem();
        item.setActivityName(itemActivityName);
        item.setAvatar(itemAvatar);
        item.setAssignee(itemAssignee);
        items.add(item);
        group.setChildren(items);
        return group;
    }

    private String getUserAvatar(Long userId) {
        ArrayList<Long> id = new ArrayList<Long>(1);
        id.add(userId);
        Map userAvatarPath = UserServiceHelper.getUserAvatarPath(id, (boolean)true);
        return userAvatarPath.size() > 0 ? (String)userAvatarPath.get(userId) : null;
    }
}

