/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.mobile.recclaim;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.MobileBillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.container.Container;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.formplugin.mobile.recclaim.M;
import kd.fi.cas.formplugin.mobile.recclaim.RecClaimPageJumpHandler;
import kd.fi.cas.formplugin.mobile.recclaim.constant.ClaimCategoryEnum;
import kd.fi.cas.formplugin.mobile.recclaim.enums.BillStatusEnum;
import kd.fi.cas.formplugin.mobile.recclaim.enums.ClaimHandleStatusEnum;
import kd.fi.cas.formplugin.mobile.recclaim.enums.ClaimStatusEnum;
import kd.fi.cas.formplugin.mobile.recclaim.enums.ClaimTypeEnum;
import kd.fi.cas.formplugin.mobile.recclaim.enums.MergeStatusEnum;
import kd.fi.cas.formplugin.mobile.recclaim.helper.CasServiceHelper;
import kd.fi.cas.formplugin.mobile.recclaim.helper.MulLanguageHelper;
import kd.fi.cas.formplugin.mobile.recclaim.helper.RecClaimHelper;
import kd.fi.cas.formplugin.mobile.recclaim.result.InvokeResult;
import kd.fi.cas.formplugin.mobile.recclaim.temp.TempPush;
import kd.fi.cas.formplugin.mobile.recclaim.utils.EmptyUtil;
import kd.fi.cas.formplugin.mobile.recclaim.utils.RecClaimNoticeMobUtils;

public class RecClaimAnnounceMobBillPlugin
extends AbstractMobBillPlugIn
implements RowClickEventListener {
    public static final String FROM_CLAIM_BILL = "fromClaimBill";
    private static final String ENTRYENTITY = "entryentity";
    private static final String ENTRYSUMMARYMONEY = "entrysummary_money";
    private static final String OPPUNIT = "oppunit";
    private static final String OPPUNIT_LABEL = "labelap5";
    private static final String DRAWER_NAME = "drawername";
    private static final String PAYER_BASE = "recbasepayer";
    private static final String IS_CANCEL = "e_billstatus";
    private static final String CLAIM_TYPE = "e_claimtype";
    private static final String HANDLE_STATUS = "e_handlestatus";
    private static final String CALLBACKID_CONTINUE_REC_CLAIM = "CONTINUE_REC_CLAIM";
    private static final String SHOW_CONFIRM_CONTINUE_REC_CLAIM = "SHOW_CONFIRM_CRC";
    private static final String IS_OPEN = "is_open";

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"panel_more_less"});
        AbstractGrid entryentity = (AbstractGrid)this.getView().getControl(ENTRYENTITY);
        if (entryentity != null) {
            entryentity.addRowClickListener((RowClickEventListener)this);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String OptKey = ((Control)evt.getSource()).getKey();
        if (StringUtils.equals((CharSequence)"panel_more_less", (CharSequence)OptKey)) {
            this.ClickEventOfPanelMoreOrLess();
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.handlePayer();
        this.handlerRegistTime();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.handleBySrcPage();
        this.handleMerge();
        this.handleHeader();
        this.handleClaimedLabel();
        this.removeAppeal();
        this.handleEntryPanel();
        this.handleShowAppeal();
        this.handleFieldCaption();
        this.afterBindDataShowConfirm();
    }

    private void afterBindDataShowConfirm() {
        Object showConfirm = this.getView().getFormShowParameter().getCustomParam(SHOW_CONFIRM_CONTINUE_REC_CLAIM);
        if (showConfirm != null) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(CALLBACKID_CONTINUE_REC_CLAIM, (IFormPlugin)this);
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
            btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u5ffd\u7565", (String)"RecClaimAnnounceMobBillPlugin_10", (String)"fi-cas-mobile", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u7ee7\u7eed\u8ba4\u9886", (String)"RecClaimAnnounceMobBillPlugin_11", (String)"fi-cas-mobile", (Object[])new Object[0]));
            MessageBoxOptions options = MessageBoxOptions.OKCancel;
            String msg = ResManager.loadKDString((String)"\u9009\u62e9\u7ee7\u7eed\u8ba4\u9886\u5219\u8fd4\u56de\u901a\u77e5\u5355\uff0c\r\n\u9009\u62e9\u5ffd\u7565\u5219\u5ffd\u7565\u8be5\u5355\u5e76\u8fd4\u56de\u5217\u8868", (String)"RecClaimAnnounceMobBillPlugin_16", (String)"fi-cas-mobile", (Object[])new Object[0]);
            this.getView().showConfirm(msg, this.getModel().getChangeDesc(), options, ConfirmTypes.Default, confirmCallBacks, btnNameMaps);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        if (StringUtils.equals((CharSequence)e.getCallBackId(), (CharSequence)CALLBACKID_CONTINUE_REC_CLAIM) && e.getResult() == MessageBoxResult.Cancel) {
            this.ignoreNotices(this.getModel().getValue("id"));
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5ffd\u7565\u6210\u529f\u3002", (String)"RecClaimAnnounceMobBillPlugin_13", (String)"fi-cas-mobile", (Object[])new Object[0]));
            RecClaimNoticeMobUtils.refreshTargetParentPage(this.getView(), "cas_claimanno_moblist");
            this.getModel().setDataChanged(false);
            this.getView().close();
        }
    }

    private void ignoreNotices(Object id) {
        DynamicObject[] dynamicObjects = new DynamicObject[1];
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"cas_claim_category");
        dynamicObject.set("userid", (Object)Long.valueOf(RequestContext.get().getUserId()));
        dynamicObject.set("noticeid", id);
        dynamicObject.set("type", (Object)ClaimCategoryEnum.IGNORE_BILL.getCode());
        dynamicObjects[0] = dynamicObject;
        try (TXHandle ignored = TX.requiresNew();){
            DeleteServiceHelper.delete((String)"cas_claim_category", (QFilter[])new QFilter[]{new QFilter("userid", "=", (Object)Long.valueOf(RequestContext.get().getUserId())).and("noticeid", "=", id)});
            SaveServiceHelper.save((DynamicObject[])dynamicObjects);
        }
    }

    private void handlerRegistTime() {
        Object businesstype = this.getModel().getValue("businesstype");
        if ("recticket".equals(businesstype)) {
            this.getModel().setValue("registtime", this.getModel().getValue("tradetime"));
        }
    }

    private void handleFieldCaption() {
        IDataModel model = this.getModel();
        Object mergestatus = model.getValue("mergestatus");
        boolean isMergeBill = "2".equals(mergestatus);
        Object businesstype = model.getValue("businesstype");
        boolean isRecBill = "rec".equals(businesstype);
        String reamountFieldAlias = MulLanguageHelper.getReamountFieldAlias(isRecBill, isMergeBill);
        String tradetimeFieldAlias = MulLanguageHelper.getTradetimeFieldAlias(isRecBill);
        FieldEdit reamountFieldEdit = (FieldEdit)this.getControl("reamount");
        LocaleString reamountCaption = new LocaleString();
        reamountCaption.setLocaleValue(reamountFieldAlias);
        reamountFieldEdit.setCaption(reamountCaption);
        FieldEdit tradetimeFieldEdit = (FieldEdit)this.getControl("tradetime");
        tradetimeFieldEdit.setCaption(new LocaleString(tradetimeFieldAlias));
    }

    private void removeAppeal() {
        DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity(ENTRYENTITY);
        dynamicObjects.removeAll((Collection)dynamicObjects.stream().filter(dy -> (ClaimTypeEnum.APPEAL.getValue().equals(dy.get(CLAIM_TYPE)) || ClaimTypeEnum.CHANGE.getValue().equals(dy.get(CLAIM_TYPE))) && !dy.getBoolean(HANDLE_STATUS)).collect(Collectors.toList()));
        this.getView().updateView(ENTRYENTITY);
    }

    private void handlePayer() {
        String type = (String)this.getModel().getValue("paymenttype");
        if (StringUtils.isNotBlank((CharSequence)type) && !StringUtils.equals((CharSequence)type, (CharSequence)"other")) {
            this.getModel().setValue("paymentbasetype", (Object)type);
            this.getModel().setValue(PAYER_BASE, this.getModel().getValue("recpayer"));
        }
    }

    private void handleHeader() {
        Label label5 = (Label)this.getControl(OPPUNIT_LABEL);
        label5.setText((String)this.getModel().getValue(OPPUNIT));
        if ("recticket".equals(this.getModel().getValue("businesstype")) && MergeStatusEnum.ALMARGE.getValue().equals(this.getModel().getValue("mergestatus"))) {
            this.getModel().setValue(DRAWER_NAME, this.getModel().getValue(OPPUNIT));
        }
    }

    private void handleShowAppeal() {
        IDataModel iDataModel;
        String claimstatus;
        Container control = (Container)this.getControl("flex_panelap_appeal");
        String addContainerCache = this.getPageCache().get("addContainerCache");
        if (EmptyUtil.isNotEmpty(addContainerCache)) {
            control.deleteControls(addContainerCache.split(","));
        }
        if (StringUtils.equals((CharSequence)(claimstatus = (String)(iDataModel = this.getModel()).getValue("claimstatus")), (CharSequence)ClaimStatusEnum.APPEAL.getValue()) || StringUtils.equals((CharSequence)claimstatus, (CharSequence)ClaimStatusEnum.CHANGE.getValue())) {
            String claimNo = (String)iDataModel.getValue("billno");
            QFilter qFilter = new QFilter("claimno", "=", (Object)claimNo);
            qFilter.and(new QFilter("claimtype", "in", (Object)new String[]{ClaimTypeEnum.APPEAL.getValue(), ClaimTypeEnum.CHANGE.getValue()}));
            qFilter.and(new QFilter("billstatus", "=", (Object)"C"));
            qFilter.and(new QFilter("handlestatus", "=", (Object)ClaimHandleStatusEnum.NOTCLAIM.getValue()));
            List colls = QueryServiceHelper.queryPrimaryKeys((String)"cas_claimbill", (QFilter[])new QFilter[]{qFilter}, null, (int)-1);
            if (EmptyUtil.isNoEmpty(colls)) {
                FlexPanelAp flex = null;
                BillShowParameter showParameter = null;
                StringBuilder flexNumber = new StringBuilder();
                ArrayList<String> lst = new ArrayList<String>(colls.size());
                for (int i = 0; i < colls.size(); ++i) {
                    flexNumber.setLength(0);
                    flexNumber.append("flexpanelaptemp").append(i);
                    flex = new FlexPanelAp();
                    flex.setKey(flexNumber.toString());
                    flex.setGrow(0);
                    flex.setShrink(0);
                    control.addControls(Collections.singletonList(flex.createControl()));
                    showParameter = new BillShowParameter();
                    showParameter.setFormId("cas_claimappeal_m");
                    showParameter.getOpenStyle().setShowType(ShowType.InContainer);
                    showParameter.getOpenStyle().setTargetKey(flexNumber.toString());
                    lst.add(flexNumber.toString());
                    showParameter.setPkId(colls.get(i));
                    this.getView().showForm((FormShowParameter)showParameter);
                }
                this.getPageCache().put("addContainerCache", String.join((CharSequence)",", lst));
                this.getView().setVisible(Boolean.TRUE, new String[]{"flex_panelap_appeal"});
            }
        }
    }

    private void handleEntryPanel() {
        IDataModel model = this.getModel();
        DynamicObjectCollection entryEntity = model.getEntryEntity(ENTRYENTITY);
        BigDecimal reAmount = entryEntity.stream().filter(dy -> !dy.getBoolean(IS_CANCEL)).map(dynamicObject -> (BigDecimal)dynamicObject.get("e_receivableamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
        Label entryCountMoneyLabel = (Label)this.getControl(ENTRYSUMMARYMONEY);
        entryCountMoneyLabel.setText(M.getCurrencyFormatStr((DynamicObject)model.getValue("currency"), reAmount));
    }

    private void handleClaimedLabel() {
        IDataModel model = this.getModel();
        String billno = (String)model.getValue("billno");
        QFilter claimno = new QFilter("claimno", "=", (Object)billno);
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        QFilter creator = new QFilter("creator", "=", (Object)userId);
        QFilter billStatus = new QFilter("billStatus", "in", (Object)new String[]{BillStatusEnum.SUBMIT.getValue(), BillStatusEnum.AUDIT.getValue()});
        QFilter qFilter = new QFilter("claimtype", "in", (Object)new String[]{ClaimTypeEnum.CLAIM.getValue(), ClaimTypeEnum.CHANGE.getValue(), ClaimTypeEnum.ADJUST.getValue(), ClaimTypeEnum.APPEAL.getValue()});
        DynamicObjectCollection cas_claimbills = QueryServiceHelper.query((String)"cas_claimbill", (String)"id,claimno,claimtype", (QFilter[])new QFilter[]{claimno, creator, billStatus, qFilter});
        Map<Boolean, List<DynamicObject>> appealClaimTypeMap = cas_claimbills.stream().collect(Collectors.partitioningBy(dy -> ClaimTypeEnum.APPEAL.getValue().equals(dy.getString("claimtype"))));
        if (!CollectionUtils.isEmpty((Collection)appealClaimTypeMap.get(Boolean.TRUE))) {
            model.setValue("appealme", (Object)Boolean.TRUE);
        }
        if (!CollectionUtils.isEmpty((Collection)appealClaimTypeMap.get(Boolean.FALSE))) {
            model.setValue("claimme", (Object)Boolean.TRUE);
        }
    }

    private void handleBySrcPage() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Object fromClaimBill = parameter.getCustomParam(FROM_CLAIM_BILL);
        if (fromClaimBill != null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"mtoolbarap"});
        }
    }

    private void handleMerge() {
        IDataModel model = this.getModel();
        Object pkValue = model.getDataEntity().getPkValue();
        if (pkValue.equals(0L)) {
            return;
        }
        List<DynamicObject> margeBills = RecClaimHelper.getAllChildNoticeBill(pkValue);
        String type = (String)this.getModel().getValue("businesstype");
        if ("rec".equals(type)) {
            DynamicObjectCollection entryEntity = model.getEntryEntity("detailentryentity");
            for (DynamicObject margeBill : margeBills) {
                DynamicObject addNew = entryEntity.addNew();
                addNew.set("e_billno", (Object)margeBill.getString("tradedetailno"));
                addNew.set("e_tracebillno", (Object)margeBill.getString("detailid"));
                addNew.set("e_bankaccount", margeBill.get("accountbank"));
                addNew.set("e_tracedate", (Object)margeBill.getDate("tradetime"));
                String bankName = margeBill.getDynamicObject("bank") == null ? null : margeBill.getDynamicObject("bank").getString("name");
                addNew.set("e_opeanbank", (Object)bankName);
                addNew.set("e_reamount", (Object)margeBill.getBigDecimal("reamount"));
                addNew.set("e_oppbanknumber", (Object)margeBill.getString("oppbanknumber"));
                addNew.set("e_oppbank", (Object)margeBill.getString("oppbank"));
                addNew.set("e_datasource", (Object)margeBill.getString("datasource"));
                addNew.set("e_description", (Object)margeBill.getString("description"));
            }
            this.getView().updateView("detailentryentity");
        } else {
            DynamicObjectCollection entryEntity = model.getEntryEntity("ticketentryentity");
            for (DynamicObject margeBill : margeBills) {
                DynamicObject addNew = entryEntity.addNew();
                addNew.set("e_ticketbillno", (Object)margeBill.getString("tradedetailno"));
                addNew.set("e_ticketamount", (Object)margeBill.getBigDecimal("reamount"));
                String name = margeBill.getDynamicObject("draftbilltype") == null ? "" : margeBill.getDynamicObject("draftbilltype").getString("name");
                addNew.set("e_draftbilltype", (Object)name);
                addNew.set("e_ticketdescription", (Object)margeBill.getString("description"));
                addNew.set("e_ticketdate", (Object)margeBill.getDate("tradetime"));
                addNew.set("e_draftbillexpiredate", (Object)margeBill.getDate("draftbillexpiredate"));
                addNew.set("e_drawername", (Object)margeBill.getString(DRAWER_NAME));
                addNew.set("e_ticketname", (Object)margeBill.getString("detailid"));
                addNew.set("e_ticketsource", (Object)margeBill.getString("datasource"));
            }
            this.getView().updateView("ticketentryentity");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("claim".equals(operateKey)) {
            this.claim(args);
        } else if ("appeal".equals(operateKey)) {
            this.appeal(args);
        } else if ("cancelmerge".equals(operateKey)) {
            try {
                this.beforeCancelMerge(args);
            }
            catch (Exception ex) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u8981\u8bfb\u53d6\u7684\u6570\u636e\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\u3002", (String)"RecClaimAnnounceMobBillPlugin_7", (String)"fi-cas-mobile", (Object[])new Object[0]));
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        OperationResult result = args.getOperationResult();
        if ("transpond".equals(operateKey)) {
            if (result.isSuccess()) {
                RecClaimPageJumpHandler.showTranspondUserListPage((AbstractFormPlugin)this);
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u8981\u8bfb\u53d6\u7684\u6570\u636e\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\u3002", (String)"RecClaimAnnounceMobBillPlugin_7", (String)"fi-cas-mobile", (Object[])new Object[0]));
            }
        }
    }

    private void beforeCancelMerge(BeforeDoOperationEventArgs args) {
        Object primaryKeyValue = this.getModel().getValue("id");
        InvokeResult ret = CasServiceHelper.beforeCancelMerge(primaryKeyValue);
        if (!ret.isSuccess()) {
            this.getView().showTipNotification(ret.getMsg());
        } else {
            HashMap<String, Object> dataMap = new HashMap<String, Object>();
            dataMap.put("pk", primaryKeyValue);
            dataMap.put("listType", this.getView().getParentView().getFormShowParameter().getCustomParam("listType"));
            Object claimCenterBillObject = ret.get("claimCenterBill");
            Object unClaimAmount = ((Map)claimCenterBillObject).get("unclaimamount");
            RecClaimPageJumpHandler.showAnnounceCancelMergeListPage((AbstractFormPlugin)this, dataMap, unClaimAmount);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        if ("cancelMerge".equals(actionId)) {
            Object returnData = evt.getReturnData();
            if ("success".equals(returnData)) {
                RecClaimNoticeMobUtils.refreshTargetParentPage(this.getView(), "cas_claimanno_moblist");
            }
        } else if (actionId.equals("transpond") && evt.getReturnData() != null) {
            this.transpond(evt);
        }
    }

    private void transpond(ClosedCallBackEvent evt) {
        ListSelectedRowCollection returnData = (ListSelectedRowCollection)evt.getReturnData();
        Set userPks = returnData.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toSet());
        Map users = BusinessDataServiceHelper.loadFromCache((String)"bos_user", (String)"id,name", (QFilter[])new QFilter("id", "in", userPks).toArray());
        HashMap<Object, String> userIdNames = new HashMap<Object, String>(users.size());
        for (Map.Entry entry : users.entrySet()) {
            String name = ((DynamicObject)entry.getValue()).getString("name");
            userIdNames.put(entry.getKey(), name);
        }
        Object[] selectIds = new Object[]{this.getModel().getValue("id")};
        InvokeResult ret = CasServiceHelper.transpond(userIdNames, selectIds);
        if (ret.isSuccess()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8f6c\u53d1\u6210\u529f\u3002", (String)"RecClaimAnnounceMobBillPlugin_6", (String)"fi-cas-mobile", (Object[])new Object[0]));
            String tabKey = (String)this.getView().getParentView().getFormShowParameter().getCustomParam("listType");
            if (StringUtils.equals((CharSequence)tabKey, (CharSequence)"undo_page") || StringUtils.equals((CharSequence)tabKey, (CharSequence)"pending_page")) {
                MobileBillShowParameter parameter = new MobileBillShowParameter();
                parameter.getOpenStyle().setShowType(ShowType.Floating);
                parameter.setFormId("cas_claimannounce_m");
                parameter.setPkId(this.getView().getModel().getValue("id"));
                parameter.setCustomParam(SHOW_CONFIRM_CONTINUE_REC_CLAIM, (Object)"true");
                parameter.setCustomParam("listType", (Object)tabKey);
                parameter.setParentPageId(this.getView().getParentView().getPageId());
                this.getView().showForm((FormShowParameter)parameter);
            }
            this.getModel().setDataChanged(false);
            this.getView().close();
        }
    }

    private void appeal(BeforeDoOperationEventArgs args) {
        Object pk = this.getModel().getValue("id");
        IFormView view = this.getView();
        InvokeResult ret = CasServiceHelper.beforeAppeal(pk);
        if (!ret.isSuccess()) {
            if (ret.get("recentDateId") != null) {
                RecClaimPageJumpHandler.showClaimBillForm((AbstractFormPlugin)this, ret.get("recentDateId"));
                view.showTipNotification(ret.getMsg());
                args.setCancel(true);
            } else {
                this.getView().showTipNotification(ret.getMsg());
                args.setCancel(true);
            }
            return;
        }
        args.setCancel(true);
        ArrayList<ListSelectedRow> selectedRows = new ArrayList<ListSelectedRow>();
        ListSelectedRow srcBill = new ListSelectedRow(pk);
        selectedRows.add(srcBill);
        new TempPush().pushClaimBill((AbstractFormPlugin)this, selectedRows, args);
    }

    private void claim(BeforeDoOperationEventArgs args) {
        IFormView view = this.getView();
        Object pk = this.getModel().getValue("id");
        InvokeResult ret = CasServiceHelper.beforeClaim(pk);
        if (!ret.isSuccess()) {
            if (ret.get("recentDateId") != null) {
                RecClaimPageJumpHandler.showClaimBillForm((AbstractFormPlugin)this, ret.get("recentDateId"));
                view.showTipNotification(ret.getMsg());
                args.setCancel(true);
            } else {
                this.getView().showTipNotification(ret.getMsg());
                args.setCancel(true);
            }
            return;
        }
        args.setCancel(true);
        ArrayList<ListSelectedRow> selectedRows = new ArrayList<ListSelectedRow>();
        ListSelectedRow srcBill = new ListSelectedRow(pk);
        selectedRows.add(srcBill);
        new TempPush().pushClaimBill((AbstractFormPlugin)this, selectedRows, args);
    }

    public void entryRowClick(RowClickEvent evt) {
        CardEntry source = (CardEntry)evt.getSource();
        if (ENTRYENTITY.equals(source.getEntryKey())) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRYENTITY);
            RecClaimPageJumpHandler.claimAnnounceToAnnounceEntry((AbstractFormPlugin)this, rowIndex);
        }
    }

    private void setCustomCtrlProp(String controlId, Map<String, Object> data) {
        CustomControl node = (CustomControl)this.getView().getControl(controlId);
        IClientViewProxy proxy = (IClientViewProxy)node.getView().getService(IClientViewProxy.class);
        HashMap<String, Object> _data = (HashMap<String, Object>)proxy.getViewState(node.getKey());
        if (_data == null) {
            _data = new HashMap<String, Object>();
        }
        _data.putAll(data);
        node.setData(_data);
    }

    private void ClickEventOfPanelMoreOrLess() {
        String flagOfOpen = this.getPageCache().get(IS_OPEN);
        if (StringUtils.equals((CharSequence)flagOfOpen, (CharSequence)"true")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap17", "vectorap_up"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"vectorap_down"});
            ((Label)this.getControl("label_more_less")).setText(ResManager.loadKDString((String)"\u5c55\u793a\u66f4\u591a", (String)"RecClaimAnnounceMobBillPlugin_14", (String)"fi-cas-mobile", (Object[])new Object[0]));
            this.getPageCache().put(IS_OPEN, "false");
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap17", "vectorap_up"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"vectorap_down"});
            ((Label)this.getControl("label_more_less")).setText(ResManager.loadKDString((String)"\u6536\u8d77", (String)"RecClaimAnnounceMobBillPlugin_15", (String)"fi-cas-mobile", (Object[])new Object[0]));
            this.getPageCache().put(IS_OPEN, "true");
        }
    }
}

