/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.mobile.recclaim;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.container.TabPage;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.MobileSearchCancelListener;
import kd.bos.form.control.events.MobileSearchTextChangeEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.AfterMobileListPushDownRefreshEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.MobileSearch;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.plugin.AbstractMobListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.formplugin.mobile.recclaim.RecClaimMobListFilterProvider;
import kd.fi.cas.formplugin.mobile.recclaim.RecClaimPageJumpHandler;
import kd.fi.cas.formplugin.mobile.recclaim.constant.ClaimCategoryEnum;
import kd.fi.cas.formplugin.mobile.recclaim.constant.SubscriptEnum;
import kd.fi.cas.formplugin.mobile.recclaim.enums.BillStatusEnum;
import kd.fi.cas.formplugin.mobile.recclaim.enums.ClaimTypeEnum;
import kd.fi.cas.formplugin.mobile.recclaim.helper.CasServiceHelper;
import kd.fi.cas.formplugin.mobile.recclaim.result.InvokeResult;
import kd.fi.cas.formplugin.mobile.recclaim.temp.TempPush;
import kd.fi.cas.formplugin.mobile.recclaim.utils.CastUtils;
import kd.fi.cas.formplugin.mobile.recclaim.utils.RecClaimNoticeMobUtils;

public class RecClaimAnnounceMobListPlugin
extends AbstractMobListPlugin
implements RowClickEventListener,
MobileSearchCancelListener {
    private static final String ALGO = "kd.fi.cas.formplugin.mobile.recclaim.RecClaimAnnounceMobListPlugin";
    public static final String PAGE_CACHE_MERGING = "pageCache_merging";
    public static final String PAGE_CACHE_SEARCHING = "pageCache_searching";
    public static final String PAGE_CACHE_ANNOUNCE_STATUS_FILTER = "pageCache_announceStatusFilter";
    private static final int TOTAL_FILTER_STATUS_COUNT = 6;
    public static final String LIST_TYPE = "listType";
    public static final String ALL = "all";
    protected static final List<String> noticeTabList = new ArrayList<String>();
    public static final String INDEX_PAGE_TAG = "cas_index_m";
    public static final String NOTICE_TAB_PAGE_TAG = "cas_claimnotice_m";
    public static final String NOTICE_LIST_PAGE_TAG = "cas_claimanno_moblist";
    private static final String NOTICE_LIST_TAG = "flexpanelapoperator";
    private static final String EMPTY_LIST_PICTURE_TAG = "flexpanelap9";
    private static final String DO_SEARCH_TAG = "DO_SEARCH";
    private static final String DO_FILTER_TAG = "DO_FILTER";
    public static final String IS_EMPTY_LIST = "IS_EMPTY_LIST";
    private static final String NO_DO_IDS = "nodoIds";

    private List<Long> getIgnoreNoticeIds() {
        String nodoIds = this.getPageCache().get(NO_DO_IDS);
        if (nodoIds == null) {
            return null;
        }
        String[] split = nodoIds.split(",");
        return Arrays.stream(split).map(Long::parseLong).collect(Collectors.toList());
    }

    private void setIgnoreNoticeIds(List<Long> ignoreNoticeIds) {
        if (ignoreNoticeIds == null || ignoreNoticeIds.isEmpty()) {
            return;
        }
        String collect = ignoreNoticeIds.stream().map(aLong -> aLong + "").collect(Collectors.joining(","));
        this.getPageCache().put(NO_DO_IDS, collect);
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
    }

    public void initialize() {
        super.initialize();
    }

    public void setView(IFormView formView) {
        super.setView(formView);
    }

    public void afterCreateNewData(EventObject e) {
        ArrayList<String[]> statusInfos = new ArrayList<String[]>();
        if (RecClaimNoticeMobUtils.isFromNoticeTabPage(this.getView())) {
            switch (this.getListType()) {
                case "undo_page": {
                    this.getModel().setValue("pagetype", (Object)"6");
                    RecClaimNoticeMobUtils.saveLastestClaimRecord();
                    break;
                }
                case "pending_page": {
                    this.getModel().setValue("pagetype", (Object)"7");
                    break;
                }
                case "ignore_page": {
                    this.getModel().setValue("pagetype", (Object)"8");
                }
            }
            statusInfos.add(new String[]{"0", ResManager.loadKDString((String)"\u5f85\u8ba4\u9886", (String)"RecClaimAnnounceMobListPlugin_4", (String)"fi-cas-mobile", (Object[])new Object[0])});
            statusInfos.add(new String[]{"1", ResManager.loadKDString((String)"\u90e8\u5206\u8ba4\u9886", (String)"RecClaimAnnounceMobListPlugin_5", (String)"fi-cas-mobile", (Object[])new Object[0])});
            statusInfos.add(new String[]{"2", ResManager.loadKDString((String)"\u5df2\u8ba4\u9886", (String)"RecClaimAnnounceMobListPlugin_10", (String)"fi-cas-mobile", (Object[])new Object[0])});
        } else if (StringUtils.equals((CharSequence)ALL, (CharSequence)((CharSequence)this.getView().getFormShowParameter().getCustomParam(LIST_TYPE)))) {
            this.getModel().setValue("pagetype", (Object)"1");
            statusInfos.add(new String[]{"0", ResManager.loadKDString((String)"\u5f85\u8ba4\u9886", (String)"RecClaimAnnounceMobListPlugin_4", (String)"fi-cas-mobile", (Object[])new Object[0])});
            statusInfos.add(new String[]{"1", ResManager.loadKDString((String)"\u90e8\u5206\u8ba4\u9886", (String)"RecClaimAnnounceMobListPlugin_5", (String)"fi-cas-mobile", (Object[])new Object[0])});
            statusInfos.add(new String[]{"2", ResManager.loadKDString((String)"\u5df2\u8ba4\u9886", (String)"RecClaimAnnounceMobListPlugin_10", (String)"fi-cas-mobile", (Object[])new Object[0])});
            statusInfos.add(new String[]{"3", ResManager.loadKDString((String)"\u5df2\u786e\u8ba4", (String)"RecClaimAnnounceMobListPlugin_11", (String)"fi-cas-mobile", (Object[])new Object[0])});
            statusInfos.add(new String[]{"4", ResManager.loadKDString((String)"\u7533\u8bc9\u4e2d", (String)"RecClaimAnnounceMobListPlugin_12", (String)"fi-cas-mobile", (Object[])new Object[0])});
            statusInfos.add(new String[]{"5", ResManager.loadKDString((String)"\u53d8\u66f4\u4e2d", (String)"RecClaimAnnounceMobListPlugin_13", (String)"fi-cas-mobile", (Object[])new Object[0])});
        } else {
            this.getModel().setValue("pagetype", (Object)"1");
            statusInfos.add(new String[]{"0", ResManager.loadKDString((String)"\u5f85\u8ba4\u9886", (String)"RecClaimAnnounceMobListPlugin_4", (String)"fi-cas-mobile", (Object[])new Object[0])});
            statusInfos.add(new String[]{"1", ResManager.loadKDString((String)"\u90e8\u5206\u8ba4\u9886", (String)"RecClaimAnnounceMobListPlugin_5", (String)"fi-cas-mobile", (Object[])new Object[0])});
        }
        this.setStatusFilter(statusInfos);
        if (Arrays.asList("undo_page", "pending_page").contains(this.getView().getFormShowParameter().getCustomParam(LIST_TYPE))) {
            QFilter filter = RecClaimNoticeMobUtils.getQFilter(this.getView(), (String)this.getView().getFormShowParameter().getCustomParam(LIST_TYPE));
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"cas_claimannounce", (String)"id", (QFilter[])new QFilter[]{filter});
            List<Long> ids = RecClaimNoticeMobUtils.distinctByPrimaryKey(dynamicObjects).stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
            this.setIgnoreNoticeIds(ids);
        }
        this.setIsMultiSelect(false);
        switch (this.getListType()) {
            case "undo_page": {
                this.setCustomCtrlProp("custom_control_menu_more", "type", 5);
                break;
            }
            case "pending_page": {
                this.setCustomCtrlProp("custom_control_menu_more", "type", 1);
                break;
            }
            case "ignore_page": {
                this.setCustomCtrlProp("custom_control_menu_more", "type", 6);
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"cancelmerge", "btn_combined", "btn_combined2", "btn_combined_cancel", "btn_combined_submit", "btn_exec_cancelmerge", "flex_status_selected", "btn_combined_select_all", "btn_search", "btn_ignor_all"});
        ((MobileSearch)this.getControl("mobilesearchap")).addMobileSearchCancelListener((MobileSearchCancelListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            parentView.getPageCache().put(NOTICE_TAB_PAGE_TAG + this.getListType(), this.getView().getPageId());
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.determineWhetherHideCardSelector();
        if (this.getPageCache().get(DO_FILTER_TAG) == null) {
            RecClaimNoticeMobUtils.refreshTargetParentPage(this.getView(), INDEX_PAGE_TAG);
            RecClaimNoticeMobUtils.refreshTab(this.getView(), NOTICE_TAB_PAGE_TAG, noticeTabList);
        } else {
            this.getPageCache().remove(DO_FILTER_TAG);
        }
    }

    private void determineWhetherHideCardSelector() {
        if (this.getPageCache().get(PAGE_CACHE_MERGING) == null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"cardselectorap"});
        }
    }

    private void setCardSelectorVisible(boolean visible) {
        this.getView().setVisible(Boolean.valueOf(visible), new String[]{"cardselectorap"});
        this.setVisible(!visible, "claim", "cancelmerge", "buttonap", "btn_menu_more");
    }

    private void setVisible(boolean visible, String key) {
        HashMap<String, String> config = new HashMap<String, String>();
        String vi = visible ? "63" : "0";
        config.put("vi", vi);
        config.put("id", key);
        this.getView().updateControlMetadata(key, config);
    }

    private void setVisible(boolean visible, String ... keys) {
        for (String key : keys) {
            this.setVisible(visible, key);
        }
    }

    public void listRowClick(ListRowClickEvent evt) {
        super.listRowClick(evt);
        if (this.getPageCache().get(PAGE_CACHE_MERGING) != null) {
            evt.setCancel(true);
            int size = ((IListView)this.getView()).getSelectedRows().size();
            ((Label)this.getView().getControl("label_combined_sel_count")).setText(String.valueOf(size));
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Object source = evt.getSource();
        if (source instanceof Control) {
            Control control = (Control)source;
            String key = control.getKey();
            if ("btn_combined".equals(key) || "btn_combined2".equals(key)) {
                this.setCardSelectorVisible(true);
                this.getPageCache().put(PAGE_CACHE_MERGING, "true");
                this.setIsMultiSelect(true);
            } else if ("btn_combined_cancel".equals(key)) {
                this.setCardSelectorVisible(false);
                this.getPageCache().remove(PAGE_CACHE_MERGING);
                this.setIsMultiSelect(false);
            } else if ("btn_combined_submit".equals(key)) {
                this.doMerge();
            } else if ("cancelmerge".equals(key)) {
                this.doCancelMerge(new HashMap<String, Object>());
            } else if ("flex_status_selected".equals(key)) {
                String curFilterStr = this.getPageCache().get(PAGE_CACHE_ANNOUNCE_STATUS_FILTER);
                RecClaimPageJumpHandler.showAnnounceListStatusFilterPage((AbstractFormPlugin)this, curFilterStr);
            } else if (!"btn_combined_select_all".equals(key) && StringUtils.equals((CharSequence)"btn_ignor_all", (CharSequence)key)) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u5b9a\u5ffd\u7565\u5f53\u524d\u5217\u8868\u6240\u6709\u901a\u77e5\u5417\uff1f", (String)"RecClaimAnnounceMobListPlugin_15", (String)"fi-cas-mobile", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("ignoreAllNotices", (IFormPlugin)this));
            }
        }
    }

    private void doIgnoreAllNotices() {
        List ids;
        List<Long> ignoreNoticeIds = this.getIgnoreNoticeIds();
        QFilter searchFilter = null;
        String searchStr = ((MobileSearch)this.getView().getControl("mobilesearchap")).getText();
        String doSearch = this.getPageCache().get(DO_SEARCH_TAG);
        if (StringUtils.isNotEmpty((CharSequence)searchStr) && "true".equals(doSearch)) {
            searchFilter = new QFilter("billno", "like", (Object)("%" + searchStr + "%")).or("oppunit", "like", (Object)("%" + searchStr + "%")).or("description", "like", (Object)("%" + searchStr + "%"));
        }
        if (CollectionUtils.isEmpty(ignoreNoticeIds)) {
            QFilter filter = RecClaimNoticeMobUtils.getQFilter(this.getView(), (String)this.getView().getFormShowParameter().getCustomParam(LIST_TYPE));
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"cas_claimannounce", (String)"id", (QFilter[])new QFilter[]{filter, searchFilter});
            ids = RecClaimNoticeMobUtils.distinctByPrimaryKey(dynamicObjects).stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
        } else {
            ids = QueryServiceHelper.queryPrimaryKeys((String)"cas_claimannounce", (QFilter[])new QFilter[]{new QFilter("id", "in", ignoreNoticeIds), searchFilter}, null, (int)-1);
        }
        if (!CollectionUtils.isEmpty((Collection)ids)) {
            Long[] ignoreNoticeArray = new Long[ids.size()];
            for (int i = 0; i < ids.size(); ++i) {
                ignoreNoticeArray[i] = (Long)ids.get(i);
            }
            this.ignoreNotices((String)this.getView().getFormShowParameter().getCustomParam(LIST_TYPE), ignoreNoticeArray);
            this.getPageCache().remove(NO_DO_IDS);
            this.refresh();
        }
    }

    private void ignoreNotices(String listType, Long[] ids) {
        DynamicObject[] dynamicObjects = new DynamicObject[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"cas_claim_category");
            dynamicObject.set("userid", (Object)Long.valueOf(RequestContext.get().getUserId()));
            dynamicObject.set("noticeid", (Object)ids[i]);
            dynamicObject.set("type", (Object)ClaimCategoryEnum.IGNORE_BILL.getCode());
            dynamicObjects[i] = dynamicObject;
        }
        try (TXHandle tx = TX.requiresNew();){
            DeleteServiceHelper.delete((String)"cas_claim_category", (QFilter[])new QFilter[]{new QFilter("userid", "=", (Object)Long.valueOf(RequestContext.get().getUserId())).and("noticeid", "in", (Object)ids)});
            SaveServiceHelper.save((DynamicObject[])dynamicObjects);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("claim".equals(operateKey)) {
            this.beforeDoClaim(args);
        } else if ("appeal".equals(operateKey)) {
            this.beforeDoAppeal(args);
        }
        IListView view = (IListView)this.getView();
        view.clearSelection();
    }

    private boolean beforeDoAppeal(BeforeDoOperationEventArgs args) {
        IListView view = (IListView)this.getView();
        Object announceBillPk = view.getFocusRowPkId();
        InvokeResult ret = CasServiceHelper.beforeAppeal(announceBillPk);
        if (!ret.isSuccess()) {
            if (ret.get("recentDateId") != null) {
                RecClaimPageJumpHandler.showClaimBillForm((AbstractFormPlugin)this, ret.get("recentDateId"));
                view.showTipNotification(ret.getMsg());
                args.setCancel(true);
            } else {
                this.getView().showTipNotification(ret.getMsg());
                args.setCancel(true);
            }
            return false;
        }
        args.setCancel(true);
        ListSelectedRowCollection selectedRows = view.getSelectedRows();
        new TempPush().pushClaimBill((AbstractFormPlugin)this, (List)selectedRows, args);
        return true;
    }

    private boolean beforeDoClaim(BeforeDoOperationEventArgs args) {
        IListView view = (IListView)this.getView();
        Object announceBillPk = view.getFocusRowPkId();
        InvokeResult ret = CasServiceHelper.beforeClaim(announceBillPk);
        if (!ret.isSuccess()) {
            if (ret.get("recentDateId") != null) {
                RecClaimPageJumpHandler.showClaimBillForm((AbstractFormPlugin)this, ret.get("recentDateId"));
                view.showTipNotification(ret.getMsg());
                args.setCancel(true);
            } else {
                this.getView().showTipNotification(ret.getMsg());
                args.setCancel(true);
            }
            return false;
        }
        args.setCancel(true);
        ListSelectedRowCollection selectedRows = view.getSelectedRows();
        new TempPush().pushClaimBill((AbstractFormPlugin)this, (List)selectedRows, args);
        return true;
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        Object returnData;
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        if ("cas_claim_m_status_select".equals(actionId)) {
            this.getPageCache().put(DO_FILTER_TAG, "true");
            List returnData2 = (List)CastUtils.cast(evt.getReturnData());
            this.setStatusFilter(returnData2);
            this.refresh();
        } else if ("cancelMerge".equals(actionId) && "success".equals(returnData = evt.getReturnData())) {
            this.refresh();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u5408\u5e76\u6210\u529f\u3002", (String)"RecClaimAnnounceMobListPlugin_16", (String)"fi-cas-mobile", (Object[])new Object[0]));
        }
    }

    private void setStatusFilter(List<String[]> statusInfos) {
        String statusCacheStr = statusInfos.stream().map(v -> v[0]).collect(Collectors.joining(","));
        String statusAliasStr = statusInfos.size() == 6 ? ResManager.loadKDString((String)"\u5168\u90e8\u72b6\u6001", (String)"RecClaimAnnounceMobListPlugin_14", (String)"fi-cas-mobile", (Object[])new Object[0]) : statusInfos.stream().map(v -> v[1]).collect(Collectors.joining("\uff1b"));
        ((Label)this.getControl("label_status")).setText(statusAliasStr);
        this.getPageCache().put(PAGE_CACHE_ANNOUNCE_STATUS_FILTER, statusCacheStr);
    }

    private void doCancelMerge(Map<String, Object> data) {
        Object primaryKeyValue;
        if (CollectionUtils.isEmpty(data)) {
            IListView listview = (IListView)this.getView();
            primaryKeyValue = listview.getFocusRowPkId();
        } else {
            DynamicObject claim = QueryServiceHelper.queryOne((String)"cas_claimannounce", (String)"id", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)data.get("targetId").toString())});
            primaryKeyValue = claim.getLong("id");
        }
        InvokeResult ret = CasServiceHelper.beforeCancelMerge(primaryKeyValue);
        if (!ret.isSuccess()) {
            this.getView().showTipNotification(ret.getMsg());
        } else {
            HashMap<String, Object> dataMap = new HashMap<String, Object>();
            dataMap.put("pk", primaryKeyValue);
            dataMap.put(LIST_TYPE, this.getView().getFormShowParameter().getCustomParam(LIST_TYPE));
            Object claimCenterBillObject = ret.get("claimCenterBill");
            Object unClaimAmount = ((Map)claimCenterBillObject).get("unclaimamount");
            RecClaimPageJumpHandler.showAnnounceCancelMergeListPage((AbstractFormPlugin)this, dataMap, unClaimAmount);
        }
    }

    private void doMerge() {
        this.mergeClaimAnnounceBill(true);
    }

    private void mergeClaimAnnounceBill(boolean isNotComfirm) {
        IListView listview = (IListView)this.getView();
        ListSelectedRowCollection recClaimBillCollection = listview.getSelectedRows();
        if (recClaimBillCollection.size() <= 1) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9009\u4e2d1\u5f20\u4ee5\u4e0a\u7684\u901a\u77e5\u5355\u624d\u80fd\u8fdb\u884c\u5408\u5e76\u3002", (String)"RecClaimAnnounceMobListPlugin_6", (String)"fi-cas-mobile", (Object[])new Object[0]));
            ((Label)this.getView().getControl("label_combined_sel_count")).setText("0");
            listview.clearSelection();
            return;
        }
        this.getPageCache().put("hasNewNotice", this.whetherHasNewNoticeInUndo().toString());
        Object[] ids = new Object[recClaimBillCollection.size()];
        int count = 0;
        for (ListSelectedRow listSelectedRow : recClaimBillCollection) {
            ids[count++] = listSelectedRow.getPrimaryKeyValue();
        }
        InvokeResult ret = CasServiceHelper.mergeClaimAnnounceBill(ids, isNotComfirm);
        if (!ret.isSuccess()) {
            if (ret.get("needUserConfirm") != null) {
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("comfirmdate", (IFormPlugin)this);
                this.getView().showConfirm(ret.getMsg(), MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks);
            } else {
                this.getView().showErrorNotification(ret.getMsg());
                ((Label)this.getView().getControl("label_combined_sel_count")).setText("0");
                listview.clearSelection();
            }
        } else {
            String generateNumber = (String)ret.get("generateNumber");
            Long pkId = (Long)ret.get("pkId");
            this.afterMerge(generateNumber, pkId);
            this.getPageCache().remove(PAGE_CACHE_MERGING);
            this.setCardSelectorVisible(false);
            this.setIsMultiSelect(false);
            if (this.getPageCache().get(PAGE_CACHE_SEARCHING) != null) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap10"});
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap8"});
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{"flex_combined_operation"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"btn_combined"});
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (messageBoxClosedEvent.getCallBackId().equals("comfirmdate") && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.mergeClaimAnnounceBill(false);
        } else if (messageBoxClosedEvent.getCallBackId().equals("ignoreAllNotices") && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.doIgnoreAllNotices();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5217\u8868\u6240\u6709\u901a\u77e5\u5df2\u5ffd\u7565\u3002", (String)"RecClaimAnnounceMobListPlugin_17", (String)"fi-cas-mobile", (Object[])new Object[0]));
        }
    }

    private void afterMerge(String generateNumber, Long pkId) {
        if ("undo_page".equals(this.getView().getFormShowParameter().getCustomParam(LIST_TYPE)) && StringUtils.equals((CharSequence)"false", (CharSequence)this.getPageCache().get("hasNewNotice"))) {
            RecClaimNoticeMobUtils.saveLastestClaimRecord();
        }
        this.refresh();
        RecClaimPageJumpHandler.showAnnounceBillAfterMerge((AbstractFormPlugin)this, pkId, generateNumber);
    }

    private Boolean whetherHasNewNoticeInUndo() {
        if (!"undo_page".equals(this.getView().getFormShowParameter().getCustomParam(LIST_TYPE))) {
            return Boolean.FALSE;
        }
        QFilter commonFilter = RecClaimMobListFilterProvider.getClaimNoticeCommonFilter(true);
        QFilter undoFilter = RecClaimMobListFilterProvider.getClaimNoticeTabFilter("undo_page").and(commonFilter);
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"cas_claimannounce", (String)"id,entryentity1.id,entryentity1.claimtype,entryentity1.claimtypeid", (QFilter[])new QFilter[]{undoFilter});
        if (dynamicObjectCollection.isEmpty()) {
            return Boolean.FALSE;
        }
        List<DynamicObject> distinctedByIdDynamicObjectCollection = RecClaimNoticeMobUtils.distinctByPrimaryKey(dynamicObjectCollection);
        Long current = 0L;
        Long old = 0L;
        current = this.getMaxNoticeId(distinctedByIdDynamicObjectCollection);
        try (DataSet typeids = QueryServiceHelper.queryDataSet((String)ALGO, (String)"cas_claim_subscriptcache", (String)"lastestid", (QFilter[])new QFilter[]{new QFilter("userid", "=", (Object)Long.valueOf(RequestContext.get().getUserId())).and("type", "=", (Object)SubscriptEnum.UNDO_NOTICE.getCode())}, (String)"id desc", (int)1);){
            Object object;
            for (Row row : typeids) {
                old = row.getLong("lastestid");
            }
            if (current.compareTo(old) <= 0) {
                object = Boolean.FALSE;
                return object;
            }
            object = Boolean.TRUE;
            return object;
        }
    }

    private Long getMaxNoticeId(List<DynamicObject> claimAnnounceLst) {
        ArrayList<Long> ids = new ArrayList<Long>();
        for (DynamicObject dynamicObject : claimAnnounceLst) {
            long claimtype = dynamicObject.getLong("entryentity1.claimtype");
            if (claimtype == 1L && dynamicObject.getLong("entryentity1.claimtypeid") != Long.parseLong(RequestContext.get().getUserId())) continue;
            ids.add(dynamicObject.getLong("entryentity1.id"));
        }
        return ids.stream().mapToLong(Long::valueOf).max().orElse(0L);
    }

    private void refresh() {
        IFormView view = this.getView();
        view.invokeOperation("refresh");
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if ("refresh".equals(args.getOperateKey())) {
            this.setParentTabBillCount();
        }
    }

    public void mobileSearchTextChange(MobileSearchTextChangeEvent args) {
        this.getPageCache().put(DO_SEARCH_TAG, "true");
    }

    public void cancel() {
        this.getPageCache().put(DO_SEARCH_TAG, "false");
    }

    public void afterPushDownRefresh(AfterMobileListPushDownRefreshEvent evt) {
        super.afterPushDownRefresh(evt);
        this.setParentTabBillCount();
    }

    private void setParentTabBillCount() {
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return;
        }
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"cas_claimannounce", (String)"id", (QFilter[])new QFilter[]{RecClaimNoticeMobUtils.getQFilter(this.getView(), (String)this.getView().getFormShowParameter().getCustomParam(LIST_TYPE))});
        switch (parentView.getEntityId()) {
            case "cas_recclaim_m": {
                String[] tabInfo = new String[]{"tabannounce", ResManager.loadKDString((String)"\u8ba4\u9886\u901a\u77e5", (String)"RecClaimAnnounceMobListPlugin_3", (String)"fi-cas-mobile", (Object[])new Object[0])};
                String tabKey = tabInfo[0];
                String tabDesc = tabInfo[1];
                this.updateParentTabPage(parentView, tabKey, tabDesc, RecClaimNoticeMobUtils.distinctByPrimaryKey(dynamicObjects).size());
                break;
            }
            case "cas_claimnotice_m": {
                String tabKey = (String)this.getView().getFormShowParameter().getCustomParam(LIST_TYPE);
                String tabDesc = RecClaimNoticeMobUtils.getTabDescByTabKey(tabKey);
                this.updateParentTabPage(parentView, tabKey, tabDesc, RecClaimNoticeMobUtils.distinctByPrimaryKey(dynamicObjects).size());
                break;
            }
        }
    }

    private void updateParentTabPage(IFormView parentView, String tabKey, String tabDesc, Integer dataCount) {
        TabPage tabPage = (TabPage)parentView.getControl(tabKey);
        if (tabPage != null) {
            LocaleString lString = new LocaleString(tabDesc + "(" + (dataCount >= 100 ? "99+" : dataCount) + ")");
            tabPage.setText(lString);
            this.getView().getParentView().updateView(tabKey);
            this.getView().sendFormAction(this.getView().getParentView());
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        QFilter filter = RecClaimNoticeMobUtils.getQFilter(this.getView(), this.getListType());
        e.getQFilters().add(filter);
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new GetListDataProvider(this));
    }

    private String getListType() {
        return this.getView().getFormShowParameter().getCustomParam(LIST_TYPE) == null ? "" : (String)this.getView().getFormShowParameter().getCustomParam(LIST_TYPE);
    }

    private void setIsMultiSelect(boolean isMulti) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ismul", isMulti);
        map.put("type", "advgrid");
        this.getView().updateControlMetadata("billlistap", map);
    }

    private void setCustomCtrlProp(String controlId, Map<String, Object> data) {
        CustomControl node = (CustomControl)this.getView().getControl(controlId);
        IClientViewProxy proxy = (IClientViewProxy)node.getView().getService(IClientViewProxy.class);
        HashMap<String, Object> _data = (HashMap<String, Object>)proxy.getViewState(node.getKey());
        if (_data == null) {
            _data = new HashMap<String, Object>();
        }
        _data.putAll(data);
        node.setData(_data);
    }

    private void setCustomCtrlProp(String controlId, String prop, Object value) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put(prop, value);
        this.setCustomCtrlProp(controlId, data);
    }

    public void customEvent(CustomEventArgs e) {
        String key = e.getKey();
        String eventName = e.getEventName();
        if ("custom_control_menu_more".equals(key) && "click".equals(eventName)) {
            Map data = (Map)SerializationUtils.fromJsonString((String)e.getEventArgs(), Map.class);
            switch (data.get("nodeKey").toString()) {
                case "menu_item_ignore": {
                    this.ignoreClickEvent(data);
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5ffd\u7565\u6210\u529f\u3002", (String)"RecClaimAnnounceMobListPlugin_20", (String)"fi-cas-mobile", (Object[])new Object[0]));
                    break;
                }
                case "menu_item_cancel_ignore": {
                    this.cancelIgnoreClickEvent(data);
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u5ffd\u7565\u6210\u529f\u3002", (String)"RecClaimAnnounceMobListPlugin_21", (String)"fi-cas-mobile", (Object[])new Object[0]));
                    break;
                }
                case "menu_item_hold_on": {
                    this.handOutClickEvent(data);
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u8f6c\u5230\u7a0d\u540e\u5904\u7406\u5217\u8868\u3002", (String)"RecClaimAnnounceMobListPlugin_22", (String)"fi-cas-mobile", (Object[])new Object[0]));
                    break;
                }
                case "menu_item_cancel_merge": {
                    this.doCancelMerge(data);
                }
            }
            ((BillList)this.getView().getControl("billlistap")).clearSelection();
        }
    }

    private void handOutClickEvent(Map<String, Object> data) {
        DynamicObject claim = QueryServiceHelper.queryOne((String)"cas_claimannounce", (String)"id", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)data.get("targetId").toString())});
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"cas_claim_category");
        dynamicObject.set("userid", (Object)Long.valueOf(RequestContext.get().getUserId()));
        dynamicObject.set("noticeid", (Object)claim.getString("id"));
        dynamicObject.set("type", (Object)ClaimCategoryEnum.PENDING_NOTICE.getCode());
        try (TXHandle tx = TX.requiresNew();){
            DeleteServiceHelper.delete((String)"cas_claim_category", (QFilter[])new QFilter[]{new QFilter("userid", "=", dynamicObject.get("userid")).and("noticeid", "=", dynamicObject.get("noticeid"))});
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        }
        this.refresh();
    }

    private void cancelIgnoreClickEvent(Map<String, Object> data) {
        DynamicObject claim = QueryServiceHelper.queryOne((String)"cas_claimannounce", (String)"id", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)data.get("targetId").toString())});
        DeleteServiceHelper.delete((String)"cas_claim_category", (QFilter[])new QFilter[]{new QFilter("userid", "=", (Object)Long.valueOf(RequestContext.get().getUserId())).and("noticeid", "=", (Object)claim.getLong("id")).and("type", "=", (Object)ClaimCategoryEnum.IGNORE_BILL.getCode())});
        this.refresh();
    }

    private void ignoreClickEvent(Map<String, Object> data) {
        DynamicObject claim = QueryServiceHelper.queryOne((String)"cas_claimannounce", (String)"id", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)data.get("targetId").toString())});
        this.ignoreNotices((String)this.getView().getFormShowParameter().getCustomParam(LIST_TYPE), new Long[]{claim.getLong("id")});
        this.refresh();
    }

    static {
        noticeTabList.add("undo_page");
        noticeTabList.add("pending_page");
        noticeTabList.add("ignore_page");
    }

    static class GetListDataProvider
    extends ListDataProvider {
        private final String pageType;
        private final AbstractMobListPlugin plugin;

        public GetListDataProvider(AbstractMobListPlugin plugin) {
            this.plugin = plugin;
            String pageType = (String)plugin.getView().getFormShowParameter().getCustomParam(RecClaimAnnounceMobListPlugin.LIST_TYPE);
            this.pageType = StringUtils.isEmpty((CharSequence)pageType) ? "0" : pageType;
        }

        public DynamicObjectCollection getData(int arg0, int arg1) {
            DynamicObjectCollection rows = super.getData(arg0, arg1);
            if (CollectionUtils.isEmpty((Collection)rows)) {
                this.showEmptyDataPage(this.plugin);
                this.plugin.getPageCache().put(RecClaimAnnounceMobListPlugin.IS_EMPTY_LIST, "true");
                return rows;
            }
            this.plugin.getPageCache().put(RecClaimAnnounceMobListPlugin.IS_EMPTY_LIST, "false");
            this.plugin.getView().setVisible(Boolean.TRUE, new String[]{RecClaimAnnounceMobListPlugin.NOTICE_LIST_TAG});
            this.plugin.getView().setVisible(Boolean.FALSE, new String[]{RecClaimAnnounceMobListPlugin.EMPTY_LIST_PICTURE_TAG});
            this.plugin.getView().setVisible(Boolean.TRUE, new String[]{"btn_ignor_all", "btn_combined"});
            if (this.plugin.getPageCache().get(RecClaimAnnounceMobListPlugin.PAGE_CACHE_SEARCHING) != null && this.plugin.getPageCache().get(RecClaimAnnounceMobListPlugin.PAGE_CACHE_MERGING) == null) {
                this.plugin.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap10"});
            }
            Long userId = Long.valueOf(RequestContext.get().getUserId());
            ArrayList<String> ids = new ArrayList<String>(rows.size());
            for (DynamicObject row : rows) {
                ids.add(row.getString("billno"));
            }
            QFilter claimno = new QFilter("claimno", "in", (Object)ids.toArray());
            QFilter creator = new QFilter("creator", "=", (Object)userId);
            QFilter billStatus = new QFilter("billStatus", "in", (Object)new String[]{BillStatusEnum.SUBMIT.getValue(), BillStatusEnum.AUDIT.getValue()});
            QFilter qFilter = new QFilter("claimtype", "in", (Object)new String[]{ClaimTypeEnum.CLAIM.getValue(), ClaimTypeEnum.CHANGE.getValue(), ClaimTypeEnum.ADJUST.getValue(), ClaimTypeEnum.APPEAL.getValue()});
            DynamicObjectCollection cas_claimbills = QueryServiceHelper.query((String)"cas_claimbill", (String)"id,claimno,claimtype", (QFilter[])new QFilter[]{claimno, creator, billStatus, qFilter});
            for (DynamicObject row : rows) {
                switch (this.pageType) {
                    case "undo_page": {
                        row.set("pagetype", (Object)"6");
                        break;
                    }
                    case "pending_page": {
                        row.set("pagetype", (Object)"7");
                        break;
                    }
                    case "ignore_page": {
                        row.set("pagetype", (Object)"8");
                    }
                }
                String billno = row.getString("billno");
                for (DynamicObject cas_claimbill : cas_claimbills) {
                    String claimno1 = cas_claimbill.getString("claimno");
                    if (!billno.equals(claimno1)) continue;
                    String claimtype = (String)cas_claimbill.get("claimtype");
                    String claimname = ClaimTypeEnum.APPEAL.getValue().equals(claimtype) ? "appealme" : "claimme";
                    row.set(claimname, (Object)Boolean.TRUE);
                }
            }
            rows.getDynamicObjectType().addProperty((DynamicProperty)new DynamicSimpleProperty("registtime", Date.class, null));
            for (DynamicObject row : rows) {
                row.set("registtime", (Object)row.getDate("tradetime"));
            }
            return rows;
        }

        private void showEmptyDataPage(AbstractMobListPlugin plugin) {
            String doSearch = plugin.getPageCache().get(RecClaimAnnounceMobListPlugin.DO_SEARCH_TAG);
            String doFilter = plugin.getPageCache().get(RecClaimAnnounceMobListPlugin.DO_FILTER_TAG);
            Image image = (Image)plugin.getView().getControl("imageap_search");
            Label label = (Label)plugin.getView().getControl("labelap_search");
            if ("true".equals(doSearch) || "true".equals(doFilter)) {
                image.setUrl("/images/mobile/emotion/skrl_ssbd_224_128.png");
                label.setText(ResManager.loadKDString((String)"\u641c\u7d22\u4e0d\u5230\u7ed3\u679c", (String)"RecClaimAnnounceMobListPlugin_18", (String)"fi-cas-mobile", (Object[])new Object[0]));
            } else {
                image.setUrl("/images/mobile/emotion/cwy_zwsj_512_320.png");
                label.setText(this.getNoDataTip(this.pageType));
            }
            plugin.getView().setVisible(Boolean.FALSE, new String[]{RecClaimAnnounceMobListPlugin.NOTICE_LIST_TAG});
            plugin.getView().setVisible(Boolean.TRUE, new String[]{RecClaimAnnounceMobListPlugin.EMPTY_LIST_PICTURE_TAG});
            plugin.getView().setVisible(Boolean.FALSE, new String[]{"btn_ignor_all", "btn_combined", "flexpanelap10"});
        }

        private String getNoDataTip(String pageType) {
            String tip = "undo_page".equals(pageType) ? ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u672a\u5904\u7406\u7684\u6570\u636e\uff0c\u5982\u6709\u65b0\u6570\u636e\uff0c\u7cfb\u7edf\u4f1a\u7ed9\u60a8\u53d1\u9001\u901a\u77e5\uff0c\u8bf7\u7559\u610f", (String)"RecClaimAnnounceMobListPlugin_23", (String)"fi-cas-mobile", (Object[])new Object[0]) : ("pending_page".equals(pageType) ? ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u7a0d\u540e\u5904\u7406\u7684\u6570\u636e\uff0c\u53ef\u5c06\u6682\u4e0d\u5904\u7406\u7684\u6570\u636e\u79fb\u81f3\u6b64\u5904\u3002", (String)"RecClaimAnnounceMobListPlugin_24", (String)"fi-cas-mobile", (Object[])new Object[0]) : ("ignore_page".equals(pageType) ? ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u5ffd\u7565\u8fc7\u4efb\u4f55\u6570\u636e\uff0c\u53ef\u5c06\u4e0d\u5173\u6ce8\u7684\u6570\u636e\u79fb\u81f3\u6b64\u5904\u3002", (String)"RecClaimAnnounceMobListPlugin_25", (String)"fi-cas-mobile", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6682\u65e0\u6570\u636e", (String)"RecClaimAnnounceMobListPlugin_19", (String)"fi-cas-mobile", (Object[])new Object[0])));
            return tip;
        }
    }
}

