/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.mobile.recclaim;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.formplugin.mobile.recclaim.M;
import kd.fi.cas.formplugin.mobile.recclaim.RecClaimPageJumpHandler;

public class RecClaimBillAuditDetailMobBillPlugin
extends AbstractMobFormPlugin
implements RowClickEventListener {
    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"labelap4"});
        AbstractGrid entryentity = (AbstractGrid)this.getView().getControl("entryentity");
        if (entryentity != null) {
            entryentity.addRowClickListener((RowClickEventListener)this);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.fillBillFields();
    }

    public void entryRowClick(RowClickEvent evt) {
        CardEntry source = (CardEntry)evt.getSource();
        if ("entryentity".equals(source.getEntryKey())) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            RecClaimPageJumpHandler.claimBillToClaimEntry((AbstractFormPlugin)this, rowIndex);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        if ("labelap4".equals(control.getKey())) {
            this.viewAnnounceInfo();
        }
    }

    private void fillBillFields() {
        this.handlePayer();
        this.calcAmtAndFee();
        this.setProgressBar();
    }

    private void viewAnnounceInfo() {
        Object claimno = this.getModel().getValue("claimno");
        List pks = QueryServiceHelper.queryPrimaryKeys((String)"cas_claimannounce", (QFilter[])new QFilter("billno", "in", claimno).toArray(), null, (int)1);
        if (pks != null && !pks.isEmpty()) {
            Object announcePK = pks.get(0);
            RecClaimPageJumpHandler.claimBillToAnnounceBill((AbstractFormPlugin)this, announcePK);
        }
    }

    private void calcAmtAndFee() {
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
        Integer totalRow = entryentity.stream().mapToInt(dy -> 1).sum();
        BigDecimal totalAmt = entryentity.stream().map(dy -> dy.getBigDecimal("e_receivableamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalFee = entryentity.stream().map(dy -> dy.getBigDecimal("e_fee")).reduce(BigDecimal.ZERO, BigDecimal::add);
        ((Label)this.getControl("labelap2")).setText(String.format(ResManager.loadKDString((String)"\u5171%s\u6761", (String)"RecClaimBillAuditDetailMobBillPlugin_0", (String)"fi-cas-mobile", (Object[])new Object[0]), totalRow));
        ((Label)this.getControl("labelap51")).setText(M.getCurrencyFormatStr((DynamicObject)this.getModel().getValue("currency"), totalAmt));
        ((Label)this.getControl("labelap52")).setText(M.getCurrencyFormatStr((DynamicObject)this.getModel().getValue("currency"), totalFee));
    }

    private void handlePayer() {
        String type = (String)this.getModel().getValue("paymenttype");
        if (!StringUtils.equals((CharSequence)type, (CharSequence)"other")) {
            this.getModel().setValue("paymentbasetype", (Object)type);
            this.getModel().setValue("recbasepayer", this.getModel().getValue("recpayer"));
        }
    }

    private void setProgressBar() {
        int amtPercent;
        int processBarPercent;
        DynamicObjectCollection notices = QueryServiceHelper.query((String)"cas_claimannounce", (String)"reamount,unclaimamount,claimedamount", (QFilter[])new QFilter("billno", "=", this.getModel().getValue("claimno")).toArray());
        BigDecimal unclaimAmount = ((DynamicObject)notices.get(0)).getBigDecimal("unclaimamount");
        BigDecimal claimedAmount = ((DynamicObject)notices.get(0)).getBigDecimal("claimedamount");
        if (unclaimAmount.compareTo(BigDecimal.ZERO) <= 0) {
            processBarPercent = 100;
            amtPercent = claimedAmount.divide(unclaimAmount.add(claimedAmount), 2, 3).multiply(new BigDecimal(100)).intValue();
        } else {
            amtPercent = processBarPercent = claimedAmount.divide(unclaimAmount.add(claimedAmount), 2, 3).multiply(new BigDecimal(100)).intValue();
        }
        ProgressBar progressBar = (ProgressBar)this.getControl("progressbarap");
        progressBar.setPercent(processBarPercent, amtPercent + "%");
        Label labelap61 = (Label)this.getControl("labelap61");
        String claimedAmountWithCurrency = M.getCurrencyFormatStr((DynamicObject)this.getModel().getValue("currency"), claimedAmount);
        String totalAmountWithCurrency = M.getCurrencyFormatStr((DynamicObject)this.getModel().getValue("currency"), claimedAmount.add(unclaimAmount));
        labelap61.setText(String.format("%s / %s", claimedAmountWithCurrency, totalAmountWithCurrency));
    }
}

