/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.mobile.recclaim;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.bill.MobileBillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.MobileListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.fi.cas.formplugin.mobile.recclaim.MobileEntryUtil;
import kd.fi.cas.formplugin.mobile.recclaim.enums.ClaimCoreBillTypeEnum;
import kd.fi.cas.formplugin.mobile.recclaim.utils.CasToolKit;
import kd.fi.cas.formplugin.mobile.recclaim.utils.EmptyUtil;

public class RecClaimBillDetailMobBillPlugin
extends AbstractMobBillPlugIn {
    private static final String ENTRYENTITY = "entryentity";

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        MobileEntryUtil.setEntryDataOnSubPage((AbstractFormPlugin)this, ENTRYENTITY);
        this.setCoreBillType();
        this.initOtherDefaultValue();
        this.judgeAndHideAttachmentControl();
        this.refresh();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_save", "btn_cancel", "remainreamount", "corebillnobtn", "corebillentrybtn"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("btn_save".equals(key)) {
            boolean flag = true;
            DynamicObject recpaytype = (DynamicObject)this.getModel().getValue("recpaytype");
            if (recpaytype != null) {
                flag = recpaytype.getBoolean("ispartreceivable");
            }
            if (flag && Objects.isNull(this.getModel().getValue("e_settleorg"))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7ed3\u7b97\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"RecClaimBillDetailMobBillPlugin_4", (String)"fi-cas-mobile", (Object[])new Object[0]));
            } else {
                MobileEntryUtil.returnEntryDataToParentPage((AbstractFormPlugin)this, ENTRYENTITY);
                this.getView().close();
            }
            return;
        }
        if ("btn_cancel".equals(key)) {
            this.getView().close();
            return;
        }
        if ("remainreamount".equals(key)) {
            this.autoSetRemainReamount();
            return;
        }
        if ("corebillnobtn".equals(key)) {
            this.showCoreBillF7();
            return;
        }
        if ("corebillentrybtn".equals(key)) {
            this.showCoreBillEntry();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        IDataEntityProperty iDataEntityProperty = e.getProperty();
        String propertyName = iDataEntityProperty.getName();
        if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"e_receivableamt") || StringUtils.equals((CharSequence)propertyName, (CharSequence)"e_discountamt") || StringUtils.equals((CharSequence)propertyName, (CharSequence)"e_fee")) {
            DynamicObjectCollection entryentity = model.getEntryEntity(ENTRYENTITY);
            for (DynamicObject entry : entryentity) {
                BigDecimal receivableamt = entry.getBigDecimal("e_receivableamt");
                BigDecimal discountamt = entry.getBigDecimal("e_discountamt");
                BigDecimal fee = entry.getBigDecimal("e_fee");
                model.setValue("e_actamt", (Object)receivableamt.subtract(discountamt).subtract(fee));
            }
            return;
        }
        if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"e_corebilltype")) {
            model.setValue("e_corebillno", null);
            model.setValue("e_corebillid", null);
            return;
        }
        if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"e_corebillno")) {
            model.setValue("e_corebillid", null);
            model.setValue("e_corebillentryseq", null);
            model.setValue("e_corebillentryid", null);
            Object newValueObj = e.getChangeSet()[0].getNewValue();
            if (EmptyUtil.isNoEmpty(newValueObj)) {
                Object coreBillTypeObj = this.getModel().getValue("e_corebilltype");
                if (EmptyUtil.isEmpty(coreBillTypeObj)) {
                    model.beginInit();
                    model.setValue("e_corebillno", null);
                    model.setValue("e_corebillid", null);
                    model.endInit();
                    view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u6307\u5b9a\u6838\u5fc3\u5355\u636e\u7c7b\u578b\u3002", (String)"RecClaimBillDetailMobBillPlugin_0", (String)"fi-cas-mobile", (Object[])new Object[0]));
                    return;
                }
                String coreBillType = (String)coreBillTypeObj;
                ClaimCoreBillTypeEnum coreBillTypeEnum = ClaimCoreBillTypeEnum.getEnum(coreBillType);
                String coreBillNo = (String)newValueObj;
                if (coreBillTypeEnum != null) {
                    List coreBillCollIds = QueryServiceHelper.queryPrimaryKeys((String)coreBillType, (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)coreBillNo)}, null, (int)1);
                    if (!CollectionUtils.isEmpty((Collection)coreBillCollIds)) {
                        model.setValue("e_corebillid", coreBillCollIds.get(0));
                    } else {
                        model.beginInit();
                        model.setValue("e_corebillno", null);
                        model.setValue("e_corebillid", null);
                        model.endInit();
                        view.showTipNotification(ResManager.loadKDString((String)"\u5bf9\u5e94\u6838\u5fc3\u5355\u636e\u7c7b\u578b\u4e0d\u5b58\u5728\u6b64\u6838\u5fc3\u5355\u636e\u7f16\u53f7\u3002", (String)"RecClaimBillDetailMobBillPlugin_2", (String)"fi-cas-mobile", (Object[])new Object[0]));
                    }
                }
            }
            return;
        }
        if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"e_corebillentryseq")) {
            model.setValue("e_corebillentryid", null);
            Object newValueObj = e.getChangeSet()[0].getNewValue();
            if (EmptyUtil.isNoEmpty(newValueObj) && (Integer)newValueObj != 0) {
                Object coreBillTypeObj = this.getModel().getValue("e_corebilltype");
                if (EmptyUtil.isEmpty(coreBillTypeObj)) {
                    model.beginInit();
                    model.setValue("e_corebillentryseq", null);
                    model.setValue("e_corebillentryid", null);
                    model.endInit();
                    view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u6307\u5b9a\u6838\u5fc3\u5355\u636e\u7c7b\u578b\u3002", (String)"RecClaimBillDetailMobBillPlugin_0", (String)"fi-cas-mobile", (Object[])new Object[0]));
                    return;
                }
                Object coreBillNo = this.getModel().getValue("e_corebillno");
                if (EmptyUtil.isEmpty(coreBillNo)) {
                    model.beginInit();
                    model.setValue("e_corebillentryseq", null);
                    model.setValue("e_corebillentryid", null);
                    model.endInit();
                    view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u6307\u5b9a\u6838\u5fc3\u5355\u636e\u7f16\u53f7\u3002", (String)"RecClaimBillDetailMobBillPlugin_5", (String)"fi-cas-mobile", (Object[])new Object[0]));
                    return;
                }
                String coreBillId = (String)this.getModel().getValue("e_corebillid");
                ClaimCoreBillTypeEnum coreBillTypeEnum = ClaimCoreBillTypeEnum.getEnum((String)coreBillTypeObj);
                if (EmptyUtil.isNoEmpty(coreBillId) && EmptyUtil.isNoEmpty((Object)coreBillTypeEnum)) {
                    String selectFields = "billentry.id entryid,billentry.materialmasterid entrymaterial,operator entryoperator,billentry.project entryproject";
                    QFilter idFilter = new QFilter("id", "=", (Object)Long.valueOf(coreBillId));
                    QFilter entryIdFilter = new QFilter("billentry.seq", "=", newValueObj);
                    DynamicObject salOrderDy = QueryServiceHelper.queryOne((String)coreBillTypeEnum.getCode(), (String)selectFields, (QFilter[])new QFilter[]{idFilter, entryIdFilter});
                    if (salOrderDy != null) {
                        model.setValue("e_corebillentryid", salOrderDy.get("entryid"));
                        model.setValue("e_material", salOrderDy.get("entrymaterial"));
                        model.setValue("e_saleman", salOrderDy.get("entryoperator"));
                        model.setValue("e_project", salOrderDy.get("entryproject"));
                    } else {
                        model.beginInit();
                        model.setValue("e_corebillentryseq", null);
                        model.setValue("e_corebillentryid", null);
                        model.endInit();
                        view.showTipNotification(ResManager.loadKDString((String)"\u5bf9\u5e94\u6838\u5fc3\u5355\u636e\u7f16\u53f7\u4e2d\u4e0d\u5b58\u5728\u8be5\u884c\u53f7\u3002", (String)"RecClaimBillDetailMobBillPlugin_7", (String)"fi-cas-mobile", (Object[])new Object[0]));
                    }
                }
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setCheckDataChange(false);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        if ("e_corebillno".equals(actionId)) {
            this.setCoreBillNo(evt);
            return;
        }
        if ("e_corebillentry".equals(actionId)) {
            this.setCoreBillEntry(evt);
        }
    }

    private void setCoreBillType() {
        List comboItems;
        IFormView parentView = this.getView().getParentView();
        IDataModel parentModel = parentView.getModel();
        String formId = parentView.getFormShowParameter().getFormId();
        if (!"cas_claimbill_m".equals(formId)) {
            return;
        }
        Object recpaytypeObj = parentModel.getValue("recpaytype");
        if (recpaytypeObj == null) {
            return;
        }
        DynamicObject recpaytype = (DynamicObject)recpaytypeObj;
        boolean ispartreceivable = recpaytype.getBoolean("ispartreceivable");
        ArrayList<ComboItem> coreComboItem = new ArrayList<ComboItem>();
        ComboProp property = (ComboProp)EntityMetadataCache.getDataEntityType((String)"cas_claimbill").getProperty(ispartreceivable ? "settlecorebilltype" : "unsettlecorebilltype");
        if (EmptyUtil.isNoEmpty(property) && EmptyUtil.isNoEmpty(comboItems = property.getComboItems())) {
            for (ValueMapItem valueMapItem : comboItems) {
                ComboItem comboItem = new ComboItem(valueMapItem.getName(), valueMapItem.getValue());
                coreComboItem.add(comboItem);
            }
        }
        ComboEdit coreCbo = (ComboEdit)this.getView().getControl("e_corebilltype");
        coreCbo.setComboItems(coreComboItem);
    }

    private void initOtherDefaultValue() {
        IFormView parentView = this.getView().getParentView();
        IDataModel parentModel = parentView.getModel();
        IDataModel model = this.getModel();
        String formId = parentView.getFormShowParameter().getFormId();
        if (!"cas_claimbill_m".equals(formId) && !"cas_claim_auditdetail_m".equals(formId)) {
            return;
        }
        this.handleSettleOrg();
        model.setValue("billstatus", parentModel.getValue("billstatus"));
        model.setValue("currency", parentModel.getValue("currency"));
        model.setValue("recpaytype", parentModel.getValue("recpaytype"));
        model.setValue("org", parentModel.getValue("org"));
    }

    private void judgeAndHideAttachmentControl() {
        String showAttachment = (String)this.getView().getFormShowParameter().getCustomParam("show_attachment");
        if ("1".equals(showAttachment)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"attachmentpanel"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"attachmentpanel"});
        }
    }

    private void refresh() {
        IFormView parentView = this.getView().getParentView();
        IDataModel parentModel = parentView.getModel();
        String formId = parentView.getFormShowParameter().getFormId();
        if (!"cas_claimbill_m".equals(formId)) {
            return;
        }
        String claimNo = (String)parentModel.getValue("claimno");
        if (StringUtils.isBlank((CharSequence)claimNo)) {
            return;
        }
        QFilter claimNoQ = new QFilter("billno", "=", (Object)claimNo);
        DynamicObjectCollection colls = QueryServiceHelper.query((String)"cas_claimcenterbill", (String)"claimstatus,claimedamount,unclaimamount,isaddfee", (QFilter[])new QFilter[]{claimNoQ});
        if (!EmptyUtil.isEmpty(colls)) {
            Boolean feeEnable = !((DynamicObject)colls.get(0)).getBoolean("isaddfee");
            this.getView().setEnable(feeEnable, 0, new String[]{"e_fee"});
        }
    }

    private void handleSettleOrg() {
        IFormView parentView = this.getView().getParentView();
        IDataModel parentModel = parentView.getModel();
        IDataModel model = this.getModel();
        DynamicObject recOrg = (DynamicObject)parentModel.getValue("org");
        DynamicObject recAccount = (DynamicObject)parentModel.getValue("accountbank");
        DynamicObject settOrg = null;
        if (EmptyUtil.isNoEmpty(recOrg)) {
            DynamicObject centerOrg = QueryServiceHelper.queryOne((String)recOrg.getDynamicObjectType().getName(), (String)"id,fisaccounting", (QFilter[])new QFilter("id", "in", recOrg.getPkValue()).toArray());
            if (EmptyUtil.isNoEmpty(centerOrg) && centerOrg.getBoolean("fisaccounting")) {
                settOrg = recOrg;
            } else if (recAccount != null) {
                settOrg = recAccount.getDynamicObject("openorg");
            }
        }
        if (Objects.isNull(this.getView().getFormShowParameter().getCustomParam("entryeditindex"))) {
            model.setValue("e_settleorg", settOrg);
        }
    }

    private void autoSetRemainReamount() {
        String claimno = this.getView().getParentView().getModel().getDataEntity().getString("claimno");
        QFilter filter = new QFilter("billno", "=", (Object)claimno);
        DynamicObject notice = QueryServiceHelper.queryOne((String)"cas_claimannounce", (String)"unclaimamount", (QFilter[])filter.toArray());
        BigDecimal remainReamount = notice.getBigDecimal("unclaimamount").compareTo(BigDecimal.ZERO) > 0 ? notice.getBigDecimal("unclaimamount") : BigDecimal.ZERO;
        this.getModel().setValue("e_receivableamt", (Object)remainReamount);
    }

    private void showCoreBillF7() {
        Object settleOrgId;
        IDataModel parentModel = this.getView().getParentView().getModel();
        String coreBillType = (String)this.getModel().getValue("e_corebilltype");
        if (StringUtils.isEmpty((CharSequence)coreBillType)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u6307\u5b9a\u6838\u5fc3\u5355\u636e\u7c7b\u578b\u3002", (String)"RecClaimBillDetailMobBillPlugin_0", (String)"fi-cas-mobile", (Object[])new Object[0]));
            return;
        }
        ClaimCoreBillTypeEnum coreBillTypeEnum = ClaimCoreBillTypeEnum.getEnum(coreBillType);
        if (coreBillTypeEnum == null) {
            return;
        }
        DynamicObject settleOrgDy = (DynamicObject)this.getModel().getValue("e_settleorg");
        Object object = settleOrgId = settleOrgDy != null ? settleOrgDy.getPkValue() : null;
        if (settleOrgId == null && (coreBillTypeEnum == ClaimCoreBillTypeEnum.FINARBILL || coreBillTypeEnum == ClaimCoreBillTypeEnum.GLREIMBILL || coreBillTypeEnum == ClaimCoreBillTypeEnum.GLREIMRECBILL)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u6307\u5b9a\u7ed3\u7b97\u7ec4\u7ec7\u3002", (String)"RecClaimBillDetailMobBillPlugin_1", (String)"fi-cas-mobile", (Object[])new Object[0]));
            return;
        }
        ListFilterParameter lfp = new ListFilterParameter();
        switch (coreBillTypeEnum) {
            case FINARBILL: {
                lfp.setFilter(new QFilter("settlestatus", "in", (Object)new String[]{"unsettle", "partsettle"}));
                lfp.setFilter(new QFilter("org", "=", settleOrgId));
                lfp.setFilter(new QFilter("billstatus", "=", (Object)"C"));
                break;
            }
            case SALORDER: {
                String appId = AppMetadataCache.getAppInfo((String)"ar").getId();
                DynamicObject org = (DynamicObject)parentModel.getValue("org");
                Object recpayer = parentModel.getValue("recpayer");
                boolean isAutoCreateBill = (Boolean)SystemParamServiceHelper.getAppParameter((String)appId, (String)"10", (Long)org.getLong("id"), (String)"ar_011");
                if (isAutoCreateBill) {
                    lfp.setFilter(new QFilter("paymode", "=", (Object)"CREDIT"));
                } else {
                    lfp.setFilter(new QFilter("paymode", "in", (Object)new String[]{"CREDIT", "CASH"}));
                }
                lfp.setFilter(new QFilter("billentry.entrysettleorg", "=", settleOrgId));
                lfp.setFilter(new QFilter("customer", "=", (Object)(!ObjectUtils.isEmpty((Object)recpayer) ? Long.parseLong(recpayer.toString()) : 0L)));
                lfp.setFilter(new QFilter("changestatus", "!=", (Object)"B"));
                lfp.setFilter(QFilter.of((String)" receiptamount < totalallamount ", (Object[])new Object[0]));
                lfp.setFilter(new QFilter("billstatus", "=", (Object)"C"));
                break;
            }
            case SALCONTRACT: {
                Object recpayer1 = parentModel.getValue("recpayer");
                lfp.setFilter(new QFilter("customer", "=", (Object)(!ObjectUtils.isEmpty((Object)recpayer1) ? Long.parseLong(recpayer1.toString()) : 0L)));
                lfp.setFilter(new QFilter("billentry.entrysettleorg", "=", settleOrgId));
                lfp.setFilter(new QFilter("validstatus", "!=", (Object)"A"));
                lfp.setFilter(new QFilter("changestatus", "!=", (Object)"B"));
                lfp.setFilter(QFilter.of((String)" receiptallamount < totalallamount ", (Object[])new Object[0]));
                lfp.setFilter(new QFilter("billstatus", "=", (Object)"C"));
                break;
            }
            case PAYBILL: {
                Object accountbankObj = parentModel.getValue("accountbank");
                Object payeebanknumObj = parentModel.getValue("oppbanknumber");
                if (EmptyUtil.isNoEmpty(accountbankObj)) {
                    lfp.setFilter(new QFilter("payeracctbank", "=", ((DynamicObject)accountbankObj).getPkValue()));
                } else {
                    lfp.setFilter(new QFilter("payeracctbank", "=", null));
                }
                if (EmptyUtil.isNoEmpty(payeebanknumObj)) {
                    lfp.setFilter(new QFilter("payeebanknum", "=", payeebanknumObj));
                } else {
                    lfp.setFilter(new QFilter("payeebanknum", "=", null));
                }
                lfp.setFilter(new QFilter("billstatus", "=", (Object)"D"));
                break;
            }
            case GLREIMBILL: 
            case GLREIMRECBILL: {
                lfp.setFilter(new QFilter("accountingorg", "=", settleOrgId));
                lfp.setFilter(new QFilter("castorecamount", ">=", (Object)0));
                lfp.setFilter(new QFilter("billstatus", "=", (Object)"D"));
                break;
            }
            case REPAYMENTBILL: {
                lfp.setFilter(new QFilter("billstatus", "=", (Object)"E"));
                break;
            }
        }
        String billFormId = coreBillTypeEnum.getMobCode() == null ? coreBillTypeEnum.getCode() : coreBillTypeEnum.getMobCode();
        MobileListShowParameter lsp = new MobileListShowParameter();
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "e_corebillno");
        lsp.setFormId("bos_moblisttabf7");
        lsp.setBillFormId(billFormId);
        lsp.setCustomParam("ismergerows", (Object)Boolean.FALSE);
        lsp.setCaption(ResManager.loadKDString((String)"\u6838\u5fc3\u5355\u636e\u7f16\u53f7", (String)"RecClaimBillDetailMobBillPlugin_3", (String)"fi-cas-mobile", (Object[])new Object[0]));
        lsp.getOpenStyle().setShowType(ShowType.Floating);
        lsp.setLookUp(true);
        lsp.setListFilterParameter(lfp);
        lsp.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)lsp);
    }

    private void showCoreBillEntry() {
        String coreBillType = (String)this.getModel().getValue("e_corebilltype");
        if (StringUtils.isEmpty((CharSequence)coreBillType)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u6307\u5b9a\u6838\u5fc3\u5355\u636e\u7c7b\u578b\u3002", (String)"RecClaimBillDetailMobBillPlugin_0", (String)"fi-cas-mobile", (Object[])new Object[0]));
            return;
        }
        ClaimCoreBillTypeEnum coreBillTypeEnum = ClaimCoreBillTypeEnum.getEnum(coreBillType);
        if (coreBillTypeEnum == null) {
            return;
        }
        if (coreBillTypeEnum != ClaimCoreBillTypeEnum.SALORDER && coreBillTypeEnum != ClaimCoreBillTypeEnum.SALCONTRACT) {
            return;
        }
        String coreBillId = (String)this.getModel().getValue("e_corebillid");
        if (coreBillId == null || StringUtils.isEmpty((CharSequence)coreBillId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u6307\u5b9a\u6838\u5fc3\u5355\u636e\u7f16\u53f7\u3002", (String)"RecClaimBillDetailMobBillPlugin_5", (String)"fi-cas-mobile", (Object[])new Object[0]));
            return;
        }
        Object settleOrgId = ((DynamicObject)this.getModel().getValue("e_settleorg")).getPkValue();
        if (settleOrgId == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u6307\u5b9a\u7ed3\u7b97\u7ec4\u7ec7\u3002", (String)"RecClaimBillDetailMobBillPlugin_1", (String)"fi-cas-mobile", (Object[])new Object[0]));
            return;
        }
        String formId = coreBillTypeEnum.getMobCode() == null ? coreBillTypeEnum.getCode() : coreBillTypeEnum.getMobCode();
        MobileBillShowParameter bsp = new MobileBillShowParameter();
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "e_corebillentry");
        bsp.setFormId(formId);
        bsp.setPkId((Object)coreBillId);
        bsp.setCaption(ResManager.loadKDString((String)"\u6838\u5fc3\u5355\u636e\u884c\u53f7", (String)"RecClaimBillDetailMobBillPlugin_6", (String)"fi-cas-mobile", (Object[])new Object[0]));
        bsp.setStatus(OperationStatus.VIEW);
        bsp.setCustomParam("org", settleOrgId);
        bsp.getOpenStyle().setShowType(ShowType.Floating);
        bsp.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)bsp);
    }

    private void setCoreBillNo(ClosedCallBackEvent evt) {
        Object returnData = evt.getReturnData();
        if (CasToolKit.isEmpty(returnData)) {
            return;
        }
        ListSelectedRowCollection coreBillCollection = (ListSelectedRowCollection)returnData;
        if (coreBillCollection.isClearFlag()) {
            this.getModel().setValue("e_corebillno", null);
            return;
        }
        for (ListSelectedRow listSelectedRow : coreBillCollection) {
            this.getModel().setValue("e_corebillno", (Object)listSelectedRow.getBillNo());
        }
    }

    private void setCoreBillEntry(ClosedCallBackEvent evt) {
        Object returnData = evt.getReturnData();
        if (CasToolKit.isEmpty(returnData)) {
            return;
        }
        DynamicObject returnDataDy = (DynamicObject)returnData;
        this.getModel().setValue("e_corebillentryseq", returnDataDy.get("entryseq"));
    }
}

