/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.mobile.recclaim;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.operate.DefaultEntityOperate;
import kd.bos.entity.operate.Submit;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.container.TabPage;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.MobileSearchCancelListener;
import kd.bos.form.control.events.MobileSearchTextChangeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.AfterMobileListPushDownRefreshEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.MobileSearch;
import kd.bos.list.plugin.AbstractMobListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.AbstractListView;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.fi.cas.formplugin.mobile.recclaim.RecClaimBillMobBillPlugin;
import kd.fi.cas.formplugin.mobile.recclaim.RecClaimMobListFilterProvider;
import kd.fi.cas.formplugin.mobile.recclaim.RecClaimPageJumpHandler;
import kd.fi.cas.formplugin.mobile.recclaim.constant.SubscriptEnum;
import kd.fi.cas.formplugin.mobile.recclaim.enums.ClaimPaymentTypeEnum;
import kd.fi.cas.formplugin.mobile.recclaim.helper.CasServiceHelper;
import kd.fi.cas.formplugin.mobile.recclaim.operation.CustomCtrlPropHelper;
import kd.fi.cas.formplugin.mobile.recclaim.operation.RecClaimBillOperationHelper;
import kd.fi.cas.formplugin.mobile.recclaim.result.InvokeResult;
import kd.fi.cas.formplugin.mobile.recclaim.temp.TempPush;
import kd.fi.cas.formplugin.mobile.recclaim.utils.CastUtils;
import kd.fi.cas.formplugin.mobile.recclaim.utils.EmptyUtil;
import kd.fi.cas.formplugin.mobile.recclaim.utils.RecClaimNoticeMobUtils;

public class RecClaimBillMobListPlugin
extends AbstractMobListPlugin
implements MobileSearchCancelListener {
    private static final Log log = LogFactory.getLog(RecClaimBillMobListPlugin.class);
    public static final String LIST_TYPE = "listType";
    private static final String PAGE_CACHE_ANNOUNCE_STATUS_FILTER = "pageCache_announceStatusFilter";
    private static final String ALGO = "kd.fi.cas.formplugin.mobile.recclaim.RecClaimBillMobListPlugin";
    private static final int DOING_PAGE_TOTAL_FILTER_STATUS_COUNT = 3;
    private static final int DONE_PAGE_TOTAL_FILTER_STATUS_COUNT = 2;
    private static final String C_LIST_TAG = "billlistap";
    private static final String C_EMPTY_LIST_PANEL_TAG = "flexpanel";
    private static final String DO_SEARCH_TAG = "DO_SEARCH";

    public void initialize() {
        super.initialize();
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String listType = this.getListType();
        this.getView().getPageCache().put(LIST_TYPE, listType);
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            parentView.getPageCache().put("cas_mine_claim" + listType, this.getView().getPageId());
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        RecClaimNoticeMobUtils.refreshTargetParentPage(this.getView(), "cas_index_m");
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"flex_status_selected"});
        ((MobileSearch)this.getControl("mobilesearchap")).addMobileSearchCancelListener((MobileSearchCancelListener)this);
    }

    public void click(EventObject evt) {
        Control control;
        String key;
        super.click(evt);
        Object source = evt.getSource();
        if (source instanceof Control && "flex_status_selected".equals(key = (control = (Control)source).getKey())) {
            String curFilterStr = this.getPageCache().get(PAGE_CACHE_ANNOUNCE_STATUS_FILTER);
            RecClaimPageJumpHandler.showAnnounceListStatusFilterPage((AbstractFormPlugin)this, curFilterStr);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        if ("cas_claim_m_status_select".equals(actionId)) {
            List returnData = (List)evt.getReturnData();
            this.setStatusFilter(returnData);
            this.refresh();
        }
    }

    private void refresh() {
        IFormView view = this.getView();
        view.invokeOperation("refresh");
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        OperationResult result = args.getOperationResult();
        String operateKey = args.getOperateKey();
        if ("refresh".equals(operateKey)) {
            this.setParentTabBillCount();
        } else if ("submit".equals(operateKey) && result.isSuccess()) {
            String id = ((Submit)args.getSource()).getListFocusRow().getPrimaryKeyValue().toString();
            if (this.isFromOldPage(this.getView()).booleanValue()) {
                List<Map<String, Object>> maps = RecClaimBillOperationHelper.forecastWorkflow(id);
                if (!CollectionUtils.isEmpty(maps)) {
                    try {
                        Thread.sleep(1500L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            } else if (StringUtils.isNotBlank((CharSequence)id)) {
                this.submitAfterDo(id);
            }
        } else if (StringUtils.equals((CharSequence)"audit", (CharSequence)operateKey) && result.isSuccess()) {
            String id = ((DefaultEntityOperate)args.getSource()).getListFocusRow().getPrimaryKeyValue().toString();
            if (StringUtils.isNotBlank((CharSequence)id)) {
                this.auditAfterDo(id);
            }
        } else if (StringUtils.equals((CharSequence)"delete", (CharSequence)operateKey) && result.isSuccess()) {
            this.setParentTabBillCount();
        }
    }

    private Boolean isFromOldPage(IFormView view) {
        for (IFormView targetView = view; targetView != null; targetView = targetView.getParentView()) {
            if (!StringUtils.equals((CharSequence)"cas_recclaim_m", (CharSequence)targetView.getEntityId())) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private void showOperationForm(String pagetype, String billno) {
        if (this.isFromOldPage(this.getView()).booleanValue()) {
            return;
        }
        RecClaimBillMobBillPlugin.showOperationForm(pagetype, billno, (AbstractFormPlugin)this);
    }

    private void setParentTabBillCount() {
        int dataCount;
        IFormView parentView = this.getView().getParentView();
        if (parentView == null || !"cas_recclaim_m".equals(parentView.getEntityId())) {
            return;
        }
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)ALGO, (String)"cas_claimbill", (String)"id", (QFilter[])new QFilter[]{this.getQFilter()}, null);){
            dataCount = dataSet.count("id", false);
        }
        String[] tabInfo = null;
        String listType = this.getListType();
        if ("tabdoing".equals(listType)) {
            tabInfo = new String[]{"tabdoing", ResManager.loadKDString((String)"\u5904\u7406\u4e2d", (String)"RecClaimBillMobListPlugin_0", (String)"fi-cas-mobile", (Object[])new Object[0])};
        } else if ("tabdone".equals(listType)) {
            tabInfo = new String[]{"tabdone", ResManager.loadKDString((String)"\u5df2\u5b8c\u6210", (String)"RecClaimBillMobListPlugin_1", (String)"fi-cas-mobile", (Object[])new Object[0])};
        }
        if (tabInfo != null) {
            void tabKey = tabInfo[0];
            void tabDesc = tabInfo[1];
            TabPage tabPage = (TabPage)parentView.getControl((String)tabKey);
            if (tabPage != null) {
                LocaleString lString = new LocaleString((String)tabDesc + "(" + (dataCount >= 100 ? "99+" : Integer.valueOf(dataCount)) + ")");
                tabPage.setText(lString);
                this.getView().getParentView().updateView((String)tabKey);
                this.getView().sendFormAction(this.getView().getParentView());
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String listType = this.getListType();
        ArrayList<String[]> statusInfos = new ArrayList<String[]>();
        if ("tabdoing".equals(listType)) {
            this.getModel().setValue("pagetype", (Object)"2");
            statusInfos.add(new String[]{"A", ResManager.loadKDString((String)"\u6682\u5b58", (String)"RecClaimBillMobListPlugin_2", (String)"fi-cas-mobile", (Object[])new Object[0])});
            statusInfos.add(new String[]{"B", ResManager.loadKDString((String)"\u5df2\u63d0\u4ea4", (String)"RecClaimBillMobListPlugin_3", (String)"fi-cas-mobile", (Object[])new Object[0])});
            statusInfos.add(new String[]{"C", ResManager.loadKDString((String)"\u5df2\u5ba1\u6838", (String)"RecClaimBillMobListPlugin_4", (String)"fi-cas-mobile", (Object[])new Object[0])});
            String statusCacheStr = statusInfos.stream().map(v -> v[0]).collect(Collectors.joining(","));
            Integer totalStatusCount = StringUtils.equals((CharSequence)((String)this.getModel().getValue("pagetype")), (CharSequence)"2") ? 3 : 2;
            String statusAliasStr = statusInfos.size() == totalStatusCount.intValue() ? ResManager.loadKDString((String)"\u5168\u90e8\u72b6\u6001", (String)"RecClaimBillMobListPlugin_6", (String)"fi-cas-mobile", (Object[])new Object[0]) : statusInfos.stream().map(v -> v[1]).collect(Collectors.joining("\uff1b"));
            ((Label)this.getControl("label_status")).setText(statusAliasStr);
            this.getPageCache().put(PAGE_CACHE_ANNOUNCE_STATUS_FILTER, statusCacheStr);
        } else if ("tabdone".equals(listType)) {
            statusInfos.add(new String[]{"C", ResManager.loadKDString((String)"\u5df2\u5ba1\u6838", (String)"RecClaimBillMobListPlugin_4", (String)"fi-cas-mobile", (Object[])new Object[0])});
            statusInfos.add(new String[]{"H", ResManager.loadKDString((String)"\u4f5c\u5e9f", (String)"RecClaimBillMobListPlugin_5", (String)"fi-cas-mobile", (Object[])new Object[0])});
            this.getModel().setValue("pagetype", (Object)"3");
            String statusCacheStr = statusInfos.stream().map(v -> v[0]).collect(Collectors.joining(","));
            Integer totalStatusCount = StringUtils.equals((CharSequence)((String)this.getModel().getValue("pagetype")), (CharSequence)"2") ? 3 : 2;
            String statusAliasStr = statusInfos.size() == totalStatusCount.intValue() ? ResManager.loadKDString((String)"\u5168\u90e8\u72b6\u6001", (String)"RecClaimBillMobListPlugin_6", (String)"fi-cas-mobile", (Object[])new Object[0]) : statusInfos.stream().map(v -> v[1]).collect(Collectors.joining("\uff1b"));
            ((Label)this.getControl("label_status")).setText(statusAliasStr);
            this.getPageCache().put(PAGE_CACHE_ANNOUNCE_STATUS_FILTER, statusCacheStr);
        } else if (StringUtils.equals((CharSequence)"tabrejected", (CharSequence)listType)) {
            this.saveLastestRejectedRecord();
        }
    }

    private void saveLastestRejectedRecord() {
        QFilter userFilter = new QFilter("creator", "=", (Object)Long.valueOf(RequestContext.get().getUserId())).or("auditor", "=", (Object)Long.valueOf(RequestContext.get().getUserId()));
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"cas_claimbill", (String)"id,billstatus,rejectreason", (QFilter[])new QFilter[]{userFilter});
        List<Long> billWithWorkFlowIds = this.getBillWithWorkFlowIds();
        List<DynamicObject> subscriptRecordsOfRejectedBill = dynamicObjects.stream().filter(dy -> {
            Boolean rejectNotEmpty = StringUtils.isNotBlank((CharSequence)dy.getString("rejectreason"));
            Boolean saveAndIsRecorded = StringUtils.equals((CharSequence)"A", (CharSequence)dy.getString("billstatus")) && billWithWorkFlowIds.contains(dy.getLong("id"));
            return rejectNotEmpty != false || saveAndIsRecorded != false;
        }).map(dy -> {
            DynamicObject categoryObject = BusinessDataServiceHelper.newDynamicObject((String)"cas_claim_subscriptcache");
            categoryObject.set("userid", (Object)Long.valueOf(RequestContext.get().getUserId()));
            categoryObject.set("lastestid", (Object)dy.getString("id"));
            categoryObject.set("type", (Object)SubscriptEnum.REJECT_BILL.getCode());
            return categoryObject;
        }).collect(Collectors.toList());
        try (TXHandle tx = TX.requiresNew();){
            DeleteServiceHelper.delete((String)"cas_claim_subscriptcache", (QFilter[])new QFilter[]{new QFilter("userid", "=", (Object)Long.valueOf(RequestContext.get().getUserId())).and("type", "=", (Object)SubscriptEnum.REJECT_BILL.getCode())});
            SaveServiceHelper.save((DynamicObject[])subscriptRecordsOfRejectedBill.toArray(new DynamicObject[0]));
        }
    }

    private List<Long> getBillWithWorkFlowIds() {
        QFilter userFilter = new QFilter("creator", "=", (Object)Long.valueOf(RequestContext.get().getUserId())).or("auditor", "=", (Object)Long.valueOf(RequestContext.get().getUserId()));
        QFilter filter = userFilter.and("billstatus", "=", (Object)"A");
        Set drafts = QueryServiceHelper.query((String)"cas_claimbill", (String)"id", (QFilter[])new QFilter[]{filter}).stream().map(v -> v.getLong("id")).collect(Collectors.toSet());
        return new ArrayList<Long>(RecClaimNoticeMobUtils.getBillRejectedInWf(drafts));
    }

    private void setStatusFilter(List<String[]> statusInfos) {
        String statusCacheStr = statusInfos.stream().map(v -> v[0]).collect(Collectors.joining(","));
        Integer totalStatusCount = StringUtils.equals((CharSequence)((String)this.getModel().getValue("pagetype")), (CharSequence)"2") ? 3 : 2;
        String statusAliasStr = statusInfos.size() == totalStatusCount.intValue() ? ResManager.loadKDString((String)"\u5168\u90e8\u72b6\u6001", (String)"RecClaimBillMobListPlugin_6", (String)"fi-cas-mobile", (Object[])new Object[0]) : statusInfos.stream().map(v -> v[1]).collect(Collectors.joining("\uff1b"));
        ((Label)this.getControl("label_status")).setText(statusAliasStr);
        this.getPageCache().put(PAGE_CACHE_ANNOUNCE_STATUS_FILTER, statusCacheStr);
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        if (!CollectionUtils.isEmpty((Collection)e.getQFilters())) {
            ((QFilter)e.getQFilters().get(0)).or(this.getPayerBaseFilter());
        }
        e.getQFilters().add(this.getQFilter());
    }

    private QFilter getQFilter() {
        QFilter filter = null;
        switch (this.getListType()) {
            case "tabdoing": {
                filter = RecClaimMobListFilterProvider.getClaimBillDoingFilter();
                break;
            }
            case "tabdone": {
                filter = RecClaimMobListFilterProvider.getClaimBillDoneFilter();
                break;
            }
            case "tabrough": {
                filter = RecClaimMobListFilterProvider.getClaimBillDraftFilter();
                break;
            }
            case "tabrejected": {
                filter = RecClaimMobListFilterProvider.getClaimBillRejectedFilter();
                break;
            }
            case "tabongoing": {
                filter = RecClaimMobListFilterProvider.getClaimBillOngoingFilter();
                break;
            }
            case "tabconfirmed": {
                filter = RecClaimMobListFilterProvider.getClaimBillConfirmedFilter();
            }
        }
        if (filter == null) {
            return null;
        }
        String statusFilterStr = this.getPageCache().get(PAGE_CACHE_ANNOUNCE_STATUS_FILTER);
        if (!StringUtils.isEmpty((CharSequence)statusFilterStr)) {
            filter = filter.and("billstatus", "in", (Object)statusFilterStr.split(","));
        }
        filter.and(new QFilter("multireceivingtype", "!=", (Object)true));
        return filter;
    }

    private String getListType() {
        String listType = (String)this.getView().getFormShowParameter().getCustomParam(LIST_TYPE);
        return listType == null ? "" : listType;
    }

    private QFilter getPayerBaseFilter() {
        String searchStr = ((MobileSearch)this.getView().getControl("mobilesearchap")).getText();
        if (StringUtils.isEmpty((CharSequence)searchStr)) {
            return null;
        }
        List customerIds = QueryServiceHelper.query((String)"bd_customer", (String)"id", (QFilter[])new QFilter("name", "like", (Object)("%" + searchStr + "%")).toArray()).stream().map(dy -> dy.getString("id")).collect(Collectors.toList());
        List supplierIds = QueryServiceHelper.query((String)"bd_supplier", (String)"id", (QFilter[])new QFilter("name", "like", (Object)("%" + searchStr + "%")).toArray()).stream().map(dy -> dy.getString("id")).collect(Collectors.toList());
        List orgIds = QueryServiceHelper.query((String)"bos_org", (String)"id", (QFilter[])new QFilter("name", "like", (Object)("%" + searchStr + "%")).toArray()).stream().map(dy -> dy.getString("id")).collect(Collectors.toList());
        List userIds = QueryServiceHelper.query((String)"bos_user", (String)"id", (QFilter[])new QFilter("name", "like", (Object)("%" + searchStr + "%")).toArray()).stream().map(dy -> dy.getString("id")).collect(Collectors.toList());
        return new QFilter("recpayer", "in", customerIds).or("recpayer", "in", supplierIds).or("recpayer", "in", orgIds).or("recpayer", "in", userIds);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("change".equals(operateKey)) {
            this.beforeDoChange(args);
        } else if ("adjust".equals(operateKey)) {
            this.beforeDoAdjust(args);
        } else if ("delete".equals(operateKey)) {
            Object idObject = null;
            ListSelectedRow listFocusRow = operate.getListFocusRow();
            ListSelectedRowCollection listSelectedData = operate.getListSelectedData();
            log.info("listFocusRow : " + listFocusRow + "-------listSelectedData : " + (listSelectedData == null ? "null" : listSelectedData.toString()));
            if (listFocusRow != null) {
                idObject = listFocusRow.getPrimaryKeyValue();
            } else if (listSelectedData != null && !listSelectedData.isEmpty()) {
                idObject = listSelectedData.get(0).getPrimaryKeyValue();
            }
            if (idObject == null) {
                return;
            }
            long id = Long.parseLong(idObject.toString());
            DynamicObject claimBill = QueryServiceHelper.queryOne((String)"cas_claimbill", (String)"id,claimno", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
            DynamicObject annoBill = null;
            if (claimBill != null && StringUtils.isNotBlank((CharSequence)claimBill.getString("claimno"))) {
                annoBill = QueryServiceHelper.queryOne((String)"cas_claimannounce", (String)"id", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)claimBill.getString("claimno"))});
            }
            if (annoBill != null) {
                DeleteServiceHelper.delete((String)"cas_claim_category", (QFilter[])new QFilter[]{new QFilter("userid", "=", (Object)Long.valueOf(RequestContext.get().getUserId())).and("noticeid", "=", annoBill.get("id"))});
            }
        } else if ("submit".equals(operateKey)) {
            this.validateMustInputField(args);
        }
    }

    private boolean beforeDoAdjust(BeforeDoOperationEventArgs args) {
        IListView view = (IListView)this.getView();
        Object claimBillPk = view.getFocusRowPkId();
        InvokeResult ret = CasServiceHelper.beforeAdjust(claimBillPk);
        if (!ret.isSuccess()) {
            if (ret.get("recentDateId") != null) {
                RecClaimPageJumpHandler.showClaimBillForm((AbstractFormPlugin)this, ret.get("recentDateId"));
                view.showTipNotification(ret.getMsg());
                args.setCancel(true);
            } else {
                this.getView().showTipNotification(ret.getMsg());
                args.setCancel(true);
            }
            return false;
        }
        args.setCancel(true);
        ArrayList<ListSelectedRow> selectedRows = new ArrayList<ListSelectedRow>();
        ListSelectedRow srcBill = new ListSelectedRow(claimBillPk);
        selectedRows.add(srcBill);
        new TempPush().pushClaimBill((AbstractFormPlugin)this, selectedRows, args);
        return true;
    }

    private boolean beforeDoChange(BeforeDoOperationEventArgs args) {
        IListView view = (IListView)this.getView();
        Object claimBillPk = view.getFocusRowPkId();
        InvokeResult ret = CasServiceHelper.beforeChangeClaimBill(claimBillPk);
        if (!ret.isSuccess()) {
            if (ret.get("recentDateId") != null) {
                RecClaimPageJumpHandler.showClaimBillForm((AbstractFormPlugin)this, ret.get("recentDateId"));
                view.showTipNotification(ret.getMsg());
                args.setCancel(true);
            } else {
                this.getView().showTipNotification(ret.getMsg());
                args.setCancel(true);
            }
            return false;
        }
        args.setCancel(true);
        ListSelectedRowCollection selectedRows = view.getSelectedRows();
        new TempPush().pushClaimBill((AbstractFormPlugin)this, (List)selectedRows, args);
        return true;
    }

    private void validateMustInputField(BeforeDoOperationEventArgs args) {
        ListSelectedRow currentSelectedRowInfo = ((AbstractListView)this.getView()).getCurrentSelectedRowInfo();
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)RecClaimBillMobListPlugin.class.getName(), (String)"cas_claimbill", (String)"bizdate,recpaytype,paymenttype,recpayer", (QFilter[])new QFilter("id", "=", currentSelectedRowInfo.getPrimaryKeyValue()).toArray(), null);
        DynamicObjectCollection dynamicObjects = ORM.create().toPlainDynamicObjectCollection(dataSet);
        DynamicObject dynamicObject = (DynamicObject)dynamicObjects.get(0);
        Date bizDate = dynamicObject.getDate("bizdate");
        Long recPayType = dynamicObject.getLong("recpaytype");
        String paymentType = dynamicObject.getString("paymenttype");
        String recPayer = dynamicObject.getString("recpayer");
        StringBuilder builder = new StringBuilder();
        boolean isCancel = false;
        if (bizDate == null) {
            builder.append(ResManager.loadKDString((String)"\"\u4e1a\u52a1\u65e5\u671f\"", (String)"RecClaimBillMobListPlugin_17", (String)"fi-cas-mobile", (Object[])new Object[0])).append("\u3001");
            isCancel = true;
        }
        if (recPayType == 0L) {
            builder.append(ResManager.loadKDString((String)"\"\u6536\u6b3e\u7c7b\u578b\"", (String)"RecClaimBillMobListPlugin_18", (String)"fi-cas-mobile", (Object[])new Object[0])).append("\u3001");
            isCancel = true;
        }
        if (StringUtils.isBlank((CharSequence)paymentType)) {
            builder.append(ResManager.loadKDString((String)"\"\u4ed8\u6b3e\u4eba\u7c7b\u578b\"", (String)"RecClaimBillMobListPlugin_19", (String)"fi-cas-mobile", (Object[])new Object[0])).append("\u3001");
            isCancel = true;
        }
        if (StringUtils.isBlank((CharSequence)recPayer)) {
            builder.append(ResManager.loadKDString((String)"\"\u4ed8\u6b3e\u4eba\"", (String)"RecClaimBillMobListPlugin_20", (String)"fi-cas-mobile", (Object[])new Object[0])).append("\u3001");
            isCancel = true;
        }
        if (isCancel) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199%s\u3002", (String)"RecClaimBillMobListPlugin_16", (String)"fi-cas-mobile", (Object[])new Object[0]), builder.substring(0, builder.length() - 1)));
            args.setCancel(true);
        }
    }

    public void mobileSearchTextChange(MobileSearchTextChangeEvent args) {
        super.mobileSearchTextChange(args);
        this.getPageCache().put(DO_SEARCH_TAG, "true");
    }

    public void cancel() {
        this.getPageCache().put(DO_SEARCH_TAG, "false");
    }

    public void afterPushDownRefresh(AfterMobileListPushDownRefreshEvent evt) {
        super.afterPushDownRefresh(evt);
        this.setParentTabBillCount();
        this.getView().updateView();
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new ClaimHandleListDataProvider(this));
    }

    public static void setNextAuditor(DynamicObjectCollection collection, List<String> pkId) {
        Map<String, String> auditorsNameMap = RecClaimBillMobListPlugin.getNextAuditor(pkId);
        collection.forEach(v -> {
            String pkIdTemp = String.valueOf(v.getPkValue());
            String nextAuditor = (String)auditorsNameMap.get(pkIdTemp);
            try {
                String billStatus = v.getString("billstatus");
                if (StringUtils.isEmpty((CharSequence)nextAuditor) && !StringUtils.isEmpty((CharSequence)billStatus) && StringUtils.equals((CharSequence)"B", (CharSequence)billStatus)) {
                    nextAuditor = ResManager.loadKDString((String)"\u5f85\u5206\u914d", (String)"RecClaimBillMobListPlugin_10", (String)"fi-cas-mobile", (Object[])new Object[0]);
                }
            }
            catch (Exception var5) {
                log.info("nextAudit", (Object)var5);
            }
            v.set("nextauditor", (Object)(nextAuditor == null ? ResManager.loadKDString((String)"\u65e0", (String)"RecClaimBillMobListPlugin_11", (String)"fi-cas-mobile", (Object[])new Object[0]) : nextAuditor));
        });
    }

    public static Map<String, String> getNextAuditor(List<String> pkId) {
        Map auditorsMap = WorkflowServiceHelper.getApproversMapByBusinessKeys((String[])pkId.toArray(new String[0]));
        HashMap<String, String> auditorsNameMap = new HashMap<String, String>();
        HashSet userId = new HashSet();
        auditorsMap.forEach((k, v) -> {
            if (v.size() > 1) {
                auditorsNameMap.put((String)k, ResManager.loadKDString((String)"\u7b49\u4eba", (String)"RecClaimBillMobListPlugin_7", (String)"fi-cas-mobile", (Object[])new Object[0]));
            } else {
                auditorsNameMap.put((String)k, "");
            }
            userId.add(v.get(0));
        });
        DynamicObjectCollection users = QueryServiceHelper.query((String)"bos_user", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "in", userId)});
        HashMap userNameIdMapping = new HashMap();
        users.forEach(v -> userNameIdMapping.put(v.getLong("id"), v.getString("name")));
        auditorsMap.forEach((k, v) -> {
            Long userIdTemp = (Long)v.get(0);
            auditorsNameMap.put((String)k, userNameIdMapping.get(userIdTemp) == null ? null : (String)userNameIdMapping.get(userIdTemp) + (String)auditorsNameMap.get(k));
        });
        return auditorsNameMap;
    }

    private void auditAfterDo(String id) {
        DynamicObject claimBill = QueryServiceHelper.queryOne((String)"cas_claimbill", (String)"id,claimtype,billno", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(id))});
        String claimtype = claimBill.getString("claimtype");
        String billno = claimBill.getString("billno");
        this.showOperationForm(claimtype, billno);
    }

    private void submitAfterDo(String id) {
        DynamicObject claimBill = QueryServiceHelper.queryOne((String)"cas_claimbill", (String)"id,claimtype,billno", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(id))});
        String claimtype = claimBill.getString("claimtype");
        String billno = claimBill.getString("billno");
        List<Map<String, Object>> maps = RecClaimBillOperationHelper.forecastWorkflow(id);
        if (CollectionUtils.isEmpty(maps)) {
            String ignore = RecClaimBillOperationHelper.getIgnoreTipAutoAudit(Long.parseLong(RequestContext.get().getUserId()));
            if ("true".equals(ignore)) {
                this.doAutoAudit(id, billno, claimtype);
            } else {
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("_t", new Date().getTime());
                data.put("claimtype", claimtype);
                data.put("billno", billno);
                data.put("id", id);
                data.put("show", Boolean.TRUE);
                CustomCtrlPropHelper.setCustomCtrlProp(this.getView(), "custom_control_dialog", data);
            }
        } else {
            this.showOperationForm(claimtype, billno);
        }
    }

    public void customEvent(CustomEventArgs e) {
        String key = e.getKey();
        String eventName = e.getEventName();
        if ("custom_control_dialog".equals(key) && "click".equals(eventName)) {
            Map data = (Map)SerializationUtils.fromJsonString((String)e.getEventArgs(), Map.class);
            switch (data.get("nodeKey").toString()) {
                case "btn_ok": {
                    this.doOk((Map)CastUtils.cast(data.get("data")));
                    break;
                }
                case "btn_cancel": {
                    this.doCancel();
                }
            }
        }
    }

    private void doOk(Map<String, Object> data) {
        String claimtype = data.getOrDefault("claimtype", "").toString();
        String billno = data.getOrDefault("billno", "").toString();
        String id = data.getOrDefault("id", "").toString();
        if (StringUtils.isEmpty((CharSequence)billno)) {
            return;
        }
        Boolean ignore = (Boolean)data.getOrDefault("ignore", Boolean.FALSE);
        if (ignore.booleanValue()) {
            RecClaimBillOperationHelper.saveIgnoreTipAutoAudit(Long.parseLong(RequestContext.get().getUserId()), "true");
        }
        this.doAutoAudit(id, billno, claimtype);
    }

    private void doAutoAudit(String id, String billno, String claimtype) {
        OperationResult result = RecClaimBillOperationHelper.executeOperateAuditById(id);
        if (result.isSuccess()) {
            this.showOperationForm(claimtype, billno);
        } else {
            log.info("\u63d0\u4ea4->\u81ea\u52a8\u5ba1\u6838 :" + Arrays.toString(result.getAllErrorOrValidateInfo().toArray()));
            this.getView().showErrorNotification(RecClaimBillOperationHelper.validateInfo(result));
        }
    }

    private void doCancel() {
        this.refresh();
    }

    static class ClaimHandleListDataProvider
    extends ListDataProvider {
        private final AbstractMobListPlugin plugin;

        ClaimHandleListDataProvider(AbstractMobListPlugin plugin) {
            this.plugin = plugin;
        }

        public void setQFilters(List<QFilter> qFilters) {
            super.setQFilters(qFilters);
        }

        public DynamicObjectCollection getData(int start, int limit) {
            DynamicObjectCollection rows = super.getData(start, limit);
            if (rows.isEmpty()) {
                this.showEmptyDataPage(this.plugin);
                this.plugin.getView().setVisible(Boolean.FALSE, new String[]{RecClaimBillMobListPlugin.C_LIST_TAG});
                this.plugin.getView().setVisible(Boolean.TRUE, new String[]{RecClaimBillMobListPlugin.C_EMPTY_LIST_PANEL_TAG});
                return rows;
            }
            IFormView view = this.plugin.getView();
            view.setVisible(Boolean.FALSE, new String[]{RecClaimBillMobListPlugin.C_EMPTY_LIST_PANEL_TAG});
            view.setVisible(Boolean.TRUE, new String[]{RecClaimBillMobListPlugin.C_LIST_TAG});
            IPageCache pageCache = this.plugin.getPageCache();
            String listType = pageCache.get(RecClaimBillMobListPlugin.LIST_TYPE);
            Set ids = rows.stream().map(dy -> Long.parseLong(dy.getPkValue().toString())).collect(Collectors.toCollection(HashSet::new));
            if (StringUtils.equals((CharSequence)listType, (CharSequence)"tabongoing") || StringUtils.equals((CharSequence)listType, (CharSequence)"tabdoing")) {
                Set<Long> haveWFids = RecClaimNoticeMobUtils.getBillRejectedInWf(ids);
                ids.removeAll(haveWFids);
                this.updataWorkFlow(rows, ids, "1");
            } else {
                this.updataWorkFlow(rows, ids, "0");
            }
            Set customerIds = rows.stream().filter(dy -> StringUtils.equals((CharSequence)ClaimPaymentTypeEnum.CUSTOMER.getValue(), (CharSequence)dy.getString("paymenttype")) && EmptyUtil.isNotEmpty(dy.getString("recpayer"))).map(dy -> Long.valueOf(dy.getString("recpayer"))).collect(Collectors.toCollection(HashSet::new));
            DynamicObjectCollection customerColl = QueryServiceHelper.query((String)ClaimPaymentTypeEnum.CUSTOMER.getValue(), (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)customerIds)});
            Map<Object, Object> customerMap = EmptyUtil.isNoEmpty(customerColl) ? customerColl.stream().collect(Collectors.toMap(dy -> String.valueOf(dy.getLong("id")), dy -> dy.getString("name"), (d1, d2) -> d2)) : new HashMap();
            Set supplierIds = rows.stream().filter(dy -> StringUtils.equals((CharSequence)ClaimPaymentTypeEnum.SUPPLIER.getValue(), (CharSequence)dy.getString("paymenttype")) && EmptyUtil.isNotEmpty(dy.getString("recpayer"))).map(dy -> Long.valueOf(dy.getString("recpayer"))).collect(Collectors.toCollection(HashSet::new));
            DynamicObjectCollection supplierColl = QueryServiceHelper.query((String)ClaimPaymentTypeEnum.SUPPLIER.getValue(), (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)supplierIds)});
            Map<Object, Object> supplierMap = EmptyUtil.isNoEmpty(supplierColl) ? supplierColl.stream().collect(Collectors.toMap(dy -> String.valueOf(dy.getLong("id")), dy -> dy.getString("name"), (d1, d2) -> d2)) : new HashMap();
            Set orgIds = rows.stream().filter(dy -> StringUtils.equals((CharSequence)ClaimPaymentTypeEnum.ORG.getValue(), (CharSequence)dy.getString("paymenttype")) && EmptyUtil.isNotEmpty(dy.getString("recpayer"))).map(dy -> Long.valueOf(dy.getString("recpayer"))).collect(Collectors.toCollection(HashSet::new));
            DynamicObjectCollection orgColl = QueryServiceHelper.query((String)ClaimPaymentTypeEnum.ORG.getValue(), (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)orgIds)});
            Map<Object, Object> orgMap = EmptyUtil.isNoEmpty(orgColl) ? orgColl.stream().collect(Collectors.toMap(dy -> String.valueOf(dy.getLong("id")), dy -> dy.getString("name"), (d1, d2) -> d2)) : new HashMap();
            Set userIds = rows.stream().filter(dy -> StringUtils.equals((CharSequence)ClaimPaymentTypeEnum.USER.getValue(), (CharSequence)dy.getString("paymenttype")) && EmptyUtil.isNotEmpty(dy.getString("recpayer"))).map(dy -> Long.valueOf(dy.getString("recpayer"))).collect(Collectors.toCollection(HashSet::new));
            DynamicObjectCollection userColl = QueryServiceHelper.query((String)ClaimPaymentTypeEnum.USER.getValue(), (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)userIds)});
            Map<Object, Object> userMap = EmptyUtil.isNoEmpty(userColl) ? userColl.stream().collect(Collectors.toMap(dy -> String.valueOf(dy.getLong("id")), dy -> dy.getString("name"), (d1, d2) -> d2)) : new HashMap();
            for (DynamicObject row : rows) {
                String paymenttype = row.getString("paymenttype");
                String recpayer = row.getString("recpayer");
                if (StringUtils.equals((CharSequence)paymenttype, (CharSequence)ClaimPaymentTypeEnum.CUSTOMER.getValue())) {
                    row.set("recpayer", customerMap.get(recpayer));
                    continue;
                }
                if (StringUtils.equals((CharSequence)paymenttype, (CharSequence)ClaimPaymentTypeEnum.SUPPLIER.getValue())) {
                    row.set("recpayer", supplierMap.get(recpayer));
                    continue;
                }
                if (StringUtils.equals((CharSequence)paymenttype, (CharSequence)ClaimPaymentTypeEnum.ORG.getValue())) {
                    row.set("recpayer", orgMap.get(recpayer));
                    continue;
                }
                if (!StringUtils.equals((CharSequence)paymenttype, (CharSequence)ClaimPaymentTypeEnum.USER.getValue())) continue;
                row.set("recpayer", userMap.get(recpayer));
            }
            long t1 = System.currentTimeMillis();
            ArrayList<String> pkId = new ArrayList<String>();
            rows.forEach(v -> pkId.add(String.valueOf(v.getPkValue())));
            if (!pkId.isEmpty()) {
                RecClaimBillMobListPlugin.setNextAuditor(rows, pkId);
            }
            long t2 = System.currentTimeMillis();
            log.info("\u5ba1\u6838\u4eba\u6570\u636e\u52a0\u8f7dB \u7528\u65f6\uff1a " + (t2 - t1) + "ms");
            return rows;
        }

        private void updataWorkFlow(DynamicObjectCollection rows, Set<Long> ids, String val) {
            for (DynamicObject row : rows) {
                String billStatus = row.getString("billstatus");
                if (StringUtils.isEmpty((CharSequence)billStatus) || !StringUtils.equals((CharSequence)"B", (CharSequence)billStatus) || !ids.contains(row.getPkValue())) continue;
                row.set("isconfireworkflow", (Object)val);
            }
        }

        private void showEmptyDataPage(AbstractMobListPlugin plugin) {
            String doSearch = plugin.getPageCache().get(RecClaimBillMobListPlugin.DO_SEARCH_TAG);
            Image image = (Image)plugin.getView().getControl("imageap_search");
            Label label = (Label)plugin.getView().getControl("labelap_search");
            if ("true".equals(doSearch)) {
                image.setUrl("/images/mobile/emotion/skrl_ssbd_224_128.png");
                label.setText(ResManager.loadKDString((String)"\u641c\u7d22\u4e0d\u5230\u7ed3\u679c", (String)"RecClaimBillMobListPlugin_8", (String)"fi-cas-mobile", (Object[])new Object[0]));
            } else {
                image.setUrl("/images/mobile/emotion/cwy_zwsj_512_320.png");
                label.setText(ResManager.loadKDString((String)"\u6682\u65e0\u6570\u636e", (String)"RecClaimBillMobListPlugin_9", (String)"fi-cas-mobile", (Object[])new Object[0]));
            }
        }
    }
}

