/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.mobile.recclaim;

import java.math.BigDecimal;
import java.security.SecureRandom;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.plugin.AbstractMobListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.cas.formplugin.mobile.recclaim.RecClaimPageJumpHandler;
import kd.fi.cas.formplugin.mobile.recclaim.constant.IndexPicUrlEnum;
import kd.fi.cas.formplugin.mobile.recclaim.constant.IndexTextEnum;
import kd.fi.cas.formplugin.mobile.recclaim.enums.ClaimStatusEnum;
import kd.fi.cas.formplugin.mobile.recclaim.utils.DateUtils;
import kd.fi.cas.formplugin.mobile.recclaim.utils.RecClaimNoticeMobUtils;
import org.apache.commons.lang3.StringUtils;

public class RecClaimCenterIndexMobPlugin
extends AbstractMobListPlugin {
    public static final String CENTER_INDEX_PAGE_TAG = "cas_claimcenter_index_m";
    private static final String UNCONFIRMED = "panel_unconfirmed";
    private static final String CONFIRMED = "panel_confirmed";
    private static final String ALL = "panel_workbench_more";
    private static final String PIC_LABEL = "img_work_results";
    private static final String TEXT_LABEL = "label_work_results_msg";
    private static final String PIC_CACHE = "pic";
    private static final String TEXT_CACHE = "text";
    private static final String BACK_UP_CACHE = "backup";
    private static final String UNCONFIRMED_COUNT_LABEL = "label_unconfirmed_value";
    private static final String CONFIRMED_COUNT_LABEL = "label_confirmed_value";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{UNCONFIRMED, CONFIRMED, ALL});
    }

    public void afterCreateNewData(EventObject e) {
        this.generateDocumentRandomParameter();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initDocumentData();
        this.initNoticeLabel();
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (StringUtils.equals((CharSequence)UNCONFIRMED, (CharSequence)key)) {
            RecClaimPageJumpHandler.JumpToNoticeCenterTabPage((AbstractFormPlugin)this, "unconfirm_page");
        } else if (StringUtils.equals((CharSequence)CONFIRMED, (CharSequence)key)) {
            RecClaimPageJumpHandler.JumpToNoticeCenterTabPage((AbstractFormPlugin)this, "confirmed_page");
        } else if (StringUtils.equals((CharSequence)ALL, (CharSequence)key)) {
            if (!this.checkViewPermission().booleanValue()) {
                return;
            }
            RecClaimPageJumpHandler.JumpToNoticeCenterAllPage((AbstractFormPlugin)this);
        }
    }

    private void initNoticeLabel() {
        QFilter unconfirmedFilter = RecClaimNoticeMobUtils.getClaimCenterQFilter(this.getView(), "unconfirm_page");
        DynamicObjectCollection unconfirmedObjects = QueryServiceHelper.query((String)"cas_claimcenterbill", (String)"id", (QFilter[])unconfirmedFilter.toArray());
        ((Label)this.getControl(UNCONFIRMED_COUNT_LABEL)).setText(String.valueOf(unconfirmedObjects.size()));
        QFilter confirmedFilter = RecClaimNoticeMobUtils.getClaimCenterQFilter(this.getView(), "confirmed_page");
        DynamicObjectCollection confirmedObjects = QueryServiceHelper.query((String)"cas_claimcenterbill", (String)"id", (QFilter[])confirmedFilter.toArray());
        ((Label)this.getControl(CONFIRMED_COUNT_LABEL)).setText(String.valueOf(confirmedObjects.size()));
    }

    private void generateDocumentRandomParameter() {
        int backUpNumberIsNot2;
        SecureRandom random = new SecureRandom();
        HashMap<String, String> randomParameterMap = new HashMap<String, String>();
        randomParameterMap.put(PIC_CACHE, String.valueOf(random.nextInt(IndexPicUrlEnum.values().length) + 1));
        randomParameterMap.put(TEXT_CACHE, String.valueOf(random.nextInt(IndexTextEnum.values().length) + 1));
        while ((backUpNumberIsNot2 = random.nextInt(IndexPicUrlEnum.values().length) + 1) == 2) {
        }
        randomParameterMap.put(BACK_UP_CACHE, String.valueOf(backUpNumberIsNot2));
        this.getPageCache().put(randomParameterMap);
    }

    private void initDocumentData() {
        String textIndex;
        String text;
        DynamicObjectCollection notices;
        String picUrl = IndexPicUrlEnum.getUrlByNumber(Integer.parseInt(this.getPageCache().get(PIC_CACHE)));
        Image image = (Image)this.getControl(PIC_LABEL);
        image.setUrl(picUrl);
        QFilter statusFilter = new QFilter("claimstatus", "=", (Object)ClaimStatusEnum.SURE.getValue());
        QFilter userFilter = new QFilter("confirmuser", "=", (Object)Long.valueOf(RequestContext.get().getUserId()));
        QFilter timeFilter = new QFilter("confirmdate", ">=", (Object)DateUtils.getDataFormat(this.getDateOfLastMonth(), false));
        QFilter orgFilter = null;
        String appId = this.getView().getFormShowParameter().getAppId();
        HasPermOrgResult permResult = PermissionServiceHelper.getAllPermOrgs((Long)Long.parseLong(RequestContext.get().getUserId()), (String)appId, (String)"cas_claimcenterbill", (String)"47150e89000000ac");
        if (!permResult.hasAllOrgPerm()) {
            orgFilter = new QFilter("org", "in", (Object)permResult.getHasPermOrgs());
        }
        if (CollectionUtils.isEmpty((Collection)(notices = QueryServiceHelper.query((String)"cas_claimcenterbill", (String)"id,reamount,org,recpayer,currency.name,currency.amtprecision,currency.sign", (QFilter[])new QFilter[]{statusFilter, userFilter, timeFilter, orgFilter})))) {
            return;
        }
        if ("2".equals(this.getPageCache().get(TEXT_CACHE)) && this.estimateCurrencyOfNoticesIsNotSingle(notices)) {
            text = IndexTextEnum.getTextByNumber(Integer.parseInt(this.getPageCache().get(BACK_UP_CACHE)));
            textIndex = this.getPageCache().get(BACK_UP_CACHE);
        } else {
            text = IndexTextEnum.getTextByNumber(Integer.parseInt(this.getPageCache().get(TEXT_CACHE)));
            textIndex = this.getPageCache().get(TEXT_CACHE);
        }
        switch (textIndex) {
            case "1": {
                this.setNoticeCountText(text, notices);
                break;
            }
            case "2": {
                this.setNoticeReamountText(text, notices);
                break;
            }
            case "3": {
                this.setNoticePayerCountText(text, notices);
                break;
            }
            case "4": {
                this.setNoticeOrgCountText(text, notices);
            }
        }
    }

    private boolean estimateCurrencyOfNoticesIsNotSingle(DynamicObjectCollection notices) {
        String currencyName = ((DynamicObject)notices.get(0)).getString("currency.name");
        for (DynamicObject notice : notices) {
            if (StringUtils.equals((CharSequence)currencyName, (CharSequence)notice.getString("currency.name"))) continue;
            return true;
        }
        return false;
    }

    private Boolean checkViewPermission() {
        HasPermOrgResult permResult = PermissionServiceHelper.getAllPermOrgs((Long)Long.parseLong(RequestContext.get().getUserId()), (String)"cas", (String)"cas_claimcenterbill", (String)"47150e89000000ac");
        if (!permResult.hasAllOrgPerm() && CollectionUtils.isEmpty((Collection)permResult.getHasPermOrgs())) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("checkPermission", (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u65e0\"\u8ba4\u9886\u4e2d\u5fc3\"\u67e5\u770b\u6743\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (String)"RecClaimCenterIndexMobPlugin_0", (String)"fi-cas-mobile", (Object[])new Object[0]), MessageBoxOptions.OK, ConfirmTypes.Default, confirmCallBacks);
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private void setNoticeCountText(String text, DynamicObjectCollection notices) {
        long count = notices.stream().map(dy -> dy.getLong("id")).distinct().count();
        if (StringUtils.isNotBlank((CharSequence)text) && count > 0L) {
            Label label = (Label)this.getControl(TEXT_LABEL);
            label.setText(String.format(text, count));
        }
    }

    private void setNoticeOrgCountText(String text, DynamicObjectCollection notices) {
        long count = notices.stream().map(dy -> dy.getString("org")).distinct().count();
        if (StringUtils.isNotBlank((CharSequence)text) && count > 0L) {
            Label label = (Label)this.getControl(TEXT_LABEL);
            label.setText(String.format(text, count));
        }
    }

    private void setNoticePayerCountText(String text, DynamicObjectCollection notices) {
        long count = notices.stream().map(dy -> dy.getString("recpayer")).distinct().count();
        if (StringUtils.isNotBlank((CharSequence)text) && count > 0L) {
            Label label = (Label)this.getControl(TEXT_LABEL);
            label.setText(String.format(text, count));
        }
    }

    private void setNoticeReamountText(String text, DynamicObjectCollection notices) {
        if (CollectionUtils.isEmpty((Collection)notices)) {
            return;
        }
        int precision = ((DynamicObject)notices.get(0)).getInt("currency.amtprecision");
        String sign = ((DynamicObject)notices.get(0)).getString("currency.sign");
        BigDecimal reamount = notices.stream().map(dy -> dy.getBigDecimal("reamount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO).setScale(precision, 7);
        if (StringUtils.isNotBlank((CharSequence)text) && reamount.compareTo(BigDecimal.ZERO) > 0) {
            Label label = (Label)this.getControl(TEXT_LABEL);
            label.setText(String.format(text, sign + reamount));
        }
    }

    private Date getDateOfLastMonth() {
        LocalDate lastMonth = LocalDate.now().minusMonths(1L);
        ZonedDateTime zonedDateTime = lastMonth.atStartOfDay(ZoneId.systemDefault());
        return Date.from(zonedDateTime.toInstant());
    }
}

