/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.mobile.recclaim;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.container.Container;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.formplugin.mobile.recclaim.M;
import kd.fi.cas.formplugin.mobile.recclaim.RecClaimPageJumpHandler;
import kd.fi.cas.formplugin.mobile.recclaim.enums.ClaimHandleStatusEnum;
import kd.fi.cas.formplugin.mobile.recclaim.enums.ClaimStatusEnum;
import kd.fi.cas.formplugin.mobile.recclaim.enums.ClaimTypeEnum;
import kd.fi.cas.formplugin.mobile.recclaim.enums.MergeStatusEnum;
import kd.fi.cas.formplugin.mobile.recclaim.helper.CasServiceHelper;
import kd.fi.cas.formplugin.mobile.recclaim.helper.MulLanguageHelper;
import kd.fi.cas.formplugin.mobile.recclaim.helper.RecClaimHelper;
import kd.fi.cas.formplugin.mobile.recclaim.result.InvokeResult;
import kd.fi.cas.formplugin.mobile.recclaim.utils.EmptyUtil;
import kd.fi.cas.formplugin.mobile.recclaim.utils.RecClaimNoticeMobUtils;

public class RecClaimCenterMobEditPlugin
extends AbstractMobBillPlugIn
implements RowClickEventListener {
    private static final String ENTRYENTITY = "entryentity";
    private static final String ENTRY_SUMMARY_MONEY = "entrysummary_money";
    private static final String OPPUNIT = "oppunit";
    private static final String OPPUNIT_LABEL = "labelap5";
    private static final String DRAWER_NAME = "drawername";
    private static final String PAYER_BASE = "recbasepayer";
    private static final String IS_CANCEL = "e_billstatus";
    private static final String CLAIM_TYPE = "e_claimtype";
    private static final String HANDLE_STATUS = "e_handlestatus";

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        AbstractGrid entryentity = (AbstractGrid)this.getView().getControl(ENTRYENTITY);
        if (entryentity != null) {
            entryentity.addRowClickListener((RowClickEventListener)this);
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        CardEntry source = (CardEntry)evt.getSource();
        if (ENTRYENTITY.equals(source.getEntryKey())) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRYENTITY);
            RecClaimPageJumpHandler.claimAnnounceToAnnounceEntry((AbstractFormPlugin)this, rowIndex);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.handlePayer();
        this.handleMerge();
        this.handleHeader();
        this.removeAppeal();
        this.handleEntryPanel();
        this.handleShowAppeal();
        this.handleFieldCaption();
        this.handlerRegistTime();
    }

    private void handlerRegistTime() {
        Object businesstype = this.getModel().getValue("businesstype");
        if ("recticket".equals(businesstype)) {
            this.getModel().setValue("registtime", this.getModel().getValue("tradetime"));
        }
    }

    private void handleFieldCaption() {
        IDataModel model = this.getModel();
        Object mergestatus = model.getValue("mergestatus");
        boolean isMergeBill = "2".equals(mergestatus);
        Object businesstype = model.getValue("businesstype");
        boolean isRecBill = "rec".equals(businesstype);
        String reamountFieldAlias = MulLanguageHelper.getReamountFieldAlias(isRecBill, isMergeBill);
        String tradetimeFieldAlias = MulLanguageHelper.getTradetimeFieldAlias(isRecBill);
        FieldEdit reamountFieldEdit = (FieldEdit)this.getControl("reamount");
        LocaleString reamountCaption = new LocaleString();
        reamountCaption.setLocaleValue(reamountFieldAlias);
        reamountFieldEdit.setCaption(reamountCaption);
        FieldEdit tradetimeFieldEdit = (FieldEdit)this.getControl("tradetime");
        tradetimeFieldEdit.setCaption(new LocaleString(tradetimeFieldAlias));
    }

    private void handleMerge() {
        List<DynamicObject> margeBills = RecClaimHelper.getAllChildNoticeBill(this.getModel().getDataEntity().getPkValue());
        String type = (String)this.getModel().getValue("businesstype");
        if ("rec".equals(type)) {
            DynamicObjectCollection detailentryentity = (DynamicObjectCollection)this.getModel().getValue("detailentryentity");
            for (DynamicObject margeBill : margeBills) {
                DynamicObject addNew = detailentryentity.addNew();
                addNew.set("e_billno", (Object)margeBill.getString("tradedetailno"));
                addNew.set("e_tracebillno", (Object)margeBill.getString("detailid"));
                addNew.set("e_bankaccount", margeBill.get("accountbank"));
                addNew.set("e_tracedate", (Object)margeBill.getDate("tradetime"));
                String bankName = margeBill.getDynamicObject("bank") == null ? null : margeBill.getDynamicObject("bank").getString("name");
                addNew.set("e_opeanbank", (Object)bankName);
                addNew.set("e_reamount", (Object)margeBill.getBigDecimal("reamount"));
                addNew.set("e_oppbanknumber", (Object)margeBill.getString("oppbanknumber"));
                addNew.set("e_oppbank", (Object)margeBill.getString("oppbank"));
                addNew.set("e_datasource", (Object)margeBill.getString("datasource"));
                addNew.set("e_description", (Object)margeBill.getString("description"));
            }
            this.getView().updateView("detailentryentity");
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"detailentry"});
            DynamicObjectCollection detailentryentity = (DynamicObjectCollection)this.getModel().getValue("ticketentryentity");
            BigDecimal sumreamount = BigDecimal.ZERO;
            for (DynamicObject margeBill : margeBills) {
                DynamicObject addNew = detailentryentity.addNew();
                addNew.set("e_ticketbillno", (Object)margeBill.getString("tradedetailno"));
                addNew.set("e_ticketamount", (Object)margeBill.getBigDecimal("reamount"));
                String name = margeBill.getDynamicObject("draftbilltype") == null ? "" : margeBill.getDynamicObject("draftbilltype").getString("name");
                addNew.set("e_draftbilltype", (Object)name);
                addNew.set("e_ticketdescription", (Object)margeBill.getString("description"));
                addNew.set("e_ticketdate", (Object)margeBill.getDate("tradetime"));
                addNew.set("e_draftbillexpiredate", (Object)margeBill.getDate("draftbillexpiredate"));
                addNew.set("e_drawername", (Object)margeBill.getString(DRAWER_NAME));
                addNew.set("e_ticketname", (Object)margeBill.getString("detailid"));
                addNew.set("e_ticketsource", (Object)margeBill.getString("datasource"));
                sumreamount = sumreamount.add(margeBill.getBigDecimal("reamount"));
            }
            this.getView().updateView("ticketentryentity");
        }
    }

    private void handleShowAppeal() {
        IDataModel iDataModel;
        String claimstatus;
        Container control = (Container)this.getControl("flex_panelap_appeal");
        String addContainerCache = this.getPageCache().get("addContainerCache");
        if (EmptyUtil.isNotEmpty(addContainerCache)) {
            control.deleteControls(addContainerCache.split(","));
        }
        if (StringUtils.equals((CharSequence)(claimstatus = (String)(iDataModel = this.getModel()).getValue("claimstatus")), (CharSequence)ClaimStatusEnum.APPEAL.getValue()) || StringUtils.equals((CharSequence)claimstatus, (CharSequence)ClaimStatusEnum.CHANGE.getValue())) {
            String claimNo = (String)iDataModel.getValue("billno");
            QFilter qFilter = new QFilter("claimno", "=", (Object)claimNo);
            qFilter.and(new QFilter("claimtype", "in", (Object)new String[]{ClaimTypeEnum.APPEAL.getValue(), ClaimTypeEnum.CHANGE.getValue()}));
            qFilter.and(new QFilter("billstatus", "=", (Object)"C"));
            qFilter.and(new QFilter("handlestatus", "=", (Object)ClaimHandleStatusEnum.NOTCLAIM.getValue()));
            List colls = QueryServiceHelper.queryPrimaryKeys((String)"cas_claimbill", (QFilter[])new QFilter[]{qFilter}, null, (int)-1);
            if (EmptyUtil.isNoEmpty(colls)) {
                FlexPanelAp flex = null;
                BillShowParameter showParameter = null;
                StringBuilder flexNumber = new StringBuilder();
                ArrayList<String> lst = new ArrayList<String>(colls.size());
                for (int i = 0; i < colls.size(); ++i) {
                    flexNumber.setLength(0);
                    flexNumber.append("flexpanelaptemp").append(i);
                    flex = new FlexPanelAp();
                    flex.setKey(flexNumber.toString());
                    flex.setGrow(0);
                    flex.setShrink(0);
                    control.addControls(Collections.singletonList(flex.createControl()));
                    showParameter = new BillShowParameter();
                    showParameter.setFormId("cas_claimappeal_m");
                    showParameter.getOpenStyle().setShowType(ShowType.InContainer);
                    showParameter.getOpenStyle().setTargetKey(flexNumber.toString());
                    lst.add(flexNumber.toString());
                    showParameter.setPkId(colls.get(i));
                    this.getView().showForm((FormShowParameter)showParameter);
                }
                this.getPageCache().put("addContainerCache", String.join((CharSequence)",", lst));
                this.getView().setVisible(Boolean.TRUE, new String[]{"flex_panelap_appeal"});
            }
        }
    }

    private void removeAppeal() {
        DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity(ENTRYENTITY);
        dynamicObjects.removeAll((Collection)dynamicObjects.stream().filter(dy -> (ClaimTypeEnum.APPEAL.getValue().equals(dy.get(CLAIM_TYPE)) || ClaimTypeEnum.CHANGE.getValue().equals(dy.get(CLAIM_TYPE))) && !dy.getBoolean(HANDLE_STATUS)).collect(Collectors.toList()));
        this.getView().updateView(ENTRYENTITY);
    }

    private void handlePayer() {
        String type = (String)this.getModel().getValue("paymenttype");
        if (!StringUtils.equals((CharSequence)type, (CharSequence)"other")) {
            this.getModel().setValue("paymentbasetype", (Object)type);
            this.getModel().setValue(PAYER_BASE, this.getModel().getValue("recpayer"));
        }
    }

    private void handleHeader() {
        Label label5 = (Label)this.getControl(OPPUNIT_LABEL);
        label5.setText((String)this.getModel().getValue(OPPUNIT));
        if ("recticket".equals(this.getModel().getValue("businesstype")) && MergeStatusEnum.ALMARGE.getValue().equals(this.getModel().getValue("mergestatus"))) {
            this.getModel().setValue(DRAWER_NAME, this.getModel().getValue(OPPUNIT));
        }
    }

    private void handleEntryPanel() {
        IDataModel model = this.getModel();
        DynamicObjectCollection entryEntity = model.getEntryEntity(ENTRYENTITY);
        BigDecimal reAmount = entryEntity.stream().filter(dy -> !dy.getBoolean(IS_CANCEL)).map(dynamicObject -> (BigDecimal)dynamicObject.get("e_receivableamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
        Label entryCountMoneyLabel = (Label)this.getControl(ENTRY_SUMMARY_MONEY);
        entryCountMoneyLabel.setText(M.getCurrencyFormatStr((DynamicObject)model.getValue("currency"), reAmount));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("beforeaccount".equals(operateKey)) {
            this.claimAccount();
        }
    }

    private void claimAccount() {
        Object primaryKeyValue = this.getModel().getDataEntity().getPkValue();
        InvokeResult ret = CasServiceHelper.beforeAccount(primaryKeyValue);
        if (!ret.isSuccess()) {
            if (ret.get("showMessge") != null) {
                this.getView().showTipNotification(ret.getMsg());
            } else if (ret.get("showConfirm") != null) {
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("beforeaccount", (IFormPlugin)this);
                this.getView().showConfirm(ret.getMsg(), MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks);
            }
            return;
        }
        this.getView().invokeOperation("claimaccount");
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        if (e.getCallBackId().equals("beforeaccount") && e.getResult() == MessageBoxResult.Yes) {
            this.getView().invokeOperation("claimaccount");
            this.getView().invokeOperation("refresh");
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        OperationResult result = args.getOperationResult();
        if ("transpond".equals(operateKey)) {
            RecClaimPageJumpHandler.showTranspondUserListPage((AbstractFormPlugin)this);
        } else if ("rejectclaim".equals(operateKey)) {
            if (args.getOperationResult().isSuccess()) {
                this.beforeRejectClaim();
            }
        } else if ("claimaccount".equals(operateKey) && result.isSuccess()) {
            this.refreshParentPageAfterOpt();
            if ("cas_claimcenter_tab_m".equals(this.getView().getFormShowParameter().getParentFormId())) {
                this.jumpToToAccountNoticeList();
            }
        } else if ("cancelaccount".equals(operateKey) && result.isSuccess()) {
            this.refreshParentPageAfterOpt();
        }
    }

    private void beforeRejectClaim() {
        String billNo = (String)this.getModel().getValue("billno");
        InvokeResult ret = CasServiceHelper.beforeRejectClaim(billNo);
        if (!ret.isSuccess()) {
            this.getView().showSuccessNotification(ret.getMsg());
            return;
        }
        List rejectData = (List)ret.get("rejectData");
        String json = SerializationUtils.toJsonString((Object)rejectData);
        RecClaimPageJumpHandler.showRejectClaimPage((AbstractFormPlugin)this, json);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        if (actionId.equals("transpond") && evt.getReturnData() != null) {
            this.transpond(evt);
        } else if (actionId.equals("cas_rejectclaim_m") && evt.getReturnData() != null) {
            this.rejectClaim(evt);
            this.refreshParentPageAfterOpt();
        }
    }

    private void rejectClaim(ClosedCallBackEvent evt) {
        HashMap returnDataMap = (HashMap)evt.getReturnData();
        if (returnDataMap == null) {
            return;
        }
        Object pkValue = this.getModel().getDataEntity().getPkValue();
        InvokeResult ret = CasServiceHelper.rejectClaim(returnDataMap, pkValue);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u9a73\u56de\u8ba4\u9886\u7ed3\u679c\u6210\u529f\u3002", (String)"RecClaimCenterMobEditPlugin_5", (String)"fi-cas-mobile", (Object[])new Object[0]));
    }

    private void transpond(ClosedCallBackEvent evt) {
        ListSelectedRowCollection returnData = (ListSelectedRowCollection)evt.getReturnData();
        Set userPks = returnData.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toSet());
        DynamicObjectCollection users = QueryServiceHelper.query((String)"bos_user", (String)"id,name", (QFilter[])new QFilter("id", "in", userPks).toArray());
        HashMap<Object, String> userIdNames = new HashMap<Object, String>();
        for (DynamicObject user : users) {
            userIdNames.put(user.get("id"), user.getString("name"));
        }
        Object[] selectids = new Object[]{this.getModel().getValue("id")};
        InvokeResult ret = CasServiceHelper.transpond(userIdNames, selectids);
        if (ret.isSuccess()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8f6c\u53d1\u6210\u529f\u3002", (String)"RecClaimCenterMobEditPlugin_6", (String)"fi-cas-mobile", (Object[])new Object[0]));
            IFormView parentView = this.getView().getParentView();
            parentView.invokeOperation("refresh");
            this.getView().sendFormAction(parentView);
            this.getModel().setDataChanged(false);
            this.getView().close();
        }
    }

    private void refreshParentPageAfterOpt() {
        RecClaimNoticeMobUtils.refreshTargetParentPage(this.getView(), "cas_claimanno_moblist");
        RecClaimNoticeMobUtils.refreshTargetParentPage(this.getView(), "cas_claimcenter_index_m");
        this.getView().invokeOperation("refresh");
    }

    private void jumpToToAccountNoticeList() {
        MobileFormShowParameter parameter = new MobileFormShowParameter();
        parameter.setFormId("cas_claimcenter_tab_m");
        parameter.getOpenStyle().setShowType(ShowType.Floating);
        parameter.setCaption(ResManager.loadKDString((String)"\u8ba4\u9886\u4e2d\u5fc3", (String)"RecClaimCenterMobEditPlugin_12", (String)"fi-cas-mobile", (Object[])new Object[0]));
        parameter.setCustomParam("listType", (Object)"unconfirm_page");
        this.getView().showForm((FormShowParameter)parameter);
    }
}

