/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.mobile.recclaim;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.MobileSearchCancelListener;
import kd.bos.form.control.events.MobileSearchTextChangeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.MobileSearch;
import kd.bos.list.plugin.AbstractMobListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.fi.cas.formplugin.mobile.recclaim.RecClaimPageJumpHandler;
import kd.fi.cas.formplugin.mobile.recclaim.utils.CastUtils;
import kd.fi.cas.formplugin.mobile.recclaim.utils.RecClaimNoticeMobUtils;

public class RecClaimCenterMobListPlugin
extends AbstractMobListPlugin
implements MobileSearchCancelListener {
    public static final String PAGE_CACHE_ANNOUNCE_STATUS_FILTER = "pageCache_announceStatusFilter";
    private static final int TOTAL_FILTER_STATUS_COUNT = 6;
    public static final String ALL = "all";
    private static final String NOTICE_LIST_TAG = "flexpanelapoperator";
    private static final String EMPTY_LIST_PICTURE_TAG = "flexpanelap9";
    private static final String DO_SEARCH_TAG = "DO_SEARCH";

    public void initialize() {
        super.initialize();
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"flex_status_selected"});
        ((MobileSearch)this.getControl("mobilesearchap")).addMobileSearchCancelListener((MobileSearchCancelListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            parentView.getPageCache().put("cas_claimcenter_tab_m" + this.getListType(), this.getView().getPageId());
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setDefaultStatusFilterByListType();
    }

    private void setDefaultStatusFilterByListType() {
        ArrayList<String[]> statusInfos = new ArrayList<String[]>();
        switch (this.getListType()) {
            case "unconfirm_page": {
                this.getModel().setValue("pagetype", (Object)"9");
                statusInfos.add(new String[]{"2", ResManager.loadKDString((String)"\u5df2\u8ba4\u9886", (String)"RecClaimCenterMobListPlugin_0", (String)"fi-cas-mobile", (Object[])new Object[0])});
                statusInfos.add(new String[]{"4", ResManager.loadKDString((String)"\u7533\u8bc9\u4e2d", (String)"RecClaimCenterMobListPlugin_2", (String)"fi-cas-mobile", (Object[])new Object[0])});
                statusInfos.add(new String[]{"5", ResManager.loadKDString((String)"\u53d8\u66f4\u4e2d", (String)"RecClaimCenterMobListPlugin_1", (String)"fi-cas-mobile", (Object[])new Object[0])});
                break;
            }
            case "confirmed_page": {
                this.getModel().setValue("pagetype", (Object)"10");
                statusInfos.add(new String[]{"3", ResManager.loadKDString((String)"\u5df2\u786e\u8ba4", (String)"RecClaimCenterMobListPlugin_3", (String)"fi-cas-mobile", (Object[])new Object[0])});
                break;
            }
            case "all": {
                this.getModel().setValue("pagetype", (Object)"5");
                statusInfos.add(new String[]{"0", ResManager.loadKDString((String)"\u5f85\u8ba4\u9886", (String)"RecClaimCenterMobListPlugin_4", (String)"fi-cas-mobile", (Object[])new Object[0])});
                statusInfos.add(new String[]{"1", ResManager.loadKDString((String)"\u90e8\u5206\u8ba4\u9886", (String)"RecClaimCenterMobListPlugin_5", (String)"fi-cas-mobile", (Object[])new Object[0])});
                statusInfos.add(new String[]{"2", ResManager.loadKDString((String)"\u5df2\u8ba4\u9886", (String)"RecClaimCenterMobListPlugin_0", (String)"fi-cas-mobile", (Object[])new Object[0])});
                statusInfos.add(new String[]{"3", ResManager.loadKDString((String)"\u5df2\u786e\u8ba4", (String)"RecClaimCenterMobListPlugin_3", (String)"fi-cas-mobile", (Object[])new Object[0])});
                statusInfos.add(new String[]{"4", ResManager.loadKDString((String)"\u7533\u8bc9\u4e2d", (String)"RecClaimCenterMobListPlugin_2", (String)"fi-cas-mobile", (Object[])new Object[0])});
                statusInfos.add(new String[]{"5", ResManager.loadKDString((String)"\u53d8\u66f4\u4e2d", (String)"RecClaimCenterMobListPlugin_1", (String)"fi-cas-mobile", (Object[])new Object[0])});
                break;
            }
            default: {
                this.getModel().setValue("pagetype", (Object)"5");
                statusInfos.add(new String[]{"2", ResManager.loadKDString((String)"\u5df2\u8ba4\u9886", (String)"RecClaimCenterMobListPlugin_0", (String)"fi-cas-mobile", (Object[])new Object[0])});
                statusInfos.add(new String[]{"5", ResManager.loadKDString((String)"\u53d8\u66f4\u4e2d", (String)"RecClaimCenterMobListPlugin_1", (String)"fi-cas-mobile", (Object[])new Object[0])});
                statusInfos.add(new String[]{"4", ResManager.loadKDString((String)"\u7533\u8bc9\u4e2d", (String)"RecClaimCenterMobListPlugin_2", (String)"fi-cas-mobile", (Object[])new Object[0])});
            }
        }
        this.setStatusFilter(statusInfos);
    }

    private void setStatusFilter(List<String[]> statusInfos) {
        String statusCacheStr = statusInfos.stream().map(v -> v[0]).collect(Collectors.joining(","));
        String statusAliasStr = statusInfos.size() == 6 ? ResManager.loadKDString((String)"\u5168\u90e8\u72b6\u6001", (String)"RecClaimCenterMobListPlugin_6", (String)"fi-cas-mobile", (Object[])new Object[0]) : statusInfos.stream().map(v -> v[1]).collect(Collectors.joining("\uff1b"));
        ((Label)this.getControl("label_status")).setText(statusAliasStr);
        this.getPageCache().put(PAGE_CACHE_ANNOUNCE_STATUS_FILTER, statusCacheStr);
    }

    public void click(EventObject evt) {
        Control control;
        String key;
        super.click(evt);
        Object source = evt.getSource();
        if (source instanceof Control && "flex_status_selected".equals(key = (control = (Control)source).getKey())) {
            String curFilterStr = this.getPageCache().get(PAGE_CACHE_ANNOUNCE_STATUS_FILTER);
            RecClaimPageJumpHandler.showAnnounceListStatusFilterPage((AbstractFormPlugin)this, curFilterStr);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        OperationResult result = args.getOperationResult();
        if ("cancelnotice".equals(operateKey) && result.isSuccess()) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void mobileSearchTextChange(MobileSearchTextChangeEvent args) {
        this.getPageCache().put(DO_SEARCH_TAG, "true");
    }

    public void cancel() {
        this.getPageCache().put(DO_SEARCH_TAG, "false");
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        QFilter filter = RecClaimNoticeMobUtils.getClaimCenterQFilter(this.getView(), this.getListType());
        e.getQFilters().add(filter);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        if ("cas_claim_m_status_select".equals(actionId)) {
            this.getPageCache().put(DO_SEARCH_TAG, "true");
            List returnData = (List)CastUtils.cast(evt.getReturnData());
            this.setStatusFilter(returnData);
            this.getView().invokeOperation("refresh");
        }
    }

    private String getListType() {
        return this.getView().getFormShowParameter().getCustomParam("listType") == null ? "" : (String)this.getView().getFormShowParameter().getCustomParam("listType");
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new ClaimCenterListDataProvider(this));
    }

    static class ClaimCenterListDataProvider
    extends ListDataProvider {
        private final AbstractMobListPlugin plugin;

        ClaimCenterListDataProvider(AbstractMobListPlugin formPlugin) {
            this.plugin = formPlugin;
        }

        public DynamicObjectCollection getData(int start, int limit) {
            DynamicObjectCollection rows = super.getData(start, limit);
            if (CollectionUtils.isEmpty((Collection)rows)) {
                this.showEmptyDataPage(this.plugin);
                return rows;
            }
            this.plugin.getView().setVisible(Boolean.TRUE, new String[]{RecClaimCenterMobListPlugin.NOTICE_LIST_TAG});
            this.plugin.getView().setVisible(Boolean.FALSE, new String[]{RecClaimCenterMobListPlugin.EMPTY_LIST_PICTURE_TAG});
            rows.getDynamicObjectType().addProperty((DynamicProperty)new DynamicSimpleProperty("registtime", Date.class, null));
            for (DynamicObject row : rows) {
                row.set("registtime", (Object)row.getDate("tradetime"));
            }
            return rows;
        }

        private void showEmptyDataPage(AbstractMobListPlugin plugin) {
            String doSearch = plugin.getPageCache().get(RecClaimCenterMobListPlugin.DO_SEARCH_TAG);
            Image image = (Image)plugin.getView().getControl("imageap_search");
            Label label = (Label)plugin.getView().getControl("labelap_search");
            if ("true".equals(doSearch)) {
                image.setUrl("/images/mobile/emotion/skrl_ssbd_224_128.png");
                label.setText(ResManager.loadKDString((String)"\u641c\u7d22\u4e0d\u5230\u7ed3\u679c", (String)"RecClaimCenterMobListPlugin_7", (String)"fi-cas-mobile", (Object[])new Object[0]));
            } else {
                image.setUrl("/images/mobile/emotion/cwy_zwsj_512_320.png");
                label.setText(ResManager.loadKDString((String)"\u6682\u65e0\u6570\u636e", (String)"RecClaimCenterMobListPlugin_8", (String)"fi-cas-mobile", (Object[])new Object[0]));
            }
            plugin.getView().setVisible(Boolean.FALSE, new String[]{RecClaimCenterMobListPlugin.NOTICE_LIST_TAG});
            plugin.getView().setVisible(Boolean.TRUE, new String[]{RecClaimCenterMobListPlugin.EMPTY_LIST_PICTURE_TAG});
        }
    }
}

