/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.mobile.recclaim;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.formplugin.mobile.recclaim.RecClaimMobListFilterProvider;
import kd.fi.cas.formplugin.mobile.recclaim.RecClaimPageJumpHandler;
import kd.fi.cas.formplugin.mobile.recclaim.constant.ClaimCategoryEnum;
import kd.fi.cas.formplugin.mobile.recclaim.constant.SubscriptEnum;
import kd.fi.cas.formplugin.mobile.recclaim.utils.RecClaimNoticeMobUtils;

public class RecClaimIndexMobPlugin
extends AbstractFormPlugin {
    private static final String ALGO = "kd.fi.cas.formplugin.mobile.recclaim.RecClaimIndexMobPlugin";
    public static final String CAS_CLAIM_CATEGORY = "cas_claim_category";
    public static final String CAS_CLAIM_SUBSCRIPT = "cas_claim_subscriptcache";
    private static final String ALL_PAGE = "all_claim_entry";
    private static final String UNDO_PAGE = "flexpanelap10";
    private static final String PENDING_PAGE = "flexpanelap11";
    private static final String IGNORE_PAGE = "flexpanelap111";
    private static final String TMP_PAGE = "flexpanelap14";
    private static final String DOING_PAGE = "flexpanelap15";
    private static final String REJECT_PAGE = "flexpanelap141";
    private static final String CONFIRMED_PAGE = "flexpanelap151";
    private static final String SAVE_BILL_WITH_WORKFLOW = "saveBillWithWorkFlow";
    private static final HashMap<String, String> noticeMap = new HashMap();
    private static final HashMap<String, String> billMap;
    private Long maxNoticeId = 0L;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{UNDO_PAGE, PENDING_PAGE, IGNORE_PAGE, TMP_PAGE, DOING_PAGE, REJECT_PAGE, CONFIRMED_PAGE, "vectorap1", "vectorap11", ALL_PAGE});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Map<String, List<Long>> dataCacheMap = this.getClaimPKDatas();
        this.setNoticeLabel(dataCacheMap);
        this.setBillLabel(dataCacheMap);
        this.setSubscript(dataCacheMap);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (noticeMap.containsKey(key)) {
            RecClaimPageJumpHandler.JumpToNoticeTabPage(this, noticeMap.get(key));
        } else if (billMap.containsKey(key)) {
            RecClaimPageJumpHandler.JumpToBillTabPage(this, billMap.get(key));
        } else if (ALL_PAGE.equals(key)) {
            RecClaimPageJumpHandler.JumpToNoticeAllPage(this);
        }
    }

    private void setNoticeLabel(Map<String, List<Long>> dataCacheMap) {
        List<Long> undoPKs = dataCacheMap.get("undo_page");
        ((Label)this.getControl("label_undo_num")).setText(String.valueOf(undoPKs.size()));
        List<Long> pendingPks = dataCacheMap.get("pending_page");
        ((Label)this.getControl("label_pending_num")).setText(String.valueOf(pendingPks.size()));
    }

    private void setBillLabel(Map<String, List<Long>> dataCacheMap) {
        List<Long> draftList = dataCacheMap.get("tabrough");
        ((Label)this.getControl("label_tmp_num")).setText(String.valueOf(draftList.size()));
        List<Long> doingList = dataCacheMap.get("tabongoing");
        ((Label)this.getControl("label_doing_num")).setText(String.valueOf(doingList.size()));
        List<Long> rejectList = dataCacheMap.get("tabrejected");
        ((Label)this.getControl("labelap101")).setText(String.valueOf(rejectList.size()));
        List<Long> confirmedList = dataCacheMap.get("tabconfirmed");
        ((Label)this.getControl("labelap121")).setText(String.valueOf(confirmedList.size()));
    }

    private Map<String, List<Long>> getClaimPKDatas() {
        HashMap<String, List<Long>> dataCacheMap = new HashMap<String, List<Long>>(8);
        ArrayList draftList = new ArrayList(8);
        ArrayList<Long> doingList = new ArrayList<Long>(8);
        ArrayList rejectList = new ArrayList(8);
        ArrayList<Long> confirmedList = new ArrayList<Long>(8);
        HashSet<Long> hasReason = new HashSet<Long>(8);
        HashSet<Long> noReason = new HashSet<Long>(8);
        QFilter notMultiReceivingTypeFilter = new QFilter("multireceivingtype", "!=", (Object)true);
        QFilter userFilter = new QFilter("creator", "=", (Object)Long.valueOf(RequestContext.get().getUserId())).or("auditor", "=", (Object)Long.valueOf(RequestContext.get().getUserId()));
        String selectFields = "id, billstatus, rejectreason, claimstatus";
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)ALGO, (String)"cas_claimbill", (String)selectFields, (QFilter[])new QFilter[]{userFilter, notMultiReceivingTypeFilter}, null);){
            for (Row r : dataSet) {
                long id = r.getLong("id");
                String billStatus = r.getString("billstatus");
                String rejectReason = r.getString("rejectreason");
                String claimStatus = r.getString("claimstatus");
                if (StringUtils.isNotBlank((CharSequence)rejectReason)) {
                    hasReason.add(id);
                } else if ("A".equalsIgnoreCase(billStatus)) {
                    noReason.add(id);
                }
                if ("B".equalsIgnoreCase(billStatus) || "C".equalsIgnoreCase(billStatus) && !"3".equalsIgnoreCase(claimStatus)) {
                    doingList.add(id);
                    continue;
                }
                if (!"C".equalsIgnoreCase(billStatus) || !"3".equalsIgnoreCase(claimStatus)) continue;
                confirmedList.add(id);
            }
        }
        ArrayList<Long> billsInWorkFlow = new ArrayList<Long>(RecClaimNoticeMobUtils.getBillRejectedInWf(noReason));
        rejectList.addAll(hasReason);
        rejectList.addAll(billsInWorkFlow);
        noReason.removeAll(billsInWorkFlow);
        draftList.addAll(noReason);
        dataCacheMap.put("tabrough", draftList);
        dataCacheMap.put("tabongoing", doingList);
        dataCacheMap.put("tabrejected", rejectList);
        dataCacheMap.put("tabconfirmed", confirmedList);
        ArrayList<Long> ignoreInCategory = new ArrayList<Long>(16);
        ArrayList<Long> pendingInCategory = new ArrayList<Long>(16);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)ALGO, (String)CAS_CLAIM_CATEGORY, (String)"noticeid,type", (QFilter[])new QFilter[]{new QFilter("userid", "=", (Object)Long.valueOf(RequestContext.get().getUserId()))}, null);){
            for (Row row : dataSet) {
                long noteId = row.getLong("noticeid");
                String type = row.getString("type");
                if (ClaimCategoryEnum.IGNORE_BILL.getCode().toString().equals(type)) {
                    ignoreInCategory.add(noteId);
                    continue;
                }
                pendingInCategory.add(noteId);
            }
        }
        ArrayList<Long> undoPKs = new ArrayList<Long>(16);
        ArrayList<Long> ignorePKs = new ArrayList<Long>(16);
        ArrayList<Long> pendingPKs = new ArrayList<Long>(16);
        String fields = "id,billno,reamount,entryentity1,entryentity1.claimtype claimtype,entryentity1.claimtypeid claimtypeid";
        QFilter commonFilter = RecClaimMobListFilterProvider.getClaimNoticeCommonFilter(true);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)ALGO, (String)"cas_claimannounce", (String)fields, (QFilter[])new QFilter[]{commonFilter}, null);){
            for (Row r : dataSet) {
                long id = r.getLong("id");
                if (ignoreInCategory.contains(id)) {
                    ignorePKs.add(id);
                    continue;
                }
                if (pendingInCategory.contains(id)) {
                    pendingPKs.add(id);
                    continue;
                }
                long claimType = r.getLong("claimtype");
                if ((claimType != 1L || r.getLong("claimtypeid") == Long.parseLong(RequestContext.get().getUserId())) && id > this.maxNoticeId) {
                    this.maxNoticeId = id;
                }
                undoPKs.add(id);
            }
        }
        dataCacheMap.put("pending_page", pendingPKs);
        dataCacheMap.put("ignore_page", ignorePKs);
        dataCacheMap.put("undo_page", undoPKs);
        return dataCacheMap;
    }

    private void setSubscript(Map<String, List<Long>> dataCacheMap) {
        int count = 0;
        Long old = 0L;
        ArrayList<Long> oldIds = new ArrayList<Long>();
        try (DataSet typeIds = QueryServiceHelper.queryDataSet((String)ALGO, (String)CAS_CLAIM_SUBSCRIPT, (String)"id, lastestid,type", (QFilter[])new QFilter[]{new QFilter("userid", "=", (Object)Long.valueOf(RequestContext.get().getUserId()))}, (String)"id desc");){
            for (Row row : typeIds) {
                int type = row.getInteger("type");
                if (SubscriptEnum.UNDO_NOTICE.getCode() == type) {
                    if (old != 0L) continue;
                    old = row.getLong("lastestid");
                    continue;
                }
                if (SubscriptEnum.REJECT_BILL.getCode() != type) continue;
                oldIds.add(row.getLong("lastestid"));
            }
        }
        count = dataCacheMap.get("undo_page").size();
        if (count == 0 || this.maxNoticeId.compareTo(old) <= 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap4"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap4"});
        }
        List<Long> currentIds = dataCacheMap.get("tabrejected");
        currentIds.removeAll(oldIds);
        count = dataCacheMap.get("tabrejected").size();
        if (count == 0 || currentIds.size() == 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap41"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap41"});
        }
    }

    static {
        noticeMap.put(UNDO_PAGE, "undo_page");
        noticeMap.put(PENDING_PAGE, "pending_page");
        noticeMap.put(IGNORE_PAGE, "ignore_page");
        billMap = new HashMap();
        billMap.put(TMP_PAGE, "tabrough");
        billMap.put(DOING_PAGE, "tabongoing");
        billMap.put(REJECT_PAGE, "tabrejected");
        billMap.put(CONFIRMED_PAGE, "tabconfirmed");
    }
}

