/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.mobile.recclaim;

import java.util.EventObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.container.Tab;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.fi.cas.formplugin.mobile.recclaim.RecClaimPageJumpHandler;

public class RecClaimMinePagePlugin
extends AbstractMobFormPlugin
implements TabSelectListener {
    public static final String TAB_ROUGH = "tabrough";
    public static final String TAB_ONGOING = "tabongoing";
    public static final String TAB_REJECTED = "tabrejected";
    public static final String TAB_CONFIRMED = "tabconfirmed";
    public static final String CACHE_PAGEID_PRE = "cas_mine_claim";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Tab tab = (Tab)this.getControl("tabap");
        if (tab != null) {
            tab.addTabSelectListener((TabSelectListener)this);
        }
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        this.showList(tabSelectEvent.getTabKey());
    }

    private void showList(String tabKey) {
        String pageId = this.getPageCache().get(CACHE_PAGEID_PRE + tabKey);
        if (pageId != null) {
            this.refreshTabPage(tabKey, pageId);
        } else {
            RecClaimPageJumpHandler.mainPageToBillList(this, tabKey);
        }
    }

    private void refreshTabPage(String tabKey, String pageId) {
        if (StringUtils.equals((CharSequence)tabKey, (CharSequence)TAB_ROUGH) || StringUtils.equals((CharSequence)tabKey, (CharSequence)TAB_ONGOING)) {
            IFormView targetView = this.getView().getView(pageId);
            targetView.invokeOperation("refresh");
            this.getView().sendFormAction(targetView);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String tabKey = (String)parameter.getCustomParam("tabKey");
        this.showList(tabKey);
    }

    public void beforeBindData(EventObject e) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        if (parameter != null && parameter.getCustomParam("pagetype") != null) {
            String pagetype = parameter.getCustomParam("pagetype").toString();
            String tabKey = "";
            switch (pagetype) {
                case "1": {
                    tabKey = TAB_ROUGH;
                    break;
                }
                case "3": {
                    tabKey = TAB_ONGOING;
                    break;
                }
                case "2": {
                    tabKey = TAB_REJECTED;
                    break;
                }
                case "4": {
                    tabKey = TAB_CONFIRMED;
                }
            }
            this.showList(tabKey);
        }
    }
}

