/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.mobile.recclaim;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.formplugin.mobile.recclaim.constant.ClaimCategoryEnum;
import kd.fi.cas.formplugin.mobile.recclaim.enums.ClaimStatusEnum;
import kd.fi.cas.formplugin.mobile.recclaim.enums.MergeStatusEnum;
import kd.fi.cas.formplugin.mobile.recclaim.helper.RecClaimHelper;
import kd.fi.cas.formplugin.mobile.recclaim.utils.RecClaimNoticeMobUtils;
import org.apache.commons.lang3.StringUtils;

public class RecClaimMobListFilterProvider {
    private static final String ID = "id";
    private static final String ALGO = "kd.fi.cas.formplugin.mobile.recclaim.RecClaimMobListFilterProvider";

    public static QFilter getClaimAnnounceFilter(boolean hasStatusFilter) {
        QFilter filter = RecClaimHelper.getAuthorityQfilter();
        filter = filter.and("mergestatus", "!=", (Object)MergeStatusEnum.MARFED.getValue());
        if (!hasStatusFilter) {
            filter = filter.and("claimstatus", "in", (Object)new String[]{"0", "1"});
        }
        return filter;
    }

    public static QFilter getClaimCenterFilter(String tabKey, boolean hasStatusFilter) {
        QFilter filter = new QFilter("mergestatus", "!=", (Object)MergeStatusEnum.MARFED.getValue());
        if (!hasStatusFilter) {
            filter = StringUtils.equals((CharSequence)tabKey, (CharSequence)"confirmed_page") ? filter.and("claimstatus", "=", (Object)ClaimStatusEnum.SURE.getValue()) : filter.and("claimstatus", "in", (Object)new String[]{"2", "4", "5"});
        }
        return filter;
    }

    public static QFilter getClaimBillDoingFilter() {
        QFilter userFilter = new QFilter("creator", "=", (Object)Long.valueOf(RequestContext.get().getUserId()));
        userFilter = userFilter.or(new QFilter("auditor", "=", (Object)Long.valueOf(RequestContext.get().getUserId())));
        QFilter statusFilter = new QFilter("billstatus", "in", (Object)new String[]{"A", "B"});
        QFilter auditFilter = new QFilter("billstatus", "=", (Object)"C");
        auditFilter = auditFilter.and("claimstatus", "in", (Object)new String[]{"1", "2", "4", "5"});
        statusFilter = statusFilter.or(auditFilter);
        return userFilter.and(statusFilter);
    }

    public static QFilter getClaimBillDoneFilter() {
        QFilter userFilter = new QFilter("creator", "=", (Object)Long.valueOf(RequestContext.get().getUserId()));
        userFilter = userFilter.or(new QFilter("auditor", "=", (Object)Long.valueOf(RequestContext.get().getUserId())));
        QFilter filter1 = new QFilter("billstatus", "=", (Object)"C").and("claimstatus", "=", (Object)"3");
        QFilter filter2 = new QFilter("billstatus", "=", (Object)"H");
        return userFilter.and(filter1.or(filter2));
    }

    public static QFilter getClaimNoticeCommonFilter(Boolean isDefaultStatus) {
        QFilter filter = RecClaimHelper.getAuthorityQfilter();
        DynamicObjectCollection notices = QueryServiceHelper.query((String)"cas_claimannounce", (String)"id,billno,reamount", (QFilter[])new QFilter[]{filter});
        DynamicObject[] distinctNotices = RecClaimNoticeMobUtils.distinctByPrimaryKey(notices).toArray(new DynamicObject[0]);
        List billnos = RecClaimNoticeMobUtils.screenNotices(distinctNotices).stream().map(dy -> dy.getString("billno")).collect(Collectors.toList());
        filter.and("billno", "in", billnos);
        filter = filter.and("mergestatus", "!=", (Object)MergeStatusEnum.MARFED.getValue());
        if (isDefaultStatus.booleanValue()) {
            filter = filter.and("claimstatus", "in", (Object)new String[]{"0", "1", "2"});
        }
        return filter;
    }

    /*
     * Unable to fully structure code
     */
    public static QFilter getClaimNoticeTabFilter(String tabKey) {
        filter = null;
        pkIds = new ArrayList<Long>();
        var3_3 = tabKey;
        var4_4 = -1;
        switch (var3_3.hashCode()) {
            case -758107894: {
                if (!var3_3.equals("undo_page")) break;
                var4_4 = 0;
                break;
            }
            case 163051575: {
                if (!var3_3.equals("pending_page")) break;
                var4_4 = 1;
                break;
            }
            case 1538453724: {
                if (!var3_3.equals("ignore_page")) break;
                var4_4 = 2;
            }
        }
        switch (var4_4) {
            case 0: {
                noticeIds = QueryServiceHelper.queryDataSet((String)"kd.fi.cas.formplugin.mobile.recclaim.RecClaimMobListFilterProvider", (String)"cas_claim_category", (String)"noticeid", (QFilter[])new QFilter[]{new QFilter("userid", "=", (Object)Long.valueOf(RequestContext.get().getUserId()))}, null);
                var6_8 = null;
                for (Row noticeid : noticeIds) {
                    pkIds.add(noticeid.getLong("noticeid"));
                }
                filter = new QFilter("id", "not in", pkIds);
                if (noticeIds == null) break;
                if (var6_8 == null) ** GOTO lbl35
                try {
                    noticeIds.close();
                }
                catch (Throwable var7_12) {
                    var6_8.addSuppressed(var7_12);
                }
                break;
lbl35:
                // 1 sources

                noticeIds.close();
                break;
                catch (Throwable var7_13) {
                    try {
                        var6_8 = var7_13;
                        throw var7_13;
                    }
                    catch (Throwable var9_23) {
                        if (noticeIds != null) {
                            if (var6_8 != null) {
                                try {
                                    noticeIds.close();
                                }
                                catch (Throwable var10_24) {
                                    var6_8.addSuppressed(var10_24);
                                }
                            } else {
                                noticeIds.close();
                            }
                        }
                        throw var9_23;
                    }
                }
            }
            case 1: {
                pendingIds = QueryServiceHelper.queryDataSet((String)"kd.fi.cas.formplugin.mobile.recclaim.RecClaimMobListFilterProvider", (String)"cas_claim_category", (String)"noticeid", (QFilter[])new QFilter[]{new QFilter("userid", "=", (Object)Long.valueOf(RequestContext.get().getUserId())).and("type", "=", (Object)ClaimCategoryEnum.PENDING_NOTICE.getCode())}, null);
                var6_9 = null;
                for (Row pendingId : pendingIds) {
                    pkIds.add(pendingId.getLong("noticeid"));
                }
                filter = new QFilter("id", "in", pkIds);
                if (pendingIds == null) break;
                if (var6_9 == null) ** GOTO lbl69
                try {
                    pendingIds.close();
                }
                catch (Throwable var7_15) {
                    var6_9.addSuppressed(var7_15);
                }
                break;
lbl69:
                // 1 sources

                pendingIds.close();
                break;
                catch (Throwable var7_16) {
                    try {
                        var6_9 = var7_16;
                        throw var7_16;
                    }
                    catch (Throwable var11_25) {
                        if (pendingIds != null) {
                            if (var6_9 != null) {
                                try {
                                    pendingIds.close();
                                }
                                catch (Throwable var12_26) {
                                    var6_9.addSuppressed(var12_26);
                                }
                            } else {
                                pendingIds.close();
                            }
                        }
                        throw var11_25;
                    }
                }
            }
            case 2: {
                ignoreIds = QueryServiceHelper.queryDataSet((String)"kd.fi.cas.formplugin.mobile.recclaim.RecClaimMobListFilterProvider", (String)"cas_claim_category", (String)"noticeid", (QFilter[])new QFilter[]{new QFilter("userid", "=", (Object)Long.valueOf(RequestContext.get().getUserId())).and("type", "=", (Object)ClaimCategoryEnum.IGNORE_BILL.getCode())}, null);
                var6_10 = null;
                for (Row ignoreId : ignoreIds) {
                    pkIds.add(ignoreId.getLong("noticeid"));
                }
                filter = new QFilter("id", "in", pkIds);
                if (ignoreIds == null) break;
                if (var6_10 == null) ** GOTO lbl103
                try {
                    ignoreIds.close();
                }
                catch (Throwable var7_18) {
                    var6_10.addSuppressed(var7_18);
                }
                break;
lbl103:
                // 1 sources

                ignoreIds.close();
                break;
                catch (Throwable var7_19) {
                    try {
                        var6_10 = var7_19;
                        throw var7_19;
                    }
                    catch (Throwable var13_27) {
                        if (ignoreIds != null) {
                            if (var6_10 != null) {
                                try {
                                    ignoreIds.close();
                                }
                                catch (Throwable var14_28) {
                                    var6_10.addSuppressed(var14_28);
                                }
                            } else {
                                ignoreIds.close();
                            }
                        }
                        throw var13_27;
                    }
                }
            }
            default: {
                filter = new QFilter("1", "=", (Object)1);
            }
        }
        return filter;
    }

    public static QFilter getClaimBillDraftFilter() {
        QFilter userFilter = new QFilter("creator", "=", (Object)Long.valueOf(RequestContext.get().getUserId()));
        userFilter = userFilter.or(new QFilter("auditor", "=", (Object)Long.valueOf(RequestContext.get().getUserId())));
        QFilter filter1 = new QFilter("billstatus", "=", (Object)"A").and("rejectreason", "=", (Object)" ");
        List claimBillIdLst = QueryServiceHelper.queryPrimaryKeys((String)"cas_claimbill", (QFilter[])new QFilter[]{filter1}, null, (int)-1);
        HashSet set = new HashSet(claimBillIdLst);
        Set<Long> arr = RecClaimNoticeMobUtils.getBillRejectedInWf(set);
        if (CollectionUtils.isEmpty(arr)) {
            return userFilter.and(filter1);
        }
        if (set.removeAll(arr)) {
            Long[] ids = new Long[set.size()];
            set.toArray(ids);
            QFilter draftFilter = new QFilter(ID, "in", (Object)ids);
            return userFilter.and(draftFilter);
        }
        return userFilter.and(filter1);
    }

    public static QFilter getClaimBillOngoingFilter() {
        QFilter userFilter = new QFilter("creator", "=", (Object)Long.valueOf(RequestContext.get().getUserId()));
        userFilter = userFilter.or(new QFilter("auditor", "=", (Object)Long.valueOf(RequestContext.get().getUserId())));
        QFilter filter1 = new QFilter("billstatus", "=", (Object)"B");
        QFilter filter2 = new QFilter("billstatus", "=", (Object)"C").and("claimstatus", "!=", (Object)"3");
        return userFilter.and(filter1.or(filter2));
    }

    public static QFilter getClaimBillRejectedFilter() {
        QFilter userFilter = new QFilter("creator", "=", (Object)Long.valueOf(RequestContext.get().getUserId()));
        userFilter = userFilter.or(new QFilter("auditor", "=", (Object)Long.valueOf(RequestContext.get().getUserId())));
        QFilter filter1 = new QFilter("rejectreason", "=", (Object)" ");
        QFilter filter2 = new QFilter("rejectreason", "!=", (Object)" ");
        QFilter filter3 = new QFilter("billstatus", "=", (Object)"A");
        List claimBillIds = QueryServiceHelper.queryPrimaryKeys((String)"cas_claimbill", (QFilter[])new QFilter[]{filter1.and(filter3)}, null, (int)-1);
        HashSet set = new HashSet(claimBillIds);
        Set<Long> arr = RecClaimNoticeMobUtils.getBillRejectedInWf(set);
        QFilter filter4 = new QFilter(ID, "in", arr);
        QFilter rejectedFilter = filter2.or(filter3.and(filter4));
        return userFilter.and(rejectedFilter);
    }

    public static QFilter getClaimBillConfirmedFilter() {
        QFilter userFilter = new QFilter("creator", "=", (Object)Long.valueOf(RequestContext.get().getUserId()));
        userFilter = userFilter.or(new QFilter("auditor", "=", (Object)Long.valueOf(RequestContext.get().getUserId())));
        QFilter filter1 = new QFilter("billstatus", "=", (Object)"C").and("claimstatus ", "=", (Object)"3");
        return userFilter.and(filter1);
    }
}

