/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.mobile.recclaim;

import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.container.Tab;
import kd.bos.form.container.TabPage;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.formplugin.mobile.recclaim.RecClaimMobListFilterProvider;
import kd.fi.cas.formplugin.mobile.recclaim.RecClaimPageJumpHandler;
import kd.fi.cas.formplugin.mobile.recclaim.utils.RecClaimNoticeMobUtils;

public class RecClaimNoticeMobPlugin
extends AbstractFormPlugin
implements TabSelectListener {
    public static final String UNDO_TAB = "undo_page";
    public static final String PENDING_TAB = "pending_page";
    public static final String IGNORE_TAB = "ignore_page";
    public static final String CACHE_PAGEID_PRE = "cas_claimnotice_m";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Tab tab = (Tab)this.getControl("tabap");
        if (tab != null) {
            tab.addTabSelectListener((TabSelectListener)this);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setTabBillCount();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        this.showList((String)formShowParameter.getCustomParam("listType"));
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        this.setTabBillCount();
        this.showList(tabSelectEvent.getTabKey());
    }

    private void showList(String tabKey) {
        String pageId = this.getPageCache().get(CACHE_PAGEID_PRE + tabKey);
        if (pageId != null) {
            IFormView targetView = this.getView().getView(pageId);
            targetView.invokeOperation("refresh");
            this.getView().sendFormAction(targetView);
        } else {
            RecClaimPageJumpHandler.noticeTabPageShowList(this, tabKey);
        }
    }

    private void setTabBillCount() {
        QFilter commonFilter = RecClaimMobListFilterProvider.getClaimNoticeCommonFilter(true);
        QFilter undoFilter = RecClaimMobListFilterProvider.getClaimNoticeTabFilter(UNDO_TAB).and(commonFilter);
        QFilter pendingFilter = RecClaimMobListFilterProvider.getClaimNoticeTabFilter(PENDING_TAB).and(commonFilter);
        QFilter ignoreFilter = RecClaimMobListFilterProvider.getClaimNoticeTabFilter(IGNORE_TAB).and(commonFilter);
        DynamicObjectCollection undos = QueryServiceHelper.query((String)"cas_claimannounce", (String)"id", (QFilter[])new QFilter[]{undoFilter});
        int undoCountWhichDistinctById = RecClaimNoticeMobUtils.distinctByPrimaryKey(undos).size();
        TabPage undoTabPage = (TabPage)this.getControl(UNDO_TAB);
        LocaleString undoLocaleString = new LocaleString(String.format(ResManager.loadKDString((String)"\u672a\u5904\u7406(%s)", (String)"RecClaimNoticeMobPlugin_0", (String)"fi-cas-mobile", (Object[])new Object[0]), undoCountWhichDistinctById > 100 ? "99+" : Integer.valueOf(undoCountWhichDistinctById)));
        undoTabPage.setText(undoLocaleString);
        DynamicObjectCollection pendings = QueryServiceHelper.query((String)"cas_claimannounce", (String)"id", (QFilter[])new QFilter[]{pendingFilter});
        int pendingCountWhichDistinctById = RecClaimNoticeMobUtils.distinctByPrimaryKey(pendings).size();
        TabPage pendingTabPage = (TabPage)this.getControl(PENDING_TAB);
        LocaleString pendingLocaleString = new LocaleString(String.format(ResManager.loadKDString((String)"\u7a0d\u540e\u5904\u7406(%s)", (String)"RecClaimNoticeMobPlugin_1", (String)"fi-cas-mobile", (Object[])new Object[0]), pendingCountWhichDistinctById > 100 ? "99+" : Integer.valueOf(pendingCountWhichDistinctById)));
        pendingTabPage.setText(pendingLocaleString);
        DynamicObjectCollection ignores = QueryServiceHelper.query((String)"cas_claimannounce", (String)"id", (QFilter[])new QFilter[]{ignoreFilter});
        int ignoreCountWhichDistinctById = RecClaimNoticeMobUtils.distinctByPrimaryKey(ignores).size();
        TabPage ignoreTabPage = (TabPage)this.getControl(IGNORE_TAB);
        LocaleString ignoreLocaleString = new LocaleString(String.format(ResManager.loadKDString((String)"\u6211\u5df2\u5ffd\u7565(%s)", (String)"RecClaimNoticeMobPlugin_2", (String)"fi-cas-mobile", (Object[])new Object[0]), ignoreCountWhichDistinctById > 100 ? "99+" : Integer.valueOf(ignoreCountWhichDistinctById)));
        ignoreTabPage.setText(ignoreLocaleString);
    }
}

