/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.mobile.recclaim;

import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.formplugin.mobile.recclaim.M;
import kd.fi.cas.formplugin.mobile.recclaim.utils.EmptyUtil;

public class RejectClaimMobFormPlugin
extends AbstractMobFormPlugin
implements RowClickEventListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        ((EntryGrid)this.getControl("entryentity")).addRowClickListener((RowClickEventListener)this);
        this.addClickListeners(new String[]{"cancel", "confirm"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Object rejectData = this.getView().getFormShowParameter().getCustomParam("rejectData");
        if (rejectData != null) {
            List data = (List)SerializationUtils.fromJsonString((String)String.valueOf(rejectData), List.class);
            Set billNos = data.stream().map(v -> v.get(0)).collect(Collectors.toSet());
            DynamicObjectCollection bills = QueryServiceHelper.query((String)"cas_claimbill", (String)"billno, claimtype", (QFilter[])new QFilter("billno", "in", billNos).toArray());
            HashSet<String> forDistinct = new HashSet<String>(data.size());
            IDataModel model = this.getModel();
            DynamicObjectCollection entryEntity = model.getEntryEntity("entryentity");
            model.beginInit();
            block0: for (List row : data) {
                String billno = (String)row.get(0);
                String claimperson = (String)row.get(1);
                String checkDup = billno + "," + claimperson;
                if (forDistinct.contains(checkDup)) continue;
                forDistinct.add(checkDup);
                DynamicObject entry = entryEntity.addNew();
                entry.set("claimbillno", (Object)billno);
                entry.set("claimperson", (Object)claimperson);
                for (DynamicObject bill : bills) {
                    if (!bill.getString("billno").equals(billno)) continue;
                    entry.set("claimtype", bill.get("claimtype"));
                    continue block0;
                }
            }
            model.endInit();
            this.getView().updateView("entryentity");
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        super.entryRowClick(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("entryentity".equals(key)) {
            EntryGrid grid = (EntryGrid)this.getControl("entryentity");
            int[] selectRows = grid.getSelectRows();
            ((Label)this.getControl("labelcount")).setText(String.format(ResManager.loadKDString((String)"\u5df2\u9009%s\u6761", (String)"RejectClaimMobFormPlugin_0", (String)"fi-cas-mobile", (Object[])new Object[0]), selectRows.length));
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("cancel".equals(key)) {
            this.getView().close();
        } else if ("confirm".equals(key)) {
            this.confirm();
        }
    }

    private void confirm() {
        IDataModel model = this.getModel();
        EntryGrid grid = (EntryGrid)this.getControl("entryentity");
        int[] selectRows = grid.getSelectRows();
        HashSet<String> billNos = new HashSet<String>(selectRows.length);
        for (int selectRow : selectRows) {
            billNos.add((String)model.getValue("claimbillno", selectRow));
        }
        Object rejectReason = model.getValue("rejectreason");
        if (billNos.isEmpty()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u9a73\u56de\u7684\u8ba4\u9886\u5355\u3002", (String)"RejectClaimMobFormPlugin_1", (String)"fi-cas-mobile", (Object[])new Object[0]));
            return;
        }
        if (EmptyUtil.isEmpty(rejectReason)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u9a73\u56de\u539f\u56e0\u3002", (String)"RejectClaimMobFormPlugin_3", (String)"fi-cas-mobile", (Object[])new Object[0]));
            return;
        }
        HashMap<String, Object> returnData = new HashMap<String, Object>();
        returnData.put("rejectbill", M.join(billNos, ","));
        returnData.put("rejectreason", rejectReason);
        this.getView().returnDataToParent(returnData);
        this.getView().close();
    }
}

