/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.mobile.recclaim.external;

import java.util.EventObject;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.BasedataProp;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.list.MobileSearch;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class ClaimSalContractBillFromPlugin
extends AbstractMobBillPlugIn {
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.loadEntryEntity(null);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"buttonap"});
        MobileSearch mobileSearch = (MobileSearch)this.getControl("mobilesearchap");
        mobileSearch.addMobileSearchTextChangeListener(evt -> {
            String searchText = evt.getText();
            this.loadEntryEntity(searchText);
        });
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (StringUtils.equals((CharSequence)"buttonap", (CharSequence)key)) {
            EntryGrid entryGrid = (EntryGrid)this.getControl("billentry");
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("billentry");
            int selectRow = entryGrid.getSelectRows()[0];
            DynamicObject selectRowDy = (DynamicObject)entryEntity.get(selectRow);
            String selectFields = "billentry.id entryid,billentry.seq entryseq";
            QFilter entryIdFilter = new QFilter("billentry.id", "=", selectRowDy.get("id"));
            DynamicObject salOrderDy = QueryServiceHelper.queryOne((String)"conm_salcontract", (String)selectFields, (QFilter[])new QFilter[]{entryIdFilter});
            this.getView().returnDataToParent((Object)salOrderDy);
            this.getView().close();
        }
    }

    private void loadEntryEntity(String searchText) {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        model.deleteEntryData("billentry");
        this.loadDataFp();
        Object orgId = view.getFormShowParameter().getCustomParam("org");
        Object id = model.getValue("id");
        if (id == null) {
            this.loadNoDataFp();
            return;
        }
        String selectFields = "id,billentry.id,billentry.material,billentry.unit,billentry.material.masterid.name,billentry.material.masterid.modelnum,billentry.priceandtax,billentry.qty,billentry.amountandtax";
        QFilter idFilter = new QFilter("id", "=", id);
        QFilter orgFilter = new QFilter("billentry.entrysettleorg", "=", orgId);
        QFilter searchFilter = new QFilter("billentry.material.masterid.name", "like", (Object)("%" + searchText + "%")).or("billentry.material.masterid.modelnum", "like", (Object)("%" + searchText + "%"));
        QFilter[] qFilters = StringUtils.isEmpty((CharSequence)searchText) ? new QFilter[]{idFilter, orgFilter} : new QFilter[]{idFilter, orgFilter, searchFilter};
        DynamicObjectCollection salContractDyCol = QueryServiceHelper.query((String)"conm_salcontract", (String)selectFields, (QFilter[])qFilters);
        if (salContractDyCol.isEmpty()) {
            this.loadNoDataFp();
            return;
        }
        int size = salContractDyCol.size();
        model.beginInit();
        model.batchCreateNewEntryRow("billentry", size);
        DynamicObjectCollection billEntryEntity = model.getEntryEntity("billentry");
        BasedataProp materialData = (BasedataProp)billEntryEntity.getDynamicObjectType().getProperty("material");
        BasedataProp unitData = (BasedataProp)billEntryEntity.getDynamicObjectType().getProperty("unit");
        DynamicProperty idData = billEntryEntity.getDynamicObjectType().getProperty("id");
        DynamicProperty nameData = billEntryEntity.getDynamicObjectType().getProperty("materialname");
        DynamicProperty priceData = billEntryEntity.getDynamicObjectType().getProperty("priceandtax");
        DynamicProperty atyData = billEntryEntity.getDynamicObjectType().getProperty("qty");
        DynamicProperty amountData = billEntryEntity.getDynamicObjectType().getProperty("amountandtax");
        for (int i = 0; i < size; ++i) {
            DynamicObject billDy = (DynamicObject)salContractDyCol.get(i);
            DynamicObject entryDy = (DynamicObject)billEntryEntity.get(i);
            materialData.setFieldValue(model, (Object)entryDy, billDy.get("billentry.material"));
            unitData.setFieldValue(model, (Object)entryDy, billDy.get("billentry.unit"));
            idData.setValueFast((Object)entryDy, billDy.get("billentry.id"));
            nameData.setValueFast((Object)entryDy, billDy.get("billentry.material.masterid.name"));
            priceData.setValueFast((Object)entryDy, billDy.get("billentry.priceandtax"));
            atyData.setValueFast((Object)entryDy, billDy.get("billentry.qty"));
            amountData.setValueFast((Object)entryDy, billDy.get("billentry.amountandtax"));
        }
        model.endInit();
        this.getView().updateView("billentry");
    }

    private void loadDataFp() {
        this.getView().setVisible(Boolean.TRUE, new String[]{"billentry"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"defaultpicturefp"});
    }

    private void loadNoDataFp() {
        this.getView().setVisible(Boolean.FALSE, new String[]{"billentry"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"defaultpicturefp"});
    }
}

