/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.mobile.recclaim.helper;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.cas.formplugin.mobile.recclaim.enums.ClaimAuthorityEnum;
import kd.fi.cas.formplugin.mobile.recclaim.utils.CasToolKit;

public class RecClaimHelper {
    public static final String VIEW = "47150e89000000ac";
    public static final String ADDNEW = "47156aff000000ac";
    public static final String EDIT = "4715a0df000000ac";

    public static List<DynamicObject> getAllChildNoticeBill(Object noticePk) {
        ArrayList<DynamicObject> childNoticeSet = new ArrayList<DynamicObject>();
        if (StringUtils.isNotBlank((Object)noticePk)) {
            DynamicObject loadSingle = BusinessDataServiceHelper.loadSingle((Object)noticePk, (String)"cas_claimcenterbill");
            List<Object> childNotices = RecClaimHelper.getChildNoticeBill(loadSingle.getPkValue());
            if (childNotices.size() > 0) {
                for (Object noticeId : childNotices) {
                    childNoticeSet.addAll(RecClaimHelper.getAllChildNoticeBill(noticeId));
                }
            } else {
                childNoticeSet.add(loadSingle);
            }
        }
        return childNoticeSet;
    }

    public static List<Object> getChildNoticeBill(Object noticePk) {
        QFilter margeid = new QFilter("margeid", "=", noticePk);
        return QueryServiceHelper.queryPrimaryKeys((String)"cas_claimcenterbill", (QFilter[])new QFilter[]{margeid}, null, (int)-1);
    }

    public static QFilter getAuthorityQfilter() {
        Map userGroups;
        String userId = RequestContext.get().getUserId();
        QFilter filter = new QFilter("entryentity1.claimtypeid", "=", (Object)userId).and("entryentity1.claimtype", "=", (Object)ClaimAuthorityEnum.USER.getValue());
        Boolean isAllPeritem = RecClaimHelper.getCacheUserPermission(Long.parseLong(userId), "", "cas_claimannounce", VIEW);
        if (!isAllPeritem.booleanValue()) {
            List orgs = PermissionServiceHelper.getUserOrgs((long)Long.parseLong(userId));
            QFilter orgFilter = null;
            if (orgs != null) {
                ArrayList userOrgs = new ArrayList();
                orgs.forEach(org -> {
                    if (!CasToolKit.isEmpty(org)) {
                        userOrgs.add(String.valueOf(org));
                    }
                });
                if (userOrgs.size() > 0) {
                    orgFilter = new QFilter("entryentity1.claimtypeid", "in", userOrgs).and("entryentity1.claimtype", "=", (Object)ClaimAuthorityEnum.USERORG.getValue());
                    filter = filter.or(orgFilter);
                }
            }
        } else {
            filter = filter.or(new QFilter("entryentity1.claimtype", "=", (Object)ClaimAuthorityEnum.USERORG.getValue()));
        }
        Set rolesByUsers = PermissionServiceHelper.getRolesByUser((Long)Long.parseLong(userId));
        if (rolesByUsers.size() > 0) {
            QFilter roleFilter = new QFilter("entryentity1.claimtypeid", "in", (Object)rolesByUsers).and("entryentity1.claimtype", "=", (Object)ClaimAuthorityEnum.ROLER.getValue());
            filter = filter.or(roleFilter);
        }
        if ((userGroups = BusinessDataServiceHelper.loadFromCache((String)"fbd_usergroup", (String)"id", (QFilter[])new QFilter[]{new QFilter("entryentity.userfield", "=", (Object)Long.parseLong(userId)).and("enable", "=", (Object)"1")})) != null && userGroups.size() > 0) {
            List idStrList = userGroups.keySet().stream().map(s -> s.toString()).collect(Collectors.toList());
            QFilter groupFilter = new QFilter("entryentity1.claimtypeid", "in", idStrList).and("entryentity1.claimtype", "=", (Object)ClaimAuthorityEnum.USERGROUP.getValue());
            filter = filter.or(groupFilter);
        }
        return filter;
    }

    public static Boolean getCacheUserPermission(Long userId, String appId, String entityId, String permItem) {
        IAppCache cache = AppCache.get((String)"cas..TmcOrgDataHelper");
        String key = userId + "-" + entityId + "-" + permItem;
        cache.remove(key);
        String value = (String)cache.get(key, String.class);
        if (CasToolKit.isEmpty(value)) {
            HasPermOrgResult result;
            if (CasToolKit.isNotEmpty(appId)) {
                appId = AppMetadataCache.getAppInfo((String)appId).getId();
            }
            if ((result = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)appId, (String)entityId, (String)permItem)).hasAllOrgPerm()) {
                return true;
            }
        }
        return false;
    }
}

