/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.mobile.recclaim.openapi;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.url.UrlService;
import kd.fi.cas.formplugin.mobile.recclaim.RecClaimMobListFilterProvider;
import kd.fi.cas.formplugin.mobile.recclaim.utils.RecClaimNoticeMobUtils;
import kd.kuep.capp.model.card.DataPanelCard;
import kd.kuep.capp.sdk.DataPanelCardProxy;
import org.apache.commons.lang3.StringUtils;

public class RecClaimAnnouncePlugin
implements IBillWebApiPlugin {
    public static final Log logger = LogFactory.getLog(RecClaimAnnouncePlugin.class);
    private static final String SAVE_BILL_WITH_WORKFLOW = "saveBillWithWorkFlow";

    public ApiResult doCustomService(Map<String, Object> params) {
        logger.info("RecClaimAnnouncePlugin request parameters\uff1a" + params);
        ApiResult result = new ApiResult();
        result.setSuccess(true);
        try {
            HashMap<String, List<DynamicObject>> dataCacheMap = new HashMap<String, List<DynamicObject>>();
            this.addSaveBillWithWorkFlow(dataCacheMap);
            int unDoNum = this.handleUnDoNum(dataCacheMap);
            logger.info("the status of undo:" + unDoNum);
            DynamicObjectCollection doings = QueryServiceHelper.query((String)"cas_claimbill", (String)"id", (QFilter[])new QFilter[]{RecClaimMobListFilterProvider.getClaimBillOngoingFilter()});
            logger.info("the status of doing:" + doings.size());
            List<DynamicObject> rejectList = this.screenRejectBills(dataCacheMap);
            logger.info("the status of rejected:" + rejectList.size());
            DataPanelCardProxy dataPanelCardProxy = new DataPanelCardProxy();
            DataPanelCard dataPanelCard = dataPanelCardProxy.getDataPanelCard();
            String linkUrl = UrlService.getDomainContextUrl() + "/mobile.html#/form/";
            String unDoLinkUrl = linkUrl + "cas_claimnotice_m";
            String doingsLinkUrl = linkUrl + "cas_mine_claim?pagetype=3";
            String rejectLinkUrl = linkUrl + "cas_mine_claim?pagetype=2";
            logger.info(String.format("unDoLinkUrl:%s ,doingsLinkUrl:%s ,rejectLinkUrl:%s", unDoLinkUrl, doingsLinkUrl, rejectLinkUrl));
            dataPanelCard.setCardTitle(ResManager.loadKDString((String)"\u6536\u6b3e\u8ba4\u9886\u901a\u77e5", (String)"RecClaimAnnouncePlugin_0", (String)"fi-cas-mobile", (Object[])new Object[0]));
            dataPanelCardProxy.addDataList(ResManager.loadKDString((String)"\u5f85\u5904\u7406", (String)"RecClaimAnnouncePlugin_1", (String)"fi-cas-mobile", (Object[])new Object[0]), unDoNum + "", null, null, null, unDoLinkUrl, null, null);
            dataPanelCardProxy.addDataList(ResManager.loadKDString((String)"\u8ba4\u9886\u4e2d", (String)"RecClaimAnnouncePlugin_2", (String)"fi-cas-mobile", (Object[])new Object[0]), doings.size() + "", null, null, null, doingsLinkUrl, null, null);
            dataPanelCardProxy.addDataList(ResManager.loadKDString((String)"\u88ab\u9a73\u56de", (String)"RecClaimAnnouncePlugin_3", (String)"fi-cas-mobile", (Object[])new Object[0]), rejectList.size() + "", null, null, null, rejectLinkUrl, null, null);
            result.setData((Object)dataPanelCard);
        }
        catch (Exception exception) {
            logger.error("RecClaimAnnouncePlugin handle failed ", (Throwable)exception);
            result.setErrorCode("1000");
            result.setMessage("data parsing failed");
        }
        return result;
    }

    private List<DynamicObject> screenRejectBills(Map<String, List<DynamicObject>> dataCacheMap) {
        QFilter userFilter = new QFilter("creator", "=", (Object)RequestContext.get().getCurrUserId()).or("auditor", "=", (Object)RequestContext.get().getCurrUserId());
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"cas_claimbill", (String)"id,billstatus,rejectreason", (QFilter[])new QFilter[]{userFilter});
        List saveBillWithWorkFlowIds = dataCacheMap.get(SAVE_BILL_WITH_WORKFLOW).stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
        return dynamicObjects.stream().filter(dy -> {
            Boolean rejectNotEmpty = StringUtils.isNotBlank((CharSequence)dy.getString("rejectreason"));
            Boolean saveAndIsRecorded = StringUtils.equals((CharSequence)"A", (CharSequence)dy.getString("billstatus")) && saveBillWithWorkFlowIds.contains(dy.getLong("id"));
            return rejectNotEmpty != false || saveAndIsRecorded != false;
        }).collect(Collectors.toList());
    }

    public int handleUnDoNum(Map<String, List<DynamicObject>> dataCacheMap) {
        QFilter commonFilter = RecClaimMobListFilterProvider.getClaimNoticeCommonFilter(true);
        QFilter undoFilter = RecClaimMobListFilterProvider.getClaimNoticeTabFilter("undo_page").and(commonFilter);
        QFilter pendingFilter = RecClaimMobListFilterProvider.getClaimNoticeTabFilter("pending_page").and(commonFilter);
        QFilter ignoreFilter = RecClaimMobListFilterProvider.getClaimNoticeTabFilter("ignore_page").and(commonFilter);
        Map undos = BusinessDataServiceHelper.loadFromCache((String)"cas_claimannounce", (String)"id", (QFilter[])new QFilter[]{undoFilter});
        Map pendings = BusinessDataServiceHelper.loadFromCache((String)"cas_claimannounce", (String)"id", (QFilter[])new QFilter[]{pendingFilter});
        Map ignores = BusinessDataServiceHelper.loadFromCache((String)"cas_claimannounce", (String)"id", (QFilter[])new QFilter[]{ignoreFilter});
        return undos.size() + pendings.size() + ignores.size();
    }

    private void addSaveBillWithWorkFlow(Map<String, List<DynamicObject>> dataCacheMap) {
        QFilter userFilter = new QFilter("creator", "=", (Object)RequestContext.get().getCurrUserId()).or("auditor", "=", (Object)RequestContext.get().getCurrUserId());
        QFilter filter = userFilter.and("billstatus", "=", (Object)"A");
        Set drafts = QueryServiceHelper.query((String)"cas_claimbill", (String)"id", (QFilter[])new QFilter[]{filter}).stream().map(v -> v.getLong("id")).collect(Collectors.toSet());
        List billsInWorkFlow = RecClaimNoticeMobUtils.getBillRejectedInWf(drafts).stream().map(id -> {
            DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cas_claimannounce"));
            dynamicObject.set("id", id);
            return dynamicObject;
        }).collect(Collectors.toList());
        dataCacheMap.put(SAVE_BILL_WITH_WORKFLOW, billsInWorkFlow);
    }
}

