/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.mobile.recclaim.temp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kd.bos.bill.MobileBillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.botp.ConvertRuleCache;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.botp.runtime.AbstractConvertServiceArgs;
import kd.bos.entity.botp.runtime.ConvertOpRule;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.botp.Push;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.fi.cas.formplugin.mobile.recclaim.enums.ClaimTypeEnum;

public class TempPush {
    public void pushClaimBill(AbstractFormPlugin plugin, List selectedRows, BeforeDoOperationEventArgs args) {
        this.push(plugin, selectedRows, args, "cas_claimbill_m");
    }

    public void push(AbstractFormPlugin plugin, List selectedRows, BeforeDoOperationEventArgs args, String targetUINumber) {
        Push push = (Push)args.getSource();
        Map parameter = push.getParameter();
        String sourceEntityNumber = push.getEntityId();
        String targetEntityNumber = (String)parameter.get("targetbill");
        PushArgs pushArgs = new PushArgs();
        pushArgs.setAppId("cas");
        pushArgs.setSourceEntityNumber(sourceEntityNumber);
        pushArgs.setTargetEntityNumber(targetEntityNumber);
        pushArgs.setAutoSave(true);
        List<ConvertOpRule> opRules = this.getOpRules(sourceEntityNumber, targetEntityNumber);
        for (ConvertOpRule rule : opRules) {
            pushArgs.getRuleIds().add(rule.getRuleId());
        }
        String ruleid = (String)parameter.get("ruleid");
        if (!StringUtils.isEmpty((CharSequence)ruleid) && !"@all".equals(ruleid)) {
            pushArgs.setRuleId(ruleid);
        }
        IFormView view = plugin.getView();
        pushArgs.setSelectedRows(selectedRows);
        pushArgs.setBuildConvReport(true);
        pushArgs.addCustomParam("pushByBill", String.valueOf(true));
        ConvertOperationResult convertResult = ConvertServiceHelper.push((PushArgs)pushArgs);
        if (!convertResult.isSuccess() || convertResult.getCachePageIds().size() == 0) {
            Push.showReport((IFormView)view, (AbstractConvertServiceArgs)pushArgs, (ConvertOperationResult)convertResult);
        } else if (convertResult.getCachePageIds().size() == 1) {
            MobileBillShowParameter showParameter = new MobileBillShowParameter();
            showParameter.setFormId(targetUINumber);
            showParameter.getOpenStyle().setShowType(ShowType.Floating);
            if (convertResult.getTargetBillIds().isEmpty()) {
                showParameter.setStatus(OperationStatus.ADDNEW);
                showParameter.setCachePageId((String)convertResult.getCachePageIds().get(0));
            } else {
                showParameter.setStatus(OperationStatus.EDIT);
                showParameter.setPkId(convertResult.getTargetBillIds().iterator().next());
            }
            showParameter.setHasRight(true);
            showParameter.addCustPlugin("kd.bos.form.plugin.botp.ConvertTrackerEdit");
            showParameter.getCustomParams().put("showreport", String.valueOf(false));
            if (Arrays.asList("undo_page", "pending_page", "ignore_page").contains((String)plugin.getView().getFormShowParameter().getCustomParam("listType"))) {
                showParameter.setCustomParam("from", (Object)"indexTab");
            }
            switch (push.getOperateKey()) {
                case "claim": {
                    showParameter.setCustomParam("claimType", (Object)ClaimTypeEnum.CLAIM.getValue());
                    break;
                }
                case "appeal": {
                    showParameter.setCustomParam("claimType", (Object)ClaimTypeEnum.APPEAL.getValue());
                }
            }
            String resultJson = SerializationUtils.toJsonString((Object)convertResult);
            IPageCache pageCache = (IPageCache)view.getService(IPageCache.class);
            pageCache.put("ConvertOperationResult", resultJson);
            view.showForm((FormShowParameter)showParameter);
        } else {
            view.showTipNotification(ResManager.loadKDString((String)"\u79fb\u52a8\u7aef\u4e0d\u652f\u6301\u4e00\u6b21\u4e0b\u63a8\u751f\u6210\u591a\u5f20\u76ee\u6807\u5355\uff0c\u8bf7\u5230PC\u7aef\u64cd\u4f5c\u3002", (String)"TempPush_0", (String)"bos-form-business", (Object[])new Object[0]));
        }
    }

    private List<ConvertOpRule> getOpRules(String sourceEntityNumber, String targetEntityNumber) {
        ArrayList<ConvertRuleElement> rules = ConvertRuleCache.loadRules((String)sourceEntityNumber, (String)targetEntityNumber);
        ArrayList<ConvertRuleElement> enableRules = new ArrayList<ConvertRuleElement>();
        for (ConvertRuleElement rule : rules) {
            if (!rule.isEnabled()) continue;
            enableRules.add(rule);
        }
        rules = enableRules;
        ArrayList<ConvertOpRule> opRules = new ArrayList<ConvertOpRule>(10);
        if (rules.isEmpty()) {
            return opRules;
        }
        for (ConvertRuleElement rule : rules) {
            if (!rule.isEnabled()) continue;
            ConvertOpRule opRule = new ConvertOpRule(rule.getId(), rule.getName().toString());
            opRule.setVisibled(rule.isVisibled());
            opRules.add(opRule);
        }
        return opRules;
    }
}

