/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.mobile.recclaim.utils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.form.IFormView;
import kd.bos.form.container.TabPage;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.cas.formplugin.mobile.recclaim.RecClaimMobListFilterProvider;
import kd.fi.cas.formplugin.mobile.recclaim.RecClaimPageJumpHandler;
import kd.fi.cas.formplugin.mobile.recclaim.constant.SubscriptEnum;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class RecClaimNoticeMobUtils {
    public static List<DynamicObject> screenNotices(DynamicObject[] dynamicObjects) {
        QFilter[] filters = new QFilter[]{new QFilter("claimno", "in", Stream.of(dynamicObjects).map(o -> o.getString("billno")).collect(Collectors.toList())), new QFilter("creator", "=", (Object)Long.parseLong(RequestContext.get().getUserId()))};
        DynamicObjectCollection bills = QueryServiceHelper.query((String)"cas_claimbill", (String)"claimno,entryentity.e_receivableamt", (QFilter[])filters);
        Map<String, List<DynamicObject>> claimBillGroup = bills.stream().collect(Collectors.groupingBy(v -> v.getString("claimno")));
        ArrayList<DynamicObject> billList = new ArrayList<DynamicObject>();
        for (DynamicObject dynamicObject : dynamicObjects) {
            List<DynamicObject> claimBillList = claimBillGroup.get(dynamicObject.getString("billno"));
            BigDecimal myBillReamount = BigDecimal.ZERO;
            if (claimBillList != null) {
                for (DynamicObject claimBill : claimBillList) {
                    myBillReamount = myBillReamount.add(claimBill.getBigDecimal("entryentity.e_receivableamt"));
                }
            }
            if (myBillReamount.compareTo(dynamicObject.getBigDecimal("reamount")) >= 0) continue;
            billList.add(dynamicObject);
        }
        return billList;
    }

    public static void saveLastestClaimRecord() {
        Object subscriptRecordsOfClaimNotice;
        QFilter commonFilter = RecClaimMobListFilterProvider.getClaimNoticeCommonFilter(true);
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"cas_claimannounce", (String)"id,billno,reamount,entryentity1,entryentity1.claimtype,entryentity1.claimtypeid", (QFilter[])new QFilter[]{commonFilter}, null);
        Object[] subscriptRecordsOfClaimNotices = BusinessDataServiceHelper.load((String)"cas_claim_subscriptcache", (String)"id,userid,lastestid,type", (QFilter[])new QFilter[]{new QFilter("userid", "=", (Object)Long.valueOf(RequestContext.get().getUserId())).and("type", "=", (Object)SubscriptEnum.UNDO_NOTICE.getCode())}, (String)"id desc", (int)1);
        if (ArrayUtils.isNotEmpty((Object[])subscriptRecordsOfClaimNotices)) {
            subscriptRecordsOfClaimNotice = subscriptRecordsOfClaimNotices[0];
            subscriptRecordsOfClaimNotice.set("lastestid", (Object)RecClaimNoticeMobUtils.getMaxNoticeId(Arrays.asList(dynamicObjects)));
        } else {
            subscriptRecordsOfClaimNotice = BusinessDataServiceHelper.newDynamicObject((String)"cas_claim_subscriptcache");
            subscriptRecordsOfClaimNotice.set("userid", (Object)Long.valueOf(RequestContext.get().getUserId()));
            subscriptRecordsOfClaimNotice.set("lastestid", (Object)RecClaimNoticeMobUtils.getMaxNoticeId(Arrays.asList(dynamicObjects)));
            subscriptRecordsOfClaimNotice.set("type", (Object)SubscriptEnum.UNDO_NOTICE.getCode());
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{subscriptRecordsOfClaimNotice});
    }

    public static Long getMaxNoticeId(List<DynamicObject> dynamicObjects) {
        ArrayList<Long> ids = new ArrayList<Long>();
        for (DynamicObject dynamicObject : dynamicObjects) {
            DynamicObjectCollection entryentity1 = dynamicObject.getDynamicObjectCollection("entryentity1");
            for (DynamicObject object : entryentity1) {
                long claimtype = object.getLong("claimtype");
                if (claimtype == 1L && object.getLong("claimtypeid") != Long.parseLong(RequestContext.get().getUserId())) continue;
                ids.add(object.getLong("id"));
            }
        }
        return ids.stream().mapToLong(Long::valueOf).max().orElse(0L);
    }

    public static Set<Long> getBillRejectedInWf(Set<?> billIds) {
        HashSet<Long> idsSet = new HashSet<Long>();
        if (CollectionUtils.isEmpty(billIds)) {
            return idsSet;
        }
        String idStr = "'" + billIds.stream().map(Object::toString).collect(Collectors.joining("','")) + "'";
        String sql = "select FBUSINESSKEY,FPROCINSTID from t_wf_hiprocinst where FBUSINESSKEY in (%s) order by FBUSINESSKEY, fcreatedate asc";
        sql = String.format(sql, idStr);
        HashMap<String, Long> procInstMap = new HashMap<String, Long>();
        try (DataSet ds = DB.queryDataSet((String)"sss", (DBRoute)DBRoute.workflow, (String)sql);){
            for (Row row : ds) {
                procInstMap.put(row.getString("FBUSINESSKEY"), row.getLong("FPROCINSTID"));
            }
        }
        if (CollectionUtils.isEmpty(procInstMap)) {
            return idsSet;
        }
        sql = "select FBUSINESSKEY from T_WF_HICOMMENT where fprocinstid in (%s)";
        idStr = procInstMap.values().stream().map(Object::toString).collect(Collectors.joining(","));
        sql = String.format(sql, idStr);
        ds = DB.queryDataSet((String)"sss", (DBRoute)DBRoute.workflow, (String)sql);
        var6_6 = null;
        try {
            for (Row row : ds) {
                idsSet.add(Long.parseLong(row.getString("FBUSINESSKEY")));
            }
        }
        catch (Throwable throwable) {
            var6_6 = throwable;
            throw throwable;
        }
        finally {
            if (ds != null) {
                if (var6_6 != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable) {
                        var6_6.addSuppressed(throwable);
                    }
                } else {
                    ds.close();
                }
            }
        }
        return idsSet;
    }

    public static void refreshTargetParentPage(IFormView sourceView, String targetId) {
        IFormView targetView = RecClaimNoticeMobUtils.getTargetPageView(sourceView, targetId);
        if (targetView == null) {
            return;
        }
        targetView.invokeOperation("refresh");
        sourceView.sendFormAction(targetView);
    }

    private static IFormView getTargetPageView(IFormView view, String targetId) {
        if (StringUtils.isEmpty((CharSequence)targetId)) {
            return null;
        }
        for (IFormView targetView = view; targetView != null; targetView = targetView.getParentView()) {
            if (!StringUtils.equals((CharSequence)targetId, (CharSequence)targetView.getEntityId())) continue;
            return targetView;
        }
        return null;
    }

    public static void refreshTab(IFormView sourceView, String targetId, List<String> noticeTabList) {
        IFormView tabView = RecClaimNoticeMobUtils.getTargetPageView(sourceView, targetId);
        if (tabView == null) {
            return;
        }
        IFormView noticeListView = RecClaimNoticeMobUtils.getTargetPageView(sourceView, "cas_claimanno_moblist");
        if (noticeListView == null || !RecClaimNoticeMobUtils.isFromNoticeTabPage(noticeListView)) {
            return;
        }
        for (String tabKey : noticeTabList) {
            String tabDesc = RecClaimNoticeMobUtils.getTabDescByTabKey(tabKey);
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"cas_claimannounce", (String)"id", (QFilter[])new QFilter[]{RecClaimNoticeMobUtils.getQFilter(noticeListView, tabKey)});
            TabPage tabPage = (TabPage)tabView.getControl(tabKey);
            if (tabPage == null) continue;
            LocaleString lString = new LocaleString(tabDesc + '(' + (RecClaimNoticeMobUtils.distinctByPrimaryKey(dynamicObjects).size() >= 100 ? "99+" : Integer.valueOf(RecClaimNoticeMobUtils.distinctByPrimaryKey(dynamicObjects).size())) + ')');
            tabPage.setText(lString);
            tabView.updateView(tabKey);
            sourceView.sendFormAction(tabView);
        }
    }

    public static QFilter getQFilter(IFormView view, String tabKey) {
        QFilter filter;
        String statusFilterStr = view.getPageCache().get("pageCache_announceStatusFilter");
        if (RecClaimNoticeMobUtils.isFromNoticeTabPage(view)) {
            if (!StringUtils.isEmpty((CharSequence)statusFilterStr)) {
                QFilter commonFilter = RecClaimMobListFilterProvider.getClaimNoticeCommonFilter(false);
                QFilter filter2 = commonFilter.and(RecClaimMobListFilterProvider.getClaimNoticeTabFilter(tabKey));
                filter2 = filter2.and("claimstatus", "in", (Object)statusFilterStr.split(","));
                return filter2;
            }
            QFilter commonFilter = RecClaimMobListFilterProvider.getClaimNoticeCommonFilter(true);
            filter = commonFilter.and(RecClaimMobListFilterProvider.getClaimNoticeTabFilter(tabKey));
        } else {
            if (!StringUtils.isEmpty((CharSequence)statusFilterStr)) {
                QFilter filter3 = RecClaimMobListFilterProvider.getClaimAnnounceFilter(true);
                filter3 = filter3.and("claimstatus", "in", (Object)statusFilterStr.split(","));
                return filter3;
            }
            filter = RecClaimMobListFilterProvider.getClaimAnnounceFilter(false);
        }
        return filter;
    }

    public static QFilter getClaimCenterQFilter(IFormView view, String tabKey) {
        QFilter filter;
        String statusFilterStr = view.getPageCache().get("pageCache_announceStatusFilter");
        if (!StringUtils.isEmpty((CharSequence)statusFilterStr)) {
            filter = RecClaimMobListFilterProvider.getClaimCenterFilter(tabKey, true);
            filter = filter.and("claimstatus", "in", (Object)statusFilterStr.split(","));
        } else {
            filter = RecClaimMobListFilterProvider.getClaimCenterFilter(tabKey, false);
        }
        String appId = view.getFormShowParameter().getAppId();
        HasPermOrgResult permResult = PermissionServiceHelper.getAllPermOrgs((Long)Long.parseLong(RequestContext.get().getUserId()), (String)appId, (String)"cas_claimcenterbill", (String)"47150e89000000ac");
        if (!permResult.hasAllOrgPerm()) {
            filter = filter.and(new QFilter("org", "in", (Object)permResult.getHasPermOrgs()));
        }
        if (StringUtils.equals((CharSequence)"confirmed_page", (CharSequence)tabKey)) {
            filter = filter.and(new QFilter("confirmuser", "=", (Object)Long.valueOf(RequestContext.get().getUserId())));
        }
        return filter;
    }

    public static boolean isFromNoticeTabPage(IFormView view) {
        return Arrays.asList("undo_page", "pending_page", "ignore_page").contains((String)view.getFormShowParameter().getCustomParam("listType"));
    }

    public static boolean isFromNoticeTabPage(String key) {
        return Arrays.asList("undo_page", "pending_page", "ignore_page").contains(key);
    }

    public static List<DynamicObject> distinctByPrimaryKey(DynamicObjectCollection dynamicObjects) {
        return dynamicObjects.stream().filter(RecClaimNoticeMobUtils.distinctByKey(dy -> dy.getLong("id"))).collect(Collectors.toList());
    }

    private static <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        ConcurrentHashMap map = new ConcurrentHashMap();
        return t -> map.putIfAbsent(keyExtractor.apply(t), Boolean.TRUE) == null;
    }

    public static void jumpPageAfterOptByTabKey(AbstractFormPlugin formPlugin, String tabKey) {
        if (RecClaimNoticeMobUtils.isFromNoticeTabPage(tabKey)) {
            RecClaimPageJumpHandler.JumpToNoticeTabPage(formPlugin, tabKey);
        } else if (StringUtils.equals((CharSequence)"all", (CharSequence)tabKey)) {
            RecClaimPageJumpHandler.JumpToNoticeAllPage(formPlugin);
        } else {
            RecClaimPageJumpHandler.jumpTomainPage(formPlugin, null);
        }
    }

    public static String getTabDescByTabKey(String tabKey) {
        switch (tabKey) {
            case "undo_page": {
                return ResManager.loadKDString((String)"\u672a\u5904\u7406", (String)"RecClaimNoticeMobUtils_1", (String)"fi-cas-mobile", (Object[])new Object[0]);
            }
            case "pending_page": {
                return ResManager.loadKDString((String)"\u7a0d\u540e\u5904\u7406", (String)"RecClaimNoticeMobUtils_2", (String)"fi-cas-mobile", (Object[])new Object[0]);
            }
            case "ignore_page": {
                return ResManager.loadKDString((String)"\u6211\u5df2\u5ffd\u7565", (String)"RecClaimNoticeMobUtils_3", (String)"fi-cas-mobile", (Object[])new Object[0]);
            }
        }
        return "";
    }
}

