/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.balancemodel.calculate;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import kd.fi.cas.business.balancemodel.calculate.AbstractCalculateBalance;
import kd.fi.cas.business.balancemodel.calculate.dto.Balance;
import kd.fi.cas.business.balancemodel.calculate.dto.BalanceData;
import kd.fi.cas.business.balancemodel.calculate.util.BalanceUtil;
import kd.fi.cas.business.balancemodel.log.enums.FromType;
import kd.fi.cas.util.DateUtils;

public class AntiCalculateBalance
extends AbstractCalculateBalance {
    public AntiCalculateBalance(Map<String, BalanceData> dataSourceBalances, Map<String, BalanceData> dealBalanceData) {
        super(dataSourceBalances, dealBalanceData);
    }

    @Override
    protected void updateBalance(BalanceData sourceBalanceData, Balance balance) throws Exception {
        BigDecimal difference = BigDecimal.ZERO;
        difference = difference.add(this.doUpdateBalance(sourceBalanceData, balance));
        super.updateFollowBalance(sourceBalanceData, balance, difference);
    }

    @Override
    protected BigDecimal doUpdateBalance(BalanceData sourceBalanceData, Balance balance) throws Exception {
        Set<Date> dates = sourceBalanceData.getStartDates();
        Date startDate = balance.getStartDate();
        Balance originBalance = sourceBalanceData.getBalance(startDate);
        if (originBalance == null) {
            return BigDecimal.ZERO;
        }
        originBalance.setInitLogIds(balance.getInitLogIds());
        originBalance.setReset(balance.getReset());
        BigDecimal monthBalance = originBalance.getMonthBalance();
        BigDecimal startBalance = originBalance.getMonthStart();
        BigDecimal difference = BigDecimal.ZERO;
        Date preDate = DateUtils.preDate(dates, (Date)startDate);
        if (preDate.getTime() == startDate.getTime()) {
            if (originBalance != null) {
                difference = balance.getMonthStart();
                BigDecimal oMonthStart = originBalance.getMonthStart();
                originBalance.setMonthStart(oMonthStart.add(difference));
                BigDecimal oMonth = originBalance.getMonthBalance();
                BigDecimal diff = oMonth.add(difference);
                originBalance.setMonthBalance(diff);
                this.addFieldValue(originBalance, balance, originBalance);
                this.persistBalanceData.updateBalance(originBalance);
                sourceBalanceData.replaceBalance(originBalance);
                return difference;
            }
            return BigDecimal.ZERO;
        }
        Balance preBalance = sourceBalanceData.getBalance(preDate);
        if (preBalance == null) {
            return BigDecimal.ZERO;
        }
        BigDecimal preMonthBalance = preBalance.getMonthBalance();
        difference = difference.add(preMonthBalance.subtract(startBalance));
        originBalance.setMonthStart(preMonthBalance);
        BigDecimal antiMonthBalance = monthBalance.add(difference);
        originBalance.setMonthBalance(antiMonthBalance);
        this.addFieldValue(originBalance, balance, preBalance);
        this.persistBalanceData.updateBalance(originBalance);
        sourceBalanceData.replaceBalance(originBalance);
        return difference;
    }

    @Override
    protected void saveNonLatBalance(Balance balance, BalanceData sourceBalanceData, BalanceData balanceData) throws Exception {
    }

    @Override
    protected void saveNewBalance(Balance balance, BalanceData sourceBalanceData, BalanceData balanceData) throws Exception {
    }

    @Override
    protected BigDecimal doSaveBalance(BalanceData sourceBalanceData, BalanceData balanceData, Balance balance) throws Exception {
        return BigDecimal.ZERO;
    }

    private void addFieldValue(Balance opBalance, Balance antiBalance, Balance conBalance) {
        if (!FromType.RECINIT_STATE.getValue().equals(this.operationType) && !FromType.STOP_STATE.getValue().equals(this.operationType)) {
            return;
        }
        BigDecimal oYearCredit = BalanceUtil.dealBigDecimal(conBalance.getYearRecAmount());
        BigDecimal oYearDebit = BalanceUtil.dealBigDecimal(conBalance.getYearPayAmount());
        BigDecimal yearCredit = BalanceUtil.dealBigDecimal(antiBalance.getYearCredit());
        BigDecimal yearDebit = BalanceUtil.dealBigDecimal(antiBalance.getYearDebit());
        opBalance.setYearDebit(oYearDebit.add(yearDebit));
        opBalance.setYearCredit(oYearCredit.add(yearCredit));
        super.addFieldValue(opBalance);
    }
}

