/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.balancemodel.calculate;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import kd.fi.cas.business.balancemodel.calculate.AbstractCalculateBalance;
import kd.fi.cas.business.balancemodel.calculate.dto.Balance;
import kd.fi.cas.business.balancemodel.calculate.dto.BalanceData;
import kd.fi.cas.business.balancemodel.calculate.util.BalanceUtil;

public class LogCalculateBalance
extends AbstractCalculateBalance {
    public LogCalculateBalance(Map<String, BalanceData> dataSourceBalances, Map<String, BalanceData> dealBalanceData) {
        super(dataSourceBalances, dealBalanceData);
    }

    @Override
    protected BigDecimal doUpdateBalance(BalanceData sourceBalanceData, Balance balance) throws Exception {
        BigDecimal difference = BigDecimal.ZERO;
        Date startDate = balance.getStartDate();
        Balance sourceBalance = sourceBalanceData.getBalance(startDate);
        BigDecimal sourceMonthBalance = sourceBalance.getMonthBalance();
        BigDecimal sourcePayAmount = sourceBalance.getPayAmount();
        BigDecimal sourceRevenueAmount = sourceBalance.getRevenueAmount();
        int sourceStroke = sourceBalance.getStroke();
        BigDecimal yearStart = BalanceUtil.dealBigDecimal(sourceBalance.getYearStart());
        BigDecimal yearBalance = BalanceUtil.dealBigDecimal(sourceBalance.getYearBalance());
        BigDecimal yearPayAmount = BalanceUtil.dealBigDecimal(sourceBalance.getYearPayAmount());
        BigDecimal yearRecAmount = BalanceUtil.dealBigDecimal(sourceBalance.getYearRecAmount());
        BigDecimal monthBalance = balance.getMonthBalance();
        BigDecimal payAmount = balance.getPayAmount();
        BigDecimal revenueAmount = balance.getRevenueAmount();
        int stroke = balance.getStroke() == null ? 0 : balance.getStroke();
        BigDecimal dealMonthBalance = sourceMonthBalance.add(monthBalance);
        BigDecimal dealPayAmount = sourcePayAmount.add(payAmount);
        BigDecimal dealRevenueAmount = sourceRevenueAmount.add(revenueAmount);
        int dealStroke = sourceStroke + stroke;
        difference = difference.add(monthBalance);
        balance.setMonthBalance(dealMonthBalance);
        balance.setPayAmount(dealPayAmount);
        balance.setRevenueAmount(dealRevenueAmount);
        balance.setStroke(dealStroke);
        balance.setMonthStart(sourceBalance.getMonthStart());
        balance.setReset(sourceBalance.getReset());
        BigDecimal newYearBalance = yearBalance.add(revenueAmount).subtract(payAmount);
        BigDecimal newYearPayAmount = yearPayAmount.add(payAmount);
        BigDecimal newYearRecAmount = yearRecAmount.add(revenueAmount);
        balance.setYearStart(yearStart);
        balance.setYearBalance(newYearBalance);
        balance.setYearPayAmount(newYearPayAmount);
        balance.setYearRecAmount(newYearRecAmount);
        this.persistBalanceData.updateBalance(balance);
        return difference;
    }

    @Override
    protected void saveNonLatBalance(Balance balance, BalanceData sourceBalanceData, BalanceData balanceData) throws Exception {
        super.saveNewBalance(balance, null, balanceData);
    }

    @Override
    protected void saveNewBalance(Balance balance, BalanceData sourceBalanceData, BalanceData balanceData) throws Exception {
        super.saveNewBalance(balance, sourceBalanceData, balanceData);
    }

    @Override
    protected BigDecimal doSaveBalance(BalanceData sourceBalanceData, BalanceData balanceData, Balance balance) throws Exception {
        return super.doSaveBalance(sourceBalanceData, balanceData, balance);
    }
}

