/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.balancemodel.calculate.dto;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.cas.business.balancemodel.calculate.dto.Balance;

public class BalanceData {
    private static final Log LOGGER = LogFactory.getLog(BalanceData.class);
    private Set<Date> startDates = new HashSet<Date>(16);
    private Set<Date> endDates = new HashSet<Date>(16);
    private List<Balance> balances = new ArrayList<Balance>(16);
    Long orgId;

    public void setBalance(Balance balance) {
        int index = this.balances.indexOf(balance);
        if (index < 0) {
            this.balances.add(balance);
        } else {
            Balance bal = this.balances.get(index);
            BigDecimal originAmount = bal.getMonthBalance();
            BigDecimal monthBalance = originAmount.add(balance.getMonthBalance());
            Set<Long> originLogIds = bal.getBalanceLogIds();
            if (originLogIds == null) {
                originLogIds = new HashSet<Long>(16);
            }
            if (balance.getBalanceLogIds() != null && balance.getBalanceLogIds().size() > 0) {
                originLogIds.addAll(balance.getBalanceLogIds());
            }
            bal.setMonthBalance(monthBalance);
            int originStroke = bal.getStroke() == null ? 0 : bal.getStroke();
            int stroke = balance.getStroke() == null ? 0 : balance.getStroke();
            bal.setStroke(originStroke + stroke);
            BigDecimal originPayAmount = bal.getPayAmount() == null ? BigDecimal.ZERO : bal.getPayAmount();
            BigDecimal originRevenueAmount = bal.getRevenueAmount() == null ? BigDecimal.ZERO : bal.getRevenueAmount();
            BigDecimal originYearPayAmount = bal.getYearPayAmount() == null ? BigDecimal.ZERO : bal.getYearPayAmount();
            BigDecimal originYearRecAmount = bal.getYearRecAmount() == null ? BigDecimal.ZERO : bal.getYearRecAmount();
            bal.setPayAmount(originPayAmount.add(balance.getPayAmount()));
            bal.setRevenueAmount(originRevenueAmount.add(balance.getRevenueAmount()));
            bal.setYearPayAmount(originYearPayAmount.add(balance.getYearPayAmount()));
            bal.setYearRecAmount(originYearRecAmount.add(balance.getYearRecAmount()));
            bal.setBalanceLogIds(originLogIds);
        }
    }

    public void orderBalancesDESC() {
        if (this.balances.size() == 0) {
            return;
        }
        Collections.sort(this.balances, new Comparator<Balance>(){

            @Override
            public int compare(Balance b1, Balance b2) {
                try {
                    if (b1.getStartDate().getTime() < b2.getStartDate().getTime()) {
                        return -1;
                    }
                    return 1;
                }
                catch (Exception e) {
                    LOGGER.error("error:", (Throwable)e);
                    return 0;
                }
            }
        });
    }

    public Balance getBalance(Date date) {
        if (this.balances.size() == 0) {
            LOGGER.info("====BALANCE IS NULL");
            return null;
        }
        Balance balance = new Balance();
        balance.setStartDate(date);
        balance.setEndDate(date);
        int index = this.balances.indexOf(balance);
        if (index < 0) {
            LOGGER.info("====INDEX IS LESS THAN 0");
            return null;
        }
        Balance indexBalance = this.balances.get(index);
        return indexBalance;
    }

    public void replaceBalance(Balance balance) {
        if (this.balances.size() == 0) {
            this.balances.add(balance);
            return;
        }
        int index = this.balances.indexOf(balance);
        if (index < 0) {
            this.balances.add(balance);
            return;
        }
        this.balances.set(index, balance);
    }

    public void setStartDate(Date date) {
        this.startDates.add(date);
    }

    public void setAllStartDates(Set<Date> date) {
        this.startDates.addAll(date);
    }

    public void setEndDate(Date date) {
        this.endDates.add(date);
    }

    public Set<Date> getStartDates() {
        return this.startDates;
    }

    public void setStartDates(Set<Date> dates) {
        this.startDates = dates;
    }

    public List<Balance> getBalances() {
        return this.balances;
    }

    public void setBalances(List<Balance> balances) {
        this.balances = balances;
    }

    public Set<Date> getEndDates() {
        return this.endDates;
    }

    public void setEndDates(Set<Date> endDates) {
        this.endDates = endDates;
    }

    public Long getOrgId() {
        return this.orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
}

