/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.balancemodel.log;

import java.io.Serializable;
import java.util.Locale;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPools;
import kd.fi.cas.business.balancemodel.calculate.service.CalculateBalanceServiceService;
import kd.fi.cas.business.balancemodel.log.enums.BalanceType;

public class BalanceCalInvoke {
    private static final Log log = LogFactory.getLog(BalanceCalInvoke.class);

    public static void invokeBalanceCal(String formId) {
        BalanceType balanceType = BalanceCalInvoke.getBalanceType(formId);
        ThreadPools.executeOnceIncludeRequestContext((String)"invokeBalanceCal", () -> {
            try {
                if (BalanceCalInvoke.isOccur(formId)) {
                    log.info("======BalanceCalInvoke==invokeBalanceCal, traceId:{}", (Object)RequestContext.get().getTraceId());
                    CalculateBalanceServiceService.getInstance().calculateLog(balanceType.getValue());
                } else {
                    CalculateBalanceServiceService.getInstance().doInitOrAntiInit();
                }
            }
            catch (Exception e) {
                log.error(StringUtils.join((Object[])new Serializable[]{"casBalanceModelLog:", e}));
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u53d8\u66f4\u65e5\u5fd7\u8bb0\u5f55\u53d1\u751f\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b\u65e5\u5fd7[traceId:%1$s]\u3002", (String)"BalanceCalInvoke_1", (String)"fi-cas-business", (Object[])new Object[0]), RequestContext.get().getTraceId()));
            }
        });
    }

    private static BalanceType getBalanceType(String formId) {
        switch (formId.toLowerCase(Locale.getDefault())) {
            case "cas_cashjournal": 
            case "cas_manualcashjournal": {
                return BalanceType.CASH;
            }
            case "cas_bankjournal": 
            case "cas_manualbankjournal": {
                return BalanceType.JOURNAL;
            }
            case "cas_bankstatement": 
            case "cas_bankstatement_manual": 
            case "cas_downbankstate": {
                return BalanceType.STATE;
            }
        }
        return null;
    }

    private static boolean isOccur(String formId) {
        switch (formId.toLowerCase(Locale.getDefault())) {
            case "cas_cashjournal": 
            case "cas_manualcashjournal": 
            case "cas_bankjournal": 
            case "cas_manualbankjournal": 
            case "cas_bankstatement": 
            case "cas_bankstatement_manual": 
            case "cas_downbankstate": {
                return true;
            }
        }
        return false;
    }
}

