/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.balancemodel.log.helper;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.business.balancemodel.log.enums.OperateType;
import kd.fi.cas.business.balancemodel.log.type.BalanceModelLogFactory;

public class BalanceModelLogHelper {
    private static final Log logger = LogFactory.getLog(BalanceModelLogHelper.class);

    public static void doBalanceModelLog(Set<Long> ids, String formId, OperateType operate) {
        if (ids != null && ids.size() > 0) {
            BalanceModelLogHelper.doBalanceModelLog(BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)formId)), operate);
        }
    }

    public static void doBalanceModelLog(DynamicObject[] bills, OperateType operate) {
        try {
            BalanceModelLogHelper.doDelLog(bills, operate);
            BalanceModelLogHelper.doAddLog(bills, operate);
        }
        catch (KDBizException ex) {
            throw ex;
        }
        catch (Exception ex) {
            logger.info("{}doBalanceModelLog_error{}", (Object)"casBalanceModelLog:", (Object)ex);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4f59\u989d\u53d8\u66f4\u65e5\u5fd7\u8bb0\u5f55\u53d1\u751f\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b\u65e5\u5fd7[traceId:%1$s]\u3002", (String)"BalanceModelLogHelper_1", (String)"fi-cas-business", (Object[])new Object[0]), RequestContext.get().getTraceId()));
        }
    }

    public static void doDelLog(DynamicObject[] bills, OperateType operate) {
        if (bills != null && bills.length > 0 && bills[0] != null && operate != null) {
            String formId = bills[0].getDynamicObjectType().getName();
            logger.info("{}LogHelper_doDelLog_{}_{}_BillNo:{}:", new Object[]{"casBalanceModelLog:", formId, operate, Stream.of(bills).map(o -> o.get("billno")).collect(Collectors.toSet()).toString()});
            BalanceModelLogFactory.createBalancer(formId).doDelLog(bills, operate);
        }
    }

    public static void doAddLog(DynamicObject[] bills, OperateType operate) {
        if (bills != null && bills.length > 0 && bills[0] != null && operate != null) {
            String formId = bills[0].getDynamicObjectType().getName();
            logger.info("{}LogHelper_doAddLog_{}_{}_BillNo:{}:", new Object[]{"casBalanceModelLog:", formId, operate, Stream.of(bills).map(o -> o.get("billno")).collect(Collectors.toSet()).toString()});
            BalanceModelLogFactory.createBalancer(formId).doAddLog(bills, operate);
        }
    }
}

