/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.balancemodel.log.type;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.CommitListener;
import kd.bos.db.tx.TX;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.cas.business.balancemodel.log.BalanceCalInvoke;
import kd.fi.cas.business.balancemodel.log.bean.BillDataInfo;
import kd.fi.cas.business.balancemodel.log.enums.BalanceType;
import kd.fi.cas.business.balancemodel.log.enums.OperateType;
import kd.fi.cas.business.balancemodel.log.type.BalanceModelLogConstant;
import kd.fi.cas.business.balancemodel.log.type.BalanceModelLogUtil;
import kd.fi.cas.business.balancemodel.log.type.IBalanceModelLog;
import kd.fi.cas.helper.ExtendConfigHelper;

public abstract class AbstractBalanceModelLog
implements IBalanceModelLog {
    private static final Log log = LogFactory.getLog(AbstractBalanceModelLog.class);
    protected static String formId;
    protected OperateType operate;
    protected boolean isNeedOldData = true;
    protected String logTable;
    protected List<String> insertFields;
    protected BalanceType balanceType;

    @Override
    public void doDelLog(DynamicObject[] bills, OperateType operate) {
        log.info(StringUtils.join((Object[])new Serializable[]{"casBalanceModelLog:", "begin doDelLog:", operate, "-", RequestContext.get().getTraceId()}));
        if (!ExtendConfigHelper.useBalanceModel()) {
            return;
        }
        this.operate = operate;
        this.isInTx();
        if (bills != null && bills.length > 0 && this.isDeleteBalance(operate)) {
            Collection<BillDataInfo> billInfos = this.buildBillInfos(bills);
            log.info("{}Log_doDelLog_{}_{}_BillNo:{}:", new Object[]{"casBalanceModelLog:", formId, operate, Stream.of(bills).map(o -> o.get("billno")).collect(Collectors.toSet()).toString()});
            BalanceModelLogUtil.lock(formId, BalanceModelLogConstant.dbRoute, billInfos);
            if (this.isNeedOldData) {
                this.doDelLog(billInfos);
            } else {
                this.doSqlLog(billInfos, true);
            }
            if (!this.isAddBalance(operate)) {
                this.balanceCall();
            }
        }
        log.info(StringUtils.join((Object[])new Serializable[]{"casBalanceModelLog:", "end doBalanceLog:", operate}));
    }

    @Override
    public void doAddLog(DynamicObject[] bills, OperateType operate) {
        log.info(StringUtils.join((Object[])new Serializable[]{"casBalanceModelLog:", "begin doAddLog:", operate, "-", RequestContext.get().getTraceId()}));
        if (!ExtendConfigHelper.useBalanceModel()) {
            return;
        }
        this.operate = operate;
        this.isInTx();
        if (bills != null && bills.length > 0 && this.isAddBalance(operate)) {
            Collection<BillDataInfo> billInfos = this.buildBillInfos(bills);
            log.info("{}'Log_doAddLog_{}_{}_BillNo:{}:", new Object[]{"casBalanceModelLog:", formId, operate, Stream.of(bills).map(o -> o.get("billno")).collect(Collectors.toSet()).toString()});
            BalanceModelLogUtil.lock(formId, BalanceModelLogConstant.dbRoute, billInfos);
            this.doSqlLog(billInfos, false);
            this.balanceCall();
        }
        log.info(StringUtils.join((Object[])new Serializable[]{"casBalanceModelLog:", "end doBalanceLog:", operate}));
    }

    private void isInTx() {
        if (!TX.inTX()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u64cd\u4f5c\u4e0d\u5728\u4e8b\u52a1\u4e2d\uff0c\u4f59\u989d\u53d8\u66f4\u65e5\u5fd7\u8bb0\u5f55\u5931\u8d25\u3002", (String)"AbstractBalanceModelLog_1", (String)"fi-cas-business", (Object[])new Object[0]));
        }
    }

    private void balanceCall() {
        TX.addCommitListener((CommitListener)new CommitListener(){

            public void onEnded(boolean rollbacked) {
                BalanceCalInvoke.invokeBalanceCal(formId);
            }
        });
    }

    protected DataSet getOldDatas(Collection<BillDataInfo> oldBills) {
        return null;
    }

    private void doDelLog(Collection<BillDataInfo> bills) {
        ArrayList<Object[]> values = new ArrayList<Object[]>(bills.size());
        ArrayList<BillDataInfo> oldBills = new ArrayList<BillDataInfo>(bills.size());
        for (BillDataInfo bill : bills) {
            if (!bill.isFromDatabase()) continue;
            oldBills.add(bill);
        }
        if (oldBills.size() > 0) {
            try (DataSet oldDatas = this.getOldDatas(oldBills);){
                for (Row row : oldDatas) {
                    values.add(this.getInsertObjs(this.buildOldDataInfo(row), true));
                    if (values.size() <= 10000) continue;
                    this.executeBatch(values);
                    values.clear();
                }
            }
        }
        this.executeBatch(values);
    }

    private void doSqlLog(Collection<BillDataInfo> bills, boolean isDel) {
        ArrayList<Object[]> values = new ArrayList<Object[]>(bills.size());
        for (BillDataInfo bill : bills) {
            values.add(this.getInsertObjs(bill, isDel));
            if (values.size() <= 10000) continue;
            this.executeBatch(values);
            values.clear();
        }
        this.executeBatch(values);
    }

    private BillDataInfo buildOldDataInfo(Row row) {
        return BalanceModelLogUtil.buildDataInfo(row.getLong("billid"), row.getString("billno"), row.getLong("orgid"), row.getLong("acctid"), row.getLong("currencyid"), row.getBigDecimal("debitamount"), row.getBigDecimal("creditamount"), row.getDate("bizdate"), row.getLong("period"), true);
    }

    private void executeBatch(List<Object[]> sqlList) {
        BalanceModelLogUtil.executeBatch(BalanceModelLogConstant.dbRoute, this.logTable, BalanceModelLogUtil.getInsertSql(this.logTable, this.insertFields), sqlList);
    }

    private Object[] getInsertObjs(BillDataInfo row, boolean isDel) {
        ArrayList<Object> valueLst = new ArrayList<Object>(this.insertFields.size());
        this.getCommonObjs(valueLst, row, isDel);
        this.getExtendObjs(valueLst, row, isDel);
        return valueLst.toArray();
    }

    private void getCommonObjs(List<Object> valueLst, BillDataInfo row, boolean isDel) {
        valueLst.add(0L);
        valueLst.add(row.getBillid());
        valueLst.add(row.getBillNo());
        valueLst.add(row.getOrgid());
        valueLst.add(this.getBalanceType(row) == BalanceType.CASH ? 0L : row.getAcctid());
        valueLst.add(this.getBalanceType(row) == BalanceType.CASH ? row.getAcctid() : 0L);
        valueLst.add(row.getCurrencyid());
        BigDecimal amount = this.getAmount(row);
        valueLst.add(isDel ? amount.negate() : amount);
        valueLst.add(Character.valueOf(row.getDebitamount().compareTo(BigDecimal.ZERO) == 0 ? (char)'0' : '1'));
        valueLst.add(this.operate.getValue());
        valueLst.add(Character.valueOf('0'));
        valueLst.add(new Date(System.currentTimeMillis()));
        valueLst.add(Long.valueOf(RequestContext.get().getUserId()));
    }

    protected BalanceType getBalanceType(BillDataInfo row) {
        return this.balanceType;
    }

    protected void getExtendObjs(List<Object> valueLst, BillDataInfo row, boolean isDel) {
        valueLst.add(this.balanceType.getValue());
        valueLst.add(row.getBookdate());
        valueLst.add(isDel ? -1 : 1);
    }

    protected BigDecimal getAmount(BillDataInfo row) {
        BigDecimal debitAmount = row.getDebitamount();
        BigDecimal creditAmount = row.getCreditamount();
        switch (this.balanceType) {
            case CASH: 
            case JOURNAL: {
                return debitAmount.compareTo(BigDecimal.ZERO) == 0 ? creditAmount.negate() : debitAmount;
            }
            case STATE: {
                return debitAmount.compareTo(BigDecimal.ZERO) == 0 ? creditAmount : debitAmount.negate();
            }
        }
        return BigDecimal.ZERO;
    }

    protected boolean isAddBalance(OperateType operate) {
        switch (operate) {
            case ADD: {
                return true;
            }
        }
        return false;
    }

    protected boolean isDeleteBalance(OperateType operate) {
        switch (operate) {
            case ADD: 
            case DELETE: {
                return true;
            }
        }
        return false;
    }

    protected Collection<BillDataInfo> buildBillInfos(DynamicObject[] bills) {
        return null;
    }
}

