/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.balancemodel.log.type;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.business.balancemodel.log.bean.BillDataInfo;
import kd.fi.cas.business.balancemodel.log.enums.BalanceType;
import kd.fi.cas.business.balancemodel.log.type.AbstractBalanceModelLog;
import kd.fi.cas.business.balancemodel.log.type.BalanceModelLogConstant;
import kd.fi.cas.business.balancemodel.log.type.BalanceModelLogUtil;

public class BalanceModelLogCash
extends AbstractBalanceModelLog {
    private static final List<String> LOGINSERTFIELDS = BalanceModelLogConstant.LOGINSERTFIELDS;
    private static final String SELFIELDS = "id billid ,billno billno ,org orgid,accountcash acctid,currency currencyid,debitamount debitamount, creditamount creditamount,bookdate bizdate, 0 period ";

    public BalanceModelLogCash() {
        this.logTable = "t_cas_balancelog";
        this.insertFields = LOGINSERTFIELDS;
        this.balanceType = BalanceType.CASH;
    }

    public static BalanceModelLogCash getInstance(String formid) {
        formId = formid;
        return Singleton.instance;
    }

    @Override
    protected DataSet getOldDatas(Collection<BillDataInfo> oldBills) {
        List ids = oldBills.stream().map(e -> e.getBillid()).collect(Collectors.toList());
        QFilter filters = new QFilter("id", "in", ids);
        return QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)formId, (String)SELFIELDS, (QFilter[])filters.toArray(), null);
    }

    @Override
    protected Collection<BillDataInfo> buildBillInfos(DynamicObject[] bills) {
        ArrayList<BillDataInfo> returns = new ArrayList<BillDataInfo>(bills.length);
        for (DynamicObject bill : bills) {
            returns.add(BalanceModelLogUtil.buildDataInfo(bill.getLong("id"), bill.getString("billno"), bill.getLong("org_id") == 0L ? bill.getLong("org") : bill.getLong("org_id"), this.getAccountId(bill), bill.getLong("currency_id") == 0L ? bill.getLong("currency") : bill.getLong("currency_id"), bill.getBigDecimal("debitamount"), bill.getBigDecimal("creditamount"), bill.getDate("bookdate"), 0L, bill.getDataEntityState().getFromDatabase()));
        }
        return returns;
    }

    private long getAccountId(DynamicObject bill) {
        if (bill.containsProperty("accountcash")) {
            return bill.getLong("accountcash_id") == 0L ? bill.getLong("accountcash") : bill.getLong("accountcash_id");
        }
        return bill.getLong("accountbank_id") == 0L ? bill.getLong("accountbank") : bill.getLong("accountbank_id");
    }

    static class Singleton {
        private static BalanceModelLogCash instance = new BalanceModelLogCash();

        Singleton() {
        }
    }
}

