/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.balancemodel.log.type;

import java.util.Locale;
import kd.fi.cas.business.balancemodel.log.type.BalanceModelLogBankJ;
import kd.fi.cas.business.balancemodel.log.type.BalanceModelLogBankS;
import kd.fi.cas.business.balancemodel.log.type.BalanceModelLogCash;
import kd.fi.cas.business.balancemodel.log.type.BalanceModelLogInit;
import kd.fi.cas.business.balancemodel.log.type.BalanceModelLogReset;
import kd.fi.cas.business.balancemodel.log.type.BalanceModelLogStart;
import kd.fi.cas.business.balancemodel.log.type.IBalanceModelLog;

public class BalanceModelLogFactory {
    public static IBalanceModelLog createBalancer(String formId) {
        switch (formId.toLowerCase(Locale.getDefault())) {
            case "cas_cashjournal": 
            case "cas_manualcashjournal": {
                return BalanceModelLogCash.getInstance(formId);
            }
            case "cas_bankjournal": 
            case "cas_manualbankjournal": {
                return BalanceModelLogBankJ.getInstance(formId);
            }
            case "cas_bankstatement": 
            case "cas_bankstatement_manual": {
                return BalanceModelLogBankS.getInstance(formId);
            }
            case "cas_resetinitbalance": {
                return BalanceModelLogReset.getInstance(formId);
            }
            case "cas_rec_init": {
                return BalanceModelLogInit.getInstance(formId);
            }
            case "cas_cashmgtinit": {
                return BalanceModelLogInit.getInstance(formId);
            }
            case "cas_rec_edcadd": 
            case "cas_rec_edc": {
                return BalanceModelLogStart.getInstance(formId);
            }
        }
        return null;
    }
}

