/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.balancemodel.log.type;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.business.balancemodel.log.bean.BillDataInfo;
import kd.fi.cas.business.balancemodel.log.enums.BalanceType;
import kd.fi.cas.business.balancemodel.log.enums.FromType;
import kd.fi.cas.business.balancemodel.log.enums.OperateType;
import kd.fi.cas.business.balancemodel.log.type.AbstractBalanceModelLog;
import kd.fi.cas.business.balancemodel.log.type.BalanceModelLogConstant;
import kd.fi.cas.business.balancemodel.log.type.BalanceModelLogUtil;

public class BalanceModelLogStart
extends AbstractBalanceModelLog {
    private static final List<String> LOGINSERTFIELDS = BalanceModelLogConstant.LOGINSERTFIELDS_RESET;

    public BalanceModelLogStart() {
        this.logTable = "t_cas_balancelog_init";
        this.insertFields = LOGINSERTFIELDS;
        this.isNeedOldData = false;
    }

    public static BalanceModelLogStart getInstance(String formid) {
        formId = formid;
        return Singleton.instance;
    }

    @Override
    protected Collection<BillDataInfo> buildBillInfos(DynamicObject[] bills) {
        ArrayList<BillDataInfo> returns = new ArrayList<BillDataInfo>(bills.length);
        Map<String, List<BillDataInfo>> initInfos = this.getInitInfos(bills);
        for (DynamicObject bill : bills) {
            List<BillDataInfo> initInfo = initInfos.get(this.getOrgPeriodKey(bill.getLong("org.id"), bill.getLong("recperiod.id")));
            if (initInfo == null) continue;
            returns.addAll(initInfo);
        }
        return returns;
    }

    private Map<String, List<BillDataInfo>> getInitInfos(DynamicObject[] bills) {
        Set ids = Stream.of(bills).map(e -> e.getLong("org.id")).collect(Collectors.toSet());
        QFilter filters = new QFilter("org.id", "in", ids);
        filters.and(new QFilter("isfinishinit", "=", (Object)true));
        String selFiels = "id,billno,org,currentperiod,entrybank.bank_accountbank,entrybank.bank_currency,entrybank.bank_statementbalance, entrybank.bank_statementdebit, entrybank.bank_statementcredit";
        HashMap<String, List<BillDataInfo>> returns = new HashMap<String, List<BillDataInfo>>(bills.length);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cas_rec_init", (String)selFiels, (QFilter[])filters.toArray(), null);){
            while (ds.hasNext()) {
                Row row = ds.next();
                BillDataInfo dataInfo = BalanceModelLogUtil.buildDataInfo(row.getLong("id"), row.getString("billno"), row.getLong("org"), row.getLong("entrybank.bank_accountbank"), row.getLong("entrybank.bank_currency"), row.getBigDecimal("entrybank.bank_statementbalance"), BigDecimal.ZERO, null, row.getLong("currentperiod"), true);
                BigDecimal yearDebit = row.getBigDecimal("entrybank.bank_statementdebit");
                BigDecimal yearCredit = row.getBigDecimal("entrybank.bank_statementcredit");
                dataInfo.setYearDebit(yearDebit == null ? BigDecimal.ZERO : yearDebit);
                dataInfo.setYearCredit(yearCredit == null ? BigDecimal.ZERO : yearCredit);
                String orgPeriodKey = this.getOrgPeriodKey(dataInfo.getOrgid(), dataInfo.getPeriod());
                List cols = returns.computeIfAbsent(orgPeriodKey, k -> new ArrayList(16));
                cols.add(dataInfo);
            }
        }
        return returns;
    }

    @Override
    protected void getExtendObjs(List<Object> valueLst, BillDataInfo row, boolean isDel) {
        valueLst.add(this.getBalanceType(row).getValue());
        valueLst.add(row.getPeriod());
        valueLst.add(this.getFromType().toString());
        valueLst.add(isDel ? row.getYearDebit().negate() : row.getYearDebit());
        valueLst.add(isDel ? row.getYearCredit().negate() : row.getYearCredit());
    }

    private String getOrgPeriodKey(Long orgId, Long periodId) {
        return StringUtils.join((Object[])new Serializable[]{orgId, "!", periodId});
    }

    @Override
    protected BigDecimal getAmount(BillDataInfo row) {
        BigDecimal debitAmount = row.getDebitamount();
        BigDecimal creditAmount = row.getCreditamount();
        return debitAmount.compareTo(BigDecimal.ZERO) == 0 ? creditAmount : debitAmount;
    }

    private FromType getFromType() {
        switch (this.operate) {
            case ADD: {
                return FromType.START_STATE;
            }
            case DELETE: {
                return FromType.STOP_STATE;
            }
        }
        return FromType.START_STATE;
    }

    @Override
    protected BalanceType getBalanceType(BillDataInfo row) {
        return BalanceType.STATE;
    }

    @Override
    protected boolean isDeleteBalance(OperateType operate) {
        switch (operate) {
            case DELETE: {
                return true;
            }
        }
        return false;
    }

    static class Singleton {
        private static BalanceModelLogStart instance = new BalanceModelLogStart();

        Singleton() {
        }
    }
}

