/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.balancemodel.service;

import java.util.ArrayList;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.cas.business.balancemodel.calculate.dto.RequestBalanceParameter;
import kd.fi.cas.business.balancemodel.calculate.dto.ResponseBalances;
import kd.fi.cas.business.balancemodel.log.enums.BalanceType;
import kd.fi.cas.business.balancemodel.service.balance.BalanceBei;
import kd.fi.cas.business.balancemodel.service.balance.BalanceNewData;
import kd.fi.cas.business.balancemodel.service.balance.BalanceOldData;
import kd.fi.cas.business.balancemodel.service.balance.BalanceQueryType;
import kd.fi.cas.helper.ExtendConfigHelper;

public class BalanceDataService {
    private static Log logger = LogFactory.getLog(BalanceDataService.class);

    public static BalanceDataService getInstance() {
        return Singleton.instance;
    }

    public List<ResponseBalances> getBalances(List<RequestBalanceParameter> balParams, BalanceQueryType queryType) throws Exception {
        ArrayList<ResponseBalances> returns = new ArrayList<ResponseBalances>(16);
        try {
            logger.info("BalanceDataService.getBalances.begin.");
            boolean useBalance = ExtendConfigHelper.useBalanceModel();
            BalanceOldData oldCls = new BalanceOldData();
            BalanceNewData newCls = new BalanceNewData();
            BalanceBei beiCls = new BalanceBei();
            for (RequestBalanceParameter balParam : balParams) {
                balParam.setOldBalance(!useBalance);
                if (balParam.getType() == BalanceType.BEI.getValue()) {
                    returns.addAll(beiCls.getBalances(balParam, queryType));
                    continue;
                }
                if (balParam.isOldBalance()) {
                    returns.addAll(oldCls.getBalances(balParam, queryType));
                    continue;
                }
                returns.addAll(newCls.getBalances(balParam, queryType));
            }
            logger.info("BalanceDataService.getBalances.end.");
            return returns;
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u62a5\u8868\u67e5\u8be2\u53d1\u751f\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b\u65e5\u5fd7[traceId:%1$s]", (String)"BalanceDataService_1", (String)"fi-cas-business", (Object[])new Object[0]), RequestContext.get().getTraceId()));
        }
    }

    static class Singleton {
        private static final BalanceDataService instance = new BalanceDataService();

        Singleton() {
        }
    }
}

