/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.balancemodel.service.report;

import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.ext.tmc.balancemodel.BalanceValue;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.business.balancemodel.service.balance.BalanceQueryType;
import kd.fi.cas.business.balancemodel.service.report.DealDsService;
import kd.fi.cas.business.balancemodel.service.report.DealDsUtil;
import kd.fi.cas.business.balancemodel.service.report.reportbalance.ReportBalanceBei;
import kd.fi.cas.business.balancemodel.service.report.reportbalance.ReportBalanceImpl;
import kd.fi.cas.business.balancemodel.service.report.reportbalance.entity.AcctType;
import kd.fi.cas.business.balancemodel.service.report.reportbalance.entity.BalDataSourceEnum;
import kd.fi.cas.business.balancemodel.service.report.reportbalance.entity.BalanceQueryParam;
import kd.fi.cas.enums.CategoryEnum;
import kd.fi.cas.enums.TimeTypeEnum;

public class ReportBalanceService {
    private static final Long nullId = -111111L;
    private static final int iniSize = 16;
    private static final String LOGTIP = "ReportBalanceService:";
    private static Log log = LogFactory.getLog(ReportBalanceService.class);

    public static ReportBalanceService getInstance() {
        return Singleton.instance;
    }

    public DataSet getBalances(int datacource, int balanceType, int timeType, int balanceQueryType, Date startDate, Date endDate, Long peirodFrom, Long periodTo, Set<Long> cashAcctIds, Set<Long> bankAcctIds, Set<Long> currencyIds, Set<Long> orgIds) throws Exception {
        BalanceQueryParam queryParam = this.buildParam(datacource, balanceType, timeType, balanceQueryType, startDate, endDate, peirodFrom, periodTo, cashAcctIds, bankAcctIds, currencyIds, orgIds);
        return this.getBalances(queryParam);
    }

    public DataSet getBalances(BalanceQueryParam queryParam) throws Exception {
        log.info("{}ReportBalanceService.getBalances:{}.", (Object)LOGTIP, (Object)queryParam.toString());
        DataSet ds = this.getBalance(queryParam);
        return DealDsService.getInstance().dealDs(ds);
    }

    public List<BalanceValue> getJournalBalances(int datacource, int balanceType, int timeType, int balanceQueryType, Date startDate, Date endDate, Long peirodFrom, Long periodTo, Set<Long> cashAcctIds, Set<Long> bankAcctIds, Set<Long> currencyIds, Set<Long> orgIds) throws Exception {
        BalanceQueryParam queryParam = this.buildParam(datacource, balanceType, timeType, balanceQueryType, startDate, endDate, peirodFrom, periodTo, cashAcctIds, bankAcctIds, currencyIds, orgIds);
        return new ReportBalanceImpl().getBalanceValues(queryParam);
    }

    private DataSet getBalance(BalanceQueryParam queryParam) throws Exception {
        log.info("{}ReportBalanceService.getBalance.", (Object)LOGTIP);
        switch (queryParam.getDataSource()) {
            case JOURNAL: {
                return new ReportBalanceImpl().getReportBalanceDs(queryParam);
            }
            case BEI: {
                queryParam.setBalanceType(CategoryEnum.BEI);
                return new ReportBalanceBei().getReportBalanceDs(queryParam);
            }
            case DIRECTACCT: {
                AcctType acctype = this.splitAcctIds(queryParam);
                queryParam.setBankAcctIds(acctype.getNoDirectIds());
                DataSet jou_Bal_noDirect = new ReportBalanceImpl().getReportBalanceDs(queryParam);
                queryParam.setBalanceType(CategoryEnum.BEI);
                queryParam.setBankAcctIds(acctype.getDirectIds());
                DataSet bei_Bal_Direct = new ReportBalanceBei().getReportBalanceDs(queryParam);
                jou_Bal_noDirect = jou_Bal_noDirect.union(bei_Bal_Direct);
                return jou_Bal_noDirect;
            }
        }
        log.info("{}ReportBalanceService.getBalance.end.", (Object)LOGTIP);
        return DealDsUtil.newDs();
    }

    private AcctType splitAcctIds(BalanceQueryParam queryParam) {
        AcctType returns = new AcctType();
        log.info("{}ReportBalanceService.splitAcctIds.", (Object)LOGTIP);
        if (queryParam.getDataSource() == BalDataSourceEnum.DIRECTACCT) {
            DynamicObjectCollection accts = QueryServiceHelper.query((String)"am_accountbank", (String)"id,finorgtype,issetbankinterface", (QFilter[])new QFilter[]{new QFilter("id", "in", queryParam.getBankAcctIds())});
            HashSet<Long> directIds = new HashSet<Long>(16);
            HashSet<Long> noDirectIds = new HashSet<Long>(16);
            for (DynamicObject acct : accts) {
                Long id = acct.getLong("id");
                String finorgtype = acct.getString("finorgtype");
                boolean issetbankinterface = acct.getBoolean("issetbankinterface");
                if ("1".equals(finorgtype) || "3".equals(finorgtype) || issetbankinterface) {
                    directIds.add(id);
                    continue;
                }
                noDirectIds.add(id);
            }
            directIds.add(nullId);
            noDirectIds.add(nullId);
            returns.setDirectIds(directIds);
            returns.setNoDirectIds(noDirectIds);
        }
        return returns;
    }

    private BalanceQueryParam buildParam(int datacource, int balanceType, int timeType, int balanceQueryType, Date startDate, Date endDate, Long peirodFrom, Long periodTo, Set<Long> cashAcctIds, Set<Long> bankAcctIds, Set<Long> currencyIds, Set<Long> orgIds) {
        BalanceQueryParam queryParam = new BalanceQueryParam();
        queryParam.setDataSource(BalDataSourceEnum.getEnum(datacource));
        queryParam.setBalanceQueryType(BalanceQueryType.getEnum(balanceQueryType));
        queryParam.setBalanceType(CategoryEnum.getEnum((int)balanceType));
        queryParam.setBankAcctIds(bankAcctIds);
        queryParam.setCashAcctIds(cashAcctIds);
        queryParam.setCurrencyIds(currencyIds);
        queryParam.setEndDate(endDate);
        queryParam.setOrgIds(orgIds);
        queryParam.setPeriodFrom(peirodFrom);
        queryParam.setPeriodTo(periodTo);
        queryParam.setStartDate(startDate);
        queryParam.setTimeType(TimeTypeEnum.getEnum((int)timeType));
        return queryParam;
    }

    static class Singleton {
        private static final ReportBalanceService instance = new ReportBalanceService();

        Singleton() {
        }
    }
}

