/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.balancemodel.up;

import com.alibaba.fastjson.JSON;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.business.balancemodel.up.BalanceModelUpService;
import kd.fi.cas.dao.RpcResult;
import kd.fi.cas.enums.RpcResultStatusCode;
import kd.fi.cas.util.EmptyUtil;

public class HisBalanceModelUpService {
    private static Log logger = LogFactory.getLog(HisBalanceModelUpService.class);
    private static final String TYPE_CASH = "1";
    private static final String TYPE_JOURNAL = "2";
    private static final String TYPE_STATE = "3";

    public String upgradeBalance() {
        RpcResult recResult = new RpcResult();
        try {
            DynamicObject[] queryOrgs = BusinessDataServiceHelper.load((String)"cas_cashmgtinit", (String)"org, startperiod", (QFilter[])new QFilter[]{new QFilter("startperiod", "is not null", null)}, null);
            Set orgIds = Arrays.stream(queryOrgs).filter(o -> o.getDynamicObject("org") != null && EmptyUtil.isNoEmpty((DynamicObject)o.getDynamicObject("org")) && o.getDynamicObject("startperiod") != null && EmptyUtil.isNoEmpty((DynamicObject)o.getDynamicObject("startperiod"))).map(item -> item.getDynamicObject("org").getLong("id")).collect(Collectors.toSet());
            Map<Long, DynamicObject> orgPeriods = Arrays.stream(queryOrgs).filter(o -> o.getDynamicObject("org") != null && EmptyUtil.isNoEmpty((DynamicObject)o.getDynamicObject("org")) && o.getDynamicObject("startperiod") != null && EmptyUtil.isNoEmpty((DynamicObject)o.getDynamicObject("startperiod"))).collect(Collectors.toMap(p -> p.getDynamicObject("org").getLong("id"), p -> p.getDynamicObject("startperiod"), (k, v) -> v));
            BalanceModelUpService balanceModelUpService = new BalanceModelUpService();
            balanceModelUpService.doUpgrade(TYPE_CASH, new HashSet<Long>(orgIds), new HashMap<Long, DynamicObject>(orgPeriods));
            balanceModelUpService.doUpgrade(TYPE_JOURNAL, new HashSet<Long>(orgIds), new HashMap<Long, DynamicObject>(orgPeriods));
            balanceModelUpService.doUpgrade(TYPE_STATE, new HashSet<Long>(orgIds), new HashMap<Long, DynamicObject>(orgPeriods));
        }
        catch (Exception e) {
            recResult.setStatusCode(RpcResultStatusCode.ERROR);
            recResult.setMessage(e.getMessage());
            logger.error((Throwable)e);
        }
        return JSON.toJSONString((Object)recResult);
    }
}

