/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.check;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.business.opservice.helper.HandLinkBillHelper;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.enums.SourceBillTypeEnum;
import kd.fi.cas.helper.BalanceAdjustHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.DynamicObjectHelper;
import kd.fi.cas.helper.EntityPropertyHelper;
import kd.fi.cas.helper.MutexServiceHelper;
import kd.fi.cas.helper.SystemParameterHelper;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.util.StringUtils;

public class CheckByHandHelper {
    private static final Log logger = LogFactory.getLog(CheckByHandHelper.class);

    public static DynamicObject getLastBalanceAdjust(IFormView view, Map<String, Object> params) {
        DynamicObject org = params == null ? CheckByHandHelper.getValue(view, "org") : (DynamicObject)params.get("org");
        DynamicObject accountBank = params == null ? CheckByHandHelper.getValue(view, "accountbank") : (DynamicObject)params.get("accountbank");
        DynamicObject currency = params == null ? CheckByHandHelper.getValue(view, "currency") : (DynamicObject)params.get("currency");
        return BalanceAdjustHelper.getLastBalanceAdust((DynamicObject)org, (DynamicObject)accountBank, (DynamicObject)currency);
    }

    public static Map<String, Set<Long>> reverseCheck(Set<Long> checkedBillIds, boolean isNeedCheck, IFormView view, Map<String, Object> params) {
        HashMap<String, Set<Long>> unReverseCheckMaps = new HashMap<String, Set<Long>>();
        HashSet<Long> unReverseCheckByBalanceIds = new HashSet<Long>(10);
        try (TXHandle h = TX.required((String)"checkresult_reversecheck");){
            DynamicObjectCollection checkedResults = QueryServiceHelper.query((String)"cas_checkedresult", (String)"id,entry.bizobject,entry.bizobjectid,entry.bizdate,entry.sourcebillnumber", (QFilter[])new QFilter[]{new QFilter("id", "in", checkedBillIds)});
            HashSet stateIdset = new HashSet(16);
            HashSet journalIdset = new HashSet(16);
            Set journalIds = checkedResults.stream().filter(s -> "cas_bankjournal".equals(s.getString("entry.bizobject"))).map(s -> s.getLong("entry.bizobjectid")).collect(Collectors.toSet());
            QFilter qFilter = new QFilter("sourcebilltype", "=", (Object)SourceBillTypeEnum.VOUCHER.getValue()).and("id", "in", journalIds);
            DynamicObjectCollection bankJournals = QueryServiceHelper.query((String)"cas_bankjournal", (String)"id,sourcebilltype,sourcebillid", (QFilter[])qFilter.toArray());
            Set vourcherIds = bankJournals.stream().map(s -> s.getLong("sourcebillid")).collect(Collectors.toSet());
            Set checkedVourcherIds = (Set)DispatchServiceHelper.invokeBizService((String)"fi", (String)"gl", (String)"VoucherStatusMService", (String)"getCheckedVoucherIds", (Object[])new Object[]{vourcherIds});
            vourcherIds.removeAll(checkedVourcherIds);
            Set unReverseCheckJournalIds = bankJournals.stream().filter(s -> vourcherIds.contains(s.getLong("sourcebillid"))).map(s -> s.getLong("id")).collect(Collectors.toSet());
            Set unReverseCheckByVoucherIds = checkedResults.stream().filter(s -> unReverseCheckJournalIds.contains(s.getLong("entry.bizobjectid"))).map(s -> s.getLong("id")).collect(Collectors.toSet());
            Set sourceBillNumbers = checkedResults.stream().filter(s -> unReverseCheckJournalIds.contains(s.getLong("entry.bizobjectid"))).map(s -> s.getString("entry.sourcebillnumber")).collect(Collectors.toSet());
            if (unReverseCheckByVoucherIds.size() > 0) {
                checkedBillIds.removeAll(unReverseCheckByVoucherIds);
                unReverseCheckMaps.put("Voucher", unReverseCheckByVoucherIds);
                if (EmptyUtil.isNoEmpty(sourceBillNumbers)) {
                    String s2 = sourceBillNumbers.toString();
                    if (EmptyUtil.isNotEmpty((String)s2) && s2.length() >= 1) {
                        s2 = s2.substring(1, s2.length() - 1);
                    }
                    view.getPageCache().put("sourceBillNumbers", s2);
                }
            }
            Map checkedResultGroup = checkedResults.stream().collect(Collectors.groupingBy(s -> s.getLong("id"), Collectors.toSet()));
            for (Map.Entry data : checkedResultGroup.entrySet()) {
                Long id = data.getKey();
                if (unReverseCheckByVoucherIds.size() > 0 && unReverseCheckByVoucherIds.contains(id)) continue;
                Set entrys = data.getValue();
                DynamicObject balance = CheckByHandHelper.getLastBalanceAdjust(view, params);
                Date stateDate = null;
                Date journalDate = null;
                HashSet<Long> stateIdsetTemp = new HashSet<Long>(16);
                HashSet<Long> journalIdsetTemp = new HashSet<Long>(16);
                for (DynamicObject entry : entrys) {
                    if ("cas_bankjournal".equals(entry.getString("entry.bizobject"))) {
                        journalIdsetTemp.add(entry.getLong("entry.bizobjectid"));
                        Date tempDateJournal = entry.getDate("entry.bizdate");
                        if (tempDateJournal == null) continue;
                        journalDate = journalDate == null ? tempDateJournal : (journalDate.before(tempDateJournal) ? tempDateJournal : journalDate);
                        continue;
                    }
                    if (!"cas_bankstatement".equals(entry.getString("entry.bizobject"))) continue;
                    stateIdsetTemp.add(entry.getLong("entry.bizobjectid"));
                    Date tempDateState = entry.getDate("entry.bizdate");
                    if (tempDateState == null) continue;
                    stateDate = stateDate == null ? tempDateState : (stateDate.before(tempDateState) ? tempDateState : stateDate);
                }
                if (isNeedCheck && balance != null) {
                    Date bizDate = balance.getDate("bizdate");
                    if (view != null) {
                        view.getPageCache().put("billstatus", balance.getString("billstatus"));
                    }
                    if (null == bizDate) continue;
                    if (stateDate != null && journalDate != null && stateDate.compareTo(bizDate) <= 0 && journalDate.compareTo(bizDate) <= 0 || stateDate != null && stateDate.compareTo(bizDate) <= 0 && journalDate == null || journalDate != null && journalDate.compareTo(bizDate) <= 0 && stateDate == null) {
                        checkedBillIds.remove(id);
                        unReverseCheckByBalanceIds.add(id);
                        continue;
                    }
                }
                stateIdset.addAll(stateIdsetTemp);
                journalIdset.addAll(journalIdsetTemp);
            }
            if (EmptyUtil.isNoEmpty(unReverseCheckByBalanceIds)) {
                unReverseCheckMaps.put("Balance", unReverseCheckByBalanceIds);
            }
            if (checkedBillIds.size() == 0) {
                HashMap<String, Set<Long>> hashMap = unReverseCheckMaps;
                return hashMap;
            }
            try {
                DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"cas_checkedresult"), (Object[])checkedBillIds.toArray());
                if (stateIdset.size() > 0) {
                    String stateSql = "update t_cas_bankstatement set fischeck=0 where fid in " + StringUtils.setToString(stateIdset);
                    DB.execute((DBRoute)new DBRoute(MetadataServiceHelper.getDataEntityType((String)"cas_bankstatement").getDBRouteKey()), (String)stateSql, (Object[])new Object[0]);
                }
                if (journalIdset.size() > 0) {
                    String journalSql = "update t_cas_bankjournal set fischeck=0 where fid in " + StringUtils.setToString(journalIdset);
                    DB.execute((DBRoute)new DBRoute(MetadataServiceHelper.getDataEntityType((String)"cas_bankjournal").getDBRouteKey()), (String)journalSql, (Object[])new Object[0]);
                }
            }
            catch (Exception e) {
                h.markRollback();
                logger.error("\u53cd\u5bf9\u8d26\u629b\u5f02\u5e38\uff1a" + e);
                throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
            }
        }
        return unReverseCheckMaps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Boolean checkByHand(Set<Long> stateBillIds, Set<Long> journalBillIds, String checkType, IFormView view, Map<String, Object> params) {
        logger.info("===========\u624b\u5de5\u52fe\u5bf9\u5f00\u59cb===============");
        if (view == null && params == null) {
            return Boolean.TRUE;
        }
        if (!("3".equals(checkType) || stateBillIds.size() != 0 && journalBillIds.size() != 0)) {
            return Boolean.TRUE;
        }
        Map srcLockMap = null;
        Map tarLockMap = null;
        try {
            boolean stateIsCheck;
            Object org;
            long orgId;
            List srcStatementIds = stateBillIds.stream().filter(EmptyUtil::isNoEmpty).map(Objects::toString).collect(Collectors.toList());
            srcLockMap = MutexServiceHelper.batchRequest(srcStatementIds, (String)"cas_checkresult", (String)"check_lock_statement_key");
            Optional<String> srcLockFiledKey = srcLockMap.entrySet().stream().filter(e -> e.getValue() != null && (Boolean)e.getValue() == false).map(Map.Entry::getKey).findFirst();
            if (srcLockFiledKey.isPresent()) {
                CheckByHandHelper.showLockFailedTips(view, srcLockFiledKey.get(), "check_lock_statement_key");
                Boolean bl = Boolean.FALSE;
                return bl;
            }
            List tarJournalIds = journalBillIds.stream().filter(EmptyUtil::isNoEmpty).map(Objects::toString).collect(Collectors.toList());
            tarLockMap = MutexServiceHelper.batchRequest(tarJournalIds, (String)"cas_checkresult", (String)"check_lock_journal_key");
            Optional<String> tarLockFiledKey = tarLockMap.entrySet().stream().filter(e -> e.getValue() != null && (Boolean)e.getValue() == false).map(Map.Entry::getKey).findFirst();
            if (tarLockFiledKey.isPresent()) {
                CheckByHandHelper.showLockFailedTips(view, tarLockFiledKey.get(), "check_lock_journal_key");
                Boolean bl = Boolean.FALSE;
                return bl;
            }
            DynamicObjectCollection stateColls = CheckByHandHelper.getDynamicObjectColls("cas_bankstatement", stateBillIds);
            DynamicObjectCollection journalColls = CheckByHandHelper.getDynamicObjectColls("cas_bankjournal", journalBillIds);
            String validateMsg = CheckByHandHelper.validateBizDate(view, params, stateColls, journalColls);
            if (view != null) {
                DynamicObject dataEntity = view.getModel().getDataEntity();
                orgId = dataEntity.getDynamicObject("org").getLong("id");
            } else {
                org = (DynamicObject)params.get("org");
                orgId = org.getLong("id");
            }
            if (!CheckByHandHelper.checkAdjustByDate(orgId) && CasHelper.isNotEmpty((Object)validateMsg)) {
                if (view != null) {
                    view.showTipNotification(String.format(ResManager.loadKDString((String)"\u4f59\u989d\u8c03\u8282\u8868%s\uff0c\u4e0d\u5141\u8bb8\u52fe\u5bf9", (String)"CheckByHandHelper_4", (String)"fi-cas-formplugin", (Object[])new Object[0]), BillStatusEnum.SUBMIT.getValue().equals(validateMsg) ? ResManager.loadKDString((String)"\u5df2\u63d0\u4ea4", (String)"CheckByHandHelper_5", (String)"fi-cas-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5df2\u5ba1\u6279", (String)"CheckByHandHelper_6", (String)"fi-cas-formplugin", (Object[])new Object[0])));
                }
                org = Boolean.FALSE;
                return org;
            }
            Map<String, BigDecimal> stateAmountMap = CheckByHandHelper.amountMap(stateColls);
            Map<String, BigDecimal> journalAmountMap = CheckByHandHelper.amountMap(journalColls);
            BigDecimal stateSumCredit = stateAmountMap.get("creditamount");
            BigDecimal stateSumdebit = stateAmountMap.get("debitamount");
            BigDecimal journalSumCredit = journalAmountMap.get("creditamount");
            BigDecimal journalSumdebit = journalAmountMap.get("debitamount");
            if ("1".equals(checkType) && (stateSumCredit.compareTo(journalSumdebit) != 0 || stateSumdebit.compareTo(journalSumCredit) != 0)) {
                if (view != null) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u6570\u636e\u4e0d\u6ee1\u8db3\u91d1\u989d\u76f8\u7b49\uff0c\u65b9\u5411\u76f8\u53cd!", (String)"CheckByHandHelper_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                }
                Boolean bl = Boolean.FALSE;
                return bl;
            }
            BigDecimal journalSub = journalSumdebit.subtract(journalSumCredit);
            BigDecimal statmSub = stateSumCredit.subtract(stateSumdebit);
            if ("2".equals(checkType) && journalSub.compareTo(statmSub) != 0) {
                if (view != null) {
                    logger.info("==========\u5dee\u989d\u52fe\u5bf9\uff0c\u65e5\u8bb0\u8d26\uff1a" + journalSub + ";\u5bf9\u8d26\u5355\uff1a" + statmSub);
                    view.showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u6570\u636e\u4e0d\u6ee1\u8db3\u5dee\u989d\u76f8\u7b49\uff0c\u65b9\u5411\u76f8\u53cd!", (String)"CheckByHandHelper_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                }
                Boolean bl = Boolean.FALSE;
                return bl;
            }
            if ("3".equals(checkType)) {
                if (stateBillIds.size() > 0) {
                    if (stateSumCredit.compareTo(stateSumdebit) != 0) {
                        if (view != null) {
                            view.showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u5bf9\u8d26\u5355\u6570\u636e\u4e0d\u6ee1\u8db3\u91d1\u989d\u76f8\u7b49\uff0c\u65b9\u5411\u76f8\u53cd!", (String)"CheckByHandHelper_2", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                        }
                        Boolean bl = Boolean.FALSE;
                        return bl;
                    }
                } else if (journalSumCredit.compareTo(journalSumdebit) != 0) {
                    if (view != null) {
                        view.showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u65e5\u8bb0\u8d26\u6570\u636e\u4e0d\u6ee1\u8db3\u91d1\u989d\u76f8\u7b49\uff0c\u65b9\u5411\u76f8\u53cd!", (String)"CheckByHandHelper_3", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    }
                    Boolean bl = Boolean.FALSE;
                    return bl;
                }
            }
            if ((stateIsCheck = stateColls.stream().anyMatch(s -> s.getBoolean("ischeck"))) || journalColls.stream().anyMatch(j -> j.getBoolean("ischeck"))) {
                if (view != null) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u52fe\u9009\u7684\u94f6\u884c\u65e5\u8bb0\u8d26\u6216\u94f6\u884c\u5bf9\u8d26\u5355\u6570\u636e\u5df2\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"CAS-N-638046", (String)"fi-cas-business", (Object[])new Object[0]));
                    view.getPageCache().put("needRefresh", "true");
                }
                Boolean bl = Boolean.FALSE;
                return bl;
            }
            CheckByHandHelper.InsertCheckedResult(stateColls, journalColls, stateSumCredit, stateSumdebit, journalSumCredit, journalSumdebit, stateBillIds, journalBillIds, checkType, view, params);
        }
        finally {
            if (srcLockMap != null && !srcLockMap.isEmpty()) {
                List lockStatementIds = srcLockMap.entrySet().stream().filter(e -> e.getValue() != null && (Boolean)e.getValue() != false).map(Map.Entry::getKey).distinct().collect(Collectors.toList());
                MutexServiceHelper.batchRelease(lockStatementIds, (String)"cas_checkresult", (String)"check_lock_statement_key");
            }
            if (tarLockMap != null && !tarLockMap.isEmpty()) {
                List lockJournalIds = tarLockMap.entrySet().stream().filter(e -> e.getValue() != null && (Boolean)e.getValue() != false).map(Map.Entry::getKey).distinct().collect(Collectors.toList());
                MutexServiceHelper.batchRelease(lockJournalIds, (String)"cas_checkresult", (String)"check_lock_journal_key");
            }
        }
        return Boolean.TRUE;
    }

    private static void showLockFailedTips(IFormView view, String lockFailedKey, String lockOp) {
        if (view != null) {
            Long userid;
            DynamicObject user;
            String userName = "";
            Map lockInfo = MutexServiceHelper.getLockInfo((String)lockFailedKey, (String)"cas_checkresult", (String)lockOp);
            if (lockInfo != null && !lockInfo.isEmpty() && (user = QueryServiceHelper.queryOne((String)"bos_user", (String)"id,name", (QFilter[])new QFilter("id", "=", (Object)(userid = Long.valueOf((String)lockInfo.get("userid")))).toArray())) != null) {
                userName = user.getString("name");
            }
            String msg = ResManager.loadKDString((String)"%1$s\u6b63\u5728\u5bf9\u5f53\u524d\u52fe\u9009\u7684\u94f6\u884c\u65e5\u8bb0\u8d26\u6216\u94f6\u884c\u5bf9\u8d26\u5355\u8fdb\u884c\u52fe\u5bf9\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"CAS-W-445137", (String)"fi-cas-business", (Object[])new Object[0]);
            view.showTipNotification(String.format(msg, userName));
        }
    }

    private static String validateBizDate(IFormView view, Map<String, Object> params, DynamicObjectCollection stateColls, DynamicObjectCollection journalColls) {
        DynamicObject balance = CheckByHandHelper.getLastBalanceAdjust(view, params);
        if (balance != null) {
            Date bizDate = balance.getDate("bizdate");
            Date stateDate = null;
            Date journalDate = null;
            for (DynamicObject stateColl : stateColls) {
                Date tempDateState = stateColl.getDate("bizdate");
                stateDate = stateDate == null ? tempDateState : (stateDate.before(tempDateState) ? tempDateState : stateDate);
            }
            for (DynamicObject journalColl : journalColls) {
                Date tempDateJournal = journalColl.getDate("bookdate");
                journalDate = journalDate == null ? tempDateJournal : (journalDate.before(tempDateJournal) ? tempDateJournal : journalDate);
            }
            if (stateDate != null && journalDate != null && bizDate != null && stateDate.compareTo(bizDate) <= 0 && journalDate.compareTo(bizDate) <= 0) {
                return balance.getString("billstatus");
            }
            if (stateDate != null && stateDate.compareTo(bizDate) <= 0 && journalDate == null) {
                return balance.getString("billstatus");
            }
            if (journalDate != null && journalDate.compareTo(bizDate) <= 0 && stateDate == null) {
                return balance.getString("billstatus");
            }
        }
        return "";
    }

    private static void InsertCheckedResult(DynamicObjectCollection stateColls, DynamicObjectCollection journalColls, BigDecimal stateSumCredit, BigDecimal stateSumdebit, BigDecimal journalSumCredit, BigDecimal journalSumdebit, Set<Long> stateBillIds, Set<Long> journalBillIds, String checkType, IFormView view, Map<String, Object> params) {
        try (TXHandle h = TX.required((String)"checkresult_manualcheck");){
            DynamicObject entryObject;
            DynamicObjectType dt;
            EntryProp prop;
            DynamicObject obj;
            int i;
            DynamicObject checkedResult = BusinessDataServiceHelper.newDynamicObject((String)"cas_checkedresult");
            DynamicObjectHelper.setValue((DynamicObject)checkedResult, (String)"accountbank", (Object)(params == null ? view.getModel().getValue("accountbank") : params.get("accountbank")));
            DynamicObjectHelper.setValue((DynamicObject)checkedResult, (String)"currency", (Object)(params == null ? view.getModel().getValue("currency") : params.get("currency")));
            DynamicObjectHelper.setValue((DynamicObject)checkedResult, (String)"checkType", (Object)"byhand");
            DynamicObjectHelper.setValue((DynamicObject)checkedResult, (String)"company", (Object)(params == null ? view.getModel().getValue("org") : params.get("org")));
            boolean journalDirection = journalSumCredit.intValue() != 0;
            boolean stateDirection = stateSumCredit.intValue() != 0;
            DynamicObjectHelper.setValue((DynamicObject)checkedResult, (String)"stateAmount", (Object)(stateDirection ? stateSumCredit : stateSumdebit));
            DynamicObjectHelper.setValue((DynamicObject)checkedResult, (String)"journalAmount", (Object)(journalDirection ? journalSumCredit : journalSumdebit));
            DynamicObjectHelper.setValue((DynamicObject)checkedResult, (String)"stateDirection", (Object)(stateDirection ? "credit" : "debit"));
            DynamicObjectHelper.setValue((DynamicObject)checkedResult, (String)"journalDirection", (Object)(journalDirection ? "credit" : "debit"));
            DynamicObjectHelper.setValue((DynamicObject)checkedResult, (String)"checkdate", (Object)new Date());
            DynamicObjectHelper.setValue((DynamicObject)checkedResult, (String)"matchruleid", (Object)0);
            int journalSize = journalColls.size();
            for (i = 0; i < journalSize; ++i) {
                obj = (DynamicObject)journalColls.get(i);
                prop = (EntryProp)EntityMetadataCache.getDataEntityType((String)checkedResult.getDataEntityType().getName()).findProperty("entry");
                dt = prop.getDynamicCollectionItemPropertyType();
                entryObject = new DynamicObject(dt);
                entryObject.set("bizdate", (Object)obj.getDate("bookdate"));
                entryObject.set("bizobjectid", (Object)obj.getLong("id"));
                entryObject.set("creditamount", (Object)obj.getBigDecimal("creditamount"));
                entryObject.set("debitamount", (Object)obj.getBigDecimal("debitamount"));
                entryObject.set("bizobject", (Object)"cas_bankjournal");
                entryObject.set("org", (Object)obj.getLong("org"));
                entryObject.set("oppunit", obj.get("oppunit"));
                entryObject.set("description", obj.get("description"));
                entryObject.set("bankcheckflag", obj.get("bankcheckflag_tag"));
                entryObject.set("settlementnumber", obj.get("settlementnumber"));
                entryObject.set("pddate", obj.get("pddate"));
                entryObject.set("avddate", obj.get("avddate"));
                entryObject.set("sysdate", obj.get("createtime"));
                entryObject.set("settlementtype", obj.get("settlementtype"));
                entryObject.set("oppacctnumber", obj.get("oppacctnumber"));
                entryObject.set("sourcebillnumber", obj.get("sourcebillnumber"));
                entryObject.set("ischeck", (Object)"1");
                entryObject.set("source", (Object)("0" + obj.get("source")));
                entryObject.set("cashier", obj.get("cashier"));
                Set props = EntityPropertyHelper.setPropsByEntityExt((DynamicObject)entryObject);
                if (props.size() > 0) {
                    props.forEach(p -> entryObject.set(p, obj.get(p)));
                }
                checkedResult.getDynamicObjectCollection("entry").add((Object)entryObject);
            }
            int stateSize = stateColls.size();
            for (i = 0; i < stateSize; ++i) {
                obj = (DynamicObject)stateColls.get(i);
                prop = (EntryProp)EntityMetadataCache.getDataEntityType((String)checkedResult.getDataEntityType().getName()).findProperty("entry");
                dt = prop.getDynamicCollectionItemPropertyType();
                entryObject = new DynamicObject(dt);
                entryObject.set("bizdate", (Object)obj.getDate("bizdate"));
                entryObject.set("bizobjectid", (Object)obj.getLong("id"));
                entryObject.set("creditamount", (Object)obj.getBigDecimal("creditamount"));
                entryObject.set("debitamount", (Object)obj.getBigDecimal("debitamount"));
                entryObject.set("bizobject", (Object)"cas_bankstatement");
                entryObject.set("org", (Object)obj.getLong("org"));
                entryObject.set("oppunit", obj.get("oppunit"));
                entryObject.set("description", obj.get("description"));
                entryObject.set("bankcheckflag", obj.get("bankcheckflag"));
                entryObject.set("settlementnumber", obj.get("settlementnumber"));
                entryObject.set("vouchernumber", obj.get("vouchernumber"));
                entryObject.set("settlementtype", obj.get("settlementtype"));
                entryObject.set("oppacctnumber", obj.get("oppaccountnumber"));
                entryObject.set("balanceamt", obj.get("balanceamt"));
                entryObject.set("tradenumber", obj.get("tradenumber"));
                entryObject.set("bankvouvherno", obj.get("bankvouvherno"));
                entryObject.set("bankdetailno", obj.get("bankdetailno"));
                entryObject.set("ischeck", (Object)"1");
                entryObject.set("source", obj.get("source"));
                checkedResult.getDynamicObjectCollection("entry").add((Object)entryObject);
            }
            try {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{checkedResult});
                if (stateBillIds != null && stateBillIds.size() > 0) {
                    String stateSql = "update t_cas_bankstatement set fischeck=1 where fid in " + StringUtils.setToString(stateBillIds);
                    DB.execute((DBRoute)new DBRoute(MetadataServiceHelper.getDataEntityType((String)"cas_bankstatement").getDBRouteKey()), (String)stateSql, (Object[])new Object[0]);
                }
                if (journalBillIds != null && journalBillIds.size() > 0) {
                    String journalSql = "update t_cas_bankjournal set fischeck=1 where fid in " + StringUtils.setToString(journalBillIds);
                    DB.execute((DBRoute)new DBRoute(MetadataServiceHelper.getDataEntityType((String)"cas_bankjournal").getDBRouteKey()), (String)journalSql, (Object[])new Object[0]);
                }
                if (stateBillIds != null && journalBillIds != null) {
                    HandLinkBillHelper.bankStatementWritBankJournal(stateBillIds, journalBillIds);
                }
            }
            catch (Exception e) {
                h.markRollback();
                logger.error("\u624b\u5de5\u5bf9\u8d26\u629b\u5f02\u5e38\uff1a" + e);
                throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
            }
        }
    }

    private static DynamicObjectCollection getDynamicObjectColls(String entityName, Set<Long> billIds) {
        QFilter journalBillFilter = new QFilter("id", "in", billIds);
        DynamicObjectCollection colls = null;
        colls = "cas_bankjournal".equals(entityName) ? QueryServiceHelper.query((String)entityName, (String)("id,org,accountbank,currency,bizdate,creditamount,debitamount,oppunit,description,bankcheckflag,bankcheckflag_tag,settlementnumber,settlementtype,ischeck,source" + CheckByHandHelper.getField(entityName)), (QFilter[])journalBillFilter.toArray()) : QueryServiceHelper.query((String)entityName, (String)("id,org,accountbank,currency,bizdate,creditamount,debitamount,oppunit,description,bankcheckflag,settlementnumber,settlementtype,ischeck,source" + CheckByHandHelper.getField(entityName)), (QFilter[])journalBillFilter.toArray());
        return colls;
    }

    private static String getField(String entityName) {
        if ("cas_bankjournal".equals(entityName)) {
            String field = ",avddate,pddate,feepayer,createtime,oppacctnumber,sourcebillnumber,cashier,bookdate";
            EntryProp prop = (EntryProp)EntityMetadataCache.getDataEntityType((String)"cas_checkedresult").findProperty("entry");
            DynamicObject entryObject = new DynamicObject(prop.getDynamicCollectionItemPropertyType());
            Set props = EntityPropertyHelper.setPropsByEntityExt((DynamicObject)entryObject);
            if (props.size() > 0) {
                field = field + "," + String.join((CharSequence)",", props);
            }
            return field;
        }
        if ("cas_bankstatement".equals(entityName)) {
            return ",ratesdate,bankvouvherno,bankdetailno,tradenumber,oppaccountnumber,balanceamt,vouchernumber";
        }
        return "";
    }

    private static Map<String, BigDecimal> amountMap(DynamicObjectCollection colls) {
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        BigDecimal sumCredit = BigDecimal.ZERO;
        BigDecimal sumdebit = BigDecimal.ZERO;
        for (int i = 0; i < colls.size(); ++i) {
            DynamicObject journal = (DynamicObject)colls.get(i);
            sumCredit = sumCredit.add(journal.getBigDecimal("creditamount"));
            sumdebit = sumdebit.add(journal.getBigDecimal("debitamount"));
        }
        map.put("creditamount", sumCredit);
        map.put("debitamount", sumdebit);
        return map;
    }

    private static DynamicObject getValue(IFormView view, String key) {
        Object value = view.getModel().getValue(key);
        if (value != null) {
            return (DynamicObject)value;
        }
        return null;
    }

    public static boolean checkAdjustByDate(Long orgId) {
        return SystemParameterHelper.getParameterBoolean((long)orgId, (String)"cs095");
    }
}

