/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.compare;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.compare.data.CompareData;
import kd.fi.cas.compare.data.CompareRule;
import kd.fi.cas.compare.result.CompareResult;
import kd.fi.cas.compare.strategy.AbstractMultiRuleCompareStrategy;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.util.EmptyUtil;

public class BankAutoMatchStrategy
extends AbstractMultiRuleCompareStrategy {
    private static final Log logger = LogFactory.getLog(BankAutoMatchStrategy.class);

    public BankAutoMatchStrategy(List<List<CompareRule>> ruleList) {
        super(ruleList);
    }

    protected void handleResult(List<CompareResult> successList, List<CompareResult> resultList, List<CompareData> srcDataList, List<CompareData> tarDataList) {
        HashMap<Object, Integer> srcIdPresentCntMap = new HashMap<Object, Integer>();
        for (CompareResult result : resultList) {
            Set srcIdSet = result.getSrcIdSet();
            for (Object srcId : srcIdSet) {
                Integer pCnt = srcIdPresentCntMap.computeIfAbsent(srcId, t -> 0);
                int tarSize = result.getTarIdSet().size();
                srcIdPresentCntMap.put(srcId, pCnt + tarSize);
            }
        }
        HashSet waitRemoveSrcIdSet = new HashSet();
        HashSet waitRemoveTarIdSet = new HashSet();
        ArrayList<CompareResult> waitRemoveResultList = new ArrayList<CompareResult>();
        HashMap tarIdPresentCntMap = new HashMap();
        for (CompareResult result : resultList) {
            Set tarIdSet = result.getTarIdSet();
            for (Object tarId : tarIdSet) {
                Integer pCnt = srcIdPresentCntMap.computeIfAbsent(tarId, t -> 0);
                int srcSize = result.getSrcIdSet().size();
                tarIdPresentCntMap.put(tarId, pCnt + srcSize);
            }
        }
        Set<Object> multiMatchSrcIdSet = srcIdPresentCntMap.entrySet().stream().filter(o -> (Integer)o.getValue() > 1).map(Map.Entry::getKey).collect(Collectors.toSet());
        HashSet successSrcId = new HashSet();
        HashSet successTarId = new HashSet();
        logger.info("\u5f00\u59cb\u67e5\u627eSRC:TAR\u4e00\u5bf9\u591a\u573a\u666f\u7684\u6570\u636e,\u4e00\u5bf9\u591aSRCID\uff1a" + multiMatchSrcIdSet);
        Map<Object, Set<Object>> mergeSrcMapTarSet = this.getMergeSrcMapTarSet(resultList, multiMatchSrcIdSet);
        logger.info("\u5408\u5e76\u591a\u5bf9\u4e00\u7ed3\u679c\u96c6\uff1a" + mergeSrcMapTarSet);
        Map<String, String> srcChecCodeMap = this.getBankCheckFlagMap("cas_bankstatement", mergeSrcMapTarSet.keySet());
        Map<String, String> tarCheckCodeMap = this.getBankCheckFlagMap("cas_bankjournal", mergeSrcMapTarSet.values().stream().flatMap(tarSet -> tarSet.stream()).collect(Collectors.toSet()));
        HashMap matchedResultMap = new HashMap(resultList.size());
        for (CompareResult compareResult : resultList) {
            Set srcIdSet = compareResult.getSrcIdSet();
            HashSet matchedSrcIdSet = new HashSet();
            Set tarIdSet = compareResult.getTarIdSet();
            if (tarIdSet.size() == 0) continue;
            if (multiMatchSrcIdSet.isEmpty()) {
                logger.info("\u4e0d\u5b58\u5728\u4e00\u5bf9\u591a\u7684\u6570\u636e");
                break;
            }
            for (Object srcId : srcIdSet) {
                Object tarId;
                if (!multiMatchSrcIdSet.contains(srcId) || successTarId.contains(tarId = tarIdSet.iterator().next()) || successSrcId.contains(srcId)) continue;
                if (!this.checCodeContains(srcId, tarId, srcChecCodeMap, tarCheckCodeMap)) {
                    if (!matchedSrcIdSet.add(srcId)) continue;
                    successTarId.add(tarId);
                    successSrcId.add(srcId);
                    waitRemoveSrcIdSet.add(srcId);
                    waitRemoveTarIdSet.add(tarId);
                    waitRemoveResultList.add(compareResult);
                    successList.add(new CompareResult(Collections.singleton(tarId), Collections.singleton(srcId)));
                    continue;
                }
                waitRemoveSrcIdSet.add(srcId);
                waitRemoveTarIdSet.add(tarId);
                waitRemoveResultList.add(compareResult);
                successTarId.add(tarId);
                HashSet matchedTarIdSet = (HashSet)matchedResultMap.get(srcId);
                if (matchedTarIdSet == null) {
                    matchedTarIdSet = new HashSet(tarIdSet.size());
                    matchedResultMap.put(srcId, matchedTarIdSet);
                }
                matchedTarIdSet.add(tarId);
            }
        }
        for (Map.Entry entry : matchedResultMap.entrySet()) {
            logger.info("\u6dfb\u52a0\u4e00\u5bf9\u591a\u5339\u914d\u5230\u7ed3\u679c\u96c6\u4e2d,SRCID" + entry.getKey() + ",TARIDS:" + entry.getValue());
            successList.add(new CompareResult((Set)entry.getValue(), Collections.singleton(entry.getKey())));
        }
        resultList.removeAll(waitRemoveResultList);
        for (CompareResult compareResult : resultList) {
            compareResult.getSrcIdSet().removeAll(multiMatchSrcIdSet);
        }
        this.removeFromDataList(srcDataList, multiMatchSrcIdSet);
        Set singleMatchTarIdSet = tarIdPresentCntMap.entrySet().stream().filter(o -> (Integer)o.getValue() == 1).map(Map.Entry::getKey).collect(Collectors.toSet());
        Set<Object> set = resultList.stream().filter(o -> o.getSrcIdSet().size() > 0).map(CompareResult::getTarIdSet).flatMap(Collection::stream).collect(Collectors.toSet());
        Set<Object> allSrcIdSet = resultList.stream().filter(o -> o.getSrcIdSet().size() > 0).map(CompareResult::getSrcIdSet).flatMap(Collection::stream).collect(Collectors.toSet());
        Map<String, String> srcIdToBankNoMap = this.getBankCheckFlagMap("cas_bankstatement", allSrcIdSet);
        Map<String, String> tarToBankNoMap = this.getBankCheckFlagMap("cas_bankjournal", set);
        for (CompareResult result : resultList) {
            Sets.SetView intersection;
            if (result.getSrcIdSet().size() == 0 || (intersection = Sets.intersection(singleMatchTarIdSet, (Set)result.getTarIdSet())).size() <= 0) continue;
            logger.info("\u5b58\u5728\u4e00\u5bf9\u4e00\u7684\u573a\u666f\u7684\u6570\u636e\uff0c\u5339\u914d\u4e0a\u7684\u6e90\u5355\uff1a{}\uff0c\u76ee\u6807\u5355\uff1a{}", (Object)result.getSrcIdSet(), (Object)result.getTarIdSet());
            waitRemoveSrcIdSet.addAll(result.getSrcIdSet());
            waitRemoveTarIdSet.addAll(result.getTarIdSet());
            waitRemoveResultList.add(result);
            successList.add(result);
        }
        resultList.removeAll(waitRemoveResultList);
        Set multiMatchTarIdSet = tarIdPresentCntMap.entrySet().stream().filter(o -> (Integer)o.getValue() > 1).map(Map.Entry::getKey).collect(Collectors.toSet());
        HashSet matchedTarIdSet = new HashSet();
        for (CompareResult result : resultList) {
            Set tarIdSet = result.getTarIdSet();
            if (result.getSrcIdSet().size() == 0) continue;
            for (Object tarId : tarIdSet) {
                if (!multiMatchTarIdSet.contains(tarId) || !matchedTarIdSet.add(tarId)) continue;
                logger.info("\u5b58\u5728\u591a\u5bf9\u4e00\u573a\u666f\u7684\u6570\u636e:{}", (Object)result);
                String tarBankCheckFlag = tarToBankNoMap.get(String.valueOf(tarId));
                if (EmptyUtil.isNoEmpty((String)tarBankCheckFlag)) {
                    logger.info("\u76ee\u6807\u5355\u636e:{},\u5b58\u5728\u5bf9\u8d26\u6807\u8bc6\u7801\uff1a{}", tarId, (Object)tarBankCheckFlag);
                    String[] bankCheckFlags = tarBankCheckFlag.split(",");
                    Set srcIdSet = result.getSrcIdSet();
                    Set<String> srcBankCheckFlags = this.getBankBankCheckFlagListByTar(srcIdToBankNoMap, srcIdSet);
                    boolean legal = true;
                    for (String bankCheckFlag : bankCheckFlags) {
                        if (!CasHelper.isNotEmpty((Object)bankCheckFlag) || srcBankCheckFlags.contains(bankCheckFlag)) continue;
                        logger.info("\u6e90\u5355\u5bf9\u8d26\u6807\u8bc6\u7801\uff1a{}\uff0c\u4e0d\u5305\u542b\u76ee\u6807\u5355\u4e2d\u7684\u5bf9\u8d26\u6807\u8bc6\u7801:{}", srcBankCheckFlags, (Object)bankCheckFlag);
                        legal = false;
                        break;
                    }
                    waitRemoveSrcIdSet.addAll(srcIdSet);
                    waitRemoveTarIdSet.add(tarId);
                    if (!legal) continue;
                    logger.info("\u5339\u914d\u4e0a\u591a\u5bf9\u4e00\u7684\u6570\u636e\uff0c\u539f\u5355id:{},\u76ee\u6807\u5355id:{}", (Object)srcIdSet, tarId);
                    successList.add(new CompareResult(Collections.singleton(tarId), srcIdSet));
                    continue;
                }
                Object srcId = result.getSrcIdSet().iterator().next();
                logger.info("\u76ee\u6807\u5355\uff1a{}\u4e0d\u5b58\u5728\u5bf9\u8d26\u6807\u8bc6\u7801\uff0c\u968f\u673a\u53d6\u7b2c\u4e00\u6761srcId:{}", tarId, srcId);
                waitRemoveSrcIdSet.add(srcId);
                waitRemoveTarIdSet.add(tarId);
                successList.add(new CompareResult(Collections.singleton(tarId), Collections.singleton(srcId)));
            }
        }
        logger.info("\u5339\u914d\u6210\u529f\u7684\u7ed3\u679c\u96c6\uff1a{}", successList);
        this.removeFromDataList(srcDataList, waitRemoveSrcIdSet);
        this.removeFromDataList(tarDataList, waitRemoveTarIdSet);
    }

    private boolean checCodeContains(Object srcId, Object tarId, Map<String, String> srcChecCodeMap, Map<String, String> tarCheckCodeMap) {
        String[] splitTarCheckCode;
        String srcCheckCode = srcChecCodeMap.get(srcId);
        String tarCheckCode = tarCheckCodeMap.get(tarId);
        logger.info("\u68c0\u67e5\u5bf9\u8d26\u7801\uff1aSRC\u5bf9\u8d26\u7801:" + srcCheckCode + ",TAR\u5bf9\u8d26\u7801" + tarCheckCode);
        if (CasHelper.isEmpty((Object)tarCheckCode) || CasHelper.isEmpty((Object)srcCheckCode)) {
            return false;
        }
        if (CasHelper.isNotEmpty((Object)tarCheckCode) && srcCheckCode.contains(tarCheckCode)) {
            return true;
        }
        for (String checkCode : splitTarCheckCode = tarCheckCode.split(",")) {
            if (!CasHelper.isNotEmpty((Object)checkCode) || srcCheckCode.contains(checkCode)) continue;
            return false;
        }
        return true;
    }

    private Map<Object, Set<Object>> getMergeSrcMapTarSet(List<CompareResult> resultList, Set<Object> needMergeSet) {
        if (needMergeSet.isEmpty()) {
            return new HashMap<Object, Set<Object>>(2);
        }
        HashMap<Object, Set<Object>> resultMap = new HashMap<Object, Set<Object>>(resultList.size());
        for (CompareResult compareResult : resultList) {
            Set srcIdSet = compareResult.getSrcIdSet();
            Set tarIdSet = compareResult.getTarIdSet();
            for (Object srcId : srcIdSet) {
                if (!needMergeSet.contains(srcId)) continue;
                HashSet resultSet = (HashSet)resultMap.get(srcId);
                if (resultSet == null) {
                    resultSet = new HashSet(tarIdSet.size());
                    resultMap.put(srcId, resultSet);
                }
                resultSet.addAll(tarIdSet);
            }
        }
        return resultMap;
    }

    /*
     * WARNING - void declaration
     */
    private Map<String, String> getBankCheckFlagMap(String entityName, Set<Object> idSet) {
        void var5_9;
        ArrayList<Long> srcIdsList = new ArrayList<Long>(10);
        for (String string : idSet) {
            srcIdsList.add(Long.valueOf(string));
        }
        Object var5_6 = null;
        if ("cas_bankstatement".equals(entityName)) {
            DynamicObject[] bills = BusinessDataServiceHelper.load((String)entityName, (String)"id,bankcheckflag", (QFilter[])new QFilter[]{new QFilter("id", "in", srcIdsList)});
            HashMap<String, String> hashMap = new HashMap<String, String>(bills.length);
            for (DynamicObject bill : bills) {
                hashMap.put(bill.getString("id"), bill.getString("bankcheckflag"));
            }
        } else {
            DynamicObject[] bills = BusinessDataServiceHelper.load((String)entityName, (String)"id,bankcheckflag_tag,bankcheckentity.ebankcheckflag", (QFilter[])new QFilter[]{new QFilter("id", "in", srcIdsList)});
            HashMap<String, String> hashMap = new HashMap<String, String>(bills.length);
            for (DynamicObject bill : bills) {
                DynamicObjectCollection bankCheckEntity = bill.getDynamicObjectCollection("bankcheckentity");
                ArrayList<String> flagList = new ArrayList<String>(10);
                if (bankCheckEntity != null && bankCheckEntity.size() > 0) {
                    for (DynamicObject entry : bankCheckEntity) {
                        flagList.add(entry.getString("ebankcheckflag"));
                    }
                }
                if (flagList.size() > 0) {
                    hashMap.put(bill.getString("id"), String.join((CharSequence)",", flagList));
                    continue;
                }
                hashMap.put(bill.getString("id"), bill.getString("bankcheckflag_tag"));
            }
        }
        return var5_9;
    }

    private Set<String> getBankBankCheckFlagListByTar(Map<String, String> srcIdToBankNoMap, Set<Object> tarIds) {
        HashSet<String> set = new HashSet<String>();
        tarIds.forEach(s -> set.add((String)srcIdToBankNoMap.get(String.valueOf(s))));
        return set;
    }
}

