/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.compare;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.compare.data.CompareData;
import kd.fi.cas.compare.data.ComparePropValue;
import kd.fi.cas.compare.result.CompareResult;
import kd.fi.cas.compare.result.RpcCompareStrategyResult;
import kd.fi.cas.helper.CasHelper;

public class BankAutoMatchStrategyV2 {
    public RpcCompareStrategyResult handleResult(List<CompareResult> resultList, List<CompareData> srcDataList, List<CompareData> tarDataList, boolean enableMultiRes) {
        List convertResultList = JSON.parseArray((String)JSON.toJSONString(resultList), CompareResult.class);
        List convertSrcDataList = JSON.parseArray((String)JSON.toJSONString(srcDataList), CompareData.class);
        List convertTarDataList = JSON.parseArray((String)JSON.toJSONString(tarDataList), CompareData.class);
        resultList.clear();
        srcDataList.clear();
        tarDataList.clear();
        resultList.addAll(convertResultList);
        srcDataList.addAll(convertSrcDataList);
        tarDataList.addAll(convertTarDataList);
        RpcCompareStrategyResult rpcCompareStrategyResult = new RpcCompareStrategyResult();
        ArrayList<CompareResult> successList = new ArrayList<CompareResult>(10);
        HashMap<Object, Integer> srcIdPresentCntMap = new HashMap<Object, Integer>();
        for (CompareResult result : resultList) {
            Set srcIdSet = result.getSrcIdSet();
            for (Object srcId : srcIdSet) {
                Integer pCnt = srcIdPresentCntMap.computeIfAbsent(srcId, t -> 0);
                int tarSize = result.getTarIdSet().size();
                srcIdPresentCntMap.put(srcId, pCnt + tarSize);
            }
        }
        HashSet<Object> waitRemoveSrcIdSet = new HashSet<Object>();
        HashSet<Object> waitRemoveTarIdSet = new HashSet<Object>();
        ArrayList<CompareResult> waitRemoveResultList = new ArrayList<CompareResult>();
        HashMap tarIdPresentCntMap = new HashMap();
        for (CompareResult result : resultList) {
            Set tarIdSet = result.getTarIdSet();
            for (Object tarId : tarIdSet) {
                Integer pCnt = srcIdPresentCntMap.computeIfAbsent(tarId, t -> 0);
                int srcSize = result.getSrcIdSet().size();
                tarIdPresentCntMap.put(tarId, pCnt + srcSize);
            }
        }
        Set<Object> multiMatchSrcIdSet = srcIdPresentCntMap.entrySet().stream().filter(o -> (Integer)o.getValue() > 1).map(Map.Entry::getKey).collect(Collectors.toSet());
        HashSet successSrcId = new HashSet(16);
        HashSet successTarId = new HashSet(16);
        for (CompareResult result : resultList) {
            HashSet matchedSrcIdSet = new HashSet();
            Set srcIdSet = result.getSrcIdSet();
            if (result.getTarIdSet().size() == 0) continue;
            for (Object srcId : srcIdSet) {
                Object tarId;
                if (!multiMatchSrcIdSet.contains(srcId) || !matchedSrcIdSet.add(srcId) || successTarId.contains(tarId = result.getTarIdSet().iterator().next()) || successSrcId.contains(srcId)) continue;
                successTarId.add(tarId);
                successSrcId.add(srcId);
                waitRemoveSrcIdSet.add(srcId);
                waitRemoveTarIdSet.add(tarId);
                waitRemoveResultList.add(result);
                successList.add(new CompareResult(Collections.singleton(tarId), Collections.singleton(srcId)));
            }
        }
        resultList.removeAll(waitRemoveResultList);
        for (CompareResult compareResult : resultList) {
            compareResult.getSrcIdSet().removeAll(multiMatchSrcIdSet);
        }
        this.removeFromDataList(srcDataList, multiMatchSrcIdSet);
        Set singleMatchTarIdSet = tarIdPresentCntMap.entrySet().stream().filter(o -> (Integer)o.getValue() == 1).map(Map.Entry::getKey).collect(Collectors.toSet());
        Set<Object> allTarIdSet = resultList.stream().filter(o -> o.getSrcIdSet().size() > 0).map(CompareResult::getTarIdSet).flatMap(Collection::stream).collect(Collectors.toSet());
        Set<Object> allSrcIdSet = resultList.stream().filter(o -> o.getSrcIdSet().size() > 0).map(CompareResult::getSrcIdSet).flatMap(Collection::stream).collect(Collectors.toSet());
        Map<String, String> srcIdToBankNoMap = this.getBankCheckFlagMap("cas_bankstatement", allSrcIdSet);
        Map<String, String> tarToBankNoMap = this.getBankCheckFlagMap("cas_bankjournal", allTarIdSet);
        for (CompareResult result : resultList) {
            Sets.SetView intersection;
            if (result.getSrcIdSet().size() == 0 || (intersection = Sets.intersection(singleMatchTarIdSet, (Set)result.getTarIdSet())).size() <= 0) continue;
            Set tarIdSet = result.getTarIdSet();
            String tarBankCheckFlag = tarToBankNoMap.get(String.valueOf(tarIdSet.iterator().next()));
            waitRemoveSrcIdSet.addAll(result.getSrcIdSet());
            waitRemoveTarIdSet.addAll(result.getTarIdSet());
            waitRemoveResultList.add(result);
            if (tarBankCheckFlag.contains(",")) continue;
            successList.add(result);
        }
        resultList.removeAll(waitRemoveResultList);
        Set multiMatchTarIdSet = tarIdPresentCntMap.entrySet().stream().filter(o -> (Integer)o.getValue() > 1).map(Map.Entry::getKey).collect(Collectors.toSet());
        HashSet matchedTarIdSet = new HashSet();
        for (CompareResult result : resultList) {
            Set tarIdSet = result.getTarIdSet();
            if (result.getSrcIdSet().size() == 0) continue;
            for (Object tarId : tarIdSet) {
                if (!multiMatchTarIdSet.contains(tarId) || !matchedTarIdSet.add(tarId)) continue;
                String tarBankCheckFlag = tarToBankNoMap.get(String.valueOf(tarId));
                if (tarBankCheckFlag.contains(",")) {
                    String[] bankCheckFlags = tarBankCheckFlag.split(",");
                    Set srcIdSet = result.getSrcIdSet();
                    Set<String> srcBankCheckFlags = this.getBankBankCheckFlagListByTar(srcIdToBankNoMap, srcIdSet);
                    boolean legal = true;
                    for (String bankCheckFlag : bankCheckFlags) {
                        if (!CasHelper.isNotEmpty((Object)bankCheckFlag) || srcBankCheckFlags.contains(bankCheckFlag)) continue;
                        legal = false;
                        break;
                    }
                    waitRemoveSrcIdSet.addAll(srcIdSet);
                    waitRemoveTarIdSet.add(tarId);
                    if (!legal) continue;
                    successList.add(new CompareResult(Collections.singleton(tarId), srcIdSet));
                    continue;
                }
                Object srcId = result.getSrcIdSet().iterator().next();
                waitRemoveSrcIdSet.add(srcId);
                waitRemoveTarIdSet.add(tarId);
                successList.add(new CompareResult(Collections.singleton(tarId), Collections.singleton(srcId)));
            }
        }
        this.removeFromDataList(srcDataList, waitRemoveSrcIdSet);
        this.removeFromDataList(tarDataList, waitRemoveTarIdSet);
        rpcCompareStrategyResult.setSuccessList(successList);
        rpcCompareStrategyResult.setUnRemovedResultList(resultList);
        rpcCompareStrategyResult.setUnRemovedSrcDataList(srcDataList);
        rpcCompareStrategyResult.setUnRemovedTarDataList(tarDataList);
        return rpcCompareStrategyResult;
    }

    private Map<String, String> getBankCheckFlagMap(String entityName, Set<Object> idSet) {
        HashMap<String, String> map = null;
        if ("cas_bankstatement".equals(entityName)) {
            DynamicObject[] bills = BusinessDataServiceHelper.load((String)entityName, (String)"id,bankcheckflag", (QFilter[])new QFilter[]{new QFilter("id", "in", idSet)});
            map = new HashMap<String, String>(bills.length);
            for (DynamicObject bill : bills) {
                map.put(bill.getString("id"), bill.getString("bankcheckflag"));
            }
        } else {
            DynamicObject[] bills = BusinessDataServiceHelper.load((String)entityName, (String)"id,bankcheckflag_tag,bankcheckentity.ebankcheckflag", (QFilter[])new QFilter[]{new QFilter("id", "in", idSet)});
            map = new HashMap(bills.length);
            for (DynamicObject bill : bills) {
                DynamicObjectCollection bankCheckEntity = bill.getDynamicObjectCollection("bankcheckentity");
                ArrayList<String> flagList = new ArrayList<String>(10);
                if (bankCheckEntity != null && bankCheckEntity.size() > 0) {
                    for (DynamicObject entry : bankCheckEntity) {
                        flagList.add(entry.getString("ebankcheckflag"));
                    }
                }
                if (flagList.size() > 0) {
                    map.put(bill.getString("id"), String.join((CharSequence)",", flagList));
                    continue;
                }
                map.put(bill.getString("id"), bill.getString("bankcheckflag_tag"));
            }
        }
        return map;
    }

    private Set<String> getBankBankCheckFlagListByTar(Map<String, String> srcIdToBankNoMap, Set<Object> tarIds) {
        HashSet<String> set = new HashSet<String>();
        tarIds.forEach(s -> set.add((String)srcIdToBankNoMap.get(String.valueOf(s))));
        return set;
    }

    private void removeFromDataList(List<CompareData> dataList, Collection<Object> idList) {
        for (CompareData data : dataList) {
            HashSet<ComparePropValue> waitRemoveValList = new HashSet<ComparePropValue>(idList.size());
            for (Object id : idList) {
                ComparePropValue propValue = new ComparePropValue();
                propValue.setPropName(data.getPropName());
                propValue.setId(id);
                waitRemoveValList.add(propValue);
            }
            data.getPropValues().removeAll(waitRemoveValList);
        }
    }
}

