/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.convert;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.EntryProp;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.fi.cas.business.convert.IBillTranslateMapper;
import kd.fi.cas.helper.DynamicObjectHelper;
import kd.fi.cas.util.EntityMetadataUtils;

public abstract class AbstractBillConverter
implements IBillTranslateMapper {
    protected abstract Map<String, String> getMapper();

    public DynamicObject convertToTargetBill(DynamicObject sourceBill) {
        MainEntityType targetDataEntityType = MetadataServiceHelper.getDataEntityType((String)this.getTargetEntityKey());
        long pk = DB.genLongId((String)targetDataEntityType.getAlias());
        DynamicObject targetBill = new DynamicObject((DynamicObjectType)targetDataEntityType, (Object)pk);
        Map<String, String> fieldMapper = this.getMapper();
        MainEntityType sourceDataEntityType = MetadataServiceHelper.getDataEntityType((String)this.getSourceEntityKey());
        boolean containsSourceEntry = EntityMetadataUtils.containsEntryField(fieldMapper.keySet(), (MainEntityType)sourceDataEntityType);
        boolean containsTargetEntry = EntityMetadataUtils.containsEntryField(fieldMapper.values(), (MainEntityType)targetDataEntityType);
        DynamicObjectCollection sourceEntry = new DynamicObjectCollection();
        if (containsSourceEntry) {
            sourceEntry = sourceBill.getDynamicObjectCollection(EntityMetadataUtils.getEntryProp((IDataEntityType)sourceDataEntityType).getName());
        }
        DynamicObjectType targetEntryDt = null;
        DynamicObjectCollection targetEntry = null;
        if (containsTargetEntry) {
            targetEntryDt = ((EntryProp)targetDataEntityType.getProperty(EntityMetadataUtils.getEntryProp((IDataEntityType)targetDataEntityType).getName())).getDynamicCollectionItemPropertyType();
            targetEntry = targetBill.getDynamicObjectCollection(EntityMetadataUtils.getEntryProp((IDataEntityType)targetDataEntityType).getName());
        }
        HashMap<DynamicObject, DynamicObject> entryMapper = new HashMap<DynamicObject, DynamicObject>();
        for (Map.Entry<String, String> mapEntry : fieldMapper.entrySet()) {
            String sourceFieldName = mapEntry.getKey();
            String targetFieldName = mapEntry.getValue();
            if (EntityMetadataUtils.isEntryField((MainEntityType)sourceDataEntityType, (String)sourceFieldName)) {
                for (DynamicObject sEntryRow : sourceEntry) {
                    if (null == targetEntryDt) continue;
                    DynamicObject targetRow = (DynamicObject)entryMapper.get(sEntryRow);
                    if (targetRow == null) {
                        targetRow = new DynamicObject(targetEntryDt);
                        entryMapper.put(sEntryRow, targetRow);
                        if (targetEntry != null) {
                            targetEntry.add((Object)targetRow);
                            targetRow.set("seq", (Object)targetEntry.size());
                        }
                    }
                    targetRow.set(targetFieldName, DynamicObjectHelper.getValue((DynamicObject)sEntryRow, (String)sourceFieldName));
                }
                continue;
            }
            targetBill.set(targetFieldName, DynamicObjectHelper.getValue((DynamicObject)sourceBill, (String)sourceFieldName));
        }
        return targetBill;
    }

    @Override
    public Collection<String> getAllSourceFields() {
        return new ArrayList<String>(this.getMapper().keySet());
    }

    @Override
    public List<String> getGroupFields() {
        return new ArrayList<String>();
    }

    @Override
    public List<String> getSummaryFields() {
        return new ArrayList<String>();
    }
}

