/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.convert;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.business.convert.AbstractPayBillConverter;
import kd.fi.cas.enums.BeBillStatusEnum;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.helper.CodeRuleHelper;

public class OverseaPaymentBillConverter
extends AbstractPayBillConverter {
    private Map<String, String> fieldMapper = new HashMap<String, String>(60);

    public OverseaPaymentBillConverter() {
        this.fieldMapper.put("org", "company");
        this.fieldMapper.put("payeracctbank", "accountbank");
        this.fieldMapper.put("payerbank", "bank");
        this.fieldMapper.put("id", "sourcebillid");
        this.fieldMapper.put("recaccbankname", "payeename");
        this.fieldMapper.put("payeebanknum", "payeeacct");
        this.fieldMapper.put("ispersonpay", "isprivatepay");
        this.fieldMapper.put("iscrosspay", "istranspay");
        this.fieldMapper.put("payeebankname", "payeebank");
        this.fieldMapper.put("reccountry", "reccountry");
        this.fieldMapper.put("recprovince", "recprovince");
        this.fieldMapper.put("reccity", "reccity");
        this.fieldMapper.put("recbanknumber", "recbanknumber");
        this.fieldMapper.put("recswiftcode", "incomeswiftcode");
        this.fieldMapper.put("actpayamt", "amount");
        this.fieldMapper.put("expectdate", "expectdealtime");
        this.fieldMapper.put("usage", "usage");
        this.fieldMapper.put("feepayer", "payerfeetype");
        this.fieldMapper.put("feecurrency", "payerfeecurrency");
        this.fieldMapper.put("paymethod", "paymentmethod");
        this.fieldMapper.put("serlevel", "servicelevel");
        this.fieldMapper.put("agreedrate", "tolexchangerate");
        this.fieldMapper.put("recroutingnum", "incomebankcode");
        this.fieldMapper.put("currency", "currency");
        this.fieldMapper.put("contractno", "excontract");
        this.fieldMapper.put("recbankaddress", "incomeradds");
        this.fieldMapper.put("sendway", "deliverymethod");
        this.fieldMapper.put("checktype", "chequetype");
        this.fieldMapper.put("checkuse", "chequeusage");
    }

    @Override
    public DynamicObject convertToTargetBill(DynamicObject sourceBill) {
        DynamicObject transType;
        DynamicObject bankPayingBill = super.convertToTargetBill(sourceBill);
        if (!this.isBizBillCommitBe() && this.isBankBillAudit()) {
            bankPayingBill.set("billstatus", (Object)BillStatusEnum.SAVE.getValue());
        } else {
            bankPayingBill.set("billstatus", (Object)BillStatusEnum.SUBMIT.getValue());
        }
        bankPayingBill.set("bankpaystate", (Object)BeBillStatusEnum.OP.getValue());
        DynamicObject company = bankPayingBill.getDynamicObject("company");
        bankPayingBill.set("billno", (Object)CodeRuleHelper.generateNumber((String)"bei_bankpaybill", (DynamicObject)bankPayingBill, (String)company.getPkValue().toString(), null));
        bankPayingBill.set("isbitback", (Object)"0");
        bankPayingBill.set("bankinterface", (Object)"OP");
        bankPayingBill.set("creator", (Object)Long.valueOf(RequestContext.get().getUserId()));
        bankPayingBill.set("createtime", (Object)new Date());
        bankPayingBill.set("srcbilltype", (Object)this.getSourceEntityKey());
        bankPayingBill.set("bizdate", (Object)new Date());
        bankPayingBill.set("applyorg", ((DynamicObject)bankPayingBill.get("company")).getPkValue());
        DynamicObject proxyBank = sourceBill.getDynamicObject("payproxybank");
        if (proxyBank != null) {
            proxyBank = BusinessDataServiceHelper.loadSingle((Object)proxyBank.getPkValue(), (String)proxyBank.getDataEntityType().getName());
            String proxyAcctNumber = proxyBank.getString("proxyacct");
            bankPayingBill.set("proxyaccno", (Object)proxyAcctNumber);
            String proxyAcctName = null;
            DynamicObject proxyAcct = BusinessDataServiceHelper.loadSingle((String)"bd_accountbanks", (String)"acctname", (QFilter[])new QFilter[]{new QFilter("bankaccountnumber", "=", (Object)proxyAcctNumber)});
            if (proxyAcct != null) {
                proxyAcctName = proxyAcct.getString("acctname");
            } else {
                DynamicObject openOrg = sourceBill.getDynamicObject("openorg");
                if (openOrg != null) {
                    proxyAcctName = openOrg.getString("name");
                }
            }
            bankPayingBill.set("proxyaccname", (Object)proxyAcctName);
            DynamicObject country = proxyBank.getDynamicObject("country");
            String countryName = null;
            if (country != null) {
                country = BusinessDataServiceHelper.loadSingle((Object)country.getPkValue(), (String)country.getDataEntityType().getName());
                countryName = country.getString("simplespell");
            }
            bankPayingBill.set("proxybankcountry", countryName);
            bankPayingBill.set("proxybankarea", countryName);
            bankPayingBill.set("proxyswiftcode", (Object)proxyBank.getString("swift_code"));
            bankPayingBill.set("proxybankname", (Object)proxyBank.getDynamicObject("bankname").getLocaleString("name").getLocaleValue());
            bankPayingBill.set("proxybankadds", (Object)proxyBank.getString("address"));
        }
        if ((transType = sourceBill.getDynamicObject("transtype")) != null) {
            bankPayingBill.set("transremarks", (Object)transType.getLocaleString("name").getLocaleValue());
        }
        bankPayingBill.set("usecn", (Object)sourceBill.getDynamicObject("crosstrantype").getLocaleString("name").getLocaleValue());
        DynamicObject feeAcct = sourceBill.getDynamicObject("feeactbank");
        if (feeAcct != null) {
            bankPayingBill.set("payerfeeaccno", (Object)feeAcct.getString("number"));
        }
        return bankPayingBill;
    }

    @Override
    public String getSourceEntityKey() {
        return "cas_paybill";
    }

    @Override
    public String getTargetEntityKey() {
        return "bei_bankpaybill";
    }

    @Override
    public String getTargetField(String sourceField) {
        return this.fieldMapper.get(sourceField);
    }

    @Override
    public String getSourceField(String targetField) {
        for (Map.Entry<String, String> entry : this.fieldMapper.entrySet()) {
            if (!entry.getValue().equalsIgnoreCase(targetField)) continue;
            return entry.getKey();
        }
        return null;
    }

    @Override
    protected Map<String, String> getMapper() {
        return this.fieldMapper;
    }

    @Override
    public List<String> getGroupFields() {
        ArrayList<String> groupByFields = new ArrayList<String>(this.fieldMapper.keySet());
        groupByFields.remove("id");
        groupByFields.remove("billno");
        groupByFields.remove("actpayamt");
        return groupByFields;
    }

    @Override
    public List<String> getSummaryFields() {
        ArrayList<String> summaryFields = new ArrayList<String>();
        summaryFields.add("actpayamt");
        return summaryFields;
    }
}

