/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.convert;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.fi.cas.business.convert.AbstractPayBillConverter;
import kd.fi.cas.enums.BeBillStatusEnum;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.helper.CodeRuleHelper;

public class PaymentBillConverter
extends AbstractPayBillConverter {
    private Map<String, String> fieldMapper = new HashMap<String, String>();

    public PaymentBillConverter() {
        this.fieldMapper.put("org", "company");
        this.fieldMapper.put("payeracctbank", "accountbank");
        this.fieldMapper.put("payerbank", "bank");
        this.fieldMapper.put("currency", "currency");
        this.fieldMapper.put("id", "sourcebillid");
        this.fieldMapper.put("usage", "usage");
        this.fieldMapper.put("expectdate", "expectdealtime");
        this.fieldMapper.put("actpayamt", "amount");
        this.fieldMapper.put("recaccbankname", "payeename");
        this.fieldMapper.put("payeebanknum", "payeeacct");
        this.fieldMapper.put("payeebankname", "payeebank");
        this.fieldMapper.put("recbanknumber", "recbanknumber");
        this.fieldMapper.put("reccountry", "reccountry");
        this.fieldMapper.put("recprovince", "recprovince");
        this.fieldMapper.put("reccity", "reccity");
        this.fieldMapper.put("ispersonpay", "isprivatepay");
    }

    @Override
    public DynamicObject convertToTargetBill(DynamicObject sourceBill) {
        DynamicObject bankPayingBill = super.convertToTargetBill(sourceBill);
        if (!this.isBizBillCommitBe() && this.isBankBillAudit()) {
            bankPayingBill.set("billstatus", (Object)BillStatusEnum.SAVE.getValue());
        } else {
            bankPayingBill.set("billstatus", (Object)BillStatusEnum.SUBMIT.getValue());
        }
        bankPayingBill.set("bankpaystate", (Object)BeBillStatusEnum.OP.getValue());
        DynamicObject company = bankPayingBill.getDynamicObject("company");
        bankPayingBill.set("billno", (Object)CodeRuleHelper.generateNumber((String)"bei_bankpaybill", (DynamicObject)bankPayingBill, (String)company.getPkValue().toString(), null));
        bankPayingBill.set("isbitback", (Object)"0");
        bankPayingBill.set("bankinterface", (Object)"OP");
        bankPayingBill.set("creator", (Object)Long.valueOf(RequestContext.get().getUserId()));
        bankPayingBill.set("createtime", (Object)new Date());
        bankPayingBill.set("srcbilltype", (Object)this.getSourceEntityKey());
        bankPayingBill.set("bizdate", (Object)new Date());
        bankPayingBill.set("applyorg", ((DynamicObject)bankPayingBill.get("company")).getPkValue());
        return bankPayingBill;
    }

    @Override
    public String getSourceEntityKey() {
        return "cas_paybill";
    }

    @Override
    public String getTargetEntityKey() {
        return "bei_bankpaybill";
    }

    @Override
    public String getTargetField(String sourceField) {
        return this.fieldMapper.get(sourceField);
    }

    @Override
    public String getSourceField(String targetField) {
        for (Map.Entry<String, String> entry : this.fieldMapper.entrySet()) {
            if (!entry.getValue().equalsIgnoreCase(targetField)) continue;
            return entry.getKey();
        }
        return null;
    }

    @Override
    protected Map<String, String> getMapper() {
        return this.fieldMapper;
    }

    @Override
    public List<String> getGroupFields() {
        ArrayList<String> groupByFields = new ArrayList<String>(this.fieldMapper.keySet());
        groupByFields.remove("id");
        groupByFields.remove("billno");
        groupByFields.remove("actpayamt");
        return groupByFields;
    }

    @Override
    public List<String> getSummaryFields() {
        ArrayList<String> summaryFields = new ArrayList<String>();
        summaryFields.add("actpayamt");
        return summaryFields;
    }
}

