/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.ebank;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.fi.cas.consts.FetchDataReponse;

public interface EBankFileCreateAPI {
    public static final Log logger = LogFactory.getLog(EBankFileCreateAPI.class);

    default public InputStream createFileContent(String message) {
        return new ByteArrayInputStream(message.getBytes(StandardCharsets.UTF_8));
    }

    public InputStream createFileContent(FetchDataReponse var1, Object ... var2) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public String writeTemporaryFile(InputStream inStream, String name) throws IOException {
        String url = null;
        int timeout = 10000;
        try {
            url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(name, inStream, timeout);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        finally {
            if (inStream != null) {
                inStream.close();
            }
        }
        return url;
    }

    default public String getTemporaryFilename(String billName, String expandType) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddhhmmssSSS");
        String currDateTime = dateFormat.format(new Date());
        String userName = RequestContext.get().getUserName();
        return String.format("%s-%s-%s%s", billName, currDateTime, userName, expandType);
    }

    default public void showErrMessage(List<String> errMessageList, int successCount, IFormView view) {
        if (!CollectionUtils.isEmpty(errMessageList)) {
            int errSize = errMessageList.size();
            view.showMessage(String.format(ResManager.loadKDString((String)"\u672c\u6b21\u5bfc\u51fa\u5171%1$s\u6761\uff0c\u5176\u4e2d\u6210\u529f%2$s\u6761\uff0c\u5931\u8d25%3$s\u6761\u3002\u8bf7\u786e\u8ba4\u4ee5\u4e0b\u9519\u8bef\u6d88\u606f\uff1a", (String)"EBankFileCreateAPI_1", (String)"fi-cas-business", (Object[])new Object[0]), successCount + errSize, successCount, errSize), errMessageList.stream().reduce((a, b) -> a + '\n' + b).orElseGet(() -> ""), MessageTypes.Default);
        }
    }
}

