/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.ebank.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.business.ebank.EBankFileCreateAPI;
import kd.fi.cas.consts.ExportDetail;
import kd.fi.cas.consts.ExportHeader;
import kd.fi.cas.consts.FetchDataReponse;
import kd.fi.cas.enums.ValueTypeEnum;
import kd.fi.cas.util.DateUtils;
import kd.fi.cas.util.EmptyUtil;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class EBankExcelFileCreateImpl
implements EBankFileCreateAPI {
    private static final Log logger = LogFactory.getLog(EBankExcelFileCreateImpl.class);
    private static final int MAX_LENGTH = 50;
    private IFormView view = null;
    private String pageSign = null;

    public EBankExcelFileCreateImpl(IFormView view, String pageSign) {
        this.view = view;
        this.pageSign = pageSign;
    }

    @Override
    public InputStream createFileContent(FetchDataReponse response, Object ... param) throws IOException {
        SXSSFWorkbook wb = new SXSSFWorkbook(-1);
        ExportHeader header = response.getHeader();
        Map headerInfo = (Map)header.getHeader().get("body");
        Map details = (Map)response.getBody().getDetails().get("body");
        ArrayList headNameList = new ArrayList(headerInfo.size());
        for (Map.Entry e : headerInfo.entrySet()) {
            headNameList.add(e.getKey());
        }
        String[] headNameE = headNameList.toArray(new String[0]);
        CellStyle style = wb.createCellStyle();
        CellStyle commonStyle = wb.createCellStyle();
        style.setFillForegroundColor(IndexedColors.YELLOW.getIndex());
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        style.setAlignment(HorizontalAlignment.CENTER);
        commonStyle.setAlignment(HorizontalAlignment.CENTER);
        SXSSFSheet sheet = this.createSheet(wb, param[0]);
        SXSSFRow createRow = sheet.createRow(0);
        ArrayList<Integer> columnLength = new ArrayList<Integer>();
        this.setRecordedStyle(style, commonStyle, headNameE, columnLength, (Map)header.getIsRecord().get("body"), createRow);
        int count = 1;
        CellStyle errorStyle = wb.createCellStyle();
        Font createFont = wb.createFont();
        createFont.setColor(IndexedColors.RED.getIndex());
        errorStyle.setFont(createFont);
        DataFormat decimalDataFormat = wb.createDataFormat();
        CellStyle dateStyle = wb.createCellStyle();
        DataFormat createDataFormat = wb.createDataFormat();
        dateStyle.setDataFormat(createDataFormat.getFormat("yyyy/MM/dd"));
        int dateLength = 12;
        try {
            dateLength = this.getCellLength("yyyy/MM/dd  hh:mm:ss");
        }
        catch (UnsupportedEncodingException e1) {
            logger.error((Throwable)e1);
        }
        int curLength = 8;
        String amountAccuracy = "0.";
        StringBuilder tempStr = new StringBuilder();
        List failureIds = response.getBody().getFailureDatas().entrySet().stream().map(o -> (Long)o.getKey()).collect(Collectors.toList());
        DynamicObject[] objects = BusinessDataServiceHelper.load((String)this.pageSign, (String)"id,billno", (QFilter[])new QFilter[]{new QFilter("id", "in", failureIds)});
        Map failureDatas = response.getBody().getFailureDatas();
        int detailSize = Optional.ofNullable(details).map(o -> o.size()).orElseGet(() -> 0);
        this.showErrMessage(Arrays.stream(objects).map(o -> {
            String billNoStr = o.getString("billno");
            String errMsg = (String)failureDatas.get(o.getPkValue());
            return String.format("%s: %s", billNoStr, errMsg);
        }).collect(Collectors.toList()), detailSize, this.view);
        if (detailSize == 0) {
            return null;
        }
        logger.info("\u5f00\u59cb\u586b\u5145 excel \u5355\u5143\u683c\u6570\u636e");
        for (Map.Entry detail : details.entrySet()) {
            createRow = sheet.createRow(count++);
            for (int i = 0; i < headNameE.length; ++i) {
                amountAccuracy = "0.";
                tempStr = new StringBuilder();
                ExportDetail temp = (ExportDetail)((Map)detail.getValue()).get(headNameE[i]);
                Object fieldValue = temp.getFieldValue();
                SXSSFCell createCell = createRow.createCell(i);
                CellStyle rowDataStyle1 = wb.createCellStyle();
                rowDataStyle1.setAlignment(HorizontalAlignment.RIGHT);
                String fieldType = temp.getFieldType();
                curLength = 8;
                try {
                    if (fieldValue != null && !fieldValue.equals("null")) {
                        if (StringUtils.equals((CharSequence)ValueTypeEnum.TP_TEXT.getValue(), (CharSequence)fieldType)) {
                            if (fieldValue.toString().indexOf(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u8868\u8fbe\u5f0f\u662f\u5426\u9519\u8bef\uff1a", (String)"EBankMessageDataAPIImpl_0", (String)"fi-cas-formplugin", (Object[])new Object[0])) != -1 || fieldValue.toString().indexOf(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u51fd\u6570\u6620\u5c04\u3002", (String)"EBankMessageDataAPIImpl_1", (String)"fi-cas-formplugin", (Object[])new Object[0])) != -1) {
                                createCell.setCellStyle(errorStyle);
                            }
                            createCell.setCellValue(fieldValue.toString());
                            curLength = this.getCellLength(fieldValue.toString());
                        } else if (StringUtils.equals((CharSequence)ValueTypeEnum.TP_MONEY.getValue(), (CharSequence)fieldType)) {
                            int amtprecision = temp.getAmtprecision();
                            if (fieldValue instanceof String) {
                                createCell.setCellValue(fieldValue.toString());
                                curLength = this.getCellLength(fieldValue.toString());
                                columnLength.set(i, Math.max((Integer)columnLength.get(i), curLength * 256));
                                createCell.setCellStyle(errorStyle);
                                continue;
                            }
                            if (amtprecision > 0) {
                                for (int j = 0; j < amtprecision; ++j) {
                                    amountAccuracy = amountAccuracy + "0";
                                    tempStr.append("0");
                                }
                                rowDataStyle1.setDataFormat(decimalDataFormat.getFormat("#,##" + amountAccuracy));
                            } else {
                                rowDataStyle1.setDataFormat(decimalDataFormat.getFormat("#,##0"));
                            }
                            createCell.setCellStyle(rowDataStyle1);
                            BigDecimal tempAmount = new BigDecimal(fieldValue.toString());
                            createCell.setCellValue(tempAmount.doubleValue());
                            StringBuilder tempString = new StringBuilder();
                            tempString.append(tempAmount.intValue());
                            tempString.append((CharSequence)tempStr);
                            tempString.append(".00000");
                            curLength = this.getCellLength(tempString.toString());
                        } else if (StringUtils.equals((CharSequence)ValueTypeEnum.TP_DATE.getValue(), (CharSequence)fieldType)) {
                            try {
                                Date stringToDate = DateUtils.stringToDate((String)fieldValue.toString(), (String)"yyyy-MM-dd");
                                createCell.setCellValue(stringToDate);
                                createCell.setCellStyle(dateStyle);
                                curLength = dateLength;
                            }
                            catch (Exception ew) {
                                createCell.setCellValue(fieldValue.toString());
                                curLength = fieldValue.toString().length();
                                createCell.setCellStyle(errorStyle);
                            }
                        } else if (!StringUtils.equals((CharSequence)ValueTypeEnum.TP_COUNT.getValue(), (CharSequence)fieldType) && StringUtils.equals((CharSequence)ValueTypeEnum.TP_SERIALNUM.getValue(), (CharSequence)fieldType)) {
                            createCell.setCellValue(fieldValue.toString());
                        }
                    }
                    logger.info(String.format("\u672c\u6b21\u7684\u6570\u636e\u7c7b\u578b\u4e3a: %s\uff0c\u586b\u5145\u7684\u503c\u4e3a: %s", ValueTypeEnum.getName((String)fieldType), fieldValue));
                }
                catch (UnsupportedEncodingException e) {
                    logger.error((Throwable)e);
                }
                catch (Exception e) {
                    logger.error((Throwable)e);
                    createCell.setCellValue(e.getMessage());
                }
                columnLength.set(i, Math.max((Integer)columnLength.get(i), curLength * 256));
            }
        }
        this.setCloumnLen(headNameE, columnLength, sheet);
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        wb.write((OutputStream)outStream);
        outStream.flush();
        ByteArrayInputStream inStream = new ByteArrayInputStream(outStream.toByteArray());
        return inStream;
    }

    private void setCloumnLen(String[] headNameE, List columnLength, SXSSFSheet sheet) {
        for (int i = 0; i < headNameE.length; ++i) {
            int length = (Integer)columnLength.get(i) / 256;
            if (length > 50) {
                sheet.setColumnWidth(i, 12800);
                continue;
            }
            sheet.setColumnWidth(i, ((Integer)columnLength.get(i)).intValue());
        }
    }

    private int getCellLength(String str) throws UnsupportedEncodingException {
        return str.getBytes("GBK").length + 2;
    }

    private void setRecordedStyle(CellStyle style, CellStyle commonStyle, String[] headNameE, List columnLength, Map<String, Boolean> isRecord, SXSSFRow createRow) {
        for (int i = 0; i < headNameE.length; ++i) {
            SXSSFCell createCell = createRow.createCell(i);
            createCell.setCellValue(headNameE[i]);
            try {
                columnLength.add(this.getCellLength(headNameE[i]) * 256);
            }
            catch (UnsupportedEncodingException e) {
                logger.error((Throwable)e);
                columnLength.add(3072);
            }
            boolean isRecord0 = isRecord.get(headNameE[i]);
            if (isRecord0) {
                createCell.setCellStyle(style);
                continue;
            }
            createCell.setCellStyle(commonStyle);
        }
    }

    private SXSSFSheet createSheet(SXSSFWorkbook wb, Object sheetName) {
        SXSSFSheet sheet;
        if (sheetName != null && EmptyUtil.isNotEmpty((String)sheetName.toString())) {
            sheet = wb.createSheet(sheetName.toString());
        } else {
            int index = wb.getNumberOfSheets() + 1;
            sheet = wb.createSheet(String.format("sheet_%s", index));
        }
        return sheet;
    }
}

