/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.ebservice;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.extplugin.PluginProxy;
import kd.bos.isv.ISVService;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.business.ebservice.bean.PayDetail;
import kd.fi.cas.business.ebservice.bean.PayInfo;
import kd.fi.cas.enums.BeBillStatusEnum;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.enums.PayBusinessTypeEnum;
import kd.fi.cas.enums.ProceedsTypeEnum;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.AgentPayBillHelper;
import kd.fi.cas.helper.BeiParameterHelper;
import kd.fi.cas.util.EmptyUtil;
import kd.sdk.fi.cas.extpoint.paybill.IGenBankBillSDKService;

public class PayInfoFactory {
    public static List<PayInfo> createPayInfo(List<DynamicObject> payBillList) {
        if (payBillList.size() == 0) {
            return Collections.emptyList();
        }
        String billName = payBillList.get(0).getDataEntityType().getName();
        if ("cas_paybill".equals(billName)) {
            return PayInfoFactory.createPaymentBillInfo(payBillList);
        }
        if ("cas_agentpaybill".equals(billName)) {
            return PayInfoFactory.createAgentPayBillInfo(payBillList);
        }
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u4ed8\u6b3e\u5355\u636e\u7c7b\u578b: %s\u3002", (String)"PayInfoFactory_0", (String)"fi-cas-business", (Object[])new Object[0]), billName));
    }

    public static List<PayInfo> createAgentPayBillInfo(List<DynamicObject> agentPayBillList) {
        Set proxyBankSet = agentPayBillList.stream().filter(o -> o.getBoolean("iscrosspay")).map(o -> o.getDynamicObject("payproxybank")).filter(Objects::nonNull).map(o -> (Long)o.getPkValue()).collect(Collectors.toSet());
        Map proxyBankMap = BusinessDataServiceHelper.loadFromCache((Object[])proxyBankSet.stream().filter(Objects::nonNull).toArray(), (String)"bei_proxybank");
        List proxyAcctNumberList = proxyBankMap.values().stream().map(o -> o.getString("proxyacct")).filter(Objects::nonNull).collect(Collectors.toList());
        DynamicObject[] proxyAcctArr = BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)String.join((CharSequence)"bankaccountnumber", "acctname"), (QFilter[])new QFilter[]{new QFilter("bankaccountnumber", "in", proxyAcctNumberList)});
        HashMap<String, DynamicObject> proxyAcctMap = new HashMap<String, DynamicObject>(proxyAcctArr.length);
        for (DynamicObject acct : proxyAcctArr) {
            proxyAcctMap.put(acct.getString("bankaccountnumber"), acct);
        }
        Set proxyCountryIdSet = proxyBankMap.values().stream().map(o -> o.getDynamicObject("country")).filter(Objects::nonNull).map(o -> (Long)o.getPkValue()).collect(Collectors.toSet());
        Map proxyCountryMap = BusinessDataServiceHelper.loadFromCache((Object[])proxyCountryIdSet.stream().filter(Objects::nonNull).toArray(), (String)"bd_country");
        ArrayList<PayInfo> payInfoList = new ArrayList<PayInfo>(agentPayBillList.size());
        for (DynamicObject agentPayBill : agentPayBillList) {
            PayInfo payInfo = new PayInfo();
            boolean isOverseaPay = agentPayBill.getBoolean("iscrosspay");
            payInfo.setCompanyId((Long)agentPayBill.getDynamicObject("org").getPkValue());
            payInfo.setPayAcctId((Long)agentPayBill.getDynamicObject("payeracctbank").getPkValue());
            payInfo.setPayCurrencyId((Long)agentPayBill.getDynamicObject("currency").getPkValue());
            payInfo.setTotalPayAmt(agentPayBill.getBigDecimal("payamount"));
            payInfo.setTotalLocalAmt(agentPayBill.getBigDecimal("localamt"));
            payInfo.setBillNo(agentPayBill.getString("billno"));
            payInfo.setBillId((Long)agentPayBill.getPkValue());
            payInfo.setPersonalPay(agentPayBill.getBoolean("ispersonpay"));
            payInfo.setEncryption(agentPayBill.getBoolean("isencryption"));
            payInfo.setOverseaPay(isOverseaPay);
            payInfo.setAgencyPersonPay(agentPayBill.getBoolean("isagencypersonpay"));
            payInfo.setBillType("cas_agentpaybill");
            DynamicObjectCollection entryList = agentPayBill.getDynamicObjectCollection("entry");
            ArrayList<PayDetail> payDetailList = new ArrayList<PayDetail>();
            DynamicObject proxyBank = null;
            DynamicObject proxyAcct = null;
            DynamicObject proxyCountry = null;
            if (isOverseaPay && (proxyBank = agentPayBill.getDynamicObject("payproxybank")) != null) {
                Long proxyBankId = (Long)proxyBank.getPkValue();
                proxyBank = (DynamicObject)proxyBankMap.get(proxyBankId);
                String proxyAcctNumber = proxyBank.getString("proxyacct");
                proxyAcct = (DynamicObject)proxyAcctMap.get(proxyAcctNumber);
                proxyCountry = proxyBank.getDynamicObject("country");
                if (proxyCountry != null) {
                    Long countryId = (Long)proxyCountry.getPkValue();
                    proxyCountry = (DynamicObject)proxyCountryMap.get(countryId);
                }
            }
            for (DynamicObject entry : entryList) {
                PayDetail payDetail = new PayDetail();
                payDetail.setRecName(entry.getString("payeename"));
                payDetail.setRecBankAcct(entry.getString("payeeacctbank"));
                payDetail.setRecBankName(entry.getString("payeebankname"));
                payDetail.setRecBankNum(entry.getString("payeebanknumber"));
                payDetail.setRecAmount(AgentPayBillHelper.decodeAmount((String)((String)entry.get("e_encryptamount"))));
                payDetail.setRemark(entry.getString("e_remark"));
                payDetail.setProvince(entry.getString("recprovince"));
                payDetail.setCity(entry.getString("reccity"));
                payDetail.setEntryId(entry.getString("id"));
                payDetail.setRecEmail(entry.getString("recemail"));
                if (isOverseaPay) {
                    DynamicObject transType;
                    DynamicObject recCountry = entry.getDynamicObject("reccountry");
                    if (recCountry != null) {
                        payDetail.setCountry((Long)recCountry.getPkValue());
                    }
                    payDetail.setFeePayer(agentPayBill.getString("feepayer"));
                    DynamicObject feeCurrency = agentPayBill.getDynamicObject("feecurrency");
                    if (feeCurrency != null) {
                        payDetail.setFeeCurrency((Long)feeCurrency.getPkValue());
                    }
                    payDetail.setPayMethod(entry.getString("paymethod"));
                    payDetail.setRecSwiftCode(entry.getString("recswiftcode"));
                    payDetail.setServiceLevel(agentPayBill.getString("serlevel"));
                    payDetail.setAgreeRate(agentPayBill.getBigDecimal("agreedrate"));
                    payDetail.setContractNo(agentPayBill.getString("contractno"));
                    payDetail.setSendWay(entry.getString("sendway"));
                    payDetail.setCheckType(entry.getString("checktype"));
                    payDetail.setCheckUsage(entry.getString("checkuse"));
                    payDetail.setSettlementMethod(agentPayBill.getString("settlementmethod"));
                    payDetail.setMobile(entry.getString("mobile"));
                    if (proxyBank != null) {
                        payDetail.setProxyAcctNo(proxyBank.getString("proxyacct"));
                        String proxyAcctName = null;
                        if (proxyAcct != null) {
                            proxyAcctName = proxyAcct.getString("acctname");
                        } else {
                            DynamicObject openOrg = agentPayBill.getDynamicObject("openorg");
                            if (openOrg != null) {
                                proxyAcctName = openOrg.getString("name");
                            }
                        }
                        payDetail.setProxyAcctName(proxyAcctName);
                        if (proxyCountry != null) {
                            String proxyCountryName = proxyCountry.getString("simplespell");
                            payDetail.setProxyBankCountry(proxyCountryName);
                            payDetail.setProxyBankArea(proxyCountryName);
                        }
                        payDetail.setProxySwiftCode(proxyBank.getString("swift_code"));
                        payDetail.setProxyBankName(proxyBank.getDynamicObject("bankname").getLocaleString("name").getLocaleValue());
                        payDetail.setProxyBankAddress(proxyBank.getString("address"));
                    }
                    payDetail.setRecBankAddress(entry.getString("recbankaddress"));
                    payDetail.setRecRoutingNum(entry.getString("recroutingnum"));
                    String overseaPayType = agentPayBill.getDynamicObject("crosstrantype").getLocaleString("name").getLocaleValue();
                    payDetail.setUseCN(overseaPayType);
                    DynamicObject feeAcct = agentPayBill.getDynamicObject("feeactbank");
                    if (feeAcct != null) {
                        payDetail.setPayerFeeAcctNo(feeAcct.getString("number"));
                    }
                    if ((transType = entry.getDynamicObject("transtype")) != null) {
                        payDetail.setTransRemarks(transType.getLocaleString("name").getLocaleValue());
                    }
                } else {
                    DynamicObject billType = agentPayBill.getDynamicObject("billtype");
                    if (billType != null) {
                        String billTypeName = billType.getString("name");
                        if (billTypeName.contains(ResManager.loadKDString((String)"\u5de5\u8d44", (String)"PayInfoFactory_1", (String)"fi-cas-business", (Object[])new Object[0]))) {
                            payDetail.setUseCN(ResManager.loadKDString((String)"\u5de5\u8d44", (String)"PayInfoFactory_1", (String)"fi-cas-business", (Object[])new Object[0]));
                        } else if (billTypeName.contains(ResManager.loadKDString((String)"\u62a5\u9500", (String)"PayInfoFactory_2", (String)"fi-cas-business", (Object[])new Object[0]))) {
                            payDetail.setUseCN(ResManager.loadKDString((String)"\u62a5\u9500", (String)"PayInfoFactory_2", (String)"fi-cas-business", (Object[])new Object[0]));
                        }
                    }
                }
                payDetailList.add(payDetail);
            }
            payInfo.setPayDetails(payDetailList);
            payInfoList.add(payInfo);
        }
        return payInfoList;
    }

    public static List<PayInfo> createPaymentBillInfo(List<DynamicObject> paymentBillList) {
        Set proxyBankSet = paymentBillList.stream().filter(o -> o.getBoolean("iscrosspay")).map(o -> o.getDynamicObject("payproxybank")).filter(Objects::nonNull).map(o -> (Long)o.getPkValue()).collect(Collectors.toSet());
        Map proxyBankMap = BusinessDataServiceHelper.loadFromCache((Object[])proxyBankSet.stream().filter(Objects::nonNull).toArray(), (String)"bei_proxybank");
        List proxyAcctNumberList = proxyBankMap.values().stream().map(o -> o.getString("proxyacct")).filter(Objects::nonNull).collect(Collectors.toList());
        DynamicObject[] proxyAcctArr = BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)String.join((CharSequence)"bankaccountnumber", "acctname"), (QFilter[])new QFilter[]{new QFilter("bankaccountnumber", "in", proxyAcctNumberList)});
        HashMap<String, DynamicObject> proxyAcctMap = new HashMap<String, DynamicObject>(proxyAcctArr.length);
        for (DynamicObject acct : proxyAcctArr) {
            proxyAcctMap.put(acct.getString("bankaccountnumber"), acct);
        }
        Set proxyCountryIdSet = proxyBankMap.values().stream().map(o -> o.getDynamicObject("country")).filter(Objects::nonNull).map(o -> (Long)o.getPkValue()).collect(Collectors.toSet());
        Map proxyCountryMap = BusinessDataServiceHelper.loadFromCache((Object[])proxyCountryIdSet.stream().filter(Objects::nonNull).toArray(), (String)"bd_country");
        ArrayList<PayInfo> payInfoList = new ArrayList<PayInfo>(paymentBillList.size());
        for (DynamicObject paymentBill : paymentBillList) {
            PayInfo payInfo = new PayInfo();
            boolean isOverseaPay = paymentBill.getBoolean("iscrosspay");
            payInfo.setCompanyId((Long)paymentBill.getDynamicObject("org").getPkValue());
            payInfo.setPayAcctId((Long)paymentBill.getDynamicObject("payeracctbank").getPkValue());
            payInfo.setPayBankId((Long)paymentBill.getDynamicObject("payerbank").getPkValue());
            payInfo.setPayCurrencyId((Long)paymentBill.getDynamicObject("currency").getPkValue());
            payInfo.setTotalPayAmt(paymentBill.getBigDecimal("actpayamt"));
            payInfo.setTotalLocalAmt(paymentBill.getBigDecimal("localamt"));
            payInfo.setBillNo(paymentBill.getString("billno"));
            payInfo.setBillId((Long)paymentBill.getPkValue());
            payInfo.setPersonalPay(paymentBill.getBoolean("ispersonpay"));
            payInfo.setEncryption(false);
            payInfo.setOverseaPay(isOverseaPay);
            payInfo.setBillType("cas_paybill");
            payInfo.setRecEmail(paymentBill.getString("recemail"));
            DynamicObject proxyBank = null;
            DynamicObject proxyAcct = null;
            DynamicObject proxyCountry = null;
            if (isOverseaPay && (proxyBank = paymentBill.getDynamicObject("payproxybank")) != null) {
                Long proxyBankId = (Long)proxyBank.getPkValue();
                proxyBank = (DynamicObject)proxyBankMap.get(proxyBankId);
                String proxyAcctNumber = proxyBank.getString("proxyacct");
                proxyAcct = (DynamicObject)proxyAcctMap.get(proxyAcctNumber);
                proxyCountry = proxyBank.getDynamicObject("country");
                if (proxyCountry != null) {
                    Long countryId = (Long)proxyCountry.getPkValue();
                    proxyCountry = (DynamicObject)proxyCountryMap.get(countryId);
                }
            }
            ArrayList<PayDetail> payDetailList = new ArrayList<PayDetail>();
            PayDetail payDetail = new PayDetail();
            payDetail.setRecName(paymentBill.getString("recaccbankname"));
            payDetail.setRecBankAcct(paymentBill.getString("payeebanknum"));
            payDetail.setRecBankName(paymentBill.getString("payeebankname"));
            payDetail.setRecBankNum(paymentBill.getString("recbanknumber"));
            payDetail.setRecAmount(paymentBill.getBigDecimal("actpayamt"));
            payDetail.setRemark(paymentBill.getString("usage"));
            DynamicObject recCountry = paymentBill.getDynamicObject("reccountry");
            if (recCountry != null) {
                payDetail.setCountry((Long)recCountry.getPkValue());
            }
            payDetail.setProvince(paymentBill.getString("recprovince"));
            payDetail.setCity(paymentBill.getString("reccity"));
            payDetail.setEntryId(paymentBill.getString("id"));
            payDetail.setExpectDate(paymentBill.getDate("expectdate"));
            if (isOverseaPay) {
                DynamicObject transType;
                payDetail.setFeePayer(paymentBill.getString("feepayer"));
                DynamicObject feeCurrency = paymentBill.getDynamicObject("feecurrency");
                if (feeCurrency != null) {
                    payDetail.setFeeCurrency((Long)feeCurrency.getPkValue());
                }
                payDetail.setPayMethod(paymentBill.getString("paymethod"));
                payDetail.setRecSwiftCode(paymentBill.getString("recswiftcode"));
                payDetail.setServiceLevel(paymentBill.getString("serlevel"));
                payDetail.setAgreeRate(paymentBill.getBigDecimal("agreedrate"));
                payDetail.setContractNo(paymentBill.getString("contractno"));
                payDetail.setSendWay(paymentBill.getString("sendway"));
                payDetail.setCheckType(paymentBill.getString("checktype"));
                payDetail.setCheckUsage(paymentBill.getString("checkuse"));
                payDetail.setSettlementMethod(paymentBill.getString("settlementmethod"));
                payDetail.setMobile(paymentBill.getString("mobile"));
                if (proxyBank != null) {
                    payDetail.setProxyAcctNo(proxyBank.getString("proxyacct"));
                    String proxyAcctName = null;
                    if (proxyAcct != null) {
                        proxyAcctName = proxyAcct.getString("acctname");
                    } else {
                        DynamicObject openOrg = paymentBill.getDynamicObject("openorg");
                        if (openOrg != null) {
                            proxyAcctName = openOrg.getString("name");
                        }
                    }
                    payDetail.setProxyAcctName(proxyAcctName);
                    if (proxyCountry != null) {
                        String proxyCountryName = proxyCountry.getString("simplespell");
                        payDetail.setProxyBankCountry(proxyCountryName);
                        payDetail.setProxyBankArea(proxyCountryName);
                    }
                    payDetail.setProxySwiftCode(proxyBank.getString("swift_code"));
                    payDetail.setProxyBankName(proxyBank.getDynamicObject("bankname").getLocaleString("name").getLocaleValue());
                    payDetail.setProxyBankAddress(proxyBank.getString("address"));
                }
                payDetail.setRecBankAddress(paymentBill.getString("recbankaddress"));
                payDetail.setRecRoutingNum(paymentBill.getString("recroutingnum"));
                String overseaPayType = paymentBill.getDynamicObject("crosstrantype").getLocaleString("name").getLocaleValue();
                payDetail.setUseCN(overseaPayType);
                DynamicObject feeAcct = paymentBill.getDynamicObject("feeactbank");
                if (feeAcct != null) {
                    payDetail.setPayerFeeAcctNo(feeAcct.getString("number"));
                }
                if ((transType = paymentBill.getDynamicObject("transtype")) != null) {
                    payDetail.setTransRemarks(transType.getLocaleString("name").getLocaleValue());
                }
            }
            payDetailList.add(payDetail);
            payInfo.setPayDetails(payDetailList);
            payInfoList.add(payInfo);
        }
        return payInfoList;
    }

    public static List<DynamicObject> transPayBillToBankPayBill(List<DynamicObject> payInfoList) {
        ArrayList<DynamicObject> billList = new ArrayList<DynamicObject>(payInfoList.size());
        Set proxyBankSet = payInfoList.stream().filter(o -> o.getBoolean("iscrosspay")).map(o -> o.getDynamicObject("payproxybank")).filter(Objects::nonNull).map(o -> (Long)o.getPkValue()).collect(Collectors.toSet());
        Map proxyBankMap = BusinessDataServiceHelper.loadFromCache((Object[])proxyBankSet.stream().filter(Objects::nonNull).toArray(), (String)"bei_proxybank");
        List proxyAcctNumberList = proxyBankMap.values().stream().map(o -> o.getString("proxyacct")).filter(Objects::nonNull).collect(Collectors.toList());
        DynamicObject[] proxyAcctArr = BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)String.join((CharSequence)"bankaccountnumber", "acctname"), (QFilter[])new QFilter[]{new QFilter("bankaccountnumber", "in", proxyAcctNumberList)});
        Set proxyCountryIdSet = proxyBankMap.values().stream().map(o -> o.getDynamicObject("country")).filter(Objects::nonNull).map(o -> (Long)o.getPkValue()).collect(Collectors.toSet());
        Map proxyCountryMap = BusinessDataServiceHelper.loadFromCache((Object[])proxyCountryIdSet.stream().filter(Objects::nonNull).toArray(), (String)"bd_country");
        MainEntityType bankPayBillEntityType = EntityMetadataCache.getDataEntityType((String)"bei_bankpaybill");
        long[] idArr = DB.genLongIds((String)"bei_bankpaybill", (int)payInfoList.size());
        for (int k = 0; k < payInfoList.size(); ++k) {
            DynamicObject paymentBill = payInfoList.get(k);
            DynamicObject bankPayBill = new DynamicObject((DynamicObjectType)bankPayBillEntityType);
            bankPayBill.set("id", (Object)idArr[k]);
            bankPayBill.set("company", (Object)paymentBill.getDynamicObject("org"));
            bankPayBill.set("applyorg", (Object)paymentBill.getDynamicObject("org"));
            String businessType = paymentBill.getString("businesstype");
            boolean chageDirect = PayBusinessTypeEnum.WALLETUP.getValue().equals(businessType);
            DynamicObject payAccount = paymentBill.getDynamicObject("payeracctbank");
            String recAccStr = paymentBill.getString("payeebanknum");
            DynamicObject payBank = paymentBill.getDynamicObject("payerbank");
            String recBankNumber = paymentBill.getString("recbanknumber");
            DynamicObject recAccount = null;
            DynamicObject recBank = null;
            if (chageDirect) {
                recAccount = AccountBankHelper.getAccountByNumber((String)recAccStr);
                recBank = PayInfoFactory.getBdFinOrginfoById(recAccount.getDynamicObject("bank").getPkValue());
                payBank = PayInfoFactory.getBdFinOrginfoById(payBank.getPkValue());
            }
            bankPayBill.set("accountbank", (Object)(chageDirect ? recAccount : payAccount));
            bankPayBill.set("bank", (Object)(chageDirect ? recBank : payBank));
            bankPayBill.set("currency", (Object)paymentBill.getDynamicObject("currency"));
            bankPayBill.set("amount", (Object)paymentBill.getBigDecimal("actpayamt"));
            bankPayBill.set("locamt", (Object)paymentBill.getBigDecimal("localamt"));
            bankPayBill.set("sourcebillid", paymentBill.getPkValue());
            bankPayBill.set("payunique", (Object)-1L);
            bankPayBill.set("isprivatepay", (Object)paymentBill.getBoolean("ispersonpay"));
            bankPayBill.set("istranspay", (Object)paymentBill.getBoolean("iscrosspay"));
            bankPayBill.set("isdiffcur", (Object)paymentBill.getBoolean("isdiffcur"));
            bankPayBill.set("srcbillno", (Object)paymentBill.getString("billno"));
            bankPayBill.set("expectdealtime", (Object)paymentBill.getDate("expectdate"));
            bankPayBill.set("usage", (Object)paymentBill.getString("usage"));
            bankPayBill.set("recbanknumber", (Object)(chageDirect ? payBank.getString("union_number") : recBankNumber));
            bankPayBill.set("payeename", (Object)(chageDirect ? payAccount.getString("acctname") : paymentBill.getString("recaccbankname")));
            bankPayBill.set("reccountry", (Object)(chageDirect ? payBank.getDynamicObject("country") : paymentBill.getDynamicObject("reccountry")));
            bankPayBill.set("recprovince", (Object)(chageDirect ? payBank.getDynamicObject("province").getString("name") : paymentBill.getString("recprovince")));
            bankPayBill.set("reccity", (Object)(chageDirect ? payBank.getDynamicObject("city").getString("name") : paymentBill.getString("reccity")));
            bankPayBill.set("paybillauditor", (Object)paymentBill.getDynamicObject("auditor"));
            bankPayBill.set("paybillcreator", (Object)paymentBill.getDynamicObject("creator"));
            bankPayBill.set("srcbilltype", (Object)"cas_paybill");
            bankPayBill.set("bizdate", (Object)new Date());
            bankPayBill.set("isbitback", (Object)Boolean.FALSE);
            bankPayBill.set("bankpaystate", (Object)BeBillStatusEnum.OP.getValue());
            bankPayBill.set("bankinterface", (Object)BeBillStatusEnum.OP.getValue());
            bankPayBill.set("creator", (Object)RequestContext.get().getCurrUserId());
            bankPayBill.set("createtime", (Object)new Date());
            bankPayBill.set("netbankacct", (Object)paymentBill.getDynamicObject("netbankacct"));
            bankPayBill.set("description", (Object)paymentBill.getString("description"));
            bankPayBill.set("isurgent", (Object)paymentBill.getBoolean("urgentflag"));
            bankPayBill.set("businesstype", (Object)businessType);
            bankPayBill.set("institutioncode", (Object)paymentBill.getString("institutioncode"));
            bankPayBill.set("institutionname", (Object)paymentBill.getString("institutionname"));
            bankPayBill.set("declaretype", (Object)paymentBill.getString("declaretype"));
            Long companyId = (Long)paymentBill.getDynamicObject("org").getPkValue();
            boolean isBankBillAudit = BeiParameterHelper.getParameterBoolean((long)companyId, (String)"bei002");
            boolean isNeedCommitBe = BeiParameterHelper.isBizBillCommitBe((long)companyId);
            if (!isNeedCommitBe && isBankBillAudit) {
                bankPayBill.set("billstatus", (Object)BillStatusEnum.SAVE.getValue());
            } else {
                bankPayBill.set("billstatus", (Object)BillStatusEnum.SUBMIT.getValue());
            }
            DynamicObject settleType = paymentBill.getDynamicObject("settletype");
            Boolean isLinkPay = settleType.getBoolean("is_linkage_payment");
            if (isLinkPay.booleanValue()) {
                bankPayBill.set("islinkpay", (Object)isLinkPay);
                bankPayBill.set("parentacctbank", (Object)paymentBill.getDynamicObject("parentacct"));
                bankPayBill.set("childacctbank", (Object)payAccount);
            }
            if (paymentBill.getBoolean("isdiffcur")) {
                bankPayBill.set("exchangecurrency", (Object)paymentBill.getDynamicObject("dpcurrency"));
            }
            if (paymentBill.getBoolean("iscrosspay")) {
                DynamicObject transType;
                String overseaPayType = paymentBill.getDynamicObject("crosstrantype").getLocaleString("name").getLocaleValue();
                bankPayBill.set("usecn", (Object)overseaPayType);
                bankPayBill.set("incomeswiftcode", (Object)paymentBill.getString("recswiftcode"));
                bankPayBill.set("payerfeetype", (Object)paymentBill.getString("feepayer"));
                bankPayBill.set("payerfeecurrency", (Object)paymentBill.getDynamicObject("feecurrency"));
                bankPayBill.set("paymentmethod", (Object)paymentBill.getString("paymethod"));
                bankPayBill.set("servicelevel", (Object)paymentBill.getString("serlevel"));
                bankPayBill.set("tolexchangerate", (Object)paymentBill.getBigDecimal("agreedrate"));
                bankPayBill.set("incomebankcode", (Object)paymentBill.getString("recroutingnum"));
                bankPayBill.set("excontract", (Object)paymentBill.getString("contractno"));
                bankPayBill.set("payeraddress", (Object)paymentBill.getDynamicObject("org").getString("contactaddress"));
                bankPayBill.set("recbankadds", (Object)paymentBill.getString("recbankaddress"));
                bankPayBill.set("incomeradds", (Object)paymentBill.getString("recaddress"));
                bankPayBill.set("deliverymethod", (Object)paymentBill.getString("sendway"));
                bankPayBill.set("chequetype", (Object)paymentBill.getString("checktype"));
                bankPayBill.set("chequeusage", (Object)paymentBill.getString("checkuse"));
                bankPayBill.set("proxyaccno", (Object)paymentBill.getString("proxybebankactno"));
                DynamicObject proxyCountry = paymentBill.getDynamicObject("proxybebankcountry");
                if (EmptyUtil.isNoEmpty((DynamicObject)proxyCountry)) {
                    Map countryMap = BusinessDataServiceHelper.loadFromCache((Object[])new Object[]{proxyCountry.getPkValue()}, (String)"bd_country");
                    proxyCountry = (DynamicObject)countryMap.get(proxyCountry.getPkValue());
                    String proxyCountryName = proxyCountry.getString("simplespell");
                    bankPayBill.set("proxybankcountry", (Object)proxyCountryName);
                    bankPayBill.set("proxybankarea", (Object)proxyCountryName);
                }
                bankPayBill.set("proxyaccname", (Object)paymentBill.getString("proxybebankactname"));
                bankPayBill.set("proxyswiftcode", (Object)paymentBill.getString("proxybebanksc"));
                bankPayBill.set("proxybankname", (Object)paymentBill.getString("proxybebankname"));
                bankPayBill.set("proxybankadds", (Object)paymentBill.getString("proxybebankad"));
                DynamicObject feeAcct = paymentBill.getDynamicObject("feeactbank");
                if (feeAcct != null) {
                    bankPayBill.set("payerfeeaccno", (Object)feeAcct.getString("number"));
                }
                if ((transType = paymentBill.getDynamicObject("transtype")) != null) {
                    bankPayBill.set("transremarks", (Object)transType.getString("number"));
                }
                bankPayBill.set("settlementmethod", (Object)paymentBill.getString("settlementmethod"));
                if (paymentBill.getBoolean("inforpayment")) {
                    bankPayBill.set("inforpayment", (Object)paymentBill.getString("inforpayment"));
                    bankPayBill.set("informrecemail", (Object)paymentBill.getString("informrecemail"));
                }
                if (paymentBill.getString("crosstrantype.number").equals("BOCHK05")) {
                    if (ProceedsTypeEnum.ONE.getValue().equals(paymentBill.getString("paymentterm"))) {
                        bankPayBill.set("paymentfps", (Object)paymentBill.getString("paymentfps"));
                    } else if (ProceedsTypeEnum.TWO.getValue().equals(paymentBill.getString("paymentterm"))) {
                        bankPayBill.set("paymentareacode", (Object)paymentBill.getString("paymentareacode"));
                        bankPayBill.set("mobile", (Object)paymentBill.getString("mobile"));
                    } else if (ProceedsTypeEnum.three.getValue().equals(paymentBill.getString("paymentterm"))) {
                        bankPayBill.set("recemail", (Object)paymentBill.getString("recemail"));
                    } else {
                        bankPayBill.set("payeebank", (Object)paymentBill.getString("payeebankname"));
                        bankPayBill.set("payeeacct", (Object)recAccStr);
                    }
                } else {
                    bankPayBill.set("payeebank", (Object)paymentBill.getString("payeebankname"));
                    bankPayBill.set("payeeacct", (Object)recAccStr);
                    bankPayBill.set("mobile", (Object)paymentBill.getString("mobile"));
                    bankPayBill.set("recemail", (Object)paymentBill.getString("recemail"));
                }
                bankPayBill.set("applyname", (Object)paymentBill.getString("applyname"));
                bankPayBill.set("applyphone", (Object)paymentBill.getString("applyphone"));
                bankPayBill.set("paymentanture", (Object)paymentBill.getString("paynature"));
                bankPayBill.set("uniformsocialcreditcode", (Object)paymentBill.getString("uniformsocialcreditcode"));
                bankPayBill.set("isbonded", (Object)paymentBill.getString("isbonded"));
                bankPayBill.set("contract", (Object)paymentBill.getString("contract"));
                bankPayBill.set("contractamount", (Object)paymentBill.getBigDecimal("contractamount"));
                bankPayBill.set("invoicenumber", (Object)paymentBill.getString("invoicenumber"));
                bankPayBill.set("reportbiztype", (Object)paymentBill.getString("reportbiztype"));
                bankPayBill.set("transactioncode", (Object)paymentBill.getString("transactioncode"));
                bankPayBill.set("transactionamount", (Object)paymentBill.getBigDecimal("transactionamount"));
                bankPayBill.set("transactionpostscrip", (Object)paymentBill.getString("transactionpostscrip"));
            } else {
                bankPayBill.set("payeeacct", (Object)(chageDirect ? payAccount.getString("bankaccountnumber") : recAccStr));
                bankPayBill.set("payeebank", chageDirect ? payBank.getDynamicObject("bebank").get("name") : paymentBill.getString("payeebankname"));
                bankPayBill.set("mobile", (Object)paymentBill.getString("mobile"));
                bankPayBill.set("recemail", (Object)paymentBill.getString("recemail"));
            }
            billList.add(bankPayBill);
        }
        PayInfoFactory.dealExPropValue("cas_paybill", payInfoList, billList);
        return billList;
    }

    private static DynamicObject getBdFinOrginfoById(Object pkValue) {
        return BusinessDataServiceHelper.loadSingleFromCache((Object)pkValue, (String)"bd_finorginfo");
    }

    public static List<DynamicObject> transAgentPayBillToBankBill(List<DynamicObject> agentPayBillList) {
        ArrayList<DynamicObject> billList = new ArrayList<DynamicObject>(agentPayBillList.size());
        Set proxyBankSet = agentPayBillList.stream().filter(o -> o.getBoolean("iscrosspay")).map(o -> o.getDynamicObject("payproxybank")).filter(Objects::nonNull).map(o -> (Long)o.getPkValue()).collect(Collectors.toSet());
        Map proxyBankMap = BusinessDataServiceHelper.loadFromCache((Object[])proxyBankSet.stream().filter(Objects::nonNull).toArray(), (String)"bei_proxybank");
        List proxyAcctNumberList = proxyBankMap.values().stream().map(o -> o.getString("proxyacct")).filter(Objects::nonNull).collect(Collectors.toList());
        DynamicObject[] proxyAcctArr = BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)String.join((CharSequence)"bankaccountnumber", "acctname"), (QFilter[])new QFilter[]{new QFilter("bankaccountnumber", "in", proxyAcctNumberList)});
        HashMap<String, DynamicObject> proxyAcctMap = new HashMap<String, DynamicObject>(proxyAcctArr.length);
        for (DynamicObject acct : proxyAcctArr) {
            proxyAcctMap.put(acct.getString("bankaccountnumber"), acct);
        }
        Set proxyCountryIdSet = proxyBankMap.values().stream().map(o -> o.getDynamicObject("country")).filter(Objects::nonNull).map(o -> (Long)o.getPkValue()).collect(Collectors.toSet());
        Map proxyCountryMap = BusinessDataServiceHelper.loadFromCache((Object[])proxyCountryIdSet.stream().filter(Objects::nonNull).toArray(), (String)"bd_country");
        MainEntityType bankAgentBillEntityType = EntityMetadataCache.getDataEntityType((String)"bei_bankagentpay");
        long[] idArr = DB.genLongIds((String)"bei_bankagentpay", (int)agentPayBillList.size());
        for (int k = 0; k < agentPayBillList.size(); ++k) {
            DynamicObject agentPayBill = agentPayBillList.get(k);
            DynamicObject bankAgentPayBill = new DynamicObject((DynamicObjectType)bankAgentBillEntityType);
            bankAgentPayBill.set("id", (Object)idArr[k]);
            bankAgentPayBill.set("company", (Object)agentPayBill.getDynamicObject("org"));
            bankAgentPayBill.set("accountbank", (Object)agentPayBill.getDynamicObject("payeracctbank"));
            bankAgentPayBill.set("currency", (Object)agentPayBill.getDynamicObject("currency"));
            bankAgentPayBill.set("amount", (Object)agentPayBill.getBigDecimal("payamount"));
            bankAgentPayBill.set("locamt", (Object)agentPayBill.getBigDecimal("localamt"));
            bankAgentPayBill.set("agentpaybillno", (Object)agentPayBill.getString("billno"));
            bankAgentPayBill.set("sourcebillid", agentPayBill.getPkValue());
            bankAgentPayBill.set("payunique", (Object)-1L);
            bankAgentPayBill.set("ispersonpay", (Object)agentPayBill.getBoolean("ispersonpay"));
            bankAgentPayBill.set("isencryption", (Object)agentPayBill.getBoolean("isencryption"));
            bankAgentPayBill.set("istranspay", (Object)agentPayBill.getBoolean("iscrosspay"));
            bankAgentPayBill.set("isurgent", (Object)agentPayBill.getBoolean("urgentflag"));
            bankAgentPayBill.set("businesstype", (Object)agentPayBill.getString("businesstype"));
            Long companyId = (Long)agentPayBill.getDynamicObject("org").getPkValue();
            boolean isBankBillAudit = BeiParameterHelper.getParameterBoolean((long)companyId, (String)"bei002");
            boolean isNeedCommitBe = BeiParameterHelper.isBizBillCommitBe((long)companyId);
            if (!isNeedCommitBe && isBankBillAudit) {
                bankAgentPayBill.set("billstatus", (Object)BillStatusEnum.SAVE.getValue());
            } else {
                bankAgentPayBill.set("billstatus", (Object)BillStatusEnum.SUBMIT.getValue());
            }
            bankAgentPayBill.set("bizdate", (Object)new Date());
            bankAgentPayBill.set("creator", (Object)RequestContext.get().getCurrUserId());
            bankAgentPayBill.set("createtime", (Object)new Date());
            bankAgentPayBill.set("paystate", (Object)BeBillStatusEnum.OP.getValue());
            DynamicObjectCollection srcEntryList = agentPayBill.getDynamicObjectCollection("entry");
            bankAgentPayBill.set("count", (Object)srcEntryList.size());
            DynamicObjectCollection entryList = bankAgentPayBill.getDynamicObjectCollection("entrys");
            boolean isOverseaPay = agentPayBill.getBoolean("iscrosspay");
            String useCN = "";
            DynamicObject proxyBank = null;
            DynamicObject proxyAcct = null;
            DynamicObject proxyCountry = null;
            if (isOverseaPay) {
                useCN = agentPayBill.getDynamicObject("crosstrantype").getLocaleString("name").getLocaleValue();
                proxyBank = agentPayBill.getDynamicObject("payproxybank");
                if (proxyBank != null) {
                    Long proxyBankId = (Long)proxyBank.getPkValue();
                    proxyBank = (DynamicObject)proxyBankMap.get(proxyBankId);
                    String proxyAcctNumber = proxyBank.getString("proxyacct");
                    proxyAcct = (DynamicObject)proxyAcctMap.get(proxyAcctNumber);
                    proxyCountry = proxyBank.getDynamicObject("country");
                    if (proxyCountry != null) {
                        Long countryId = (Long)proxyCountry.getPkValue();
                        proxyCountry = (DynamicObject)proxyCountryMap.get(countryId);
                    }
                }
            } else {
                DynamicObject billType = agentPayBill.getDynamicObject("billtype");
                if (billType != null) {
                    String billTypeName = billType.getString("name");
                    if (billTypeName.contains(ResManager.loadKDString((String)"\u5de5\u8d44", (String)"PayInfoFactory_1", (String)"fi-cas-business", (Object[])new Object[0]))) {
                        useCN = ResManager.loadKDString((String)"\u5de5\u8d44", (String)"PayInfoFactory_1", (String)"fi-cas-business", (Object[])new Object[0]);
                    } else if (billTypeName.contains(ResManager.loadKDString((String)"\u62a5\u9500", (String)"PayInfoFactory_2", (String)"fi-cas-business", (Object[])new Object[0]))) {
                        useCN = ResManager.loadKDString((String)"\u62a5\u9500", (String)"PayInfoFactory_2", (String)"fi-cas-business", (Object[])new Object[0]);
                    }
                }
            }
            bankAgentPayBill.set("description", (Object)agentPayBill.getString("description"));
            for (int i = 0; i < srcEntryList.size(); ++i) {
                DynamicObject srcEntry = (DynamicObject)srcEntryList.get(i);
                DynamicObject entry = new DynamicObject(entryList.getDynamicObjectType());
                entry.set("status", (Object)BeBillStatusEnum.OP.getValue());
                entry.set("isagencypersonpay", (Object)agentPayBill.getBoolean("isagencypersonpay"));
                entry.set("recname", (Object)srcEntry.getString("payeename"));
                entry.set("recbanknumber", (Object)srcEntry.getString("payeebanknumber"));
                entry.set("remark", (Object)srcEntry.getString("e_remark"));
                entry.set("recprovince", (Object)srcEntry.getString("recprovince"));
                entry.set("reccity", (Object)srcEntry.getString("reccity"));
                entry.set("sourceentryid", (Object)srcEntry.getString("id"));
                entry.set("recamount", (Object)AgentPayBillHelper.decodeAmount((String)((String)srcEntry.get("e_encryptamount"))));
                entry.set("certtype", srcEntry.get("certtype"));
                entry.set("certnum", srcEntry.get("certnum"));
                if (i == 0) {
                    bankAgentPayBill.set("usecn", (Object)useCN);
                    if (isOverseaPay) {
                        DynamicObject feeAcct;
                        bankAgentPayBill.set("payerfeetype", (Object)agentPayBill.getString("feepayer"));
                        bankAgentPayBill.set("payerfeecurrency", (Object)agentPayBill.getDynamicObject("feecurrency"));
                        bankAgentPayBill.set("servicelevel", (Object)agentPayBill.getString("serlevel"));
                        bankAgentPayBill.set("tolexchangerate", (Object)agentPayBill.getBigDecimal("agreedrate"));
                        bankAgentPayBill.set("excontract", (Object)agentPayBill.getString("contractno"));
                        bankAgentPayBill.set("applyname", (Object)agentPayBill.getString("applyname"));
                        bankAgentPayBill.set("applyphone", (Object)agentPayBill.getString("applyphone"));
                        if (proxyBank != null) {
                            bankAgentPayBill.set("proxyaccno", (Object)proxyBank.getString("proxyacct"));
                            String proxyAcctName = null;
                            if (proxyAcct != null) {
                                proxyAcctName = proxyAcct.getString("acctname");
                            } else {
                                DynamicObject openOrg = agentPayBill.getDynamicObject("openorg");
                                if (openOrg != null) {
                                    proxyAcctName = openOrg.getString("name");
                                }
                            }
                            bankAgentPayBill.set("proxyaccname", (Object)proxyAcctName);
                            if (proxyCountry != null) {
                                String proxyCountryName = proxyCountry.getString("simplespell");
                                bankAgentPayBill.set("proxybankcountry", (Object)proxyCountryName);
                                bankAgentPayBill.set("proxybankarea", (Object)proxyCountryName);
                            }
                            bankAgentPayBill.set("proxyswiftcode", (Object)proxyBank.getString("swift_code"));
                            bankAgentPayBill.set("proxybankname", (Object)proxyBank.getDynamicObject("bankname").getLocaleString("name").getLocaleValue());
                            bankAgentPayBill.set("proxybankadds", (Object)proxyBank.getString("address"));
                        }
                        if ((feeAcct = agentPayBill.getDynamicObject("feeactbank")) != null) {
                            bankAgentPayBill.set("payerfeeaccno", (Object)feeAcct.getString("number"));
                        }
                        bankAgentPayBill.set("settlementmethod", (Object)agentPayBill.getString("settlementmethod"));
                    }
                }
                if (isOverseaPay) {
                    entry.set("incomeswiftcode", (Object)srcEntry.getString("recswiftcode"));
                    entry.set("deliverymethod", (Object)srcEntry.getString("sendway"));
                    entry.set("chequetype", (Object)srcEntry.getString("checktype"));
                    entry.set("chequeusage", (Object)srcEntry.getString("checkuse"));
                    entry.set("incomeradds", (Object)srcEntry.getString("recaddress"));
                    entry.set("incomebankcode", (Object)srcEntry.getString("recroutingnum"));
                    entry.set("paymentmethod", (Object)srcEntry.getString("paymethod"));
                    DynamicObject transType = srcEntry.getDynamicObject("transtype");
                    if (transType != null) {
                        entry.set("transremarks", (Object)transType.getLocaleString("name").getLocaleValue());
                    }
                    if (agentPayBill.getString("crosstrantype.number").equals("BOCHK05")) {
                        if (ProceedsTypeEnum.ONE.getValue().equals(srcEntry.getString("paymentterm"))) {
                            entry.set("paymentfps", (Object)srcEntry.getString("paymentfps"));
                        } else if (ProceedsTypeEnum.TWO.getValue().equals(srcEntry.getString("paymentterm"))) {
                            entry.set("paymentareacode", (Object)srcEntry.getString("paymentareacode"));
                            entry.set("mobile", (Object)srcEntry.getString("mobile"));
                        } else if (ProceedsTypeEnum.three.getValue().equals(srcEntry.getString("paymentterm"))) {
                            entry.set("recemail", (Object)srcEntry.getString("recemail"));
                        } else {
                            entry.set("recbank", (Object)srcEntry.getString("payeebankname"));
                            entry.set("recaccountbank", (Object)srcEntry.getString("payeeacctbank"));
                        }
                    } else {
                        entry.set("recbank", (Object)srcEntry.getString("payeebankname"));
                        entry.set("recaccountbank", (Object)srcEntry.getString("payeeacctbank"));
                        entry.set("mobile", (Object)srcEntry.getString("mobile"));
                        entry.set("recemail", (Object)srcEntry.getString("recemail"));
                    }
                    if (srcEntry.getBoolean("inforpayment")) {
                        entry.set("inforpayment", (Object)srcEntry.getString("inforpayment"));
                        entry.set("informrecemail", (Object)srcEntry.getString("informrecemail"));
                    }
                } else {
                    entry.set("recbank", (Object)srcEntry.getString("payeebankname"));
                    entry.set("recaccountbank", (Object)srcEntry.getString("payeeacctbank"));
                    entry.set("mobile", (Object)srcEntry.getString("mobile"));
                    entry.set("recemail", (Object)srcEntry.getString("recemail"));
                }
                entryList.add((Object)entry);
            }
            billList.add(bankAgentPayBill);
        }
        PayInfoFactory.dealExPropValue("cas_agentpaybill", agentPayBillList, billList);
        return billList;
    }

    protected static void dealExPropValue(String entityName, List<DynamicObject> bills, List<DynamicObject> bankBills) {
        PluginProxy pluginProxy = PluginProxy.create(IGenBankBillSDKService.class, (String)"kd.sdk.fi.cas.extpoint.paybill.IGenBankBillSDKService.extFillBankBill");
        List changeProps = pluginProxy.callReplace(p -> p.extFillBankBill(entityName, bills));
        if (EmptyUtil.isNoEmpty((Object)changeProps) && changeProps.size() > 0 && EmptyUtil.isNoEmpty(changeProps.get(0))) {
            String isv = ISVService.getISVInfo().getId();
            for (DynamicObject one : bankBills) {
                Map extValue = (Map)((Map)changeProps.get(0)).get(one.getLong("sourcebillid"));
                if (!EmptyUtil.isNoEmpty((Object)extValue)) continue;
                for (Map.Entry oneExtValue : extValue.entrySet()) {
                    if (!((String)oneExtValue.getKey()).startsWith(isv)) continue;
                    one.set((String)oneExtValue.getKey(), oneExtValue.getValue());
                }
            }
        }
    }
}

