/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.facade.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.business.balancemodel.log.enums.BalanceType;
import kd.fi.cas.business.facade.ICasServiceFacade;
import kd.fi.cas.business.service.BalanceCountService;
import kd.fi.cas.helper.PeriodHelper;
import kd.fi.cas.helper.SystemStatusCtrolHelper;
import kd.fi.cas.util.DateUtils;
import kd.fi.cas.util.EmptyUtil;

public class CasServiceFacadeImpl
implements ICasServiceFacade {
    private static Log logger = LogFactory.getLog(CasServiceFacadeImpl.class);
    private String accountField = "accountField";
    private boolean isCash = false;
    private Map<Long, Long> periodDateMap = null;

    public Map<Long, Long> getPeriodDateMap(List<Long> orgIds, Date bizDate) {
        if (this.periodDateMap == null) {
            this.periodDateMap = PeriodHelper.geBatchPeriodByDate(orgIds, (Date)bizDate);
        }
        return this.periodDateMap;
    }

    @Override
    public DataSet getJournalBalance_ByDate(List<Long> orgIds, Set<Long> acctBankIds, Long currencyId, Date bizDate, boolean isCash) {
        this.getPeriodDateMap(orgIds, bizDate);
        this.isCash = isCash;
        this.accountField = isCash ? "accountcash.id" : "accountbank.id";
        DataSet ds = null;
        for (Long orgId : orgIds) {
            DataSet tempDs = this.getJournalBalance_ByDate(orgId, acctBankIds, currencyId, bizDate);
            if (ds == null) {
                ds = tempDs;
                continue;
            }
            ds = ds.union(tempDs);
        }
        return ds;
    }

    public DataSet getJournalBalance_ByDate(Long orgId, Set<Long> acctBankIds, Long currencyId, Date bizDate) {
        DataSet beginBalanceDs = this.getDayBeginBalance(orgId, acctBankIds, currencyId, bizDate);
        Date endDdate = DateUtils.getNextDay((Date)bizDate, (int)1);
        DataSet ds = this.getRangeJournal(orgId, acctBankIds, currencyId, bizDate, endDdate);
        if (beginBalanceDs != null) {
            ds = null == ds ? beginBalanceDs : ds.union(beginBalanceDs);
        }
        ds = ds.addField("monthbalance + debitamount - creditamount", "endBalance").groupBy(new String[]{"org.id", "org.name", this.accountField, "currency.id", "currency"}).sum("monthbalance").sum("debitamount").sum("creditamount").sum("endBalance").finish();
        return ds;
    }

    public DataSet getDayBeginBalance(Long orgId, Set<Long> acctBankIds, Long currencyId, Date bizDate) {
        DataSet journalBalDs = this.getPeriodBalance(orgId, acctBankIds, currencyId, bizDate);
        if (journalBalDs != null) {
            DataSet maxPeriod = this.getMaxPeriod(journalBalDs);
            DataSet beginBalanceDs = this.getMaxPeriodBalance(journalBalDs, maxPeriod);
            Date newBeginDate = this.getBeginDate(maxPeriod.copy());
            DataSet ds = this.getRangeJournal(orgId, acctBankIds, currencyId, newBeginDate, bizDate);
            if (null == ds) {
                ds = beginBalanceDs;
            } else if (null != beginBalanceDs) {
                ds = ds.union(beginBalanceDs);
            }
            ds.groupBy(new String[]{"org.id", this.accountField, "currency.id", "currency"}).sum("monthbalance").sum("debitamount").sum("creditamount").finish();
            ds = ds.select(new String[]{"org.id", "org.name", this.accountField, "currency.id", "currency", "monthbalance+debitamount-creditamount monthbalance", "0 debitamount", "0 creditamount"});
            return ds;
        }
        return this.creataEmptyDataSet();
    }

    private DataSet getPeriodBalance(Long orgId, Set<Long> acctBankIds, Long currencyId, Date bizDate) {
        Long period = this.getPeriodDateMap(Collections.singletonList(orgId), bizDate).get(orgId);
        logger.info("---->>> CasServiceFacadeImpl.getPeriodBalance(),period={}", (Object)period);
        if (EmptyUtil.isEmpty((Long)period)) {
            return null;
        }
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("org.id", "=", (Object)orgId));
        qFilters.add(new QFilter(this.accountField, "!=", (Object)0));
        qFilters.add(new QFilter("type", "=", (Object)(this.isCash ? "1" : "2")));
        qFilters.add(new QFilter("period.id", "<=", (Object)period));
        if (acctBankIds != null) {
            qFilters.add(new QFilter(this.accountField, "in", acctBankIds));
        }
        if (currencyId != null) {
            qFilters.add(new QFilter("currency.id", "=", (Object)currencyId));
        }
        return QueryServiceHelper.queryDataSet((String)"journalBallance", (String)"cas_journalbalance", (String)("org.id,org.name," + this.accountField + ",currency.id,currency.name currency,period.id,monthstart as monthbalance"), (QFilter[])qFilters.toArray(new QFilter[0]), null);
    }

    private DataSet getMaxPeriod(DataSet journalBalDs) {
        if (null != journalBalDs) {
            return journalBalDs.copy().groupBy(new String[]{"org.id", this.accountField, "currency.id", "currency"}).max("period.id").finish();
        }
        return null;
    }

    private DataSet getMaxPeriodBalance(DataSet journalBalDs, DataSet currentPeriodDs) {
        return journalBalDs.join(currentPeriodDs, JoinType.INNER).on("org.id", "org.id").on(this.accountField, this.accountField).on("currency.id", "currency.id").on("period.id", "period.id").select(new String[]{"org.id", "org.name", this.accountField, "currency.id", "currency", "monthbalance", "0 debitamount", "0 creditamount"}).finish();
    }

    public DataSet getRangeJournal(Long orgId, Set<Long> acctBankIds, Long currencyId, Date beginDate, Date endDate) {
        String queryEntity;
        DataSet dataSet;
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("org.id", "=", (Object)orgId));
        qFilters.add(new QFilter("bookdate", "<", (Object)endDate));
        if (beginDate != null) {
            qFilters.add(new QFilter("bookdate", ">=", (Object)beginDate));
        }
        if (acctBankIds != null) {
            qFilters.add(new QFilter(this.accountField, "=", acctBankIds));
        }
        if (currencyId != null) {
            qFilters.add(new QFilter("currency.id", "=", (Object)currencyId));
        }
        if (null != (dataSet = QueryServiceHelper.queryDataSet((String)"bankJournal", (String)(queryEntity = this.isCash ? "cas_cashjournal" : "cas_bankjournal"), (String)("org.id,org.name," + this.accountField + ",currency.id,currency.name currency,0 monthbalance,debitamount,creditamount"), (QFilter[])qFilters.toArray(new QFilter[0]), null))) {
            return dataSet.groupBy(new String[]{"org.id", "org.name", this.accountField, "currency.id", "currency"}).sum("monthbalance").sum("debitamount").sum("creditamount").finish();
        }
        return this.creataEmptyDataSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigDecimal getCashJournalDayBalanceByBookDate(Long orgId, Long acctBankId, Long currencyId, Date pBookDate) {
        DynamicObject casInitInfo;
        Date bookDate = DateUtils.getDataFormat((Date)pBookDate, (boolean)true);
        BigDecimal balanceAmout = BigDecimal.ZERO;
        this.accountField = "accountcash.id";
        this.isCash = true;
        HashSet<Long> acctBankIds = new HashSet<Long>(1);
        acctBankIds.add(acctBankId);
        DynamicObject periodObj = PeriodHelper.getPeriodByDate((long)orgId, (Date)bookDate);
        if (!(periodObj != null || (casInitInfo = PeriodHelper.getCasInitInfo((long)orgId)) != null && casInitInfo.getBoolean("isfinishinit"))) {
            return balanceAmout;
        }
        DynamicObject startPeriod = SystemStatusCtrolHelper.getStartPeriod((long)orgId);
        if (startPeriod.getDate("begindate").after(bookDate)) {
            return balanceAmout;
        }
        DataSet journalBalDs = this.getPeriodBalance(orgId, acctBankIds, currencyId, bookDate);
        if (null == journalBalDs) {
            return balanceAmout;
        }
        DataSet maxPeriod = this.getMaxPeriod(journalBalDs);
        DataSet beginBalanceDs = this.getMaxPeriodBalance(journalBalDs, maxPeriod);
        Date newBeginDate = this.getBeginDate(maxPeriod.copy());
        Date endDate = DateUtils.getNextDay((Date)bookDate, (int)1);
        try (DataSet ds = this.getRangeJournalByBookdate(orgId, acctBankId, currencyId, newBeginDate, endDate);){
            if (null == ds) {
                ds = beginBalanceDs;
            } else if (null != beginBalanceDs) {
                ds = ds.union(beginBalanceDs);
            }
            ds = ds.groupBy(new String[]{"org.id", "accountcash.id", "currency.id", "currency"}).sum("monthbalance").sum("debitamount").sum("creditamount").finish();
            ds = ds.select(new String[]{"org.id", "accountcash.id", "currency.id", "currency", "monthbalance+debitamount-creditamount balance"});
            Iterator it = ds.iterator();
            if (it.hasNext()) {
                Row row = (Row)it.next();
                balanceAmout = row.getBigDecimal("balance");
            }
        }
        return balanceAmout;
    }

    public BigDecimal getCashJournalBalanceByBalanceModel(Long orgId, Long acctBankId, Long currencyId, Date pBookDate) {
        BigDecimal balanceAmout = BigDecimal.ZERO;
        Date bookDate = DateUtils.getDataFormat((Date)pBookDate, (boolean)true);
        DynamicObject casInitInfo = PeriodHelper.getCasInitInfo((long)orgId);
        if (casInitInfo == null || !casInitInfo.getBoolean("isfinishinit")) {
            return balanceAmout;
        }
        DynamicObject startPeriod = SystemStatusCtrolHelper.getStartPeriod((long)orgId);
        if (startPeriod.getDate("begindate").after(bookDate)) {
            return balanceAmout;
        }
        bookDate = DateUtils.getNextDay((Date)bookDate, (int)1);
        try {
            BalanceCountService balanceCountService = new BalanceCountService();
            balanceAmout = balanceCountService.queryByBalanceModel(BalanceType.CASH, orgId, acctBankId, currencyId, bookDate, bookDate);
        }
        catch (Exception e) {
            logger.error("error:", (Throwable)e);
        }
        return balanceAmout;
    }

    private DataSet getRangeJournalByBookdate(Long orgId, Long acctBankId, Long currencyId, Date beginDate, Date endDate) {
        DataSet dataSet;
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("org.id", "=", (Object)orgId));
        qFilters.add(new QFilter("bookdate", "<", (Object)endDate));
        if (beginDate != null) {
            qFilters.add(new QFilter("bookdate", ">=", (Object)beginDate));
        }
        if (acctBankId != null) {
            qFilters.add(new QFilter(this.accountField, "=", (Object)acctBankId));
        }
        if (currencyId != null) {
            qFilters.add(new QFilter("currency.id", "=", (Object)currencyId));
        }
        if ((dataSet = QueryServiceHelper.queryDataSet((String)"Journal", (String)"cas_cashjournal", (String)"org.id,org.name,accountcash.id,currency.id,currency.name currency,0 monthbalance,debitamount,creditamount", (QFilter[])qFilters.toArray(new QFilter[0]), null)) != null) {
            return dataSet.groupBy(new String[]{"org.id", "org.name", "accountcash.id", "currency.id", "currency"}).sum("monthbalance").sum("debitamount").sum("creditamount").finish();
        }
        return null;
    }

    private Date getBeginDate(DataSet maxPeriod) {
        if (maxPeriod != null && maxPeriod.hasNext()) {
            Row row = maxPeriod.next();
            DynamicObject beginDate = BusinessDataServiceHelper.loadSingle((Object)row.getLong("period.id"), (String)"bd_period", (String)"begindate");
            return beginDate.getDate("begindate");
        }
        return null;
    }

    private DataSet creataEmptyDataSet() {
        String[] feilds = new String[]{"org.id", "org.name", this.accountField, "currency.id", "currency", "monthbalance", "debitamount", "creditamount"};
        DataType[] dataTypes = new DataType[]{DataType.LongType, DataType.StringType, DataType.LongType, DataType.LongType, DataType.StringType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.BigDecimalType};
        RowMeta rowMeta = new RowMeta(feilds, dataTypes);
        return Algo.create((String)"EmptyDataSet").createDataSetBuilder(rowMeta).build();
    }
}

